/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.jdbc.shaded.com.fasterxml.jackson.databind.deser.impl;

import java.io.IOException;
import java.lang.annotation.Annotation;
import org.apache.kylin.jdbc.shaded.com.fasterxml.jackson.core.JsonParser;
import org.apache.kylin.jdbc.shaded.com.fasterxml.jackson.core.JsonProcessingException;
import org.apache.kylin.jdbc.shaded.com.fasterxml.jackson.databind.DeserializationContext;
import org.apache.kylin.jdbc.shaded.com.fasterxml.jackson.databind.JsonDeserializer;
import org.apache.kylin.jdbc.shaded.com.fasterxml.jackson.databind.deser.SettableBeanProperty;
import org.apache.kylin.jdbc.shaded.com.fasterxml.jackson.databind.deser.impl.ObjectIdReader;
import org.apache.kylin.jdbc.shaded.com.fasterxml.jackson.databind.deser.impl.ReadableObjectId;
import org.apache.kylin.jdbc.shaded.com.fasterxml.jackson.databind.introspect.AnnotatedMember;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ObjectIdValueProperty
extends SettableBeanProperty {
    private static final long serialVersionUID = 1L;
    protected final ObjectIdReader _objectIdReader;

    public ObjectIdValueProperty(ObjectIdReader objectIdReader) {
        super(objectIdReader.propertyName, objectIdReader.idType, null, null);
        this._objectIdReader = objectIdReader;
        this._valueDeserializer = objectIdReader.deserializer;
    }

    protected ObjectIdValueProperty(ObjectIdValueProperty src, JsonDeserializer<?> deser) {
        super((SettableBeanProperty)src, deser);
        this._objectIdReader = src._objectIdReader;
    }

    protected ObjectIdValueProperty(ObjectIdValueProperty src, String newName) {
        super((SettableBeanProperty)src, newName);
        this._objectIdReader = src._objectIdReader;
    }

    @Override
    public ObjectIdValueProperty withName(String newName) {
        return new ObjectIdValueProperty(this, newName);
    }

    @Override
    public ObjectIdValueProperty withValueDeserializer(JsonDeserializer<?> deser) {
        return new ObjectIdValueProperty(this, deser);
    }

    @Override
    public <A extends Annotation> A getAnnotation(Class<A> acls) {
        return null;
    }

    @Override
    public AnnotatedMember getMember() {
        return null;
    }

    @Override
    public void deserializeAndSet(JsonParser jp, DeserializationContext ctxt, Object instance) throws IOException, JsonProcessingException {
        this.deserializeSetAndReturn(jp, ctxt, instance);
    }

    @Override
    public Object deserializeSetAndReturn(JsonParser jp, DeserializationContext ctxt, Object instance) throws IOException, JsonProcessingException {
        Object id = this._valueDeserializer.deserialize(jp, ctxt);
        ReadableObjectId roid = ctxt.findObjectId(id, this._objectIdReader.generator);
        roid.bindItem(instance);
        SettableBeanProperty idProp = this._objectIdReader.idProperty;
        if (idProp != null) {
            return idProp.setAndReturn(instance, id);
        }
        return instance;
    }

    @Override
    public void set(Object instance, Object value) throws IOException {
        this.setAndReturn(instance, value);
    }

    @Override
    public Object setAndReturn(Object instance, Object value) throws IOException {
        SettableBeanProperty idProp = this._objectIdReader.idProperty;
        if (idProp == null) {
            throw new UnsupportedOperationException("Should not call set() on ObjectIdProperty that has no SettableBeanProperty");
        }
        return idProp.setAndReturn(instance, value);
    }
}

