/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.jdbc.shaded.com.fasterxml.jackson.databind.ser.std;

import java.io.IOException;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.kylin.jdbc.shaded.com.fasterxml.jackson.core.JsonGenerationException;
import org.apache.kylin.jdbc.shaded.com.fasterxml.jackson.core.JsonGenerator;
import org.apache.kylin.jdbc.shaded.com.fasterxml.jackson.databind.AnnotationIntrospector;
import org.apache.kylin.jdbc.shaded.com.fasterxml.jackson.databind.BeanProperty;
import org.apache.kylin.jdbc.shaded.com.fasterxml.jackson.databind.JavaType;
import org.apache.kylin.jdbc.shaded.com.fasterxml.jackson.databind.JsonMappingException;
import org.apache.kylin.jdbc.shaded.com.fasterxml.jackson.databind.JsonNode;
import org.apache.kylin.jdbc.shaded.com.fasterxml.jackson.databind.JsonSerializer;
import org.apache.kylin.jdbc.shaded.com.fasterxml.jackson.databind.SerializationFeature;
import org.apache.kylin.jdbc.shaded.com.fasterxml.jackson.databind.SerializerProvider;
import org.apache.kylin.jdbc.shaded.com.fasterxml.jackson.databind.annotation.JacksonStdImpl;
import org.apache.kylin.jdbc.shaded.com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import org.apache.kylin.jdbc.shaded.com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import org.apache.kylin.jdbc.shaded.com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import org.apache.kylin.jdbc.shaded.com.fasterxml.jackson.databind.node.ObjectNode;
import org.apache.kylin.jdbc.shaded.com.fasterxml.jackson.databind.ser.ContainerSerializer;
import org.apache.kylin.jdbc.shaded.com.fasterxml.jackson.databind.ser.ContextualSerializer;
import org.apache.kylin.jdbc.shaded.com.fasterxml.jackson.databind.ser.impl.PropertySerializerMap;
import org.apache.kylin.jdbc.shaded.com.fasterxml.jackson.databind.type.TypeFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@JacksonStdImpl
public class MapSerializer
extends ContainerSerializer<Map<?, ?>>
implements ContextualSerializer {
    protected static final JavaType UNSPECIFIED_TYPE = TypeFactory.unknownType();
    protected final BeanProperty _property;
    protected final HashSet<String> _ignoredEntries;
    protected final boolean _valueTypeIsStatic;
    protected final JavaType _keyType;
    protected final JavaType _valueType;
    protected JsonSerializer<Object> _keySerializer;
    protected JsonSerializer<Object> _valueSerializer;
    protected final TypeSerializer _valueTypeSerializer;
    protected PropertySerializerMap _dynamicValueSerializers;

    protected MapSerializer(HashSet<String> ignoredEntries, JavaType keyType, JavaType valueType, boolean valueTypeIsStatic, TypeSerializer vts, JsonSerializer<?> keySerializer, JsonSerializer<?> valueSerializer) {
        super(Map.class, false);
        this._ignoredEntries = ignoredEntries;
        this._keyType = keyType;
        this._valueType = valueType;
        this._valueTypeIsStatic = valueTypeIsStatic;
        this._valueTypeSerializer = vts;
        this._keySerializer = keySerializer;
        this._valueSerializer = valueSerializer;
        this._dynamicValueSerializers = PropertySerializerMap.emptyMap();
        this._property = null;
    }

    protected MapSerializer(MapSerializer src, BeanProperty property, JsonSerializer<?> keySerializer, JsonSerializer<?> valueSerializer, HashSet<String> ignored) {
        super(Map.class, false);
        this._ignoredEntries = ignored;
        this._keyType = src._keyType;
        this._valueType = src._valueType;
        this._valueTypeIsStatic = src._valueTypeIsStatic;
        this._valueTypeSerializer = src._valueTypeSerializer;
        this._keySerializer = keySerializer;
        this._valueSerializer = valueSerializer;
        this._dynamicValueSerializers = src._dynamicValueSerializers;
        this._property = property;
    }

    protected MapSerializer(MapSerializer src, TypeSerializer vts) {
        super(Map.class, false);
        this._ignoredEntries = src._ignoredEntries;
        this._keyType = src._keyType;
        this._valueType = src._valueType;
        this._valueTypeIsStatic = src._valueTypeIsStatic;
        this._valueTypeSerializer = vts;
        this._keySerializer = src._keySerializer;
        this._valueSerializer = src._valueSerializer;
        this._dynamicValueSerializers = src._dynamicValueSerializers;
        this._property = src._property;
    }

    public MapSerializer _withValueTypeSerializer(TypeSerializer vts) {
        return new MapSerializer(this, vts);
    }

    public MapSerializer withResolved(BeanProperty property, JsonSerializer<?> keySerializer, JsonSerializer<?> valueSerializer, HashSet<String> ignored) {
        return new MapSerializer(this, property, keySerializer, valueSerializer, ignored);
    }

    public static MapSerializer construct(String[] ignoredList, JavaType mapType, boolean staticValueType, TypeSerializer vts, JsonSerializer<Object> keySerializer, JsonSerializer<Object> valueSerializer) {
        JavaType keyType;
        JavaType valueType;
        HashSet<String> ignoredEntries = MapSerializer.toSet(ignoredList);
        if (mapType == null) {
            keyType = valueType = UNSPECIFIED_TYPE;
        } else {
            keyType = mapType.getKeyType();
            valueType = mapType.getContentType();
        }
        if (!staticValueType) {
            staticValueType = valueType != null && valueType.isFinal();
        }
        return new MapSerializer(ignoredEntries, keyType, valueType, staticValueType, vts, keySerializer, valueSerializer);
    }

    private static HashSet<String> toSet(String[] ignoredEntries) {
        if (ignoredEntries == null || ignoredEntries.length == 0) {
            return null;
        }
        HashSet<String> result = new HashSet<String>(ignoredEntries.length);
        for (String prop : ignoredEntries) {
            result.add(prop);
        }
        return result;
    }

    @Override
    public JsonSerializer<?> createContextual(SerializerProvider provider, BeanProperty property) throws JsonMappingException {
        String[] moreToIgnore;
        AnnotatedMember m;
        JsonSerializer<Object> ser = null;
        JsonSerializer<Object> keySer = null;
        if (property != null && (m = property.getMember()) != null) {
            AnnotationIntrospector intr = provider.getAnnotationIntrospector();
            Object serDef = intr.findKeySerializer(m);
            if (serDef != null) {
                keySer = provider.serializerInstance(m, serDef);
            }
            if ((serDef = intr.findContentSerializer(m)) != null) {
                ser = provider.serializerInstance(m, serDef);
            }
        }
        if (ser == null) {
            ser = this._valueSerializer;
        }
        if (ser == null) {
            if (this._valueTypeIsStatic || this.hasContentTypeAnnotation(provider, property)) {
                ser = provider.findValueSerializer(this._valueType, property);
            }
        } else if (ser instanceof ContextualSerializer) {
            ser = ((ContextualSerializer)((Object)ser)).createContextual(provider, property);
        }
        if (keySer == null) {
            keySer = this._keySerializer;
        }
        if (keySer == null) {
            keySer = provider.findKeySerializer(this._keyType, property);
        } else if (keySer instanceof ContextualSerializer) {
            keySer = ((ContextualSerializer)((Object)keySer)).createContextual(provider, property);
        }
        HashSet<String> ignored = this._ignoredEntries;
        AnnotationIntrospector intr = provider.getAnnotationIntrospector();
        if (intr != null && property != null && (moreToIgnore = intr.findPropertiesToIgnore(property.getMember())) != null) {
            ignored = ignored == null ? new HashSet() : new HashSet<String>(ignored);
            for (String str : moreToIgnore) {
                ignored.add(str);
            }
        }
        return this.withResolved(property, keySer, ser, ignored);
    }

    @Override
    public JavaType getContentType() {
        return this._valueType;
    }

    @Override
    public JsonSerializer<?> getContentSerializer() {
        return this._valueSerializer;
    }

    @Override
    public boolean isEmpty(Map<?, ?> value) {
        return value == null || value.isEmpty();
    }

    @Override
    public boolean hasSingleElement(Map<?, ?> value) {
        return value.size() == 1;
    }

    public JsonSerializer<?> getKeySerializer() {
        return this._keySerializer;
    }

    @Override
    public void serialize(Map<?, ?> value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonGenerationException {
        jgen.writeStartObject();
        if (!value.isEmpty()) {
            if (provider.isEnabled(SerializationFeature.ORDER_MAP_ENTRIES_BY_KEYS)) {
                value = this._orderEntries(value);
            }
            if (this._valueSerializer != null) {
                this.serializeFieldsUsing(value, jgen, provider, this._valueSerializer);
            } else {
                this.serializeFields(value, jgen, provider);
            }
        }
        jgen.writeEndObject();
    }

    @Override
    public void serializeWithType(Map<?, ?> value, JsonGenerator jgen, SerializerProvider provider, TypeSerializer typeSer) throws IOException, JsonGenerationException {
        typeSer.writeTypePrefixForObject(value, jgen);
        if (!value.isEmpty()) {
            if (provider.isEnabled(SerializationFeature.ORDER_MAP_ENTRIES_BY_KEYS)) {
                value = this._orderEntries(value);
            }
            if (this._valueSerializer != null) {
                this.serializeFieldsUsing(value, jgen, provider, this._valueSerializer);
            } else {
                this.serializeFields(value, jgen, provider);
            }
        }
        typeSer.writeTypeSuffixForObject(value, jgen);
    }

    public void serializeFields(Map<?, ?> value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonGenerationException {
        if (this._valueTypeSerializer != null) {
            this.serializeTypedFields(value, jgen, provider);
            return;
        }
        JsonSerializer<Object> keySerializer = this._keySerializer;
        HashSet<String> ignored = this._ignoredEntries;
        boolean skipNulls = !provider.isEnabled(SerializationFeature.WRITE_NULL_MAP_VALUES);
        PropertySerializerMap serializers = this._dynamicValueSerializers;
        for (Map.Entry<?, ?> entry : value.entrySet()) {
            Object valueElem = entry.getValue();
            Object keyElem = entry.getKey();
            if (keyElem == null) {
                provider.findNullKeySerializer(this._keyType, this._property).serialize(null, jgen, provider);
            } else {
                if (skipNulls && valueElem == null || ignored != null && ignored.contains(keyElem)) continue;
                keySerializer.serialize(keyElem, jgen, provider);
            }
            if (valueElem == null) {
                provider.defaultSerializeNull(jgen);
                continue;
            }
            Class<?> cc = valueElem.getClass();
            JsonSerializer<Object> serializer = serializers.serializerFor(cc);
            if (serializer == null) {
                serializer = this._valueType.hasGenericTypes() ? this._findAndAddDynamic(serializers, provider.constructSpecializedType(this._valueType, cc), provider) : this._findAndAddDynamic(serializers, cc, provider);
                serializers = this._dynamicValueSerializers;
            }
            try {
                serializer.serialize(valueElem, jgen, provider);
            }
            catch (Exception e) {
                String keyDesc = "" + keyElem;
                this.wrapAndThrow(provider, (Throwable)e, value, keyDesc);
            }
        }
    }

    protected void serializeFieldsUsing(Map<?, ?> value, JsonGenerator jgen, SerializerProvider provider, JsonSerializer<Object> ser) throws IOException, JsonGenerationException {
        JsonSerializer<Object> keySerializer = this._keySerializer;
        HashSet<String> ignored = this._ignoredEntries;
        TypeSerializer typeSer = this._valueTypeSerializer;
        boolean skipNulls = !provider.isEnabled(SerializationFeature.WRITE_NULL_MAP_VALUES);
        for (Map.Entry<?, ?> entry : value.entrySet()) {
            Object valueElem = entry.getValue();
            Object keyElem = entry.getKey();
            if (keyElem == null) {
                provider.findNullKeySerializer(this._keyType, this._property).serialize(null, jgen, provider);
            } else {
                if (skipNulls && valueElem == null || ignored != null && ignored.contains(keyElem)) continue;
                keySerializer.serialize(keyElem, jgen, provider);
            }
            if (valueElem == null) {
                provider.defaultSerializeNull(jgen);
                continue;
            }
            try {
                if (typeSer == null) {
                    ser.serialize(valueElem, jgen, provider);
                    continue;
                }
                ser.serializeWithType(valueElem, jgen, provider, typeSer);
            }
            catch (Exception e) {
                String keyDesc = "" + keyElem;
                this.wrapAndThrow(provider, (Throwable)e, value, keyDesc);
            }
        }
    }

    protected void serializeTypedFields(Map<?, ?> value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonGenerationException {
        JsonSerializer<Object> keySerializer = this._keySerializer;
        JsonSerializer<Object> prevValueSerializer = null;
        Class<?> prevValueClass = null;
        HashSet<String> ignored = this._ignoredEntries;
        boolean skipNulls = !provider.isEnabled(SerializationFeature.WRITE_NULL_MAP_VALUES);
        for (Map.Entry<?, ?> entry : value.entrySet()) {
            JsonSerializer<Object> currSerializer;
            Object valueElem = entry.getValue();
            Object keyElem = entry.getKey();
            if (keyElem == null) {
                provider.findNullKeySerializer(this._keyType, this._property).serialize(null, jgen, provider);
            } else {
                if (skipNulls && valueElem == null || ignored != null && ignored.contains(keyElem)) continue;
                keySerializer.serialize(keyElem, jgen, provider);
            }
            if (valueElem == null) {
                provider.defaultSerializeNull(jgen);
                continue;
            }
            Class<?> cc = valueElem.getClass();
            if (cc == prevValueClass) {
                currSerializer = prevValueSerializer;
            } else {
                prevValueSerializer = currSerializer = provider.findValueSerializer(cc, this._property);
                prevValueClass = cc;
            }
            try {
                currSerializer.serializeWithType(valueElem, jgen, provider, this._valueTypeSerializer);
            }
            catch (Exception e) {
                String keyDesc = "" + keyElem;
                this.wrapAndThrow(provider, (Throwable)e, value, keyDesc);
            }
        }
    }

    @Override
    public JsonNode getSchema(SerializerProvider provider, Type typeHint) {
        ObjectNode o = this.createSchemaNode("object", true);
        return o;
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) {
        visitor.expectObjectFormat(typeHint);
    }

    protected final JsonSerializer<Object> _findAndAddDynamic(PropertySerializerMap map, Class<?> type, SerializerProvider provider) throws JsonMappingException {
        PropertySerializerMap.SerializerAndMapResult result = map.findAndAddSerializer(type, provider, this._property);
        if (map != result.map) {
            this._dynamicValueSerializers = result.map;
        }
        return result.serializer;
    }

    protected final JsonSerializer<Object> _findAndAddDynamic(PropertySerializerMap map, JavaType type, SerializerProvider provider) throws JsonMappingException {
        PropertySerializerMap.SerializerAndMapResult result = map.findAndAddSerializer(type, provider, this._property);
        if (map != result.map) {
            this._dynamicValueSerializers = result.map;
        }
        return result.serializer;
    }

    protected Map<?, ?> _orderEntries(Map<?, ?> input) {
        if (input instanceof SortedMap) {
            return input;
        }
        return new TreeMap(input);
    }
}

