/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.jdbc.shaded.org.apache.calcite.avatica.com.google.protobuf;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.RandomAccess;
import org.apache.kylin.jdbc.shaded.org.apache.calcite.avatica.com.google.protobuf.AbstractProtobufList;
import org.apache.kylin.jdbc.shaded.org.apache.calcite.avatica.com.google.protobuf.Internal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class IntArrayList
extends AbstractProtobufList<Integer>
implements Internal.IntList,
RandomAccess {
    private static final int DEFAULT_CAPACITY = 10;
    private static final IntArrayList EMPTY_LIST = new IntArrayList();
    private int[] array;
    private int size;

    public static IntArrayList emptyList() {
        return EMPTY_LIST;
    }

    IntArrayList() {
        this.array = new int[10];
        this.size = 0;
    }

    IntArrayList(List<Integer> other) {
        if (other instanceof IntArrayList) {
            IntArrayList list = (IntArrayList)other;
            this.array = (int[])list.array.clone();
            this.size = list.size;
        } else {
            this.size = other.size();
            this.array = new int[this.size];
            for (int i = 0; i < this.size; ++i) {
                this.array[i] = other.get(i);
            }
        }
    }

    @Override
    public Integer get(int index) {
        return this.getInt(index);
    }

    @Override
    public int getInt(int index) {
        this.ensureIndexInRange(index);
        return this.array[index];
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public Integer set(int index, Integer element) {
        return this.setInt(index, element);
    }

    @Override
    public int setInt(int index, int element) {
        this.ensureIsMutable();
        this.ensureIndexInRange(index);
        int previousValue = this.array[index];
        this.array[index] = element;
        return previousValue;
    }

    @Override
    public void add(int index, Integer element) {
        this.addInt(index, element);
    }

    @Override
    public void addInt(int element) {
        this.addInt(this.size, element);
    }

    private void addInt(int index, int element) {
        this.ensureIsMutable();
        if (index < 0 || index > this.size) {
            throw new IndexOutOfBoundsException(this.makeOutOfBoundsExceptionMessage(index));
        }
        if (this.size < this.array.length) {
            System.arraycopy(this.array, index, this.array, index + 1, this.size - index);
        } else {
            int length = this.size * 3 / 2 + 1;
            int[] newArray = new int[length];
            System.arraycopy(this.array, 0, newArray, 0, index);
            System.arraycopy(this.array, index, newArray, index + 1, this.size - index);
            this.array = newArray;
        }
        this.array[index] = element;
        ++this.size;
        ++this.modCount;
    }

    @Override
    public boolean addAll(Collection<? extends Integer> collection) {
        this.ensureIsMutable();
        if (collection == null) {
            throw new NullPointerException();
        }
        if (!(collection instanceof IntArrayList)) {
            return super.addAll(collection);
        }
        IntArrayList list = (IntArrayList)collection;
        if (list.size == 0) {
            return false;
        }
        int overflow = Integer.MAX_VALUE - this.size;
        if (overflow < list.size) {
            throw new OutOfMemoryError();
        }
        int newSize = this.size + list.size;
        if (newSize > this.array.length) {
            this.array = Arrays.copyOf(this.array, newSize);
        }
        System.arraycopy(list.array, 0, this.array, this.size, list.size);
        this.size = newSize;
        ++this.modCount;
        return true;
    }

    @Override
    public boolean remove(Object o) {
        this.ensureIsMutable();
        for (int i = 0; i < this.size; ++i) {
            if (!o.equals(this.array[i])) continue;
            System.arraycopy(this.array, i + 1, this.array, i, this.size - i);
            --this.size;
            ++this.modCount;
            return true;
        }
        return false;
    }

    @Override
    public Integer remove(int index) {
        this.ensureIsMutable();
        this.ensureIndexInRange(index);
        int value = this.array[index];
        System.arraycopy(this.array, index + 1, this.array, index, this.size - index);
        --this.size;
        ++this.modCount;
        return value;
    }

    private void ensureIndexInRange(int index) {
        if (index < 0 || index >= this.size) {
            throw new IndexOutOfBoundsException(this.makeOutOfBoundsExceptionMessage(index));
        }
    }

    private String makeOutOfBoundsExceptionMessage(int index) {
        return "Index:" + index + ", Size:" + this.size;
    }

    static {
        EMPTY_LIST.makeImmutable();
    }
}

