/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.jdbc.shaded.org.apache.calcite.avatica.remote;

import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Properties;
import org.apache.kylin.jdbc.shaded.org.apache.calcite.avatica.AvaticaConnection;
import org.apache.kylin.jdbc.shaded.org.apache.calcite.avatica.BuiltInConnectionProperty;
import org.apache.kylin.jdbc.shaded.org.apache.calcite.avatica.ConnectionConfig;
import org.apache.kylin.jdbc.shaded.org.apache.calcite.avatica.ConnectionProperty;
import org.apache.kylin.jdbc.shaded.org.apache.calcite.avatica.DriverVersion;
import org.apache.kylin.jdbc.shaded.org.apache.calcite.avatica.Meta;
import org.apache.kylin.jdbc.shaded.org.apache.calcite.avatica.UnregisteredDriver;
import org.apache.kylin.jdbc.shaded.org.apache.calcite.avatica.remote.AvaticaHttpClient;
import org.apache.kylin.jdbc.shaded.org.apache.calcite.avatica.remote.AvaticaHttpClientImpl;
import org.apache.kylin.jdbc.shaded.org.apache.calcite.avatica.remote.AvaticaRemoteConnectionProperty;
import org.apache.kylin.jdbc.shaded.org.apache.calcite.avatica.remote.MockJsonService;
import org.apache.kylin.jdbc.shaded.org.apache.calcite.avatica.remote.ProtobufTranslationImpl;
import org.apache.kylin.jdbc.shaded.org.apache.calcite.avatica.remote.RemoteMeta;
import org.apache.kylin.jdbc.shaded.org.apache.calcite.avatica.remote.RemoteProtobufService;
import org.apache.kylin.jdbc.shaded.org.apache.calcite.avatica.remote.RemoteService;
import org.apache.kylin.jdbc.shaded.org.apache.calcite.avatica.remote.Service;

public class Driver
extends UnregisteredDriver {
    public static final String CONNECT_STRING_PREFIX = "jdbc:avatica:remote:";

    @Override
    protected String getConnectStringPrefix() {
        return CONNECT_STRING_PREFIX;
    }

    @Override
    protected DriverVersion createDriverVersion() {
        return DriverVersion.load(Driver.class, "org-apache-calcite-jdbc.properties", "Avatica Remote JDBC Driver", "unknown version", "Avatica", "unknown version");
    }

    @Override
    protected Collection<ConnectionProperty> getConnectionProperties() {
        ArrayList<ConnectionProperty> list = new ArrayList<ConnectionProperty>();
        Collections.addAll(list, BuiltInConnectionProperty.values());
        Collections.addAll(list, AvaticaRemoteConnectionProperty.values());
        return list;
    }

    @Override
    public Meta createMeta(AvaticaConnection connection) {
        ConnectionConfig config = connection.config();
        Service service = this.createService(connection, config);
        return new RemoteMeta(connection, service);
    }

    Service createService(AvaticaConnection connection, ConnectionConfig config) {
        Service service;
        Service.Factory metaFactory = config.factory();
        if (metaFactory != null) {
            service = metaFactory.create(connection);
        } else if (config.url() != null) {
            AvaticaHttpClient httpClient = this.getHttpClient(connection, config);
            Serialization serializationType = this.getSerialization(config);
            switch (serializationType) {
                case JSON: {
                    service = new RemoteService(httpClient);
                    break;
                }
                case PROTOBUF: {
                    service = new RemoteProtobufService(httpClient, new ProtobufTranslationImpl());
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unhandled serialization type: " + (Object)((Object)serializationType));
                }
            }
        } else {
            service = new MockJsonService(Collections.emptyMap());
        }
        return service;
    }

    AvaticaHttpClient getHttpClient(AvaticaConnection connection, ConnectionConfig config) {
        URL url;
        try {
            url = new URL(config.url());
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        return new AvaticaHttpClientImpl(url);
    }

    @Override
    public Connection connect(String url, Properties info) throws SQLException {
        AvaticaConnection conn = (AvaticaConnection)super.connect(url, info);
        if (conn == null) {
            return null;
        }
        ConnectionConfig config = conn.config();
        Service service = this.createService(conn, config);
        service.apply(new Service.OpenConnectionRequest(conn.id, Service.OpenConnectionRequest.serializeProperties(info)));
        return conn;
    }

    Serialization getSerialization(ConnectionConfig config) {
        String serializationStr = config.serialization();
        Serialization serializationType = Serialization.JSON;
        if (null != serializationStr) {
            try {
                serializationType = Serialization.valueOf(serializationStr.toUpperCase());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return serializationType;
    }

    static {
        new Driver().register();
    }

    public static enum Serialization {
        JSON,
        PROTOBUF;

    }
}

