/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.compiler;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.maven.api.Exclusion;
import org.apache.maven.api.PathScope;
import org.apache.maven.api.Project;
import org.apache.maven.api.ProjectScope;
import org.apache.maven.api.Session;
import org.apache.maven.api.Toolchain;
import org.apache.maven.api.di.Inject;
import org.apache.maven.api.plugin.Log;
import org.apache.maven.api.plugin.Mojo;
import org.apache.maven.api.plugin.MojoException;
import org.apache.maven.api.plugin.annotations.Parameter;
import org.apache.maven.api.services.ArtifactManager;
import org.apache.maven.api.services.DependencyCoordinateFactory;
import org.apache.maven.api.services.DependencyCoordinateFactoryRequest;
import org.apache.maven.api.services.DependencyResolver;
import org.apache.maven.api.services.DependencyResolverRequest;
import org.apache.maven.api.services.MessageBuilder;
import org.apache.maven.api.services.MessageBuilderFactory;
import org.apache.maven.api.services.ProjectManager;
import org.apache.maven.api.services.ToolchainManager;
import org.apache.maven.plugin.compiler.CompilationFailureException;
import org.apache.maven.plugin.compiler.DependencyCoordinate;
import org.apache.maven.plugin.compiler.DependencyExclusion;
import org.apache.maven.plugin.compiler.IncrementalBuildHelper;
import org.apache.maven.plugin.compiler.ModuleInfoTransformer;
import org.codehaus.plexus.compiler.Compiler;
import org.codehaus.plexus.compiler.CompilerConfiguration;
import org.codehaus.plexus.compiler.CompilerException;
import org.codehaus.plexus.compiler.CompilerMessage;
import org.codehaus.plexus.compiler.CompilerOutputStyle;
import org.codehaus.plexus.compiler.CompilerResult;
import org.codehaus.plexus.compiler.manager.CompilerManager;
import org.codehaus.plexus.compiler.manager.NoSuchCompilerException;
import org.codehaus.plexus.compiler.util.scan.InclusionScanException;
import org.codehaus.plexus.compiler.util.scan.SourceInclusionScanner;
import org.codehaus.plexus.compiler.util.scan.mapping.SingleTargetSourceMapping;
import org.codehaus.plexus.compiler.util.scan.mapping.SourceMapping;
import org.codehaus.plexus.compiler.util.scan.mapping.SuffixMapping;
import org.codehaus.plexus.languages.java.jpms.JavaModuleDescriptor;
import org.codehaus.plexus.languages.java.version.JavaVersion;
import org.codehaus.plexus.logging.AbstractLogger;
import org.codehaus.plexus.logging.LogEnabled;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.StringUtils;
import org.objectweb.asm.ClassWriter;

public abstract class AbstractCompilerMojo
implements Mojo {
    protected static final String PS = System.getProperty("path.separator");
    private static final String INPUT_FILES_LST_FILENAME = "inputFiles.lst";
    static final String DEFAULT_SOURCE = "1.8";
    static final String DEFAULT_TARGET = "1.8";
    static final String MODULE_INFO_TARGET = "1.9";
    @Parameter(property="maven.compiler.failOnError", defaultValue="true")
    protected boolean failOnError = true;
    @Parameter(property="maven.compiler.failOnWarning", defaultValue="false")
    protected boolean failOnWarning;
    @Parameter(property="maven.compiler.debug", defaultValue="true")
    protected boolean debug = true;
    @Parameter(property="maven.compiler.parameters", defaultValue="false")
    protected boolean parameters;
    @Parameter(property="maven.compiler.enablePreview", defaultValue="false")
    protected boolean enablePreview;
    @Parameter(property="maven.compiler.verbose", defaultValue="false")
    protected boolean verbose;
    @Parameter(property="maven.compiler.showDeprecation", defaultValue="false")
    protected boolean showDeprecation;
    @Deprecated
    @Parameter(property="maven.compiler.optimize", defaultValue="false")
    protected boolean optimize;
    @Parameter(property="maven.compiler.showWarnings", defaultValue="true")
    protected boolean showWarnings;
    @Parameter(property="maven.compiler.source", defaultValue="1.8")
    protected String source;
    @Parameter(property="maven.compiler.target", defaultValue="1.8")
    protected String target;
    @Parameter(property="maven.compiler.release")
    protected String release;
    @Parameter(property="encoding", defaultValue="${project.build.sourceEncoding}")
    protected String encoding;
    @Parameter(property="lastModGranularityMs", defaultValue="0")
    protected int staleMillis;
    @Parameter(property="maven.compiler.compilerId", defaultValue="javac")
    protected String compilerId;
    @Deprecated
    @Parameter(property="maven.compiler.compilerVersion")
    protected String compilerVersion;
    @Parameter(property="maven.compiler.fork", defaultValue="false")
    protected boolean fork;
    @Parameter(property="maven.compiler.meminitial")
    protected String meminitial;
    @Parameter(property="maven.compiler.maxmem")
    protected String maxmem;
    @Parameter(property="maven.compiler.executable")
    protected String executable;
    @Parameter(property="maven.compiler.proc")
    protected String proc;
    @Parameter
    protected String[] annotationProcessors;
    @Parameter
    protected List<DependencyCoordinate> annotationProcessorPaths;
    @Parameter(defaultValue="false")
    protected boolean annotationProcessorPathsUseDepMgmt;
    @Parameter
    protected List<String> compilerArgs;
    @Parameter
    protected String compilerArgument;
    @Parameter
    private String outputFileName;
    @Parameter(property="maven.compiler.debuglevel")
    private String debuglevel;
    @Parameter(property="maven.compiler.implicit")
    protected String implicit;
    @Parameter
    protected Map<String, String> jdkToolchain;
    @Parameter(defaultValue="${project.basedir}", required=true, readonly=true)
    protected Path basedir;
    @Parameter(defaultValue="${project.build.directory}", required=true, readonly=true)
    protected Path buildDirectory;
    @Inject
    protected CompilerManager compilerManager;
    @Inject
    protected Session session;
    @Inject
    protected Project project;
    @Parameter(defaultValue="${reuseCreated}", property="maven.compiler.compilerReuseStrategy")
    protected String compilerReuseStrategy = "reuseCreated";
    @Parameter(defaultValue="false", property="maven.compiler.skipMultiThreadWarning")
    protected boolean skipMultiThreadWarning;
    @Parameter(defaultValue="false", property="maven.compiler.forceLegacyJavacApi")
    protected boolean forceLegacyJavacApi;
    @Parameter(defaultValue="maven-status/${mojo.plugin.descriptor.artifactId}/${mojo.goal}/${mojo.executionId}")
    protected String mojoStatusPath;
    @Parameter
    protected List<String> fileExtensions;
    @Parameter(defaultValue="true", property="maven.compiler.useIncrementalCompilation")
    protected boolean useIncrementalCompilation = true;
    @Parameter(defaultValue="true", property="maven.compiler.createMissingPackageInfoClass")
    protected boolean createMissingPackageInfoClass = true;
    @Parameter(defaultValue="false", property="maven.compiler.showCompilationChanges")
    protected boolean showCompilationChanges = false;
    @Parameter(defaultValue="${project.build.outputTimestamp}")
    protected String outputTimestamp;
    @Inject
    protected ProjectManager projectManager;
    @Inject
    protected ArtifactManager artifactManager;
    @Inject
    protected ToolchainManager toolchainManager;
    @Inject
    protected MessageBuilderFactory messageBuilderFactory;
    @Inject
    protected Log logger;
    private boolean targetOrReleaseSet;

    protected abstract SourceInclusionScanner getSourceInclusionScanner(int var1);

    protected abstract SourceInclusionScanner getSourceInclusionScanner(String var1);

    protected abstract List<String> getClasspathElements();

    protected abstract List<String> getModulepathElements();

    protected abstract Map<String, JavaModuleDescriptor> getPathElements();

    protected abstract List<Path> getCompileSourceRoots();

    protected abstract void preparePaths(Set<Path> var1);

    protected abstract Path getOutputDirectory();

    protected abstract String getSource();

    protected abstract String getTarget();

    protected abstract String getRelease();

    protected abstract String getCompilerArgument();

    protected abstract Path getGeneratedSourcesDirectory();

    protected abstract String getDebugFileName();

    protected final Project getProject() {
        return this.project;
    }

    public void execute() {
        CompilerResult compilerResult;
        Set<File> staleSources;
        Set<Path> sources;
        boolean canUpdateTarget;
        List<Path> compileSourceRoots;
        Compiler compiler;
        this.getLog().debug((CharSequence)("Using compiler '" + this.compilerId + "'."));
        try {
            compiler = this.compilerManager.getCompiler(this.compilerId);
            if (compiler instanceof LogEnabled) {
                ((LogEnabled)compiler).enableLogging((Logger)new MavenLogger());
            }
        }
        catch (NoSuchCompilerException e) {
            throw new MojoException("No such compiler '" + e.getCompilerId() + "'.");
        }
        Optional<Toolchain> tc = this.getToolchain();
        if (tc.isPresent()) {
            this.getLog().info((CharSequence)("Toolchain in maven-compiler-plugin: " + String.valueOf(tc)));
            if (this.executable != null) {
                this.getLog().warn((CharSequence)("Toolchains are ignored, 'executable' parameter is set to " + this.executable));
            } else {
                this.fork = true;
                this.executable = tc.get().findTool(this.compilerId);
            }
        }
        if ((compileSourceRoots = AbstractCompilerMojo.removeEmptyCompileSourceRoots(this.getCompileSourceRoots())).isEmpty()) {
            this.getLog().info((CharSequence)"No sources to compile");
            return;
        }
        if (!this.targetOrReleaseSet) {
            MessageBuilder mb = this.messageBuilderFactory.builder().a((CharSequence)"No explicit value set for target or release! ").a((CharSequence)"To ensure the same result even after upgrading this plugin, please add ").newline().newline();
            this.writePlugin(mb);
            this.getLog().warn((CharSequence)mb.build());
        }
        CompilerConfiguration compilerConfiguration = new CompilerConfiguration();
        compilerConfiguration.setOutputLocation(this.getOutputDirectory().toAbsolutePath().toString());
        compilerConfiguration.setOptimize(this.optimize);
        compilerConfiguration.setDebug(this.debug);
        compilerConfiguration.setDebugFileName(this.getDebugFileName());
        compilerConfiguration.setImplicitOption(this.implicit);
        if (this.debug && StringUtils.isNotEmpty((String)this.debuglevel)) {
            String[] split;
            for (String aSplit : split = StringUtils.split((String)this.debuglevel, (String)",")) {
                if (aSplit.equalsIgnoreCase("none") || aSplit.equalsIgnoreCase("lines") || aSplit.equalsIgnoreCase("vars") || aSplit.equalsIgnoreCase("source")) continue;
                throw new IllegalArgumentException("The specified debug level: '" + aSplit + "' is unsupported. Legal values are 'none', 'lines', 'vars', and 'source'.");
            }
            compilerConfiguration.setDebugLevel(this.debuglevel);
        }
        compilerConfiguration.setParameters(this.parameters);
        compilerConfiguration.setEnablePreview(this.enablePreview);
        compilerConfiguration.setVerbose(this.verbose);
        compilerConfiguration.setShowWarnings(this.showWarnings);
        compilerConfiguration.setFailOnWarning(this.failOnWarning);
        compilerConfiguration.setShowDeprecation(this.showDeprecation);
        compilerConfiguration.setSourceVersion(this.getSource());
        compilerConfiguration.setTargetVersion(this.getTarget());
        compilerConfiguration.setReleaseVersion(this.getRelease());
        compilerConfiguration.setProc(this.proc);
        Path generatedSourcesDirectory = this.getGeneratedSourcesDirectory();
        compilerConfiguration.setGeneratedSourcesDirectory(generatedSourcesDirectory != null ? generatedSourcesDirectory.toFile().getAbsoluteFile() : null);
        if (generatedSourcesDirectory != null) {
            if (!Files.exists(generatedSourcesDirectory, new LinkOption[0])) {
                try {
                    Files.createDirectories(generatedSourcesDirectory, new FileAttribute[0]);
                }
                catch (IOException e) {
                    throw new MojoException("Unable to create directory: " + String.valueOf(generatedSourcesDirectory), (Throwable)e);
                }
            }
            Path generatedSourcesPath = generatedSourcesDirectory.toAbsolutePath();
            compileSourceRoots.add(generatedSourcesPath);
            ProjectScope scope = this.isTestCompile() ? ProjectScope.TEST : ProjectScope.MAIN;
            this.getLog().debug((CharSequence)("Adding " + String.valueOf(generatedSourcesPath) + " to " + scope.id() + "-compile source roots:\n  " + StringUtils.join(this.projectManager.getCompileSourceRoots(this.project, scope).iterator(), (String)"\n  ")));
            this.projectManager.addCompileSourceRoot(this.project, scope, generatedSourcesPath);
            this.getLog().debug((CharSequence)("New " + scope.id() + "-compile source roots:\n  " + StringUtils.join(this.projectManager.getCompileSourceRoots(this.project, scope).iterator(), (String)"\n  ")));
        }
        compilerConfiguration.setSourceLocations(compileSourceRoots.stream().map(Path::toString).collect(Collectors.toList()));
        compilerConfiguration.setAnnotationProcessors(this.annotationProcessors);
        compilerConfiguration.setProcessorPathEntries(this.resolveProcessorPathEntries());
        compilerConfiguration.setSourceEncoding(this.encoding);
        compilerConfiguration.setFork(this.fork);
        if (this.fork) {
            String value;
            if (!StringUtils.isEmpty((String)this.meminitial)) {
                value = this.getMemoryValue(this.meminitial);
                if (value != null) {
                    compilerConfiguration.setMeminitial(value);
                } else {
                    this.getLog().info((CharSequence)("Invalid value for meminitial '" + this.meminitial + "'. Ignoring this option."));
                }
            }
            if (!StringUtils.isEmpty((String)this.maxmem)) {
                value = this.getMemoryValue(this.maxmem);
                if (value != null) {
                    compilerConfiguration.setMaxmem(value);
                } else {
                    this.getLog().info((CharSequence)("Invalid value for maxmem '" + this.maxmem + "'. Ignoring this option."));
                }
            }
        }
        compilerConfiguration.setExecutable(this.executable);
        compilerConfiguration.setWorkingDirectory(this.basedir.toFile());
        compilerConfiguration.setCompilerVersion(this.compilerVersion);
        compilerConfiguration.setBuildDirectory(this.buildDirectory.toFile());
        compilerConfiguration.setOutputFileName(this.outputFileName);
        if (CompilerConfiguration.CompilerReuseStrategy.AlwaysNew.getStrategy().equals(this.compilerReuseStrategy)) {
            compilerConfiguration.setCompilerReuseStrategy(CompilerConfiguration.CompilerReuseStrategy.AlwaysNew);
        } else if (CompilerConfiguration.CompilerReuseStrategy.ReuseSame.getStrategy().equals(this.compilerReuseStrategy)) {
            if (this.getRequestThreadCount() > 1 && !this.skipMultiThreadWarning) {
                this.getLog().warn((CharSequence)("You are in a multi-thread build and compilerReuseStrategy is set to reuseSame. This can cause issues in some environments (os/jdk)! Consider using reuseCreated strategy." + System.getProperty("line.separator") + "If your env is fine with reuseSame, you can skip this warning with the configuration field skipMultiThreadWarning or -Dmaven.compiler.skipMultiThreadWarning=true"));
            }
            compilerConfiguration.setCompilerReuseStrategy(CompilerConfiguration.CompilerReuseStrategy.ReuseSame);
        } else {
            compilerConfiguration.setCompilerReuseStrategy(CompilerConfiguration.CompilerReuseStrategy.ReuseCreated);
        }
        this.getLog().debug((CharSequence)("CompilerReuseStrategy: " + compilerConfiguration.getCompilerReuseStrategy().getStrategy()));
        compilerConfiguration.setForceJavacCompilerUse(this.forceLegacyJavacApi);
        IncrementalBuildHelper incrementalBuildHelper = null;
        if (this.useIncrementalCompilation) {
            this.getLog().debug((CharSequence)"useIncrementalCompilation enabled");
            try {
                canUpdateTarget = compiler.canUpdateTarget(compilerConfiguration);
                sources = this.getCompileSources(compiler, compilerConfiguration);
                this.preparePaths(sources);
                incrementalBuildHelper = new IncrementalBuildHelper(this.mojoStatusPath, sources, this.buildDirectory, this.getOutputDirectory());
                ArrayList<String> added = new ArrayList<String>();
                ArrayList<String> removed = new ArrayList<String>();
                boolean immutableOutputFile = compiler.getCompilerOutputStyle().equals((Object)CompilerOutputStyle.ONE_OUTPUT_FILE_FOR_ALL_INPUT_FILES) && !canUpdateTarget;
                boolean dependencyChanged = this.isDependencyChanged();
                boolean sourceChanged = this.isSourceChanged(compilerConfiguration, compiler);
                boolean inputFileTreeChanged = incrementalBuildHelper.inputFileTreeChanged(added, removed);
                if (immutableOutputFile || dependencyChanged || sourceChanged || inputFileTreeChanged) {
                    String cause = immutableOutputFile ? "immutable single output file" : (dependencyChanged ? "changed dependency" : (sourceChanged ? "changed source code" : "added or removed source files"));
                    this.getLog().info((CharSequence)("Recompiling the module because of " + cause + "."));
                    if (this.showCompilationChanges) {
                        for (String fileAdded : added) {
                            this.getLog().info((CharSequence)("\t+ " + fileAdded));
                        }
                        for (String fileRemoved : removed) {
                            this.getLog().info((CharSequence)("\t- " + fileRemoved));
                        }
                    }
                } else {
                    this.getLog().info((CharSequence)"Nothing to compile - all classes are up to date.");
                    return;
                }
                compilerConfiguration.setSourceFiles(sources.stream().map(Path::toFile).collect(Collectors.toSet()));
            }
            catch (CompilerException e) {
                throw new MojoException("Error while computing stale sources.", (Throwable)e);
            }
        }
        this.getLog().debug((CharSequence)"useIncrementalCompilation disabled");
        try {
            staleSources = this.computeStaleSources(compilerConfiguration, compiler, this.getSourceInclusionScanner(this.staleMillis));
            canUpdateTarget = compiler.canUpdateTarget(compilerConfiguration);
            if (compiler.getCompilerOutputStyle().equals((Object)CompilerOutputStyle.ONE_OUTPUT_FILE_FOR_ALL_INPUT_FILES) && !canUpdateTarget) {
                this.getLog().info((CharSequence)"RESCANNING!");
                String inputFileEnding = compiler.getInputFileEnding(compilerConfiguration);
                staleSources = this.computeStaleSources(compilerConfiguration, compiler, this.getSourceInclusionScanner(inputFileEnding));
            }
        }
        catch (CompilerException e) {
            throw new MojoException("Error while computing stale sources.", (Throwable)e);
        }
        if (staleSources.isEmpty()) {
            this.getLog().info((CharSequence)"Nothing to compile - all classes are up to date.");
            return;
        }
        compilerConfiguration.setSourceFiles(staleSources);
        try {
            sources = this.getCompileSources(compiler, compilerConfiguration);
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)("#sources: " + sources.size()));
                for (Path file : sources) {
                    this.getLog().debug((CharSequence)file.toString());
                }
            }
            this.preparePaths(sources);
        }
        catch (CompilerException e) {
            throw new MojoException("Error while computing stale sources.", (Throwable)e);
        }
        compilerConfiguration.setClasspathEntries(this.getClasspathElements());
        compilerConfiguration.setModulepathEntries(this.getModulepathElements());
        compilerConfiguration.setIncludes(this.getIncludes());
        compilerConfiguration.setExcludes(this.getExcludes());
        String effectiveCompilerArgument = this.getCompilerArgument();
        if (effectiveCompilerArgument != null || this.compilerArgs != null) {
            if (!StringUtils.isEmpty((String)effectiveCompilerArgument)) {
                compilerConfiguration.addCompilerCustomArgument(effectiveCompilerArgument, null);
            }
            if (this.compilerArgs != null) {
                for (String arg : this.compilerArgs) {
                    compilerConfiguration.addCompilerCustomArgument(arg, null);
                }
            }
        }
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)"Classpath:");
            for (String s : this.getClasspathElements()) {
                this.getLog().debug((CharSequence)(" " + s));
            }
            if (!this.getModulepathElements().isEmpty()) {
                this.getLog().debug((CharSequence)"Modulepath:");
                for (String s : this.getModulepathElements()) {
                    this.getLog().debug((CharSequence)(" " + s));
                }
            }
            this.getLog().debug((CharSequence)"Source roots:");
            for (Path root : this.getCompileSourceRoots()) {
                this.getLog().debug((CharSequence)(" " + String.valueOf(root)));
            }
            try {
                String[] cl;
                if (this.fork && compilerConfiguration.getExecutable() != null) {
                    this.getLog().debug((CharSequence)"Executable: ");
                    this.getLog().debug((CharSequence)(" " + compilerConfiguration.getExecutable()));
                }
                if ((cl = compiler.createCommandLine(compilerConfiguration)) != null && cl.length > 0) {
                    StringBuilder sb = new StringBuilder();
                    sb.append(cl[0]);
                    for (int i = 1; i < cl.length; ++i) {
                        sb.append(" ");
                        sb.append(cl[i]);
                    }
                    this.getLog().debug((CharSequence)"Command line options:");
                    this.getLog().debug((CharSequence)sb.toString());
                }
            }
            catch (CompilerException ce) {
                this.getLog().debug((CharSequence)"Compilation error", (Throwable)ce);
            }
        }
        ArrayList<Object> jpmsLines = new ArrayList<Object>();
        List<String> runtimeArgs = Arrays.asList("--upgrade-module-path", "--add-exports", "--add-reads", "--add-modules", "--limit-modules");
        Iterator entryIter = compilerConfiguration.getCustomCompilerArgumentsEntries().iterator();
        while (entryIter.hasNext()) {
            String[] files;
            Map.Entry entry = (Map.Entry)entryIter.next();
            if (runtimeArgs.contains(entry.getKey())) {
                jpmsLines.add((String)entry.getKey());
                String value = (String)entry.getValue();
                if (value == null) {
                    entry = (Map.Entry)entryIter.next();
                    value = (String)entry.getKey();
                }
                jpmsLines.add(value);
                continue;
            }
            if (!"--patch-module".equals(entry.getKey())) continue;
            String value = (String)entry.getValue();
            if (value == null) {
                entry = (Map.Entry)entryIter.next();
                value = (String)entry.getKey();
            }
            String[] values = value.split("=");
            StringBuilder patchModule = new StringBuilder(values[0]);
            patchModule.append('=');
            LinkedHashSet<String> patchModules = new LinkedHashSet<String>();
            HashSet<Path> sourceRoots = new HashSet<Path>(this.getCompileSourceRoots());
            for (String file : files = values[1].split(PS)) {
                Path filePath = Paths.get(file, new String[0]);
                if (this.getOutputDirectory().equals(filePath)) {
                    patchModules.add("_");
                    continue;
                }
                if (this.getOutputDirectory().startsWith(filePath)) continue;
                if (sourceRoots.contains(filePath)) {
                    patchModules.add("_");
                    continue;
                }
                JavaModuleDescriptor descriptor = this.getPathElements().get(file);
                if (descriptor == null) {
                    if (Files.isDirectory(filePath, new LinkOption[0])) {
                        patchModules.add(file);
                        continue;
                    }
                    this.getLog().warn((CharSequence)("Can't locate " + file));
                    continue;
                }
                if (values[0].equals(descriptor.name())) continue;
                patchModules.add(descriptor.name());
            }
            StringBuilder sb = new StringBuilder();
            if (patchModules.isEmpty()) continue;
            for (String mod : patchModules) {
                if (sb.length() > 0) {
                    sb.append(", ");
                }
                sb.append(mod);
            }
            jpmsLines.add("--patch-module");
            jpmsLines.add(String.valueOf(patchModule) + sb.toString());
        }
        if (!jpmsLines.isEmpty()) {
            Path jpmsArgs = this.getOutputDirectory().toAbsolutePath().resolve("META-INF/jpms.args");
            try {
                Files.createDirectories(jpmsArgs.getParent(), new FileAttribute[0]);
                Files.write(jpmsArgs, jpmsLines, Charset.defaultCharset(), new OpenOption[0]);
            }
            catch (IOException e) {
                this.getLog().warn((CharSequence)e.getMessage());
            }
        }
        if (StringUtils.isEmpty((String)compilerConfiguration.getSourceEncoding())) {
            this.getLog().warn((CharSequence)("File encoding has not been set, using platform encoding " + ReaderFactory.FILE_ENCODING + ", i.e. build is platform dependent!"));
        }
        if (this.useIncrementalCompilation) {
            incrementalBuildHelper.beforeRebuildExecution();
            this.getLog().debug((CharSequence)"incrementalBuildHelper#beforeRebuildExecution");
        }
        try {
            compilerResult = compiler.performCompile(compilerConfiguration);
        }
        catch (Exception e) {
            throw new MojoException("Fatal error compiling", (Throwable)e);
        }
        if (this.createMissingPackageInfoClass && compilerResult.isSuccess() && compiler.getCompilerOutputStyle() == CompilerOutputStyle.ONE_OUTPUT_FILE_PER_INPUT_FILE) {
            try {
                SourceMapping sourceMapping = this.getSourceMapping(compilerConfiguration, compiler);
                this.createMissingPackageInfoClasses(compilerConfiguration, sourceMapping, sources);
            }
            catch (Exception e) {
                this.getLog().warn((CharSequence)"Error creating missing package info classes", (Throwable)e);
            }
        }
        if (this.outputTimestamp != null && (this.outputTimestamp.length() > 1 || Character.isDigit(this.outputTimestamp.charAt(0)))) {
            this.patchJdkModuleVersion(compilerResult, sources);
        }
        if (this.useIncrementalCompilation) {
            if (Files.exists(this.getOutputDirectory(), new LinkOption[0])) {
                this.getLog().debug((CharSequence)"incrementalBuildHelper#afterRebuildExecution");
                incrementalBuildHelper.afterRebuildExecution();
            } else {
                this.getLog().debug((CharSequence)"skip incrementalBuildHelper#afterRebuildExecution as the output directory doesn't exist");
            }
        }
        ArrayList<CompilerMessage> warnings = new ArrayList<CompilerMessage>();
        ArrayList<CompilerMessage> errors = new ArrayList<CompilerMessage>();
        ArrayList<CompilerMessage> others = new ArrayList<CompilerMessage>();
        for (CompilerMessage message : compilerResult.getCompilerMessages()) {
            if (message.getKind() == CompilerMessage.Kind.ERROR) {
                errors.add(message);
                continue;
            }
            if (message.getKind() == CompilerMessage.Kind.WARNING || message.getKind() == CompilerMessage.Kind.MANDATORY_WARNING) {
                warnings.add(message);
                continue;
            }
            others.add(message);
        }
        if (this.failOnError && !compilerResult.isSuccess()) {
            for (CompilerMessage message : others) {
                assert (message.getKind() != CompilerMessage.Kind.ERROR && message.getKind() != CompilerMessage.Kind.WARNING && message.getKind() != CompilerMessage.Kind.MANDATORY_WARNING);
                this.getLog().info((CharSequence)message.toString());
            }
            if (!warnings.isEmpty()) {
                this.getLog().info((CharSequence)"-------------------------------------------------------------");
                this.getLog().warn((CharSequence)"COMPILATION WARNING : ");
                this.getLog().info((CharSequence)"-------------------------------------------------------------");
                for (CompilerMessage warning : warnings) {
                    this.getLog().warn((CharSequence)warning.toString());
                }
                this.getLog().info((CharSequence)(warnings.size() + (warnings.size() > 1 ? " warnings " : " warning")));
                this.getLog().info((CharSequence)"-------------------------------------------------------------");
            }
            if (!errors.isEmpty()) {
                this.getLog().info((CharSequence)"-------------------------------------------------------------");
                this.getLog().error((CharSequence)"COMPILATION ERROR : ");
                this.getLog().info((CharSequence)"-------------------------------------------------------------");
                for (CompilerMessage error : errors) {
                    this.getLog().error((CharSequence)error.toString());
                }
                this.getLog().info((CharSequence)(errors.size() + (errors.size() > 1 ? " errors " : " error")));
                this.getLog().info((CharSequence)"-------------------------------------------------------------");
            }
            if (!errors.isEmpty()) {
                throw new CompilationFailureException(errors);
            }
            throw new CompilationFailureException(warnings);
        }
        block38: for (CompilerMessage message : compilerResult.getCompilerMessages()) {
            switch (message.getKind()) {
                case NOTE: 
                case OTHER: {
                    this.getLog().info((CharSequence)message.toString());
                    continue block38;
                }
                case ERROR: {
                    this.getLog().error((CharSequence)message.toString());
                    continue block38;
                }
            }
            this.getLog().warn((CharSequence)message.toString());
        }
    }

    private void createMissingPackageInfoClasses(CompilerConfiguration compilerConfiguration, SourceMapping sourceMapping, Set<Path> sources) throws InclusionScanException, IOException {
        for (Path source : sources) {
            String path = source.toString();
            if (!path.endsWith(File.separator + "package-info.java")) continue;
            for (Path rootPath : this.getCompileSourceRoots()) {
                String root = rootPath.toString() + File.separator;
                if (!path.startsWith(root)) continue;
                String rel = path.substring(root.length());
                Set files = sourceMapping.getTargetFiles(this.getOutputDirectory().toFile(), rel);
                for (File file : files) {
                    if (file.exists()) continue;
                    File parentFile = file.getParentFile();
                    if (!parentFile.exists()) {
                        Files.createDirectories(parentFile.toPath(), new FileAttribute[0]);
                    }
                    byte[] bytes = this.generatePackage(compilerConfiguration, rel);
                    Files.write(file.toPath(), bytes, new OpenOption[0]);
                }
            }
        }
    }

    private byte[] generatePackage(CompilerConfiguration compilerConfiguration, String javaFile) {
        int version = this.getOpcode(compilerConfiguration);
        String internalPackageName = javaFile.substring(0, javaFile.length() - ".java".length());
        if (File.separatorChar != '/') {
            internalPackageName = internalPackageName.replace(File.separatorChar, '/');
        }
        ClassWriter cw = new ClassWriter(0);
        cw.visit(version, 5632, internalPackageName, null, "java/lang/Object", null);
        cw.visitSource("package-info.java", null);
        return cw.toByteArray();
    }

    private int getOpcode(CompilerConfiguration compilerConfiguration) {
        int iVersion;
        String version = compilerConfiguration.getReleaseVersion();
        if (version == null && (version = compilerConfiguration.getTargetVersion()) == null) {
            version = "1.5";
        }
        if (version.startsWith("1.")) {
            version = version.substring(2);
        }
        if ((iVersion = Integer.parseInt(version)) < 2) {
            throw new IllegalArgumentException("Unsupported java version '" + version + "'");
        }
        return iVersion - 2 + 46;
    }

    protected boolean isTestCompile() {
        return false;
    }

    private Set<Path> getCompileSources(Compiler compiler, CompilerConfiguration compilerConfiguration) throws MojoException, CompilerException {
        String inputFileEnding = compiler.getInputFileEnding(compilerConfiguration);
        if (StringUtils.isEmpty((String)inputFileEnding)) {
            inputFileEnding = ".*";
        }
        SourceInclusionScanner scanner = this.getSourceInclusionScanner(inputFileEnding);
        SourceMapping mapping = this.getSourceMapping(compilerConfiguration, compiler);
        scanner.addSourceMapping(mapping);
        HashSet<Path> compileSources = new HashSet<Path>();
        for (Path sourceRoot : this.getCompileSourceRoots()) {
            if (!Files.isDirectory(sourceRoot, new LinkOption[0]) || sourceRoot.toFile().equals(compilerConfiguration.getGeneratedSourcesDirectory())) continue;
            try {
                scanner.getIncludedSources(sourceRoot.toFile(), null).forEach(f -> compileSources.add(f.toPath()));
            }
            catch (InclusionScanException e) {
                throw new MojoException("Error scanning source root: '" + String.valueOf(sourceRoot) + "' for stale files to recompile.", (Throwable)e);
            }
        }
        return compileSources;
    }

    protected abstract Set<String> getIncludes();

    protected abstract Set<String> getExcludes();

    private boolean isSourceChanged(CompilerConfiguration compilerConfiguration, Compiler compiler) throws CompilerException, MojoException {
        Set<File> staleSources = this.computeStaleSources(compilerConfiguration, compiler, this.getSourceInclusionScanner(this.staleMillis));
        if (this.getLog().isDebugEnabled() || this.showCompilationChanges) {
            for (File f : staleSources) {
                if (this.showCompilationChanges) {
                    this.getLog().info((CharSequence)("Stale source detected: " + f.getAbsolutePath()));
                    continue;
                }
                this.getLog().debug((CharSequence)("Stale source detected: " + f.getAbsolutePath()));
            }
        }
        return !staleSources.isEmpty();
    }

    protected int getRequestThreadCount() {
        return this.session.getDegreeOfConcurrency();
    }

    protected Instant getBuildStartTime() {
        return this.session.getStartTime();
    }

    private String getMemoryValue(String setting) {
        Object value = null;
        if (this.isDigits(setting)) {
            value = setting + "m";
        } else if (this.isDigits(setting.substring(0, setting.length() - 1)) && setting.toLowerCase().endsWith("m")) {
            value = setting;
        }
        return value;
    }

    protected final Optional<Toolchain> getToolchain() {
        List tcs;
        if (this.jdkToolchain != null && (tcs = this.toolchainManager.getToolchains(this.session, "jdk", this.jdkToolchain)) != null && !tcs.isEmpty()) {
            return Optional.of((Toolchain)tcs.get(0));
        }
        return this.toolchainManager.getToolchainFromBuildContext(this.session, "jdk");
    }

    private boolean isDigits(String string) {
        for (int i = 0; i < string.length(); ++i) {
            if (Character.isDigit(string.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private Set<File> computeStaleSources(CompilerConfiguration compilerConfiguration, Compiler compiler, SourceInclusionScanner scanner) throws MojoException, CompilerException {
        SourceMapping mapping = this.getSourceMapping(compilerConfiguration, compiler);
        CompilerOutputStyle outputStyle = compiler.getCompilerOutputStyle();
        Path outputDirectory = outputStyle == CompilerOutputStyle.ONE_OUTPUT_FILE_FOR_ALL_INPUT_FILES ? this.buildDirectory : this.getOutputDirectory();
        scanner.addSourceMapping(mapping);
        HashSet<File> staleSources = new HashSet<File>();
        for (Path sourceRoot : this.getCompileSourceRoots()) {
            if (!Files.isDirectory(sourceRoot, new LinkOption[0])) continue;
            try {
                staleSources.addAll(scanner.getIncludedSources(sourceRoot.toFile(), outputDirectory.toFile()));
            }
            catch (InclusionScanException e) {
                throw new MojoException("Error scanning source root: '" + String.valueOf(sourceRoot) + "' for stale files to recompile.", (Throwable)e);
            }
        }
        return staleSources;
    }

    private SourceMapping getSourceMapping(CompilerConfiguration compilerConfiguration, Compiler compiler) throws CompilerException, MojoException {
        SuffixMapping mapping;
        CompilerOutputStyle outputStyle = compiler.getCompilerOutputStyle();
        if (outputStyle == CompilerOutputStyle.ONE_OUTPUT_FILE_PER_INPUT_FILE) {
            mapping = new SuffixMapping(compiler.getInputFileEnding(compilerConfiguration), compiler.getOutputFileEnding(compilerConfiguration));
        } else if (outputStyle == CompilerOutputStyle.ONE_OUTPUT_FILE_FOR_ALL_INPUT_FILES) {
            mapping = new SingleTargetSourceMapping(compiler.getInputFileEnding(compilerConfiguration), compiler.getOutputFile(compilerConfiguration));
        } else {
            throw new MojoException("Unknown compiler output style: '" + String.valueOf(outputStyle) + "'.");
        }
        return mapping;
    }

    private static List<Path> removeEmptyCompileSourceRoots(List<Path> compileSourceRootsList) {
        if (compileSourceRootsList != null) {
            return compileSourceRootsList.stream().filter(x$0 -> Files.exists(x$0, new LinkOption[0])).collect(Collectors.toList());
        }
        return new ArrayList<Path>();
    }

    protected boolean isDependencyChanged() {
        if (this.session == null) {
            this.getLog().info((CharSequence)"Cannot determine build start date, skipping incremental build detection.");
            return false;
        }
        if (this.fileExtensions == null || this.fileExtensions.isEmpty()) {
            this.fileExtensions = Collections.unmodifiableList(Arrays.asList("class", "jar"));
        }
        Instant buildStartTime = this.getBuildStartTime();
        ArrayList<String> pathElements = new ArrayList<String>();
        pathElements.addAll(this.getClasspathElements());
        pathElements.addAll(this.getModulepathElements());
        for (String pathElement : pathElements) {
            File artifactPath = new File(pathElement);
            if (!artifactPath.isDirectory() && !artifactPath.isFile() || !this.hasNewFile(artifactPath, buildStartTime)) continue;
            if (this.showCompilationChanges) {
                this.getLog().info((CharSequence)("New dependency detected: " + artifactPath.getAbsolutePath()));
            } else {
                this.getLog().debug((CharSequence)("New dependency detected: " + artifactPath.getAbsolutePath()));
            }
            return true;
        }
        return false;
    }

    private boolean hasNewFile(File classPathEntry, Instant buildStartTime) {
        File[] children;
        if (!classPathEntry.exists()) {
            return false;
        }
        if (classPathEntry.isFile()) {
            return classPathEntry.lastModified() >= buildStartTime.toEpochMilli() && this.fileExtensions.contains(FileUtils.getExtension((String)classPathEntry.getName()));
        }
        for (File child : children = classPathEntry.listFiles()) {
            if (!this.hasNewFile(child, buildStartTime)) continue;
            return true;
        }
        return false;
    }

    private List<String> resolveProcessorPathEntries() throws MojoException {
        if (this.annotationProcessorPaths == null || this.annotationProcessorPaths.isEmpty()) {
            return null;
        }
        try {
            Session session = this.session.withRemoteRepositories(this.projectManager.getRemoteProjectRepositories(this.project));
            List coords = this.annotationProcessorPaths.stream().map(this::toCoordinate).collect(Collectors.toList());
            return ((DependencyResolver)session.getService(DependencyResolver.class)).resolve(DependencyResolverRequest.builder().session(session).dependencies(coords).managedDependencies(this.project.getManagedDependencies()).pathScope(PathScope.MAIN_RUNTIME).build()).getPaths().stream().map(Path::toString).collect(Collectors.toList());
        }
        catch (Exception e) {
            throw new MojoException("Resolution of annotationProcessorPath dependencies failed: " + e.getMessage(), (Throwable)e);
        }
    }

    private org.apache.maven.api.DependencyCoordinate toCoordinate(DependencyCoordinate coord) {
        return ((DependencyCoordinateFactory)this.session.getService(DependencyCoordinateFactory.class)).create(DependencyCoordinateFactoryRequest.builder().session(this.session).groupId(coord.getGroupId()).artifactId(coord.getArtifactId()).classifier(coord.getClassifier()).type(coord.getType()).version(this.getAnnotationProcessorPathVersion(coord)).exclusions(this.toExclusions(coord.getExclusions())).build());
    }

    private Collection<Exclusion> toExclusions(Set<DependencyExclusion> exclusions) {
        if (exclusions == null || exclusions.isEmpty()) {
            return List.of();
        }
        return exclusions.stream().map(e -> new Exclusion(){
            final /* synthetic */ DependencyExclusion val$e;
            {
                this.val$e = dependencyExclusion;
            }

            public String getGroupId() {
                return this.val$e.getGroupId();
            }

            public String getArtifactId() {
                return this.val$e.getArtifactId();
            }
        }).toList();
    }

    private String getAnnotationProcessorPathVersion(DependencyCoordinate annotationProcessorPath) throws MojoException {
        String configuredVersion = annotationProcessorPath.getVersion();
        if (configuredVersion != null) {
            return configuredVersion;
        }
        List managedDependencies = this.project.getManagedDependencies();
        return this.findManagedVersion(annotationProcessorPath, managedDependencies).orElseThrow(() -> new MojoException(String.format("Cannot find version for annotation processor path '%s'. The version needs to be either provided directly in the plugin configuration or via dependency management.", annotationProcessorPath)));
    }

    private Optional<String> findManagedVersion(DependencyCoordinate dependencyCoordinate, List<org.apache.maven.api.DependencyCoordinate> managedDependencies) {
        return managedDependencies.stream().filter(dep -> Objects.equals(dep.getGroupId(), dependencyCoordinate.getGroupId()) && Objects.equals(dep.getArtifactId(), dependencyCoordinate.getArtifactId()) && Objects.equals(dep.getClassifier(), dependencyCoordinate.getClassifier()) && Objects.equals(dep.getType().id(), dependencyCoordinate.getType())).findAny().map(d -> d.getVersion().asString());
    }

    private void writePlugin(MessageBuilder mb) {
        mb.a((CharSequence)"    <plugin>").newline();
        mb.a((CharSequence)"      <groupId>org.apache.maven.plugins</groupId>").newline();
        mb.a((CharSequence)"      <artifactId>maven-compiler-plugin</artifactId>").newline();
        String version = this.getMavenCompilerPluginVersion();
        if (version != null) {
            mb.a((CharSequence)"      <version>").a((CharSequence)version).a((CharSequence)"</version>").newline();
        }
        this.writeConfig(mb);
        mb.a((CharSequence)"    </plugin>").newline();
    }

    private void writeConfig(MessageBuilder mb) {
        mb.a((CharSequence)"      <configuration>").newline();
        if (this.release != null && !this.release.isEmpty()) {
            mb.a((CharSequence)"        <release>").a((CharSequence)this.release).a((CharSequence)"</release>").newline();
        } else if (JavaVersion.JAVA_VERSION.isAtLeast("9")) {
            String rls = this.target.replaceAll(".\\.", "");
            mb.a((CharSequence)"        <release>").a((CharSequence)rls).a((CharSequence)"</release>").newline();
        } else {
            mb.a((CharSequence)"        <source>").a((CharSequence)this.source).a((CharSequence)"</source>").newline();
            mb.a((CharSequence)"        <target>").a((CharSequence)this.target).a((CharSequence)"</target>").newline();
        }
        mb.a((CharSequence)"      </configuration>").newline();
    }

    private String getMavenCompilerPluginVersion() {
        Properties pomProperties = new Properties();
        try (InputStream is = AbstractCompilerMojo.class.getResourceAsStream("/META-INF/maven/org.apache.maven.plugins/maven-compiler-plugin/pom.properties");){
            if (is != null) {
                pomProperties.load(is);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return pomProperties.getProperty("version");
    }

    public void setTarget(String target) {
        this.target = target;
        this.targetOrReleaseSet = true;
    }

    public void setRelease(String release) {
        this.release = release;
        this.targetOrReleaseSet = true;
    }

    final String getImplicit() {
        return this.implicit;
    }

    private void patchJdkModuleVersion(CompilerResult compilerResult, Set<Path> sources) throws MojoException {
        Path moduleDescriptor;
        if (compilerResult.isSuccess() && this.getModuleDeclaration(sources).isPresent() && Files.isRegularFile(moduleDescriptor = this.getOutputDirectory().resolve("module-info.class"), new LinkOption[0])) {
            try {
                byte[] descriptorOriginal = Files.readAllBytes(moduleDescriptor);
                byte[] descriptorMod = ModuleInfoTransformer.transform(descriptorOriginal, this.getRelease(), this.getLog());
                if (descriptorMod != null) {
                    Files.write(moduleDescriptor, descriptorMod, new OpenOption[0]);
                }
            }
            catch (IOException ex) {
                throw new MojoException("Error reading or writing module-info.class", (Throwable)ex);
            }
        }
    }

    protected final Optional<Path> getModuleDeclaration(Set<Path> sourceFiles) {
        for (Path sourceFile : sourceFiles) {
            if (!"module-info.java".equals(sourceFile.getFileName().toString())) continue;
            return Optional.of(sourceFile);
        }
        return Optional.empty();
    }

    protected Log getLog() {
        return this.logger;
    }

    class MavenLogger
    extends AbstractLogger {
        MavenLogger() {
            super(0, AbstractCompilerMojo.this.getClass().getName());
        }

        public void debug(String message, Throwable throwable) {
            AbstractCompilerMojo.this.logger.debug((CharSequence)message, throwable);
        }

        public boolean isDebugEnabled() {
            return AbstractCompilerMojo.this.logger.isDebugEnabled();
        }

        public void info(String message, Throwable throwable) {
            AbstractCompilerMojo.this.logger.info((CharSequence)message, throwable);
        }

        public boolean isInfoEnabled() {
            return AbstractCompilerMojo.this.logger.isInfoEnabled();
        }

        public void warn(String message, Throwable throwable) {
            AbstractCompilerMojo.this.logger.warn((CharSequence)message, throwable);
        }

        public boolean isWarnEnabled() {
            return AbstractCompilerMojo.this.logger.isWarnEnabled();
        }

        public void error(String message, Throwable throwable) {
            AbstractCompilerMojo.this.logger.error((CharSequence)message, throwable);
        }

        public boolean isErrorEnabled() {
            return AbstractCompilerMojo.this.logger.isErrorEnabled();
        }

        public void fatalError(String message, Throwable throwable) {
            AbstractCompilerMojo.this.logger.error((CharSequence)message, throwable);
        }

        public boolean isFatalErrorEnabled() {
            return this.isFatalErrorEnabled();
        }

        public Logger getChildLogger(String name) {
            return this;
        }
    }
}

