/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.eclipse.writers.myeclipse;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Map;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.eclipse.Messages;
import org.apache.maven.plugin.eclipse.writers.AbstractEclipseWriter;
import org.apache.maven.plugin.ide.IdeUtils;
import org.codehaus.plexus.util.IOUtil;

public class MyEclipseHibernateWriter
extends AbstractEclipseWriter {
    private static final String MYECLIPSE_HIBERNATE_DATA_FILE = ".myhibernatedata";
    private static final String MYECLIPSE_HB_GEN_COMP_ID = "genBasicCompId";
    private static final String MYECLIPSE_HB_SESSION_FACTORY_NAME = "sessionFactoryName";
    private static final String MYECLIPSE_HB_PROFILE = "profile";
    private static final String MYECLIPSE_HB_DAO_SF_ID = "daoSFId";
    private static final String MYECLIPSE_HB_VERSION = "version";
    private static final String MYECLIPSE_HB_JNDI_PATH = "jndiPath";
    private static final String MYECLIPSE_HB_DETECT_M2M = "detectM2M";
    private static final String MYECLIPSE_HB_RE_STRATEGY_CLASS = "reStrategyClass";
    private static final String MYECLIPSE_HB_SPRING_DAO_FILE = "springDaoFile";
    private static final String MYECLIPSE_HB_USE_JAVA_TYPES = "useJavaTypes";
    private static final String MYECLIPSE_HB_KEY_GENERATOR = "keyGenerator";
    private static final String MYECLIPSE_HB_LIB_INSTALL_FOLDER = "libInstallFolder";
    private static final String MYECLIPSE_HB_ADD_LIBS_TO_PROJECT = "addLibs2Project";
    private static final String MYECLIPSE_HB_GEN_VERSION_TAG = "genVersionTag";
    private static final String MYECLIPSE_HB_SESSION_FACTORY_ID = "sessionFactoryId";
    private static final String MYECLIPSE_HB_BASE_PERSISTENT_CLASS = "basePersistenceClass";
    private static final String MYECLIPSE_HB_RE_SETTINGS_FILE = "reSettingsFile";
    private static final String MYECLIPSE_HB_CONFIG_FILE = "configFile";
    private static final String MYECLIPSE_HB_CREATE_CONFIG_FILE = "createConfigFile";
    private static final String MYECLIPSE_HB_ADD_LIBS_TO_CLASSPATH = "addLibs2Classpath";
    private static final String MYECLIPSE_HB_BASE_DAO_CLASS = "baseDaoClass";
    private Map hibernateConfig;

    public MyEclipseHibernateWriter(Map hibernateConfig) {
        this.hibernateConfig = hibernateConfig;
    }

    public void write() throws MojoExecutionException {
        FileWriter w;
        try {
            w = new FileWriter(new File(this.config.getEclipseProjectDirectory(), MYECLIPSE_HIBERNATE_DATA_FILE));
        }
        catch (IOException ex) {
            throw new MojoExecutionException(Messages.getString("EclipsePlugin.erroropeningfile"), (Exception)ex);
        }
        PrintWriter pw = new PrintWriter(w);
        pw.println("# Generated by Maven");
        this.addProperty(pw, MYECLIPSE_HB_GEN_COMP_ID, "false");
        this.addProperty(pw, MYECLIPSE_HB_SESSION_FACTORY_NAME, null);
        this.addProperty(pw, MYECLIPSE_HB_PROFILE, null);
        this.addProperty(pw, MYECLIPSE_HB_DAO_SF_ID, null);
        this.addProperty(pw, MYECLIPSE_HB_VERSION, this.getHibernateVersion());
        this.addProperty(pw, MYECLIPSE_HB_JNDI_PATH, null);
        this.addProperty(pw, MYECLIPSE_HB_DETECT_M2M, "false");
        this.addProperty(pw, MYECLIPSE_HB_RE_STRATEGY_CLASS, null);
        this.addProperty(pw, MYECLIPSE_HB_SPRING_DAO_FILE, null);
        this.addProperty(pw, MYECLIPSE_HB_USE_JAVA_TYPES, "true");
        this.addProperty(pw, MYECLIPSE_HB_KEY_GENERATOR, null);
        this.addProperty(pw, MYECLIPSE_HB_LIB_INSTALL_FOLDER, null);
        this.addProperty(pw, MYECLIPSE_HB_ADD_LIBS_TO_PROJECT, "false");
        this.addProperty(pw, MYECLIPSE_HB_GEN_VERSION_TAG, "false");
        this.addProperty(pw, MYECLIPSE_HB_SESSION_FACTORY_ID, (String)this.hibernateConfig.get("session-factory-id"));
        this.addProperty(pw, MYECLIPSE_HB_BASE_PERSISTENT_CLASS, null);
        this.addProperty(pw, MYECLIPSE_HB_RE_SETTINGS_FILE, null);
        this.addProperty(pw, MYECLIPSE_HB_CONFIG_FILE, this.makePathToHibernateConfigFile((String)this.hibernateConfig.get("config-file")));
        this.addProperty(pw, MYECLIPSE_HB_CREATE_CONFIG_FILE, "false");
        this.addProperty(pw, MYECLIPSE_HB_ADD_LIBS_TO_CLASSPATH, "false");
        this.addProperty(pw, MYECLIPSE_HB_BASE_DAO_CLASS, null);
        IOUtil.close((Writer)w);
    }

    private void addProperty(PrintWriter pw, String propName, String propValue) {
        StringBuilder sb = new StringBuilder(64);
        sb.append(propName).append("=");
        if (propValue != null) {
            sb.append(propValue);
        }
        pw.println(sb.toString());
    }

    private String getHibernateVersion() {
        String version = IdeUtils.getArtifactVersion(new String[]{"hibernate"}, this.config.getProject().getDependencies(), 3);
        return version != null ? version : "3.2";
    }

    private String makePathToHibernateConfigFile(String configFile) {
        return "/" + this.config.getProject().getArtifactId() + "/" + configFile;
    }
}

