/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.junitcore;

import java.util.concurrent.atomic.AtomicReference;
import org.apache.maven.surefire.api.report.CategorizedReportEntry;
import org.apache.maven.surefire.api.report.ConsoleOutputReceiver;
import org.apache.maven.surefire.api.report.ConsoleOutputReceiverForCurrentThread;
import org.apache.maven.surefire.api.report.ReportEntry;
import org.apache.maven.surefire.api.report.RunListener;
import org.apache.maven.surefire.junitcore.LogicalStream;
import org.apache.maven.surefire.junitcore.TestSet;

class TestMethod
implements ConsoleOutputReceiver {
    private static final InheritableThreadLocal<TestMethod> TEST_METHOD = new InheritableThreadLocal();
    private final AtomicReference<LogicalStream> output = new AtomicReference();
    private final ReportEntry description;
    private final TestSet testSet;
    private final long startTime;
    private volatile long endTime;
    private volatile ReportEntry testFailure;
    private volatile ReportEntry testError;
    private volatile ReportEntry testIgnored;
    private volatile ReportEntry testAssumption;

    TestMethod(ReportEntry description, TestSet testSet) {
        this.description = description;
        this.testSet = testSet;
        this.startTime = System.currentTimeMillis();
    }

    void testFinished() {
        this.setEndTime();
    }

    void testIgnored(ReportEntry description) {
        this.testIgnored = description;
        this.setEndTime();
    }

    void testFailure(ReportEntry failure) {
        this.testFailure = failure;
        this.setEndTime();
    }

    void testError(ReportEntry failure) {
        this.testError = failure;
        this.setEndTime();
    }

    void testAssumption(ReportEntry failure) {
        this.testAssumption = failure;
        this.setEndTime();
    }

    private void setEndTime() {
        this.endTime = System.currentTimeMillis();
    }

    int getElapsed() {
        return this.endTime > 0L ? (int)(this.endTime - this.startTime) : 0;
    }

    long getStartTime() {
        return this.startTime;
    }

    long getEndTime() {
        return this.endTime;
    }

    void replay(RunListener reporter) {
        if (this.testIgnored != null) {
            reporter.testSkipped(this.createReportEntry(this.testIgnored));
        } else {
            ReportEntry descriptionReport = this.createReportEntry(this.description);
            reporter.testStarting(descriptionReport);
            LogicalStream ls = this.output.get();
            if (ls != null) {
                ls.writeDetails((ConsoleOutputReceiver)reporter);
            }
            if (this.testFailure != null) {
                reporter.testFailed(this.createReportEntry(this.testFailure));
            } else if (this.testError != null) {
                reporter.testError(this.createReportEntry(this.testError));
            } else if (this.testAssumption != null) {
                reporter.testAssumptionFailure(this.createReportEntry(this.testAssumption));
            } else {
                reporter.testSucceeded(descriptionReport);
            }
        }
    }

    private ReportEntry createReportEntry(ReportEntry reportEntry) {
        return new CategorizedReportEntry(reportEntry.getSourceName(), reportEntry.getName(), reportEntry.getGroup(), reportEntry.getStackTraceWriter(), Integer.valueOf(this.getElapsed()), reportEntry.getMessage());
    }

    void attachToThread() {
        TEST_METHOD.set(this);
        ConsoleOutputReceiverForCurrentThread.set((ConsoleOutputReceiver)this);
    }

    void detachFromCurrentThread() {
        TEST_METHOD.remove();
        ConsoleOutputReceiverForCurrentThread.remove();
    }

    static TestMethod getThreadTestMethod() {
        return (TestMethod)TEST_METHOD.get();
    }

    LogicalStream getLogicalStream() {
        LogicalStream ls = this.output.get();
        if (ls == null && !this.output.compareAndSet(null, ls = new LogicalStream())) {
            ls = this.output.get();
        }
        return ls;
    }

    public void writeTestOutput(String output, boolean newLine, boolean stdout) {
        this.getLogicalStream().write(stdout, output, newLine);
    }

    TestSet getTestSet() {
        return this.testSet;
    }
}

