/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.binder.engine.segment.dml.projection;

import com.cedarsoftware.util.CaseInsensitiveMap;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import lombok.Generated;
import org.apache.shardingsphere.infra.binder.engine.segment.SegmentType;
import org.apache.shardingsphere.infra.binder.engine.segment.dml.expression.ExpressionSegmentBinder;
import org.apache.shardingsphere.infra.binder.engine.segment.dml.from.context.TableSegmentBinderContext;
import org.apache.shardingsphere.infra.binder.engine.segment.dml.from.context.type.SimpleTableSegmentBinderContext;
import org.apache.shardingsphere.infra.binder.engine.segment.dml.projection.type.ColumnProjectionSegmentBinder;
import org.apache.shardingsphere.infra.binder.engine.segment.dml.projection.type.ShorthandProjectionSegmentBinder;
import org.apache.shardingsphere.infra.binder.engine.segment.dml.projection.type.SubqueryProjectionSegmentBinder;
import org.apache.shardingsphere.infra.binder.engine.segment.util.SubqueryTableBindUtils;
import org.apache.shardingsphere.infra.binder.engine.statement.SQLStatementBinderContext;
import org.apache.shardingsphere.infra.exception.kernel.metadata.ColumnNotFoundException;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.ExpressionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.item.AggregationDistinctProjectionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.item.AggregationProjectionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.item.ColumnProjectionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.item.ExpressionProjectionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.item.ProjectionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.item.ProjectionsSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.item.ShorthandProjectionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.item.SubqueryProjectionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.table.TableSegment;
import org.apache.shardingsphere.sql.parser.statement.core.value.identifier.IdentifierValue;

public final class ProjectionsSegmentBinder {
    public static ProjectionsSegment bind(ProjectionsSegment segment, SQLStatementBinderContext binderContext, TableSegment boundTableSegment, Multimap<CaseInsensitiveMap.CaseInsensitiveString, TableSegmentBinderContext> tableBinderContexts, Multimap<CaseInsensitiveMap.CaseInsensitiveString, TableSegmentBinderContext> outerTableBinderContexts) {
        ProjectionsSegment result = new ProjectionsSegment(segment.getStartIndex(), segment.getStopIndex());
        result.setDistinctRow(segment.isDistinctRow());
        for (ProjectionSegment each : segment.getProjections()) {
            Multimap<CaseInsensitiveMap.CaseInsensitiveString, TableSegmentBinderContext> currentTableBinderContexts = ProjectionsSegmentBinder.createCurrentTableBinderContexts(binderContext, result.getProjections());
            result.getProjections().add(ProjectionsSegmentBinder.bind(binderContext, boundTableSegment, currentTableBinderContexts, tableBinderContexts, outerTableBinderContexts, each));
        }
        return result;
    }

    private static ProjectionSegment bind(SQLStatementBinderContext binderContext, TableSegment boundTableSegment, Multimap<CaseInsensitiveMap.CaseInsensitiveString, TableSegmentBinderContext> currentTableBinderContexts, Multimap<CaseInsensitiveMap.CaseInsensitiveString, TableSegmentBinderContext> tableBinderContexts, Multimap<CaseInsensitiveMap.CaseInsensitiveString, TableSegmentBinderContext> outerTableBinderContexts, ProjectionSegment projectionSegment) {
        try {
            return ProjectionsSegmentBinder.bind(projectionSegment, binderContext, boundTableSegment, tableBinderContexts, outerTableBinderContexts);
        }
        catch (ColumnNotFoundException ignored) {
            return ProjectionsSegmentBinder.bind(projectionSegment, binderContext, boundTableSegment, currentTableBinderContexts, outerTableBinderContexts);
        }
    }

    private static ProjectionSegment bind(ProjectionSegment projectionSegment, SQLStatementBinderContext binderContext, TableSegment boundTableSegment, Multimap<CaseInsensitiveMap.CaseInsensitiveString, TableSegmentBinderContext> tableBinderContexts, Multimap<CaseInsensitiveMap.CaseInsensitiveString, TableSegmentBinderContext> outerTableBinderContexts) {
        if (projectionSegment instanceof ColumnProjectionSegment) {
            return ColumnProjectionSegmentBinder.bind((ColumnProjectionSegment)projectionSegment, binderContext, tableBinderContexts, outerTableBinderContexts);
        }
        if (projectionSegment instanceof ShorthandProjectionSegment) {
            return ShorthandProjectionSegmentBinder.bind((ShorthandProjectionSegment)projectionSegment, boundTableSegment, tableBinderContexts);
        }
        if (projectionSegment instanceof SubqueryProjectionSegment) {
            LinkedHashMultimap newOuterTableBinderContexts = LinkedHashMultimap.create();
            newOuterTableBinderContexts.putAll(outerTableBinderContexts);
            newOuterTableBinderContexts.putAll(tableBinderContexts);
            return SubqueryProjectionSegmentBinder.bind((SubqueryProjectionSegment)projectionSegment, binderContext, (Multimap<CaseInsensitiveMap.CaseInsensitiveString, TableSegmentBinderContext>)newOuterTableBinderContexts);
        }
        if (projectionSegment instanceof ExpressionProjectionSegment) {
            ExpressionSegment boundExpressionSegment = ExpressionSegmentBinder.bind(((ExpressionProjectionSegment)projectionSegment).getExpr(), SegmentType.PROJECTION, binderContext, tableBinderContexts, outerTableBinderContexts);
            ExpressionProjectionSegment result = new ExpressionProjectionSegment(projectionSegment.getStartIndex(), projectionSegment.getStopIndex(), ((ExpressionProjectionSegment)projectionSegment).getText(), boundExpressionSegment);
            result.setAlias(((ExpressionProjectionSegment)projectionSegment).getAliasSegment());
            return result;
        }
        if (projectionSegment instanceof AggregationDistinctProjectionSegment) {
            return ProjectionsSegmentBinder.bindAggregationDistinctProjection((AggregationDistinctProjectionSegment)projectionSegment, binderContext, tableBinderContexts, outerTableBinderContexts);
        }
        if (projectionSegment instanceof AggregationProjectionSegment) {
            return ProjectionsSegmentBinder.bindAggregationProjection((AggregationProjectionSegment)projectionSegment, binderContext, tableBinderContexts, outerTableBinderContexts);
        }
        return projectionSegment;
    }

    private static AggregationDistinctProjectionSegment bindAggregationDistinctProjection(AggregationDistinctProjectionSegment aggregationDistinctSegment, SQLStatementBinderContext binderContext, Multimap<CaseInsensitiveMap.CaseInsensitiveString, TableSegmentBinderContext> tableBinderContexts, Multimap<CaseInsensitiveMap.CaseInsensitiveString, TableSegmentBinderContext> outerTableBinderContexts) {
        AggregationDistinctProjectionSegment result = new AggregationDistinctProjectionSegment(aggregationDistinctSegment.getStartIndex(), aggregationDistinctSegment.getStopIndex(), aggregationDistinctSegment.getType(), aggregationDistinctSegment.getExpression(), aggregationDistinctSegment.getDistinctInnerExpression(), (String)aggregationDistinctSegment.getSeparator().orElse(null));
        aggregationDistinctSegment.getParameters().forEach(each -> result.getParameters().add(ExpressionSegmentBinder.bind(each, SegmentType.PROJECTION, binderContext, tableBinderContexts, outerTableBinderContexts)));
        aggregationDistinctSegment.getAliasSegment().ifPresent(arg_0 -> ((AggregationDistinctProjectionSegment)result).setAlias(arg_0));
        return result;
    }

    private static AggregationProjectionSegment bindAggregationProjection(AggregationProjectionSegment aggregationSegment, SQLStatementBinderContext binderContext, Multimap<CaseInsensitiveMap.CaseInsensitiveString, TableSegmentBinderContext> tableBinderContexts, Multimap<CaseInsensitiveMap.CaseInsensitiveString, TableSegmentBinderContext> outerTableBinderContexts) {
        AggregationProjectionSegment result = new AggregationProjectionSegment(aggregationSegment.getStartIndex(), aggregationSegment.getStopIndex(), aggregationSegment.getType(), aggregationSegment.getExpression(), (String)aggregationSegment.getSeparator().orElse(null));
        aggregationSegment.getParameters().forEach(each -> result.getParameters().add(ExpressionSegmentBinder.bind(each, SegmentType.PROJECTION, binderContext, tableBinderContexts, outerTableBinderContexts)));
        aggregationSegment.getAliasSegment().ifPresent(arg_0 -> ((AggregationProjectionSegment)result).setAlias(arg_0));
        return result;
    }

    private static Multimap<CaseInsensitiveMap.CaseInsensitiveString, TableSegmentBinderContext> createCurrentTableBinderContexts(SQLStatementBinderContext binderContext, Collection<ProjectionSegment> projections) {
        LinkedHashMultimap result = LinkedHashMultimap.create();
        Collection<ProjectionSegment> subqueryProjections = SubqueryTableBindUtils.createSubqueryProjections(projections, new IdentifierValue(""), binderContext.getSqlStatement().getDatabaseType());
        result.put((Object)new CaseInsensitiveMap.CaseInsensitiveString(""), (Object)new SimpleTableSegmentBinderContext(subqueryProjections));
        return result;
    }

    @Generated
    private ProjectionsSegmentBinder() {
    }
}

