/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.metadata;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.shardingsphere.infra.config.schema.SchemaConfiguration;
import org.apache.shardingsphere.infra.database.type.DatabaseType;
import org.apache.shardingsphere.infra.database.type.DatabaseTypeRecognizer;
import org.apache.shardingsphere.infra.metadata.resource.CachedDatabaseMetaData;
import org.apache.shardingsphere.infra.metadata.resource.DataSourcesMetaData;
import org.apache.shardingsphere.infra.metadata.resource.ShardingSphereResource;
import org.apache.shardingsphere.infra.metadata.rule.ShardingSphereRuleMetaData;
import org.apache.shardingsphere.infra.metadata.schema.ShardingSphereSchema;
import org.apache.shardingsphere.infra.rule.ShardingSphereRule;

public final class ShardingSphereMetaData {
    private final String name;
    private final ShardingSphereResource resource;
    private final ShardingSphereRuleMetaData ruleMetaData;
    private final ShardingSphereSchema schema;

    public static ShardingSphereMetaData create(String schemaName, ShardingSphereSchema schema, SchemaConfiguration schemaConfig, Collection<ShardingSphereRule> rules) throws SQLException {
        ShardingSphereResource resource = ShardingSphereMetaData.createResource(schemaConfig.getDataSources());
        ShardingSphereRuleMetaData ruleMetaData = new ShardingSphereRuleMetaData(schemaConfig.getRuleConfigurations(), rules);
        return new ShardingSphereMetaData(schemaName, resource, ruleMetaData, schema);
    }

    private static ShardingSphereResource createResource(Map<String, DataSource> dataSourceMap) throws SQLException {
        DatabaseType databaseType = DatabaseTypeRecognizer.getDatabaseType(dataSourceMap.values());
        DataSourcesMetaData dataSourcesMetaData = new DataSourcesMetaData(databaseType, dataSourceMap);
        CachedDatabaseMetaData cachedDatabaseMetaData = ShardingSphereMetaData.createCachedDatabaseMetaData(dataSourceMap).orElse(null);
        return new ShardingSphereResource(dataSourceMap, dataSourcesMetaData, cachedDatabaseMetaData, databaseType);
    }

    private static Optional<CachedDatabaseMetaData> createCachedDatabaseMetaData(Map<String, DataSource> dataSources) throws SQLException {
        if (dataSources.isEmpty()) {
            return Optional.empty();
        }
        try (Connection connection = dataSources.values().iterator().next().getConnection();){
            Optional<CachedDatabaseMetaData> optional = Optional.of(new CachedDatabaseMetaData(connection.getMetaData()));
            return optional;
        }
    }

    public boolean isComplete() {
        return !this.ruleMetaData.getRules().isEmpty() && !this.resource.getDataSources().isEmpty();
    }

    public boolean hasDataSource() {
        return !this.resource.getDataSources().isEmpty();
    }

    @Generated
    public ShardingSphereMetaData(String name, ShardingSphereResource resource, ShardingSphereRuleMetaData ruleMetaData, ShardingSphereSchema schema) {
        this.name = name;
        this.resource = resource;
        this.ruleMetaData = ruleMetaData;
        this.schema = schema;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public ShardingSphereResource getResource() {
        return this.resource;
    }

    @Generated
    public ShardingSphereRuleMetaData getRuleMetaData() {
        return this.ruleMetaData;
    }

    @Generated
    public ShardingSphereSchema getSchema() {
        return this.schema;
    }
}

