/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.metadata.schema.builder.loader;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.sql.SQLException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.apache.shardingsphere.infra.database.type.DatabaseType;
import org.apache.shardingsphere.infra.database.type.DatabaseTypeAwareSPI;
import org.apache.shardingsphere.infra.exception.ShardingSphereException;
import org.apache.shardingsphere.infra.metadata.schema.builder.loader.TableMetaDataLoaderMaterial;
import org.apache.shardingsphere.infra.metadata.schema.builder.loader.common.TableMetaDataLoader;
import org.apache.shardingsphere.infra.metadata.schema.builder.spi.DialectTableMetaDataLoader;
import org.apache.shardingsphere.infra.metadata.schema.model.TableMetaData;
import org.apache.shardingsphere.spi.singleton.SingletonSPIRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TableMetaDataLoaderEngine {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TableMetaDataLoaderEngine.class);
    private static final Map<String, DialectTableMetaDataLoader> DIALECT_METADATA_LOADER_MAP = SingletonSPIRegistry.getSingletonInstancesMap(DialectTableMetaDataLoader.class, DatabaseTypeAwareSPI::getDatabaseType);
    private static final ExecutorService EXECUTOR_SERVICE = new ThreadPoolExecutor(Runtime.getRuntime().availableProcessors() * 2, Runtime.getRuntime().availableProcessors() * 2, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactoryBuilder().setDaemon(true).setNameFormat("ShardingSphere-TableMetaDataLoaderEngine-%d").build());

    public static Collection<TableMetaData> load(Collection<TableMetaDataLoaderMaterial> materials, DatabaseType databaseType) throws SQLException {
        Optional<DialectTableMetaDataLoader> dialectTableMetaDataLoader = TableMetaDataLoaderEngine.findDialectTableMetaDataLoader(databaseType);
        if (dialectTableMetaDataLoader.isPresent()) {
            try {
                return TableMetaDataLoaderEngine.loadByDialect(dialectTableMetaDataLoader.get(), materials);
            }
            catch (SQLException | ShardingSphereException ex) {
                log.error("Dialect load table meta data error", (Throwable)ex);
                return TableMetaDataLoaderEngine.loadByDefault(materials, databaseType);
            }
        }
        return TableMetaDataLoaderEngine.loadByDefault(materials, databaseType);
    }

    private static Collection<TableMetaData> loadByDefault(Collection<TableMetaDataLoaderMaterial> materials, DatabaseType databaseType) throws SQLException {
        LinkedList<TableMetaData> result = new LinkedList<TableMetaData>();
        for (TableMetaDataLoaderMaterial each : materials) {
            for (String tableName : each.getTableNames()) {
                TableMetaDataLoader.load(each.getDataSource(), tableName, databaseType).ifPresent(result::add);
            }
        }
        return result;
    }

    private static Collection<TableMetaData> loadByDialect(DialectTableMetaDataLoader loader, Collection<TableMetaDataLoaderMaterial> materials) throws SQLException {
        LinkedList<TableMetaData> result = new LinkedList<TableMetaData>();
        LinkedList<Future<Map>> futures = new LinkedList<Future<Map>>();
        for (TableMetaDataLoaderMaterial tableMetaDataLoaderMaterial : materials) {
            futures.add(EXECUTOR_SERVICE.submit(() -> loader.load(tableMetaDataLoaderMaterial.getDataSource(), tableMetaDataLoaderMaterial.getTableNames())));
        }
        try {
            for (Future future : futures) {
                result.addAll(((Map)future.get()).values());
            }
        }
        catch (InterruptedException | ExecutionException ex) {
            if (ex.getCause() instanceof SQLException) {
                throw (SQLException)ex.getCause();
            }
            throw new ShardingSphereException(ex);
        }
        return result;
    }

    private static Optional<DialectTableMetaDataLoader> findDialectTableMetaDataLoader(DatabaseType databaseType) {
        return Optional.ofNullable(DIALECT_METADATA_LOADER_MAP.get(databaseType.getName()));
    }

    @Generated
    private TableMetaDataLoaderEngine() {
    }
}

