/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.route.engine;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.shardingsphere.infra.binder.context.extractor.SQLStatementContextExtractor;
import org.apache.shardingsphere.infra.binder.context.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.config.props.ConfigurationProperties;
import org.apache.shardingsphere.infra.exception.kernel.syntax.hint.DataSourceHintNotExistsException;
import org.apache.shardingsphere.infra.hint.HintManager;
import org.apache.shardingsphere.infra.hint.HintValueContext;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.database.resource.unit.StorageUnit;
import org.apache.shardingsphere.infra.metadata.database.rule.RuleMetaData;
import org.apache.shardingsphere.infra.route.SQLRouter;
import org.apache.shardingsphere.infra.route.context.RouteContext;
import org.apache.shardingsphere.infra.route.context.RouteMapper;
import org.apache.shardingsphere.infra.route.context.RouteUnit;
import org.apache.shardingsphere.infra.route.engine.tableless.router.TablelessSQLRouter;
import org.apache.shardingsphere.infra.route.lifecycle.DecorateSQLRouter;
import org.apache.shardingsphere.infra.route.lifecycle.EntranceSQLRouter;
import org.apache.shardingsphere.infra.rule.ShardingSphereRule;
import org.apache.shardingsphere.infra.session.query.QueryContext;
import org.apache.shardingsphere.infra.spi.type.ordered.OrderedSPILoader;

public final class SQLRouteEngine {
    private final ConfigurationProperties props;
    private final Map<ShardingSphereRule, SQLRouter> dataNodeRouters;
    private final Map<ShardingSphereRule, SQLRouter> dataSourceRouters;

    public SQLRouteEngine(Collection<ShardingSphereRule> rules, ConfigurationProperties props) {
        this.props = props;
        Map routers = OrderedSPILoader.getServices(SQLRouter.class, rules);
        this.dataNodeRouters = this.filterRouters(routers, SQLRouter.Type.DATA_NODE);
        this.dataSourceRouters = this.filterRouters(routers, SQLRouter.Type.DATA_SOURCE);
    }

    private Map<ShardingSphereRule, SQLRouter> filterRouters(Map<ShardingSphereRule, SQLRouter> routers, SQLRouter.Type type) {
        LinkedHashMap<ShardingSphereRule, SQLRouter> result = new LinkedHashMap<ShardingSphereRule, SQLRouter>();
        for (Map.Entry<ShardingSphereRule, SQLRouter> entry : routers.entrySet()) {
            if (type != entry.getValue().getType()) continue;
            result.put(entry.getKey(), entry.getValue());
        }
        return result;
    }

    public RouteContext route(QueryContext queryContext, RuleMetaData globalRuleMetaData, ShardingSphereDatabase database) {
        RouteContext result = new RouteContext();
        Optional<String> dataSourceName = this.findDataSourceByHint(queryContext.getHintValueContext(), database.getResourceMetaData().getStorageUnits());
        if (dataSourceName.isPresent()) {
            result.getRouteUnits().add(new RouteUnit(new RouteMapper(dataSourceName.get(), dataSourceName.get()), Collections.emptyList()));
            return result;
        }
        Collection tableNames = SQLStatementContextExtractor.getTableNames((ShardingSphereDatabase)database, (SQLStatementContext)queryContext.getSqlStatementContext());
        result = this.route(queryContext, globalRuleMetaData, database, this.dataNodeRouters, tableNames, result);
        result = new TablelessSQLRouter().route(queryContext, globalRuleMetaData, database, tableNames, result);
        if ((result = this.route(queryContext, globalRuleMetaData, database, this.dataSourceRouters, tableNames, result)).getRouteUnits().isEmpty() && 1 == database.getResourceMetaData().getStorageUnits().size()) {
            String singleDataSourceName = (String)database.getResourceMetaData().getStorageUnits().keySet().iterator().next();
            result.getRouteUnits().add(new RouteUnit(new RouteMapper(singleDataSourceName, singleDataSourceName), Collections.emptyList()));
        }
        return result;
    }

    private RouteContext route(QueryContext queryContext, RuleMetaData globalRuleMetaData, ShardingSphereDatabase database, Map<ShardingSphereRule, SQLRouter> routers, Collection<String> tableNames, RouteContext routeContext) {
        RouteContext result = routeContext;
        for (Map.Entry<ShardingSphereRule, SQLRouter> entry : routers.entrySet()) {
            if (result.getRouteUnits().isEmpty() && entry.getValue() instanceof EntranceSQLRouter) {
                result = ((EntranceSQLRouter)entry.getValue()).createRouteContext(queryContext, globalRuleMetaData, database, entry.getKey(), tableNames, this.props);
                continue;
            }
            if (!(entry.getValue() instanceof DecorateSQLRouter)) continue;
            ((DecorateSQLRouter)entry.getValue()).decorateRouteContext(result, queryContext, database, entry.getKey(), tableNames, this.props);
        }
        return result;
    }

    private Optional<String> findDataSourceByHint(HintValueContext hintValueContext, Map<String, StorageUnit> storageUnits) {
        Optional result;
        Optional optional = result = HintManager.isInstantiated() && HintManager.getDataSourceName().isPresent() ? HintManager.getDataSourceName() : hintValueContext.findHintDataSourceName();
        if (result.isPresent() && !storageUnits.containsKey(result.get())) {
            throw new DataSourceHintNotExistsException((String)result.get());
        }
        return result;
    }
}

