/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.session.connection;

import java.util.Collection;
import java.util.HashSet;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.infra.metadata.user.Grantee;
import org.apache.shardingsphere.infra.session.connection.cursor.CursorConnectionContext;
import org.apache.shardingsphere.infra.session.connection.datasource.UsedDataSourceProvider;
import org.apache.shardingsphere.infra.session.connection.transaction.TransactionConnectionContext;

public final class ConnectionContext
implements AutoCloseable {
    private final UsedDataSourceProvider usedDataSourceProvider;
    private final Grantee grantee;
    private final CursorConnectionContext cursorContext = new CursorConnectionContext();
    private final TransactionConnectionContext transactionContext = new TransactionConnectionContext();
    private String currentDatabaseName;

    public ConnectionContext(UsedDataSourceProvider usedDataSourceProvider) {
        this(usedDataSourceProvider, null);
    }

    public Collection<String> getUsedDataSourceNames() {
        HashSet<String> result = new HashSet<String>(this.usedDataSourceProvider.getNames().size(), 1.0f);
        for (String each : this.usedDataSourceProvider.getNames()) {
            result.add(each.contains(".") ? each.split("\\.")[1] : each);
        }
        return result;
    }

    public void clearCursorContext() {
        this.cursorContext.close();
    }

    public void clearTransactionContext() {
        this.transactionContext.close();
    }

    public void setCurrentDatabaseName(String currentDatabaseName) {
        if (null != currentDatabaseName && !currentDatabaseName.equals(this.currentDatabaseName)) {
            this.currentDatabaseName = currentDatabaseName;
        }
    }

    public Optional<String> getCurrentDatabaseName() {
        return Optional.ofNullable(this.currentDatabaseName);
    }

    @Override
    public void close() {
        this.clearCursorContext();
        this.clearTransactionContext();
    }

    @Generated
    public ConnectionContext(UsedDataSourceProvider usedDataSourceProvider, Grantee grantee) {
        this.usedDataSourceProvider = usedDataSourceProvider;
        this.grantee = grantee;
    }

    @Generated
    public Grantee getGrantee() {
        return this.grantee;
    }

    @Generated
    public CursorConnectionContext getCursorContext() {
        return this.cursorContext;
    }

    @Generated
    public TransactionConnectionContext getTransactionContext() {
        return this.transactionContext;
    }
}

