/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.session.query;

import com.google.common.base.Joiner;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import lombok.Generated;
import org.apache.shardingsphere.infra.binder.context.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.binder.context.type.TableAvailable;
import org.apache.shardingsphere.infra.exception.core.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.exception.dialect.exception.syntax.database.UnknownDatabaseException;
import org.apache.shardingsphere.infra.exception.generic.UnsupportedSQLOperationException;
import org.apache.shardingsphere.infra.hint.HintValueContext;
import org.apache.shardingsphere.infra.metadata.ShardingSphereMetaData;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.session.connection.ConnectionContext;

public final class QueryContext {
    private final SQLStatementContext sqlStatementContext;
    private final String sql;
    private final List<Object> parameters;
    private final HintValueContext hintValueContext;
    private final ConnectionContext connectionContext;
    private final ShardingSphereMetaData metaData;
    private final Collection<String> usedDatabaseNames;
    private final boolean useCache;

    public QueryContext(SQLStatementContext sqlStatementContext, String sql, List<Object> params, HintValueContext hintValueContext, ConnectionContext connectionContext, ShardingSphereMetaData metaData) {
        this(sqlStatementContext, sql, params, hintValueContext, connectionContext, metaData, false);
    }

    public QueryContext(SQLStatementContext sqlStatementContext, String sql, List<Object> params, HintValueContext hintValueContext, ConnectionContext connectionContext, ShardingSphereMetaData metaData, boolean useCache) {
        this.sqlStatementContext = sqlStatementContext;
        this.sql = sql;
        this.parameters = params;
        this.hintValueContext = hintValueContext;
        this.connectionContext = connectionContext;
        this.metaData = metaData;
        this.usedDatabaseNames = this.getUsedDatabaseNames(sqlStatementContext, connectionContext);
        this.useCache = useCache;
    }

    private Collection<String> getUsedDatabaseNames(SQLStatementContext sqlStatementContext, ConnectionContext connectionContext) {
        if (sqlStatementContext instanceof TableAvailable) {
            Collection<String> result = ((TableAvailable)sqlStatementContext).getTablesContext().getDatabaseNames();
            return result.isEmpty() ? this.getCurrentDatabaseNames(connectionContext) : result;
        }
        return this.getCurrentDatabaseNames(connectionContext);
    }

    private Collection<String> getCurrentDatabaseNames(ConnectionContext connectionContext) {
        return connectionContext.getCurrentDatabaseName().isPresent() ? Collections.singleton(connectionContext.getCurrentDatabaseName().get()) : Collections.emptyList();
    }

    public ShardingSphereDatabase getUsedDatabase() {
        ShardingSpherePreconditions.checkState((this.usedDatabaseNames.size() <= 1 ? 1 : 0) != 0, () -> new UnsupportedSQLOperationException(String.format("Can not support multiple logic databases [%s]", Joiner.on((String)", ").join(this.usedDatabaseNames))));
        String databaseName = this.usedDatabaseNames.iterator().next();
        ShardingSpherePreconditions.checkState((boolean)this.metaData.containsDatabase(databaseName), () -> new UnknownDatabaseException(databaseName));
        return this.metaData.getDatabase(databaseName);
    }

    @Generated
    public SQLStatementContext getSqlStatementContext() {
        return this.sqlStatementContext;
    }

    @Generated
    public String getSql() {
        return this.sql;
    }

    @Generated
    public List<Object> getParameters() {
        return this.parameters;
    }

    @Generated
    public HintValueContext getHintValueContext() {
        return this.hintValueContext;
    }

    @Generated
    public ConnectionContext getConnectionContext() {
        return this.connectionContext;
    }

    @Generated
    public ShardingSphereMetaData getMetaData() {
        return this.metaData;
    }

    @Generated
    public Collection<String> getUsedDatabaseNames() {
        return this.usedDatabaseNames;
    }

    @Generated
    public boolean isUseCache() {
        return this.useCache;
    }
}

