/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.spring.boot.datasource;

import java.lang.reflect.Field;
import org.springframework.aop.framework.AdvisedSupport;
import org.springframework.aop.framework.AopProxy;
import org.springframework.aop.support.AopUtils;

public final class AopProxyUtils {
    public static Object getTarget(Object proxy) {
        if (AopUtils.isJdkDynamicProxy((Object)proxy)) {
            return AopProxyUtils.getJdkDynamicProxyTargetObject(proxy);
        }
        if (AopUtils.isCglibProxy((Object)proxy)) {
            return AopProxyUtils.getCglibProxyTargetObject(proxy);
        }
        return proxy;
    }

    private static Object getJdkDynamicProxyTargetObject(Object proxy) throws Exception {
        AopProxy aopProxy = AopProxyUtils.getJdkDynamicAopProxy(proxy);
        Field advisedField = aopProxy.getClass().getDeclaredField("advised");
        advisedField.setAccessible(true);
        return ((AdvisedSupport)advisedField.get(aopProxy)).getTargetSource().getTarget();
    }

    private static AopProxy getJdkDynamicAopProxy(Object proxy) {
        Field hField = proxy.getClass().getSuperclass().getDeclaredField("h");
        hField.setAccessible(true);
        return (AopProxy)hField.get(proxy);
    }

    private static Object getCglibProxyTargetObject(Object proxy) throws Exception {
        Object advisedInterceptor = AopProxyUtils.getCglibAdvisedInterceptor(proxy);
        Field advisedField = advisedInterceptor.getClass().getDeclaredField("advised");
        advisedField.setAccessible(true);
        return ((AdvisedSupport)advisedField.get(advisedInterceptor)).getTargetSource().getTarget();
    }

    private static Object getCglibAdvisedInterceptor(Object proxy) {
        Field callbackField = proxy.getClass().getDeclaredField("CGLIB$CALLBACK_0");
        callbackField.setAccessible(true);
        return callbackField.get(proxy);
    }
}

