/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.node.path;

import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;

public final class GlobalRuleNodePath {
    private static final String ROOT_NODE = "/rules";
    private static final String VERSIONS_NODE = "versions";
    private static final String ACTIVE_VERSION_NODE = "active_version";
    private static final String IDENTIFIER_PATTERN = "(\\w+)";
    private static final String VERSION_PATTERN = "(\\d+)";

    public static String getRootPath() {
        return ROOT_NODE;
    }

    public static String getRulePath(String ruleTypeName) {
        return String.join((CharSequence)"/", GlobalRuleNodePath.getRootPath(), ruleTypeName);
    }

    public static String getVersionRootPath(String ruleTypeName) {
        return String.join((CharSequence)"/", GlobalRuleNodePath.getRulePath(ruleTypeName), VERSIONS_NODE);
    }

    public static String getVersionPath(String ruleTypeName, String version) {
        return String.join((CharSequence)"/", GlobalRuleNodePath.getVersionRootPath(ruleTypeName), version);
    }

    public static String getActiveVersionPath(String ruleTypeName) {
        return String.join((CharSequence)"/", GlobalRuleNodePath.getRulePath(ruleTypeName), ACTIVE_VERSION_NODE);
    }

    public static Optional<String> findRuleTypeNameFromActiveVersion(String path) {
        Pattern pattern = Pattern.compile(GlobalRuleNodePath.getActiveVersionPath(IDENTIFIER_PATTERN) + "$", 2);
        Matcher matcher = pattern.matcher(path);
        return matcher.find() ? Optional.of(matcher.group(1)) : Optional.empty();
    }

    public static Optional<String> findVersion(String ruleTypeName, String path) {
        Pattern pattern = Pattern.compile(GlobalRuleNodePath.getVersionPath(ruleTypeName, VERSION_PATTERN) + "$", 2);
        Matcher matcher = pattern.matcher(path);
        return matcher.find() ? Optional.of(matcher.group(1)) : Optional.empty();
    }

    @Generated
    private GlobalRuleNodePath() {
    }
}

