/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.archiver.util;

import java.io.InputStream;
import java.util.List;
import org.codehaus.plexus.archiver.ArchiveFileFilter;
import org.codehaus.plexus.archiver.ArchiveFilterException;
import org.codehaus.plexus.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilterSupport {
    private final List<ArchiveFileFilter> filters;
    private final Logger logger;

    public FilterSupport(List<ArchiveFileFilter> filters, Logger logger) {
        this.filters = filters;
        this.logger = logger;
    }

    public boolean include(InputStream dataStream, String entryName) throws ArchiveFilterException {
        boolean included = true;
        if (this.filters != null && !this.filters.isEmpty()) {
            for (ArchiveFileFilter filter : this.filters) {
                included = filter.include(dataStream, entryName);
                if (included) continue;
                if (!this.logger.isDebugEnabled()) break;
                this.logger.debug("Entry: '" + entryName + "' excluded by filter: " + filter.getClass().getName());
                break;
            }
        }
        return included;
    }
}

