/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.common;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.drools.core.base.ClassObjectType;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.common.WorkingMemoryAction;
import org.drools.core.definitions.InternalKnowledgePackage;
import org.drools.core.definitions.rule.impl.RuleImpl;
import org.drools.core.marshalling.impl.MarshallerReaderContext;
import org.drools.core.reteoo.LeftTuple;
import org.drools.core.reteoo.PropertySpecificUtil;
import org.drools.core.reteoo.TerminalNode;
import org.drools.core.rule.EntryPointId;
import org.drools.core.rule.TypeDeclaration;
import org.drools.core.spi.ObjectType;
import org.drools.core.spi.PropagationContext;
import org.drools.core.util.bitmask.BitMask;
import org.kie.api.definition.rule.Rule;
import org.kie.api.runtime.rule.FactHandle;

public class PhreakPropagationContext
implements PropagationContext {
    private static final long serialVersionUID = 510L;
    private int type;
    private RuleImpl rule;
    private TerminalNode terminalNodeOrigin;
    private LeftTuple leftTuple;
    private InternalFactHandle factHandle;
    private long propagationNumber;
    private EntryPointId entryPoint;
    private int originOffset;
    private BitMask modificationMask = PropertySpecificUtil.allSetButTraitBitMask();
    private BitMask originalMask = PropertySpecificUtil.allSetButTraitBitMask();
    private Class<?> modifiedClass;
    private ObjectType objectType;
    private transient MarshallerReaderContext readerContext;

    public PhreakPropagationContext() {
    }

    public PhreakPropagationContext(long number, int type, RuleImpl rule, LeftTuple leftTuple, InternalFactHandle factHandle) {
        this(number, type, rule, leftTuple, factHandle, EntryPointId.DEFAULT, PropertySpecificUtil.allSetButTraitBitMask(), Object.class, null);
        this.originOffset = -1;
    }

    public PhreakPropagationContext(long number, int type, RuleImpl rule, LeftTuple leftTuple, InternalFactHandle factHandle, EntryPointId entryPoint) {
        this(number, type, rule, leftTuple, factHandle, entryPoint, PropertySpecificUtil.allSetButTraitBitMask(), Object.class, null);
    }

    public PhreakPropagationContext(long number, int type, RuleImpl rule, LeftTuple leftTuple, InternalFactHandle factHandle, int activeActivations, int dormantActivations, EntryPointId entryPoint, BitMask modificationMask) {
        this(number, type, rule, leftTuple, factHandle, entryPoint, modificationMask, Object.class, null);
    }

    public PhreakPropagationContext(long number, int type, RuleImpl rule, LeftTuple leftTuple, InternalFactHandle factHandle, EntryPointId entryPoint, MarshallerReaderContext readerContext) {
        this(number, type, rule, leftTuple, factHandle, entryPoint, PropertySpecificUtil.allSetButTraitBitMask(), Object.class, readerContext);
    }

    public PhreakPropagationContext(long number, int type, RuleImpl rule, LeftTuple leftTuple, InternalFactHandle factHandle, EntryPointId entryPoint, BitMask modificationMask, Class<?> modifiedClass, MarshallerReaderContext readerContext) {
        this.type = type;
        this.rule = rule;
        this.leftTuple = leftTuple;
        this.terminalNodeOrigin = leftTuple != null ? (TerminalNode)leftTuple.getSink() : null;
        this.factHandle = factHandle;
        this.propagationNumber = number;
        this.entryPoint = entryPoint;
        this.originOffset = -1;
        this.modificationMask = modificationMask;
        this.originalMask = modificationMask;
        this.modifiedClass = modifiedClass;
        this.readerContext = readerContext;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.type = in.readInt();
        this.propagationNumber = in.readLong();
        this.rule = (RuleImpl)in.readObject();
        this.leftTuple = (LeftTuple)in.readObject();
        this.entryPoint = (EntryPointId)in.readObject();
        this.originOffset = in.readInt();
        this.modificationMask = (BitMask)in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.type);
        out.writeLong(this.propagationNumber);
        out.writeObject(this.rule);
        out.writeObject(this.leftTuple);
        out.writeObject(this.entryPoint);
        out.writeInt(this.originOffset);
        out.writeObject(this.modificationMask);
    }

    public long getPropagationNumber() {
        return this.propagationNumber;
    }

    @Override
    public void cleanReaderContext() {
        this.readerContext = null;
    }

    @Override
    public RuleImpl getRuleOrigin() {
        return this.rule;
    }

    @Override
    public TerminalNode getTerminalNodeOrigin() {
        return this.terminalNodeOrigin;
    }

    public Rule getRule() {
        return this.rule;
    }

    @Override
    public LeftTuple getLeftTupleOrigin() {
        return this.leftTuple;
    }

    @Override
    public InternalFactHandle getFactHandleOrigin() {
        return this.factHandle;
    }

    public FactHandle getFactHandle() {
        return this.factHandle;
    }

    @Override
    public void setFactHandle(FactHandle factHandle) {
        this.factHandle = (InternalFactHandle)factHandle;
    }

    public int getType() {
        return this.type;
    }

    @Override
    public void releaseResources() {
        this.leftTuple = null;
    }

    @Override
    public EntryPointId getEntryPoint() {
        return this.entryPoint;
    }

    @Override
    public void setEntryPoint(EntryPointId entryPoint) {
        this.entryPoint = entryPoint;
    }

    public void setFactHandle(InternalFactHandle factHandle) {
        this.factHandle = factHandle;
    }

    @Override
    public int getOriginOffset() {
        return this.originOffset;
    }

    @Override
    public void setOriginOffset(int originOffset) {
        this.originOffset = originOffset;
    }

    @Override
    public void addInsertAction(WorkingMemoryAction action) {
        throw new UnsupportedOperationException("rete only method");
    }

    @Override
    public void removeInsertAction(WorkingMemoryAction action) {
        throw new UnsupportedOperationException("rete only method");
    }

    @Override
    public LinkedList<WorkingMemoryAction> getQueue1() {
        throw new UnsupportedOperationException("rete only method");
    }

    @Override
    public LinkedList<WorkingMemoryAction> getQueue2() {
        throw new UnsupportedOperationException("rete only method");
    }

    @Override
    public void evaluateActionQueue(InternalWorkingMemory workingMemory) {
    }

    @Override
    public BitMask getModificationMask() {
        return this.modificationMask;
    }

    @Override
    public void setModificationMask(BitMask modificationMask) {
        this.modificationMask = modificationMask;
    }

    @Override
    public PropagationContext adaptModificationMaskForObjectType(ObjectType type, InternalWorkingMemory workingMemory) {
        if (PropertySpecificUtil.isAllSetPropertyReactiveMask(this.originalMask) || this.originalMask.isSet(0) || !(type instanceof ClassObjectType)) {
            return this;
        }
        ClassObjectType classObjectType = (ClassObjectType)type;
        BitMask cachedMask = classObjectType.getTransformedMask(this.modifiedClass, this.originalMask);
        if (cachedMask != null) {
            return this;
        }
        this.modificationMask = this.originalMask;
        boolean typeBit = this.modificationMask.isSet(0);
        this.modificationMask = this.modificationMask.reset(0);
        Class<?> classType = classObjectType.getClassType();
        String pkgName = classType.getPackage().getName();
        if (classType == this.modifiedClass || "java.lang".equals(pkgName) || !classType.isInterface() && !this.modifiedClass.isInterface()) {
            if (typeBit) {
                this.modificationMask = this.modificationMask.set(0);
            }
            return this;
        }
        List<String> typeClassProps = this.getSettableProperties(workingMemory, classType, pkgName);
        List<String> modifiedClassProps = this.getSettableProperties(workingMemory, this.modifiedClass);
        this.modificationMask = PropertySpecificUtil.getEmptyPropertyReactiveMask(typeClassProps.size());
        for (int i = 0; i < modifiedClassProps.size(); ++i) {
            int posInType;
            if (!PropertySpecificUtil.isPropertySetOnMask(this.originalMask, i) || (posInType = typeClassProps.indexOf(modifiedClassProps.get(i))) < 0) continue;
            this.modificationMask = PropertySpecificUtil.setPropertyOnMask(this.modificationMask, posInType);
        }
        if (typeBit) {
            this.modificationMask = this.modificationMask.set(0);
        }
        classObjectType.storeTransformedMask(this.modifiedClass, this.originalMask, this.modificationMask);
        return this;
    }

    private List<String> getSettableProperties(InternalWorkingMemory workingMemory, Class<?> classType) {
        return this.getSettableProperties(workingMemory, classType, classType.getPackage().getName());
    }

    private List<String> getSettableProperties(InternalWorkingMemory workingMemory, Class<?> classType, String pkgName) {
        if (pkgName.equals("java.lang") || pkgName.equals("java.util")) {
            return Collections.EMPTY_LIST;
        }
        InternalKnowledgePackage pkg = workingMemory.getKnowledgeBase().getPackage(pkgName);
        TypeDeclaration tdecl = pkg != null ? pkg.getTypeDeclaration(classType) : null;
        return tdecl != null ? tdecl.getSettableProperties() : Collections.EMPTY_LIST;
    }

    @Override
    public ObjectType getObjectType() {
        return this.objectType;
    }

    @Override
    public void setObjectType(ObjectType objectType) {
        this.objectType = objectType;
    }

    @Override
    public MarshallerReaderContext getReaderContext() {
        return this.readerContext;
    }

    public static String intEnumToString(PropagationContext pctx) {
        Object pctxType = null;
        switch (pctx.getType()) {
            case 0: {
                return "INSERTION";
            }
            case 3: {
                return "RULE_ADDITION";
            }
            case 2: {
                return "MODIFICATION";
            }
            case 4: {
                return "RULE_REMOVAL";
            }
            case 1: {
                return "DELETION";
            }
            case 5: {
                return "EXPIRATION";
            }
        }
        throw new IllegalStateException("Int type unknown");
    }

    public String toString() {
        return "PhreakPropagationContext [entryPoint=" + this.entryPoint + ", factHandle=" + this.factHandle + ", leftTuple=" + this.leftTuple + ", originOffset=" + this.originOffset + ", propagationNumber=" + this.propagationNumber + ", rule=" + this.rule + ", type=" + this.type + "]";
    }
}

