/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.test.impl.logger;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.flowable.engine.impl.persistence.entity.ExecutionEntity;
import org.flowable.engine.test.impl.logger.AbstractDebugInfo;
import org.flowable.engine.test.impl.logger.DebugInfo;
import org.flowable.engine.test.impl.logger.DebugInfoExecutionTree;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessExecutionLogger {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProcessExecutionLogger.class);
    protected Map<String, List<DebugInfo>> debugInfoMap = new HashMap<String, List<DebugInfo>>();
    protected Map<String, ExecutionEntity> createdExecutions = new HashMap<String, ExecutionEntity>();
    protected Map<String, ExecutionEntity> deletedExecutions = new HashMap<String, ExecutionEntity>();

    public void addDebugInfo(AbstractDebugInfo debugInfo) {
        this.addDebugInfo(debugInfo, false);
    }

    public synchronized void addDebugInfo(AbstractDebugInfo debugInfo, boolean generateExecutionTreeRepresentation) {
        String threadName = Thread.currentThread().getName();
        if (!this.debugInfoMap.containsKey(threadName)) {
            this.debugInfoMap.put(threadName, new ArrayList());
        }
        this.debugInfoMap.get(threadName).add(debugInfo);
        if (generateExecutionTreeRepresentation) {
            debugInfo.setExecutionTrees(this.generateExecutionTrees());
        }
    }

    protected List<DebugInfoExecutionTree> generateExecutionTrees() {
        ArrayList<ExecutionEntity> processInstances = new ArrayList<ExecutionEntity>();
        HashMap<String, List<ExecutionEntity>> parentMapping = new HashMap<String, List<ExecutionEntity>>();
        for (ExecutionEntity executionEntity : this.createdExecutions.values()) {
            if (this.deletedExecutions.containsKey(executionEntity.getId())) continue;
            if (executionEntity.getParentId() == null) {
                processInstances.add(executionEntity);
                continue;
            }
            if (!parentMapping.containsKey(executionEntity.getParentId())) {
                parentMapping.put(executionEntity.getParentId(), new ArrayList());
            }
            ((List)parentMapping.get(executionEntity.getParentId())).add(executionEntity);
        }
        ArrayList<DebugInfoExecutionTree> executionTrees = new ArrayList<DebugInfoExecutionTree>();
        for (ExecutionEntity processInstance : processInstances) {
            DebugInfoExecutionTree executionTree = new DebugInfoExecutionTree();
            executionTrees.add(executionTree);
            DebugInfoExecutionTree.DebugInfoExecutionTreeNode rootNode = new DebugInfoExecutionTree.DebugInfoExecutionTreeNode();
            executionTree.setProcessInstance(rootNode);
            rootNode.setId(processInstance.getId());
            this.internalPopulateExecutionTree(rootNode, parentMapping);
        }
        return executionTrees;
    }

    protected void internalPopulateExecutionTree(DebugInfoExecutionTree.DebugInfoExecutionTreeNode parentNode, Map<String, List<ExecutionEntity>> parentMapping) {
        if (parentMapping.containsKey(parentNode.getId())) {
            for (ExecutionEntity childExecutionEntity : parentMapping.get(parentNode.getId())) {
                DebugInfoExecutionTree.DebugInfoExecutionTreeNode childNode = new DebugInfoExecutionTree.DebugInfoExecutionTreeNode();
                childNode.setId(childExecutionEntity.getId());
                childNode.setActivityId(childExecutionEntity.getCurrentFlowElement() != null ? childExecutionEntity.getCurrentFlowElement().getId() : null);
                childNode.setActivityName(childExecutionEntity.getCurrentFlowElement() != null ? childExecutionEntity.getCurrentFlowElement().getName() : null);
                childNode.setProcessDefinitionId(childExecutionEntity.getProcessDefinitionId());
                childNode.setParentNode(childNode);
                parentNode.getChildNodes().add(childNode);
                this.internalPopulateExecutionTree(childNode, parentMapping);
            }
        }
    }

    public void logDebugInfo() {
        this.logDebugInfo(false);
    }

    public void logDebugInfo(boolean clearAfterLogging) {
        LOGGER.info("--------------------------------");
        LOGGER.info("CommandInvoker debug information");
        LOGGER.info("--------------------------------");
        for (String threadName : this.debugInfoMap.keySet()) {
            LOGGER.info("");
            LOGGER.info("Thread '{}':", (Object)threadName);
            LOGGER.info("");
            for (DebugInfo debugInfo : this.debugInfoMap.get(threadName)) {
                debugInfo.printOut(LOGGER);
            }
        }
        LOGGER.info("");
        if (clearAfterLogging) {
            this.clear();
        }
    }

    public void clear() {
        this.debugInfoMap.clear();
        this.createdExecutions.clear();
    }

    public void executionCreated(ExecutionEntity executionEntity) {
        this.createdExecutions.put(executionEntity.getId(), executionEntity);
    }

    public void executionDeleted(ExecutionEntity executionEntity) {
        this.deletedExecutions.put(executionEntity.getId(), executionEntity);
    }
}

