/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.eventregistry.spring.kafka.payload;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.apache.commons.lang3.StringUtils;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.flowable.eventregistry.api.FlowableEventInfo;
import org.flowable.eventregistry.api.InboundEventInfoAwarePayloadExtractor;
import org.flowable.eventregistry.api.runtime.EventPayloadInstance;
import org.flowable.eventregistry.impl.runtime.EventPayloadInstanceImpl;
import org.flowable.eventregistry.model.EventModel;
import org.flowable.eventregistry.model.EventPayload;
import org.flowable.eventregistry.model.InboundChannelModel;
import org.flowable.eventregistry.model.KafkaInboundChannelModel;

public class KafkaConsumerRecordInformationPayloadExtractor<T>
implements InboundEventInfoAwarePayloadExtractor<T> {
    public Collection<EventPayloadInstance> extractPayload(EventModel eventModel, FlowableEventInfo<T> event) {
        InboundChannelModel inboundChannel = event.getInboundChannel();
        Object rawEvent = event.getRawEvent();
        if (inboundChannel instanceof KafkaInboundChannelModel && rawEvent instanceof ConsumerRecord) {
            return this.extractPayload(eventModel, (KafkaInboundChannelModel)inboundChannel, (ConsumerRecord)rawEvent);
        }
        return Collections.emptyList();
    }

    protected Collection<EventPayloadInstance> extractPayload(EventModel eventModel, KafkaInboundChannelModel inboundChannel, ConsumerRecord<?, ?> consumerRecord) {
        ArrayList<EventPayloadInstance> payloadInstances = new ArrayList<EventPayloadInstance>();
        this.addPayloadIfAvailable(inboundChannel.getTopicOutputName(), eventModel, () -> consumerRecord.topic(), payloadInstances::add);
        this.addPayloadIfAvailable(inboundChannel.getPartitionOutputName(), eventModel, () -> consumerRecord.partition(), payloadInstances::add);
        this.addPayloadIfAvailable(inboundChannel.getOffsetOutputName(), eventModel, () -> consumerRecord.offset(), payloadInstances::add);
        return payloadInstances;
    }

    protected void addPayloadIfAvailable(String payloadName, EventModel model, Supplier<?> valueSupplier, Consumer<EventPayloadInstance> payloadInstanceConsumer) {
        EventPayload payloadDefinition;
        if (StringUtils.isNotBlank((CharSequence)payloadName) && (payloadDefinition = model.getPayload(payloadName)) != null) {
            payloadInstanceConsumer.accept((EventPayloadInstance)new EventPayloadInstanceImpl(payloadDefinition, valueSupplier.get()));
        }
    }
}

