/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.eventregistry.impl.tenantdetector;

import com.fasterxml.jackson.core.JsonPointer;
import com.fasterxml.jackson.databind.JsonNode;
import org.flowable.eventregistry.api.InboundEventTenantDetector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonPointerBasedInboundEventTenantDetector
implements InboundEventTenantDetector<JsonNode> {
    private static final Logger LOGGER = LoggerFactory.getLogger(JsonPointerBasedInboundEventTenantDetector.class);
    protected String jsonPointerExpression;
    protected JsonPointer jsonPointer;

    public JsonPointerBasedInboundEventTenantDetector(String jsonPointerExpression) {
        this.jsonPointerExpression = jsonPointerExpression;
        this.jsonPointer = JsonPointer.compile((String)jsonPointerExpression);
    }

    public String detectTenantId(JsonNode payload) {
        JsonNode result = payload.at(this.jsonPointer);
        if (result == null || result.isMissingNode() || result.isNull()) {
            LOGGER.warn("JsonPointer expression {} did not detect event tenant", (Object)this.jsonPointer);
            return null;
        }
        if (result.isTextual()) {
            return result.asText();
        }
        return null;
    }

    public String getJsonPointerExpression() {
        return this.jsonPointerExpression;
    }

    public void setJsonPointerExpression(String jsonPointerExpression) {
        this.jsonPointerExpression = jsonPointerExpression;
    }
}

