/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.code.aarch64;

import com.oracle.objectfile.ObjectFile;
import com.oracle.svm.hosted.code.HostedPatcher;
import com.oracle.svm.hosted.image.RelocatableBuffer;
import jdk.vm.ci.code.site.Reference;
import org.graalvm.compiler.asm.aarch64.AArch64MacroAssembler;
import org.graalvm.compiler.code.CompilationResult;

class AdrpLdrMacroInstructionHostedPatcher
extends CompilationResult.CodeAnnotation
implements HostedPatcher {
    private final AArch64MacroAssembler.AdrpLdrMacroInstruction macroInstruction;

    AdrpLdrMacroInstructionHostedPatcher(AArch64MacroAssembler.AdrpLdrMacroInstruction macroInstruction) {
        super(macroInstruction.instructionPosition);
        this.macroInstruction = macroInstruction;
    }

    @Override
    public void relocate(Reference ref, RelocatableBuffer relocs, int compStart) {
        int siteOffset = compStart + this.macroInstruction.instructionPosition;
        relocs.addRelocation(siteOffset, ObjectFile.RelocationKind.AARCH64_R_AARCH64_ADR_PREL_PG_HI21, 0, 0L, ref);
        relocs.addRelocation(siteOffset += 4, ObjectFile.RelocationKind.AARCH64_R_AARCH64_LDST64_ABS_LO12_NC, 0, 0L, ref);
    }

    @Override
    public void patch(int codePos, int relative, byte[] code) {
        this.macroInstruction.patch(codePos, relative, code);
    }

    public boolean equals(Object obj) {
        return this == obj;
    }
}

