/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.rules.core;

import com.datical.liquibase.ext.checks.config.model.DynamicRule;
import com.datical.liquibase.ext.rules.api.SeverityEnum;
import com.datical.liquibase.ext.rules.core.AbstractLiquibaseRule;
import com.datical.liquibase.ext.rules.core.RuleIteration;
import com.datical.liquibase.ext.rules.core.RuleIteration$FailureReason;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import liquibase.util.StringUtil;

public class LiquibaseRuleResult {
    private final List<RuleIteration> executions = new ArrayList<RuleIteration>();
    private final AbstractLiquibaseRule rule;
    private final DynamicRule dynamicRule;

    public LiquibaseRuleResult(AbstractLiquibaseRule abstractLiquibaseRule) {
        this.rule = abstractLiquibaseRule;
        this.dynamicRule = null;
    }

    public LiquibaseRuleResult(AbstractLiquibaseRule abstractLiquibaseRule, DynamicRule dynamicRule, RuleIteration ... ruleIterationArray) {
        this.rule = abstractLiquibaseRule;
        this.dynamicRule = dynamicRule;
        this.executions.addAll(Arrays.asList(ruleIterationArray));
    }

    public List<RuleIteration> getExecutions() {
        return this.executions;
    }

    public AbstractLiquibaseRule getRule() {
        return this.rule;
    }

    public DynamicRule getDynamicRule() {
        return this.dynamicRule;
    }

    public boolean hasRuleSucceeded() {
        Iterator<RuleIteration> iterator = this.executions.iterator();
        while (iterator.hasNext()) {
            if (iterator.next().isSuccess()) continue;
            return false;
        }
        return true;
    }

    public boolean hasSqlParseFailures() {
        return this.executions.stream().anyMatch(ruleIteration -> RuleIteration$FailureReason.SQL_PARSING.equals((Object)ruleIteration.getFailureReason()));
    }

    public boolean hasInvalidChangelogFileTypeFailures() {
        return this.executions.stream().anyMatch(ruleIteration -> RuleIteration$FailureReason.INVALID_CHANGELOG_FILE_TYPE.equals((Object)ruleIteration.getFailureReason()));
    }

    public String getRuleShortName() {
        return this.getRuleShortName(true);
    }

    public String getRuleShortName(boolean bl2) {
        String string = this.dynamicRule != null ? this.dynamicRule.getShortName() : this.getRule().getShortName();
        if (bl2 && StringUtil.isNotEmpty(string)) {
            string = " (" + string + ")";
        }
        return string;
    }

    public SeverityEnum getRuleSeverity() {
        SeverityEnum severityEnum = this.dynamicRule != null ? this.dynamicRule.getSeverity() : this.getRule().getSeverity();
        return severityEnum;
    }

    public int getRuleExitValue() {
        return this.getRuleSeverity().getExitValue();
    }
}

