/*
 * Decompiled with CFR 0.152.
 */
package liquibase.license.pro;

import com.datical.liquibase.ext.config.LiquibaseLabsConfiguration;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import liquibase.license.LicenseServiceUtils;
import liquibase.util.StringUtil;

public enum LicenseTier {
    LABS("Liquibase Labs", 200),
    PRO("Liquibase Pro", Collections.singletonList(LABS), 100),
    COMMUNITY("Liquibase", Arrays.asList(PRO, LABS), 0);

    private final String subject;
    private final List<LicenseTier> supersetLicenses;
    private final int value;

    private LicenseTier(String string2, int n3) {
        this(string2, null, n3);
    }

    private LicenseTier(String string2, List<LicenseTier> list, int n3) {
        this.subject = string2;
        this.supersetLicenses = list;
        this.value = n3;
    }

    public final String getSubject() {
        return this.subject;
    }

    public final List<LicenseTier> getSupersetLicenses() {
        return this.supersetLicenses;
    }

    public final int getValue() {
        return this.value;
    }

    public final boolean isValid() {
        if (this == LABS) {
            return LiquibaseLabsConfiguration.isLabsLicenseValid();
        }
        if (this == PRO) {
            return LicenseServiceUtils.isProLicenseValid();
        }
        return this == COMMUNITY;
    }

    public static LicenseTier fromSubject(String string) {
        if (!StringUtil.isEmpty(string)) {
            for (LicenseTier licenseTier : LicenseTier.values()) {
                if (!licenseTier.getSubject().equals(string)) continue;
                return licenseTier;
            }
        }
        return null;
    }
}

