/*
 * Decompiled with CFR 0.152.
 */
package liquibase.sqlgenerator.core;

import liquibase.ContextExpression;
import liquibase.Labels;
import liquibase.change.Change;
import liquibase.change.core.TagDatabaseChange;
import liquibase.changelog.ChangeLogHistoryServiceFactory;
import liquibase.changelog.ChangeSet;
import liquibase.changelog.column.LiquibaseColumn;
import liquibase.database.Database;
import liquibase.database.ObjectQuotingStrategy;
import liquibase.exception.LiquibaseException;
import liquibase.exception.UnexpectedLiquibaseException;
import liquibase.exception.ValidationErrors;
import liquibase.sql.Sql;
import liquibase.sqlgenerator.SqlGeneratorChain;
import liquibase.sqlgenerator.SqlGeneratorFactory;
import liquibase.sqlgenerator.core.AbstractSqlGenerator;
import liquibase.statement.AbstractSqlStatement;
import liquibase.statement.DatabaseFunction;
import liquibase.statement.core.InsertStatement;
import liquibase.statement.core.MarkChangeSetRanStatement;
import liquibase.statement.core.UpdateStatement;
import liquibase.util.LiquibaseUtil;
import liquibase.util.StringUtil;

public class MarkChangeSetRanGenerator
extends AbstractSqlGenerator<MarkChangeSetRanStatement> {
    public static final String AND = " AND ";
    public static final String OPEN_BRACKET = "(";
    public static final String CLOSE_BRACKET = ")";
    public static final String WHITESPACE = " ";
    public static final String COMMA = ",";
    private static final String COMMENTS = "COMMENTS";
    private static final String CONTEXTS = "CONTEXTS";
    private static final String LABELS = "LABELS";

    @Override
    public ValidationErrors validate(MarkChangeSetRanStatement statement, Database database, SqlGeneratorChain sqlGeneratorChain) {
        ValidationErrors validationErrors = new ValidationErrors();
        validationErrors.checkRequiredField("changeSet", statement.getChangeSet());
        return validationErrors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Sql[] generateSql(MarkChangeSetRanStatement statement, Database database, SqlGeneratorChain sqlGeneratorChain) {
        String dateValue = database.getCurrentDateTimeFunction();
        ChangeSet changeSet = statement.getChangeSet();
        ObjectQuotingStrategy currentStrategy = database.getObjectQuotingStrategy();
        database.setObjectQuotingStrategy(ObjectQuotingStrategy.LEGACY);
        try {
            AbstractSqlStatement runStatement;
            if (statement.getExecType().equals((Object)ChangeSet.ExecType.FAILED) || statement.getExecType().equals((Object)ChangeSet.ExecType.SKIPPED)) {
                Sql[] sqlArray = new Sql[]{};
                return sqlArray;
            }
            try {
                String tag = null;
                for (Change change : changeSet.getChanges()) {
                    if (!(change instanceof TagDatabaseChange)) continue;
                    TagDatabaseChange tagChange = (TagDatabaseChange)change;
                    tag = tagChange.getTag();
                }
                if (statement.getExecType().ranBefore) {
                    runStatement = new UpdateStatement(database.getLiquibaseCatalogName(), database.getLiquibaseSchemaName(), database.getDatabaseChangeLogTableName()).addNewColumnValue("DATEEXECUTED", new DatabaseFunction(dateValue)).addNewColumnValue("ORDEREXECUTED", ChangeLogHistoryServiceFactory.getInstance().getChangeLogService(database).getNextSequenceValue()).addNewColumnValue("MD5SUM", changeSet.generateCheckSum().toString()).addNewColumnValue("EXECTYPE", statement.getExecType().value).addNewColumnValue("DEPLOYMENT_ID", ChangeLogHistoryServiceFactory.getInstance().getChangeLogService(database).getDeploymentId()).addNewColumnValue(COMMENTS, this.getCommentsColumn(changeSet)).addNewColumnValue(CONTEXTS, this.getContextsColumn(changeSet)).addNewColumnValue(LABELS, this.getLabelsColumn(changeSet)).setWhereClause(database.escapeObjectName("ID", LiquibaseColumn.class) + " = ? AND " + database.escapeObjectName("AUTHOR", LiquibaseColumn.class) + " = ? AND " + database.escapeObjectName("FILENAME", LiquibaseColumn.class) + " = ?").addWhereParameters(changeSet.getId(), changeSet.getAuthor(), changeSet.getFilePath());
                    if (tag != null) {
                        ((UpdateStatement)runStatement).addNewColumnValue("TAG", tag);
                    }
                } else {
                    runStatement = new InsertStatement(database.getLiquibaseCatalogName(), database.getLiquibaseSchemaName(), database.getDatabaseChangeLogTableName()).addColumnValue("ID", changeSet.getId()).addColumnValue("AUTHOR", changeSet.getAuthor()).addColumnValue("FILENAME", changeSet.getFilePath()).addColumnValue("DATEEXECUTED", new DatabaseFunction(dateValue)).addColumnValue("ORDEREXECUTED", ChangeLogHistoryServiceFactory.getInstance().getChangeLogService(database).getNextSequenceValue()).addColumnValue("MD5SUM", changeSet.generateCheckSum().toString()).addColumnValue("DESCRIPTION", this.limitSize(changeSet.getDescription())).addColumnValue(COMMENTS, this.getCommentsColumn(changeSet)).addColumnValue("EXECTYPE", statement.getExecType().value).addColumnValue(CONTEXTS, this.getContextsColumn(changeSet)).addColumnValue(LABELS, this.getLabelsColumn(changeSet)).addColumnValue("LIQUIBASE", StringUtil.limitSize(LiquibaseUtil.getBuildVersion().replaceAll("SNAPSHOT", "SNP").replaceAll("beta", "b").replaceAll("alpha", "b"), 20)).addColumnValue("DEPLOYMENT_ID", ChangeLogHistoryServiceFactory.getInstance().getChangeLogService(database).getDeploymentId());
                    if (tag != null) {
                        runStatement.addColumnValue("TAG", tag);
                    }
                }
            }
            catch (LiquibaseException e2) {
                throw new UnexpectedLiquibaseException(e2);
            }
            Sql[] sqlArray = SqlGeneratorFactory.getInstance().generateSql(runStatement, database);
            return sqlArray;
        }
        finally {
            database.setObjectQuotingStrategy(currentStrategy);
        }
    }

    private String getCommentsColumn(ChangeSet changeSet) {
        return this.limitSize(StringUtil.trimToEmpty(changeSet.getComments()));
    }

    protected String getContextsColumn(ChangeSet changeSet) {
        return this.buildFullContext(changeSet);
    }

    protected String getLabelsColumn(ChangeSet changeSet) {
        return this.buildFullLabels(changeSet);
    }

    private String buildFullContext(ChangeSet changeSet) {
        StringBuilder contextExpression = new StringBuilder();
        boolean notFirstContext = false;
        for (ContextExpression inheritableContext : changeSet.getInheritableContexts()) {
            this.appendContext(contextExpression, inheritableContext.toString(), notFirstContext);
            notFirstContext = true;
        }
        ContextExpression changeSetContext = changeSet.getContexts();
        if (changeSetContext != null && !changeSetContext.isEmpty()) {
            this.appendContext(contextExpression, changeSetContext.toString(), notFirstContext);
        }
        return StringUtil.trimToNull(contextExpression.toString());
    }

    private String buildFullLabels(ChangeSet changeSet) {
        StringBuilder labels = new StringBuilder();
        boolean notFirstLabel = false;
        for (Labels inheritableLabel : changeSet.getInheritableLabels()) {
            this.appendLabels(labels, inheritableLabel.toString(), notFirstLabel);
            notFirstLabel = true;
        }
        Labels changeSetLabels = changeSet.getLabels();
        if (changeSetLabels != null && !changeSetLabels.isEmpty()) {
            this.appendLabels(labels, changeSetLabels.toString(), notFirstLabel);
        }
        return StringUtil.trimToNull(labels.toString());
    }

    private void appendLabels(StringBuilder existingLabels, String labelToAppend, boolean notFirstContext) {
        if (notFirstContext) {
            existingLabels.append(COMMA);
        }
        existingLabels.append(labelToAppend);
    }

    private void appendContext(StringBuilder contextExpression, String contextToAppend, boolean notFirstContext) {
        boolean complexExpression;
        boolean bl2 = complexExpression = contextToAppend.contains(COMMA) || contextToAppend.contains(WHITESPACE);
        if (notFirstContext) {
            contextExpression.append(AND);
        }
        if (complexExpression) {
            contextExpression.append(OPEN_BRACKET);
        }
        contextExpression.append(contextToAppend);
        if (complexExpression) {
            contextExpression.append(CLOSE_BRACKET);
        }
    }

    private String limitSize(String string) {
        int maxLength = 250;
        if (string.length() > maxLength) {
            return string.substring(0, maxLength - 3) + "...";
        }
        return string;
    }
}

