/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.quickautobalance;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.postgresql.log.Log;
import org.postgresql.log.Logger;
import org.postgresql.util.GT;

public class ReflectUtil {
    private static Log LOGGER = Logger.getLogger(ReflectUtil.class.getName());

    public static void invoke(Class classz, Object object, String methodName) {
        try {
            Method method = classz.getDeclaredMethod(methodName, new Class[0]);
            method.setAccessible(true);
            method.invoke(object, new Object[0]);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            LOGGER.error(GT.tr("call reflect method {}.{} error.", classz, methodName));
        }
    }

    public static <T> T getField(Class classz, Object object, Class<T> t, String fieldName) {
        try {
            Field field = classz.getDeclaredField(fieldName);
            field.setAccessible(true);
            return (T)field.get(object);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            LOGGER.error("get reflect field " + classz + "." + fieldName + " error.");
            return null;
        }
    }

    public static void setField(Class classz, Object object, String fieldName, Object value) {
        try {
            Field field = classz.getDeclaredField(fieldName);
            field.setAccessible(true);
            field.set(object, value);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            LOGGER.error("set reflect field " + classz + "." + fieldName + " error.");
        }
    }
}

