/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.buildpack.platform.build;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.springframework.boot.buildpack.platform.build.Buildpack;
import org.springframework.boot.buildpack.platform.build.BuildpackCoordinates;
import org.springframework.boot.buildpack.platform.docker.type.Layer;
import org.springframework.boot.buildpack.platform.io.Content;
import org.springframework.boot.buildpack.platform.io.IOConsumer;
import org.springframework.boot.buildpack.platform.io.Layout;
import org.springframework.boot.buildpack.platform.io.Owner;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

final class Buildpacks {
    static final Buildpacks EMPTY = new Buildpacks(Collections.emptyList());
    private final List<Buildpack> buildpacks;

    private Buildpacks(List<Buildpack> buildpacks) {
        this.buildpacks = buildpacks;
    }

    List<Buildpack> getBuildpacks() {
        return this.buildpacks;
    }

    void apply(IOConsumer<Layer> layers) throws IOException {
        if (!this.buildpacks.isEmpty()) {
            for (Buildpack buildpack : this.buildpacks) {
                buildpack.apply(layers);
            }
            layers.accept(Layer.of(this::addOrderLayerContent));
        }
    }

    void addOrderLayerContent(Layout layout) throws IOException {
        layout.file("/cnb/order.toml", Owner.ROOT, Content.of(this.getOrderToml()));
    }

    private String getOrderToml() {
        StringBuilder builder = new StringBuilder();
        builder.append("[[order]]\n\n");
        for (Buildpack buildpack : this.buildpacks) {
            this.appendToOrderToml(builder, buildpack.getCoordinates());
        }
        return builder.toString();
    }

    private void appendToOrderToml(StringBuilder builder, BuildpackCoordinates coordinates) {
        builder.append("  [[order.group]]\n");
        builder.append("    id = \"" + coordinates.getId() + "\"\n");
        if (StringUtils.hasText((String)coordinates.getVersion())) {
            builder.append("    version = \"" + coordinates.getVersion() + "\"\n");
        }
        builder.append("\n");
    }

    static Buildpacks of(List<Buildpack> buildpacks) {
        return CollectionUtils.isEmpty(buildpacks) ? EMPTY : new Buildpacks(buildpacks);
    }
}

