/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.alibaba.nacos.client;

import com.alibaba.nacos.api.config.ConfigService;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.alibaba.nacos.NacosConfigProperties;
import org.springframework.cloud.alibaba.nacos.NacosPropertySourceRepository;
import org.springframework.cloud.alibaba.nacos.client.NacosPropertySource;
import org.springframework.cloud.alibaba.nacos.client.NacosPropertySourceBuilder;
import org.springframework.cloud.alibaba.nacos.refresh.NacosContextRefresher;
import org.springframework.cloud.bootstrap.config.PropertySourceLocator;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.CompositePropertySource;
import org.springframework.core.env.Environment;
import org.springframework.core.env.PropertySource;
import org.springframework.util.StringUtils;

@Order(value=0)
public class NacosPropertySourceLocator
implements PropertySourceLocator {
    private static final Logger log = LoggerFactory.getLogger(NacosPropertySourceLocator.class);
    private static final String NACOS_PROPERTY_SOURCE_NAME = "NACOS";
    private static final String SEP1 = "-";
    private static final String DOT = ".";
    private static final String SHARED_CONFIG_SEPARATOR_CHAR = "[,]";
    private static final List<String> SUPPORT_FILE_EXTENSION = Arrays.asList("properties", "yaml", "yml");
    private NacosPropertySourceBuilder nacosPropertySourceBuilder;
    private NacosConfigProperties nacosConfigProperties;

    public NacosPropertySourceLocator(NacosConfigProperties nacosConfigProperties) {
        this.nacosConfigProperties = nacosConfigProperties;
    }

    public PropertySource<?> locate(Environment env) {
        ConfigService configService = this.nacosConfigProperties.configServiceInstance();
        if (null == configService) {
            log.warn("no instance of config service found, can't load config from nacos");
            return null;
        }
        long timeout = this.nacosConfigProperties.getTimeout();
        this.nacosPropertySourceBuilder = new NacosPropertySourceBuilder(configService, timeout);
        String name = this.nacosConfigProperties.getName();
        String dataIdPrefix = this.nacosConfigProperties.getPrefix();
        if (StringUtils.isEmpty((Object)dataIdPrefix)) {
            dataIdPrefix = name;
        }
        if (StringUtils.isEmpty((Object)dataIdPrefix)) {
            dataIdPrefix = env.getProperty("spring.application.name");
        }
        CompositePropertySource composite = new CompositePropertySource(NACOS_PROPERTY_SOURCE_NAME);
        this.loadSharedConfiguration(composite);
        this.loadExtConfiguration(composite);
        this.loadApplicationConfiguration(composite, dataIdPrefix, this.nacosConfigProperties, env);
        return composite;
    }

    private void loadSharedConfiguration(CompositePropertySource compositePropertySource) {
        String sharedDataIds = this.nacosConfigProperties.getSharedDataids();
        String refreshDataIds = this.nacosConfigProperties.getRefreshableDataids();
        if (sharedDataIds == null || sharedDataIds.trim().length() == 0) {
            return;
        }
        String[] sharedDataIdArry = sharedDataIds.split(SHARED_CONFIG_SEPARATOR_CHAR);
        NacosPropertySourceLocator.checkDataIdFileExtension(sharedDataIdArry);
        for (int i = 0; i < sharedDataIdArry.length; ++i) {
            String dataId = sharedDataIdArry[i];
            String fileExtension = dataId.substring(dataId.lastIndexOf(DOT) + 1);
            boolean isRefreshable = this.checkDataIdIsRefreshbable(refreshDataIds, sharedDataIdArry[i]);
            this.loadNacosDataIfPresent(compositePropertySource, dataId, "DEFAULT_GROUP", fileExtension, isRefreshable);
        }
    }

    private void loadExtConfiguration(CompositePropertySource compositePropertySource) {
        if (this.nacosConfigProperties.getExtConfig() == null || this.nacosConfigProperties.getExtConfig().isEmpty()) {
            return;
        }
        List<NacosConfigProperties.Config> extConfigs = this.nacosConfigProperties.getExtConfig();
        this.checkExtConfiguration(extConfigs);
        for (NacosConfigProperties.Config config : extConfigs) {
            String dataId = config.getDataId();
            String fileExtension = dataId.substring(dataId.lastIndexOf(DOT) + 1);
            this.loadNacosDataIfPresent(compositePropertySource, dataId, config.getGroup(), fileExtension, config.isRefresh());
        }
    }

    private void checkExtConfiguration(List<NacosConfigProperties.Config> extConfigs) {
        String[] dataIds = new String[extConfigs.size()];
        for (int i = 0; i < extConfigs.size(); ++i) {
            String dataId = extConfigs.get(i).getDataId();
            if (dataId == null || dataId.trim().length() == 0) {
                throw new IllegalStateException(String.format("the [ spring.cloud.nacos.config.ext-config[%s] ] must give a dataid", i));
            }
            dataIds[i] = dataId;
        }
        NacosPropertySourceLocator.checkDataIdFileExtension(dataIds);
    }

    private void loadApplicationConfiguration(CompositePropertySource compositePropertySource, String dataIdPrefix, NacosConfigProperties properties, Environment environment) {
        String fileExtension = properties.getFileExtension();
        String nacosGroup = properties.getGroup();
        this.loadNacosDataIfPresent(compositePropertySource, dataIdPrefix + DOT + fileExtension, nacosGroup, fileExtension, true);
        for (String profile : environment.getActiveProfiles()) {
            String dataId = dataIdPrefix + SEP1 + profile + DOT + fileExtension;
            this.loadNacosDataIfPresent(compositePropertySource, dataId, nacosGroup, fileExtension, true);
        }
    }

    private void loadNacosDataIfPresent(CompositePropertySource composite, String dataId, String group, String fileExtension, boolean isRefreshable) {
        if (NacosContextRefresher.getRefreshCount() != 0L) {
            NacosPropertySource ps = !isRefreshable ? NacosPropertySourceRepository.getNacosPropertySource(dataId) : this.nacosPropertySourceBuilder.build(dataId, group, fileExtension, true);
            composite.addFirstPropertySource((PropertySource)ps);
        } else {
            NacosPropertySource ps = this.nacosPropertySourceBuilder.build(dataId, group, fileExtension, isRefreshable);
            composite.addFirstPropertySource((PropertySource)ps);
        }
    }

    private static void checkDataIdFileExtension(String[] dataIdArray) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < dataIdArray.length; ++i) {
            boolean isLegal = false;
            for (String fileExtension : SUPPORT_FILE_EXTENSION) {
                if (dataIdArray[i].indexOf(fileExtension) <= 0) continue;
                isLegal = true;
                break;
            }
            if (isLegal) continue;
            stringBuilder.append(dataIdArray[i] + ",");
        }
        if (stringBuilder.length() > 0) {
            String result = stringBuilder.substring(0, stringBuilder.length() - 1);
            throw new IllegalStateException(String.format("[%s] must contains file extension with properties|yaml|yml", result));
        }
    }

    private boolean checkDataIdIsRefreshbable(String refreshDataIds, String sharedDataId) {
        String[] refreshDataIdArry;
        if (refreshDataIds == null || "".equals(refreshDataIds)) {
            return false;
        }
        for (String refreshDataId : refreshDataIdArry = refreshDataIds.split(SHARED_CONFIG_SEPARATOR_CHAR)) {
            if (!refreshDataId.equals(sharedDataId)) continue;
            return true;
        }
        return false;
    }
}

