/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.server.config;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.cloud.bootstrap.encrypt.KeyProperties;
import org.springframework.cloud.config.server.encryption.LocatorTextEncryptor;
import org.springframework.cloud.config.server.encryption.TextEncryptorLocator;
import org.springframework.cloud.context.encrypt.EncryptorFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.crypto.encrypt.Encryptors;
import org.springframework.security.crypto.encrypt.TextEncryptor;
import org.springframework.util.StringUtils;

@ConditionalOnMissingBean(value={TextEncryptor.class})
@Configuration
class DefaultTextEncryptorConfiguration {
    @Autowired
    private KeyProperties key;
    @Autowired(required=false)
    private TextEncryptorLocator locator;

    DefaultTextEncryptorConfiguration() {
    }

    @Bean
    public TextEncryptor defaultTextEncryptor() {
        if (this.locator != null) {
            return new LocatorTextEncryptor(this.locator);
        }
        if (StringUtils.hasText((String)this.key.getKey())) {
            return new EncryptorFactory(this.key.getSalt()).create(this.key.getKey());
        }
        return Encryptors.noOpText();
    }
}

