/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.server.environment;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotEmpty;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.config.YamlPropertiesFactoryBean;
import org.springframework.cloud.config.environment.Environment;
import org.springframework.cloud.config.environment.PropertySource;
import org.springframework.cloud.config.server.environment.ConfigTokenProvider;
import org.springframework.cloud.config.server.environment.EnvironmentRepository;
import org.springframework.cloud.config.server.environment.EnvironmentWatch;
import org.springframework.cloud.config.server.environment.HttpRequestConfigTokenProvider;
import org.springframework.cloud.config.server.environment.VaultEnvironmentProperties;
import org.springframework.cloud.config.server.environment.VaultKvAccessStrategy;
import org.springframework.cloud.config.server.environment.VaultKvAccessStrategyFactory;
import org.springframework.core.Ordered;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.Resource;
import org.springframework.http.HttpHeaders;
import org.springframework.util.StringUtils;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.client.RestOperations;
import org.springframework.web.client.RestTemplate;

@Validated
public class VaultEnvironmentRepository
implements EnvironmentRepository,
Ordered {
    private static final String VAULT_TOKEN = "X-Vault-Token";
    static final String VAULT_NAMESPACE = "X-Vault-Namespace";
    @NotEmpty
    private String host;
    @Min(value=1L)
    @Max(value=65535L)
    private @Min(value=1L) @Max(value=65535L) int port;
    private String scheme;
    @NotEmpty
    private String backend;
    private String defaultKey;
    private String namespace;
    @NotEmpty
    private String profileSeparator;
    private int order;
    private VaultKvAccessStrategy accessStrategy;
    private final ObjectProvider<HttpServletRequest> request;
    private final EnvironmentWatch watch;
    private final ConfigTokenProvider tokenProvider;

    public VaultEnvironmentRepository(ObjectProvider<HttpServletRequest> request, EnvironmentWatch watch, RestTemplate rest, VaultEnvironmentProperties properties) {
        this(request, watch, rest, properties, new HttpRequestConfigTokenProvider(request));
    }

    public VaultEnvironmentRepository(ObjectProvider<HttpServletRequest> request, EnvironmentWatch watch, RestTemplate rest, VaultEnvironmentProperties properties, ConfigTokenProvider tokenProvider) {
        this.request = request;
        this.watch = watch;
        this.tokenProvider = tokenProvider;
        this.backend = properties.getBackend();
        this.defaultKey = properties.getDefaultKey();
        this.host = properties.getHost();
        this.order = properties.getOrder();
        this.port = properties.getPort();
        this.profileSeparator = properties.getProfileSeparator();
        this.scheme = properties.getScheme();
        this.namespace = properties.getNamespace();
        String baseUrl = String.format("%s://%s:%s", this.scheme, this.host, this.port);
        this.accessStrategy = VaultKvAccessStrategyFactory.forVersion((RestOperations)rest, baseUrl, properties.getKvVersion());
    }

    void setAccessStrategy(VaultKvAccessStrategy accessStrategy) {
        this.accessStrategy = accessStrategy;
    }

    @Override
    public Environment findOne(String application, String profile, String label) {
        String[] profiles = StringUtils.commaDelimitedListToStringArray((String)profile);
        List<String> scrubbedProfiles = this.scrubProfiles(profiles);
        List<String> keys = this.findKeys(application, scrubbedProfiles);
        Environment environment = new Environment(application, profiles, label, null, this.getWatchState());
        for (String key : keys) {
            String data = this.read(key);
            if (data == null) continue;
            YamlPropertiesFactoryBean yaml = new YamlPropertiesFactoryBean();
            yaml.setResources(new Resource[]{new ByteArrayResource(data.getBytes())});
            Properties properties = yaml.getObject();
            if (properties.isEmpty()) continue;
            environment.add(new PropertySource("vault:" + key, (Map)properties));
        }
        return environment;
    }

    private String getWatchState() {
        HttpServletRequest servletRequest = (HttpServletRequest)this.request.getIfAvailable();
        if (servletRequest != null) {
            String state = servletRequest.getHeader("X-Config-State");
            return this.watch.watch(state);
        }
        return null;
    }

    private List<String> findKeys(String application, List<String> profiles) {
        String[] applications;
        ArrayList<String> keys = new ArrayList<String>();
        if (StringUtils.hasText((String)this.defaultKey) && !this.defaultKey.equals(application)) {
            keys.add(this.defaultKey);
            this.addProfiles(keys, this.defaultKey, profiles);
        }
        for (String app : applications = StringUtils.commaDelimitedListToStringArray((String)application)) {
            keys.add(app);
            this.addProfiles(keys, app, profiles);
        }
        Collections.reverse(keys);
        return keys;
    }

    private List<String> scrubProfiles(String[] profiles) {
        ArrayList<String> scrubbedProfiles = new ArrayList<String>(Arrays.asList(profiles));
        if (scrubbedProfiles.contains("default")) {
            scrubbedProfiles.remove("default");
        }
        return scrubbedProfiles;
    }

    private void addProfiles(List<String> contexts, String baseContext, List<String> profiles) {
        for (String profile : profiles) {
            contexts.add(baseContext + this.profileSeparator + profile);
        }
    }

    private String read(String key) {
        HttpHeaders headers = new HttpHeaders();
        headers.add(VAULT_TOKEN, this.getToken());
        if (StringUtils.hasText((String)this.namespace)) {
            headers.add(VAULT_NAMESPACE, this.namespace);
        }
        return this.accessStrategy.getData(headers, this.backend, key);
    }

    private String getToken() {
        String token = this.tokenProvider.getToken();
        if (!StringUtils.hasLength((String)token)) {
            throw new IllegalArgumentException("A Vault token must be supplied by a token provider");
        }
        return token;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setScheme(String scheme) {
        this.scheme = scheme;
    }

    public void setBackend(String backend) {
        this.backend = backend;
    }

    public void setDefaultKey(String defaultKey) {
        this.defaultKey = defaultKey;
    }

    public void setProfileSeparator(String profileSeparator) {
        this.profileSeparator = profileSeparator;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }
}

