/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.spring6.processor;

import org.thymeleaf.context.ITemplateContext;
import org.thymeleaf.engine.AttributeDefinition;
import org.thymeleaf.engine.AttributeName;
import org.thymeleaf.model.IProcessableElementTag;
import org.thymeleaf.processor.element.IElementTagStructureHandler;
import org.thymeleaf.spring6.context.IThymeleafBindStatus;
import org.thymeleaf.spring6.processor.AbstractSpringFieldTagProcessor;
import org.thymeleaf.spring6.requestdata.RequestDataValueProcessorUtils;
import org.thymeleaf.spring6.util.SpringValueFormatter;
import org.thymeleaf.standard.util.StandardProcessorUtils;
import org.thymeleaf.util.StringUtils;

public final class SpringTextareaFieldTagProcessor
extends AbstractSpringFieldTagProcessor {
    public SpringTextareaFieldTagProcessor(String dialectPrefix) {
        super(dialectPrefix, "textarea", null, null, true);
    }

    @Override
    protected void doProcess(ITemplateContext context, IProcessableElementTag tag, AttributeName attributeName, String attributeValue, IThymeleafBindStatus bindStatus, IElementTagStructureHandler structureHandler) {
        String name = bindStatus.getExpression();
        name = name == null ? "" : name;
        String id = this.computeId(context, tag, name, false);
        String value = SpringValueFormatter.getDisplayString(bindStatus.getValue(), bindStatus.getEditor(), true);
        Object processedValue = RequestDataValueProcessorUtils.processFormFieldValue(context, name, value, "textarea");
        if (!StringUtils.isEmpty((String)processedValue)) {
            char c0 = ((String)processedValue).charAt(0);
            if (c0 == '\n') {
                processedValue = "\n" + (String)processedValue;
            } else if (c0 == '\r' && ((String)processedValue).length() > 1 && ((String)processedValue).charAt(1) == '\n') {
                processedValue = "\r\n" + (String)processedValue;
            } else if (c0 == '\r') {
                processedValue = "\r" + (String)processedValue;
            }
        }
        StandardProcessorUtils.setAttribute((IElementTagStructureHandler)structureHandler, (AttributeDefinition)this.idAttributeDefinition, (String)"id", (String)id);
        StandardProcessorUtils.setAttribute((IElementTagStructureHandler)structureHandler, (AttributeDefinition)this.nameAttributeDefinition, (String)"name", (String)name);
        structureHandler.setBody((CharSequence)(processedValue == null ? "" : processedValue), false);
    }
}

