/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cis.pms.biz.service.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.dtyunxi.cis.pms.biz.enums.PlatformOrderTypeEnum;
import com.dtyunxi.cis.pms.biz.enums.SaleOrderTypeEnum;
import com.dtyunxi.cis.pms.biz.model.BusinessOrderInfoVO;
import com.dtyunxi.cis.pms.biz.model.DeliveryInfoVo;
import com.dtyunxi.cis.pms.biz.model.GetOutResultOrderListPageParams;
import com.dtyunxi.cis.pms.biz.model.OutResultOrderVO;
import com.dtyunxi.cis.pms.biz.model.RelateBillInfoVO;
import com.dtyunxi.cis.pms.biz.service.InventoryCenterBillOutResultOrderService;
import com.dtyunxi.cis.search.api.dto.request.EsOutResultOrderListPageParams;
import com.dtyunxi.cis.search.api.query.delivery.EsOutResultOrderQueryApi;
import com.dtyunxi.cube.plugin.mq.ICommonsMqService;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.cube.utils.enums.DatePattern;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.request.OutResultOrderReqDto;
import com.dtyunxi.tcbj.api.query.IOutResultOrderQueryApi;
import com.dtyunxi.tcbj.center.openapi.api.dto.request.StringCodeCheckReqDto;
import com.dtyunxi.tcbj.center.openapi.api.dto.response.StringCodeCheckRespDto;
import com.dtyunxi.tcbj.center.openapi.api.query.IStringCodeQueryApi;
import com.dtyunxi.util.DateUtil;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.order.ICsOutNoticeOrderQueryApi;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.order.ICsOutResultOrderQueryApi;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.order.pcp.ICsInPlannedOrderApi;
import com.dtyunxi.yundt.cube.center.inventory.api.inventory.ICsTransferOrderApi;
import com.dtyunxi.yundt.cube.center.inventory.constant.ConsignmentConstant;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.order.CsOutNoticeOrderRespDto;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsPcpBusinessTypeEnum;
import com.dtyunxi.yundt.cube.center.item.api.dto.request.ItemExtendReqDto;
import com.dtyunxi.yundt.cube.center.item.api.dto.response.ItemExtendRespDto;
import com.dtyunxi.yundt.cube.center.item.api.query.IItemExtendQueryApi;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.BizSaleOrderRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.BizSaleRefundRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.SaleOrderAddrRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.SaleRefundAddrRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.query.ISaleOrderQueryApi;
import com.dtyunxi.yundt.cube.center.trade.api.query.ISaleRefundQueryApi;
import com.dtyunxi.yundt.cube.center.transform.api.query.IPlatformOrderQueryApi;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.inventory.dto.domain.ContactDto;
import com.yunxi.dg.base.center.inventory.dto.domain.CsOutNoticeOrderDetailRespDto;
import com.yunxi.dg.base.center.inventory.dto.domain.CsOutNoticeOrderQueryDto;
import com.yunxi.dg.base.center.inventory.dto.domain.CsOutResultOrderRespDto;
import com.yunxi.dg.base.center.inventory.dto.domain.CsTransferOrderRespDto;
import com.yunxi.dg.base.center.report.api.entity.IDailyDeliveryReportApi;
import com.yunxi.dg.base.center.report.dto.entity.DailyDeliveryReportDto;
import com.yunxi.dg.base.center.report.dto.report.DailyDeliveryReportListQueryDto;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import com.yunxi.dg.base.commons.utils.LogUtils;
import io.swagger.annotations.ApiParam;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.validation.Valid;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

@Service
public class InventoryCenterBillOutResultOrderServiceServiceImpl
implements InventoryCenterBillOutResultOrderService {
    private static final Logger log = LoggerFactory.getLogger(InventoryCenterBillOutResultOrderServiceServiceImpl.class);
    @Resource
    IOutResultOrderQueryApi outResultOrderQueryApi;
    @Resource
    private ICsOutResultOrderQueryApi csOutResultOrderQueryApi;
    @Resource
    private ICsOutNoticeOrderQueryApi csOutNoticeOrderQueryApi;
    @Resource
    private EsOutResultOrderQueryApi esOutResultOrderQueryApi;
    @Resource
    private ISaleOrderQueryApi saleOrderQueryApi;
    @Resource
    private ISaleRefundQueryApi saleRefundQueryApi;
    @Resource
    private IPlatformOrderQueryApi platformOrderQueryApi;
    @Resource
    private IStringCodeQueryApi stringCodeQueryApi;
    @Resource
    private ICsInPlannedOrderApi plannedOrderApi;
    @Resource
    private ICommonsMqService commonsMqService;
    @Resource
    private ICsTransferOrderApi transferOrderQueryApi;
    @Resource
    private ICacheService cacheService;
    @Value(value="${esQuery:true}")
    private Boolean esQuery;
    @Resource
    private IOutResultOrderQueryApi iOutResultOrderQueryApi;
    @Autowired
    private IItemExtendQueryApi itemExtendQueryApi;
    @Resource
    private IDailyDeliveryReportApi dailyDeliveryReportApi;

    @Override
    public RestResponse<OutResultOrderVO> getOutResultOrderDetail(@ApiParam(value="\u53d1\u8d27\u901a\u77e5\u5355\u53f7") @Valid @RequestParam(value="outResultNo", required=false) String outResultNo) {
        List respDtos;
        log.info("\u51fa\u5e93\u7ed3\u679c\u5355\u8be6\u60c5\uff1a{}", (Object)outResultNo);
        CsOutResultOrderRespDto respDto = (CsOutResultOrderRespDto)RestResponseHelper.extractData((RestResponse)this.csOutResultOrderQueryApi.queryByDocumentNo(outResultNo));
        OutResultOrderVO vo = new OutResultOrderVO();
        if (respDto == null) {
            return new RestResponse((Object)vo);
        }
        BeanUtils.copyProperties((Object)respDto, (Object)vo);
        vo.setBusinessOrderNo(respDto.getPreOrderNo());
        vo.setBunchCodeFlag(respDto.getStringValidResult());
        ContactDto contactDto = respDto.getContactDto();
        if (Objects.nonNull(contactDto)) {
            BusinessOrderInfoVO businessOrderInfo = new BusinessOrderInfoVO();
            BeanUtils.copyProperties((Object)contactDto, (Object)businessOrderInfo);
            businessOrderInfo.setAddress(Optional.ofNullable(contactDto.getProvince()).orElse("") + Optional.ofNullable(contactDto.getCity()).orElse("") + Optional.ofNullable(contactDto.getDistrict()).orElse("") + contactDto.getAddress());
            vo.setBusinessOrderInfo(businessOrderInfo);
        }
        if (CollectionUtils.isNotEmpty((Collection)(respDtos = (List)RestResponseHelper.extractData((RestResponse)this.iOutResultOrderQueryApi.queryDeliveryInformation(outResultNo))))) {
            List<DeliveryInfoVo> list = respDtos.stream().map(o -> {
                DeliveryInfoVo documentVO = new DeliveryInfoVo();
                BeanUtils.copyProperties((Object)o, (Object)documentVO);
                if (o.getConsignmentType() != null) {
                    documentVO.setConsignmentTypeName((String)ConsignmentConstant.CONSIGNMENT_TYPE.valueMap.get(o.getConsignmentType()));
                }
                return documentVO;
            }).collect(Collectors.toList());
            vo.setDeliveryInfoList(list);
        }
        this.getRelateBillInfo(respDto, vo);
        if (respDto.getCreateTime() != null) {
            vo.setCreateTime(DateUtil.format((Date)respDto.getCreateTime(), (String)DatePattern.DATETIME_PATTERN.getPattern()));
        }
        DailyDeliveryReportListQueryDto listQueryDto = new DailyDeliveryReportListQueryDto();
        listQueryDto.setRelevanceNo(respDto.getRelevanceNo());
        PageInfo dailyDeliveryReportDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.dailyDeliveryReportApi.queryByPage(listQueryDto, Integer.valueOf(1), Integer.valueOf(1)));
        if (Objects.nonNull(dailyDeliveryReportDtoPageInfo) && CollectionUtils.isNotEmpty((Collection)dailyDeliveryReportDtoPageInfo.getList())) {
            DailyDeliveryReportDto dailyDeliveryReportDto = (DailyDeliveryReportDto)dailyDeliveryReportDtoPageInfo.getList().get(0);
            vo.setWmsMergeDocumentNo(dailyDeliveryReportDto.getWmsMergeDocumentNo());
        }
        if (StringUtils.isNotBlank((CharSequence)vo.getWmsMergeDocumentNo())) {
            DailyDeliveryReportDto reportDto = new DailyDeliveryReportDto();
            reportDto.setWmsMergeDocumentNo(vo.getWmsMergeDocumentNo());
            reportDto.setWmsOrderType("\u5408\u5355\u751f\u6210");
            log.info("\u67e5\u8be2\u52a0\u5165\u5408\u5355\u53f7\uff1a{}", (Object)JSON.toJSONString((Object)reportDto));
            List dailyDeliveryReportDtoList = (List)RestResponseHelper.extractData((RestResponse)this.dailyDeliveryReportApi.queryList(reportDto));
            if (CollectionUtils.isNotEmpty((Collection)dailyDeliveryReportDtoList)) {
                vo.setJoinMergeDocumentNo(((DailyDeliveryReportDto)dailyDeliveryReportDtoList.get(0)).getJoinMergeDocumentNo());
            }
        }
        vo.setDocumentStatus(respDto.getOrderStatus());
        vo.setDeliveryLogicalWarehouseCode(respDto.getOutLogicWarehouseCode());
        vo.setDeliveryLogicalWarehouseName(respDto.getOutLogicWarehouseName());
        vo.setDeliveryPhysicalWarehouseCode(respDto.getWarehouseCode());
        vo.setDeliveryPhysicalWarehouseName(respDto.getWarehouseName());
        vo.setReceiveLogicalWarehouseCode(respDto.getInLogicWarehouseCode());
        vo.setReceiveLogicalWarehouseName(respDto.getInLogicWarehouseName());
        vo.setReceivePhysicalWarehouseCode(respDto.getInWarehouseCode());
        vo.setReceivePhysicalWarehouseName(respDto.getInWarehouseName());
        vo.setSummary(respDto.getTotalQuantity() == null ? BigDecimal.ZERO : respDto.getTotalQuantity());
        vo.setTotalBoxesNum(respDto.getTotalCartons() == null ? BigDecimal.ZERO : respDto.getTotalCartons());
        vo.setMixBoxesNum(respDto.getMergeQuantity() == null ? BigDecimal.ZERO : respDto.getMergeQuantity());
        vo.setTotalSku(respDto.getSkuNum() == null ? BigDecimal.ZERO : respDto.getSkuNum());
        vo.setBizDateStr(ObjectUtil.isNotEmpty((Object)respDto.getBizDate()) ? DateUtil.format((Date)respDto.getBizDate(), (String)DatePattern.DATETIME_PATTERN.getPattern()) : null);
        return new RestResponse((Object)vo);
    }

    private void getRelateBillInfo(CsOutResultOrderRespDto respDto, OutResultOrderVO vo) {
        List relOrderInfoList = respDto.getRelOrderInfoList();
        if (CollectionUtils.isNotEmpty((Collection)relOrderInfoList)) {
            List<RelateBillInfoVO> list = relOrderInfoList.stream().filter(o -> StringUtils.isNotBlank((CharSequence)o.getOrderNo())).map(o -> {
                RelateBillInfoVO relateBillInfoVO = new RelateBillInfoVO();
                if (PlatformOrderTypeEnum.PLATFORM_ORDER_NO.getCode().equals(o.getOrderType())) {
                    BeanUtils.copyProperties((Object)o, (Object)relateBillInfoVO);
                    relateBillInfoVO.setIsExternalOrder(true);
                } else if (SaleOrderTypeEnum.getStatusByCode(o.getOrderType()) != null) {
                    if (SaleOrderTypeEnum.ORDER_SALES_REFUND.getCode().equals(o.getOrderType())) {
                        BizSaleRefundRespDto bizSaleRefundRespDto = (BizSaleRefundRespDto)RestResponseHelper.extractData((RestResponse)this.saleRefundQueryApi.queryByRefundNo(o.getOrderNo()));
                        if (bizSaleRefundRespDto != null) {
                            BeanUtils.copyProperties((Object)o, (Object)relateBillInfoVO);
                            relateBillInfoVO.setOrderStatus(bizSaleRefundRespDto.getRefundStatus());
                            SaleRefundAddrRespDto saleRefundAddrRespDto = bizSaleRefundRespDto.getSaleRefundAddrRespDto();
                            if (saleRefundAddrRespDto != null) {
                                BusinessOrderInfoVO businessOrderInfo = new BusinessOrderInfoVO();
                                businessOrderInfo.setReciveName(saleRefundAddrRespDto.getReceiveName());
                                businessOrderInfo.setRecivePhone(saleRefundAddrRespDto.getReceivePhone());
                                businessOrderInfo.setAddress(this.getString(saleRefundAddrRespDto.getProvince()) + this.getString(saleRefundAddrRespDto.getCity()) + this.getString(saleRefundAddrRespDto.getCounty()) + saleRefundAddrRespDto.getReceiveAddress());
                                vo.setBusinessOrderInfo(businessOrderInfo);
                            }
                        }
                    } else {
                        BizSaleOrderRespDto saleOrderRespDto = (BizSaleOrderRespDto)RestResponseHelper.extractData((RestResponse)this.saleOrderQueryApi.queryByOrderNo(o.getOrderNo()));
                        if (saleOrderRespDto != null) {
                            BeanUtils.copyProperties((Object)o, (Object)relateBillInfoVO);
                            relateBillInfoVO.setOrderStatus(saleOrderRespDto.getOrderStatus());
                            SaleOrderAddrRespDto orderAddrRespDto = saleOrderRespDto.getOrderAddrRespDto();
                            if (orderAddrRespDto != null) {
                                BusinessOrderInfoVO businessOrderInfo = new BusinessOrderInfoVO();
                                businessOrderInfo.setReciveName(orderAddrRespDto.getReceiveName());
                                businessOrderInfo.setRecivePhone(orderAddrRespDto.getReceivePhone());
                                businessOrderInfo.setAddress(this.getString(orderAddrRespDto.getProvince()) + this.getString(orderAddrRespDto.getCity()) + this.getString(orderAddrRespDto.getCounty()) + orderAddrRespDto.getReceiveAddress());
                                businessOrderInfo.setRemark(saleOrderRespDto.getRemark());
                                vo.setBusinessOrderInfo(businessOrderInfo);
                            }
                        }
                    }
                } else {
                    BeanUtils.copyProperties((Object)o, (Object)relateBillInfoVO);
                    relateBillInfoVO.setLogisticsCompany(o.getShippingCompany());
                    relateBillInfoVO.setLogisticsNo(o.getShippingCode());
                    relateBillInfoVO.setDeliveryWay(o.getShippingType());
                    relateBillInfoVO.setWmsNo(o.getWmsOrderNo());
                    if (o.getEstimatedTime() != null) {
                        relateBillInfoVO.setExpectedArriveTime(DateUtil.format((Date)o.getEstimatedTime(), (String)DatePattern.DATETIME_PATTERN.getPattern()));
                    }
                }
                return relateBillInfoVO;
            }).collect(Collectors.toList());
            vo.setRelateBillInfoList(list);
        }
    }

    private String getString(String o) {
        return Optional.ofNullable(o).orElse(" ");
    }

    @Override
    public RestResponse<PageInfo<OutResultOrderVO>> getOutResultOrderListPage(@ApiParam(value="") @Valid @RequestBody(required=false) GetOutResultOrderListPageParams getOutResultOrderListPageParams) {
        if (!this.esQuery.booleanValue()) {
            PageInfo pageInfoRestResponse = new PageInfo();
            PageInfo pageInfo = new PageInfo();
            OutResultOrderReqDto reqDto = new OutResultOrderReqDto();
            BeanUtils.copyProperties((Object)getOutResultOrderListPageParams, (Object)reqDto);
            reqDto.setOrderNo(getOutResultOrderListPageParams.getDocumentNo());
            reqDto.setBusinessType(getOutResultOrderListPageParams.getBusinessType());
            reqDto.setDeliveryWarehouseName(getOutResultOrderListPageParams.getDeliveryLogicalWarehouseName());
            reqDto.setReceiveWarehouseName(getOutResultOrderListPageParams.getReceiveLogicalWarehouseName());
            reqDto.setOrderStatus(getOutResultOrderListPageParams.getDocumentStatus());
            if (ObjectUtil.isNotEmpty((Object)getOutResultOrderListPageParams.getStartTime()) && ObjectUtil.isNotEmpty((Object)getOutResultOrderListPageParams.getEndTime())) {
                reqDto.setCreateBeginTime(DateUtil.parse((String)(getOutResultOrderListPageParams.getStartTime() + " 00:00:00"), (String)DatePattern.DATETIME_PATTERN.getPattern()));
                reqDto.setCreateEndTime(DateUtil.parse((String)(getOutResultOrderListPageParams.getEndTime() + " 23:59:59"), (String)DatePattern.DATETIME_PATTERN.getPattern()));
            }
            if (CollectionUtils.isEmpty((Collection)(pageInfoRestResponse = (PageInfo)this.outResultOrderQueryApi.queryByPage(reqDto).getData()).getList())) {
                return new RestResponse();
            }
            CubeBeanUtils.copyProperties((Object)pageInfo, (Object)pageInfoRestResponse, (String[])new String[]{"list", "navigatepageNums"});
            ArrayList outResultOrderVOS = new ArrayList();
            pageInfoRestResponse.getList().forEach(o -> {
                OutResultOrderVO outResultOrderVO = new OutResultOrderVO();
                BeanUtils.copyProperties((Object)o, (Object)outResultOrderVO);
                outResultOrderVO.setDeliveryLogicalWarehouseName(o.getDeliveryWarehouseName());
                outResultOrderVO.setDeliveryLogicalWarehouseCode(o.getDeliveryWarehouseCode());
                outResultOrderVO.setReceiveLogicalWarehouseName(o.getReceiveWarehouseName());
                outResultOrderVO.setReceiveLogicalWarehouseCode(o.getReceiveWarehouseCode());
                outResultOrderVO.setDocumentStatus(o.getOrderStatus());
                outResultOrderVO.setBusinessOrderNo(o.getRelevanceNo());
                outResultOrderVO.setNoticeNo(o.getNoticeNo());
                outResultOrderVO.setTotalSku(o.getTotalSku());
                outResultOrderVO.setTotalVolume(o.getTotalVolume() == null ? new BigDecimal(0) : o.getTotalVolume());
                outResultOrderVO.setTotalWeight(o.getTotalWeight() == null ? new BigDecimal(0) : o.getTotalWeight());
                outResultOrderVO.setCreateTime(ObjectUtil.isNotEmpty((Object)o.getCreateTime()) ? DateUtil.format((Date)o.getCreateTime(), (String)DatePattern.DATETIME_PATTERN.getPattern()) : null);
                outResultOrderVO.setBizDateStr(ObjectUtil.isNotEmpty((Object)o.getBizDate()) ? DateUtil.format((Date)o.getBizDate(), (String)DatePattern.DATETIME_PATTERN.getPattern()) : null);
                outResultOrderVO.setMixBoxesNum(o.getMixBoxesNum() == null ? new BigDecimal(0) : o.getMixBoxesNum());
                outResultOrderVO.setTotalBoxesNum(o.getTotalBoxesNum() == null ? new BigDecimal(0) : o.getTotalBoxesNum());
                outResultOrderVO.setWmsOrderNo(outResultOrderVO.getWmsNo());
                outResultOrderVOS.add(outResultOrderVO);
            });
            pageInfo.setList(outResultOrderVOS);
            return new RestResponse((Object)pageInfo);
        }
        EsOutResultOrderListPageParams pageQueryDto = new EsOutResultOrderListPageParams();
        BeanUtils.copyProperties((Object)getOutResultOrderListPageParams, (Object)pageQueryDto);
        pageQueryDto.setInLogicWarehouseName(getOutResultOrderListPageParams.getReceiveLogicalWarehouseName());
        pageQueryDto.setOutLogicWarehouseName(getOutResultOrderListPageParams.getDeliveryLogicalWarehouseName());
        PageInfo outResultOrderRespDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.esOutResultOrderQueryApi.queryOutResultOrderPage(pageQueryDto));
        if (CollectionUtils.isEmpty((Collection)outResultOrderRespDtoPageInfo.getList())) {
            return new RestResponse();
        }
        PageInfo pageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)pageInfo, (Object)outResultOrderRespDtoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        List list = outResultOrderRespDtoPageInfo.getList();
        ArrayList outResultOrderVOS = new ArrayList(list.size());
        list.forEach(p -> {
            OutResultOrderVO outResultOrderVO = new OutResultOrderVO();
            BeanUtils.copyProperties((Object)p, (Object)outResultOrderVO);
            outResultOrderVO.setDeliveryLogicalWarehouseName(p.getOutLogicWarehouseName());
            outResultOrderVO.setDeliveryLogicalWarehouseCode(p.getOutLogicWarehouseCode());
            outResultOrderVO.setReceiveLogicalWarehouseName(p.getInLogicWarehouseName());
            outResultOrderVO.setReceiveLogicalWarehouseCode(p.getInLogicWarehouseCode());
            outResultOrderVO.setDocumentStatus(p.getOrderStatus());
            outResultOrderVO.setBusinessOrderNo(p.getRelevanceNo());
            outResultOrderVO.setTotalVolume(p.getTotalVolume() == null ? null : new BigDecimal(p.getTotalVolume()));
            outResultOrderVO.setTotalWeight(p.getTotalWeight() == null ? null : new BigDecimal(p.getTotalWeight()));
            outResultOrderVO.setCreateTime(ObjectUtil.isNotEmpty((Object)p.getCreateTime()) ? DateUtil.format((Date)p.getCreateTime(), (String)DatePattern.DATETIME_PATTERN.getPattern()) : null);
            outResultOrderVO.setBizDateStr(ObjectUtil.isNotEmpty((Object)p.getBizDate()) ? DateUtil.format((Date)p.getBizDate(), (String)DatePattern.DATETIME_PATTERN.getPattern()) : null);
            outResultOrderVOS.add(outResultOrderVO);
        });
        pageInfo.setList(outResultOrderVOS);
        return new RestResponse((Object)pageInfo);
    }

    @Override
    public RestResponse<List<StringCodeCheckRespDto>> stringCodeCheck(String documentNo, Integer checkType, Boolean syncView) {
        CsOutNoticeOrderRespDto csOutResultOrderRespDto = (CsOutNoticeOrderRespDto)RestResponseHelper.extractData((RestResponse)this.csOutNoticeOrderQueryApi.queryByDocumentNo(documentNo));
        if (Objects.isNull(csOutResultOrderRespDto)) {
            return new RestResponse();
        }
        CsOutNoticeOrderQueryDto csOutResultOrderQueryDto = new CsOutNoticeOrderQueryDto();
        csOutResultOrderQueryDto.setDocumentNo(documentNo);
        csOutResultOrderQueryDto.setPageNum(Integer.valueOf(1));
        csOutResultOrderQueryDto.setPageSize(Integer.valueOf(1000));
        PageInfo csOutResultOrderDetailRespDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.csOutNoticeOrderQueryApi.queryDetailByPage(csOutResultOrderQueryDto));
        if (CollectionUtils.isEmpty((Collection)csOutResultOrderDetailRespDtoPageInfo.getList())) {
            return new RestResponse();
        }
        List<StringCodeCheckRespDto> checkRespDtos = this.loadCheckResp(csOutResultOrderRespDto, null, csOutResultOrderDetailRespDtoPageInfo.getList(), checkType, syncView);
        this.sendMqAndUpdateCache(checkRespDtos);
        return new RestResponse(checkRespDtos);
    }

    private List<StringCodeCheckRespDto> loadCheckResp(CsOutNoticeOrderRespDto csOutResultOrderRespDto, BizSaleOrderRespDto bizSaleOrderRespDto, List<CsOutNoticeOrderDetailRespDto> outResultOrderDetailRespDtos, int checkType, Boolean syncView) {
        if (checkType == 1) {
            StringCodeCheckRespDto codeCheckRespDto = new StringCodeCheckRespDto();
            codeCheckRespDto.setEasSaleOrderNo(csOutResultOrderRespDto.getExternalOrderNo());
            codeCheckRespDto.setDocumentNo(csOutResultOrderRespDto.getDocumentNo());
            codeCheckRespDto.setCheckResult(Boolean.TRUE.booleanValue());
            return Lists.newArrayList((Object[])new StringCodeCheckRespDto[]{codeCheckRespDto});
        }
        List skuCodes = outResultOrderDetailRespDtos.stream().map(CsOutNoticeOrderDetailRespDto::getLongCode).distinct().collect(Collectors.toList());
        ItemExtendReqDto itemExtendReqDto = new ItemExtendReqDto();
        itemExtendReqDto.setItemCodeList(skuCodes);
        List itemExtendRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.itemExtendQueryApi.queryParam(itemExtendReqDto));
        AssertUtils.notEmpty((Collection)itemExtendRespDtos, (String)"\u5546\u54c1\u6269\u5c55\u4fe1\u606f\u67e5\u8be2\u4e0d\u5b58\u5728");
        Map<String, String> skuImeiCodeMap = itemExtendRespDtos.stream().collect(Collectors.toMap(ItemExtendRespDto::getItemCode, ItemExtendRespDto::getImeiCodeFlag));
        outResultOrderDetailRespDtos = outResultOrderDetailRespDtos.stream().filter(o -> StringUtils.equals((CharSequence)"Y", (CharSequence)((CharSequence)skuImeiCodeMap.get(o.getLongCode())))).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(outResultOrderDetailRespDtos)) {
            StringCodeCheckRespDto codeCheckRespDto = new StringCodeCheckRespDto();
            codeCheckRespDto.setEasSaleOrderNo(csOutResultOrderRespDto.getExternalOrderNo());
            codeCheckRespDto.setDocumentNo(csOutResultOrderRespDto.getDocumentNo());
            codeCheckRespDto.setCheckResult(Boolean.TRUE.booleanValue());
            return Lists.newArrayList((Object[])new StringCodeCheckRespDto[]{codeCheckRespDto});
        }
        List stringCodeCheckReqDtos = outResultOrderDetailRespDtos.stream().map(r -> {
            StringCodeCheckReqDto req = new StringCodeCheckReqDto();
            req.setItemLongCode(r.getLongCode());
            req.setDocumentNo(csOutResultOrderRespDto.getDocumentNo());
            req.setBatch(r.getBatch());
            req.setSyncView(syncView.booleanValue());
            if (Objects.nonNull(bizSaleOrderRespDto)) {
                req.setEasSaleOrderNo(this.getThirdOrderNo(bizSaleOrderRespDto.getSaleOrderNo(), bizSaleOrderRespDto, checkType));
            } else {
                req.setEasSaleOrderNo(this.getThirdNo(csOutResultOrderRespDto, checkType));
            }
            req.setNum(Integer.valueOf(r.getDoneQuantity().intValue()));
            return req;
        }).collect(Collectors.toList());
        log.info("loadCheckResp stringCodeCheckReqDtos: {}", (Object)LogUtils.buildLogContent(stringCodeCheckReqDtos));
        List checkRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.stringCodeQueryApi.check(stringCodeCheckReqDtos));
        log.info("\u4e32\u7801\u6821\u9a8c\u7ed3\u679ccheckRespDtos:{}", (Object)JSON.toJSONString((Object)checkRespDtos));
        return checkRespDtos;
    }

    public void sendMqAndUpdateCache(List<StringCodeCheckRespDto> checkResult) {
        this.commonsMqService.publishMessage("OP_EXTERNAL_TOPIC", "string_check_result_tag", (Object)JSON.toJSONString(checkResult));
        String data = (String)this.cacheService.getCache("string_code_check_cache_key", "string_code_check_cache_key", String.class);
        if (StringUtils.isNotBlank((CharSequence)data)) {
            List orderNos = JSONArray.parseArray((String)data, String.class);
            Set documentNos = checkResult.stream().filter(StringCodeCheckRespDto::isCheckResult).map(StringCodeCheckReqDto::getDocumentNo).collect(Collectors.toSet());
            orderNos.removeIf(documentNos::contains);
            this.cacheService.setCache("string_code_check_cache_key", "string_code_check_cache_key", JSON.toJSON((Object)orderNos));
        }
    }

    @Override
    public String getThirdNo(String documentNo, int checkType) {
        return this.getThirdNo((CsOutNoticeOrderRespDto)this.csOutNoticeOrderQueryApi.queryByDocumentNo(documentNo).getData(), 0);
    }

    @Override
    public void stringCodeCheck(String documentNo, String saleOrderNo, Integer checkType, boolean b) {
        CsOutNoticeOrderRespDto csOutResultOrderRespDto = (CsOutNoticeOrderRespDto)RestResponseHelper.extractData((RestResponse)this.csOutNoticeOrderQueryApi.queryByDocumentNo(documentNo));
        if (Objects.isNull(csOutResultOrderRespDto)) {
            return;
        }
        CsOutNoticeOrderQueryDto csOutResultOrderQueryDto = new CsOutNoticeOrderQueryDto();
        csOutResultOrderQueryDto.setDocumentNo(documentNo);
        csOutResultOrderQueryDto.setPageNum(Integer.valueOf(1));
        csOutResultOrderQueryDto.setPageSize(Integer.valueOf(1000));
        PageInfo csOutResultOrderDetailRespDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.csOutNoticeOrderQueryApi.queryDetailByPage(csOutResultOrderQueryDto));
        if (CollectionUtils.isEmpty((Collection)csOutResultOrderDetailRespDtoPageInfo.getList())) {
            return;
        }
        BizSaleOrderRespDto bizSaleOrderRespDto = (BizSaleOrderRespDto)RestResponseHelper.extractData((RestResponse)this.saleOrderQueryApi.queryByOrderNo(saleOrderNo));
        if (Objects.isNull(bizSaleOrderRespDto)) {
            return;
        }
        List<StringCodeCheckRespDto> checkRespDtos = this.loadCheckResp(csOutResultOrderRespDto, bizSaleOrderRespDto, csOutResultOrderDetailRespDtoPageInfo.getList(), checkType, false);
        this.sendMqAndUpdateCache(checkRespDtos);
    }

    @Override
    public void stringCodeCheck(String documentNo, String saleOrderNo, Integer checkType, boolean b, String type) {
        CsOutNoticeOrderRespDto csOutResultOrderRespDto = (CsOutNoticeOrderRespDto)RestResponseHelper.extractData((RestResponse)this.csOutNoticeOrderQueryApi.queryByDocumentNo(documentNo));
        if (Objects.isNull(csOutResultOrderRespDto)) {
            return;
        }
        CsOutNoticeOrderQueryDto csOutResultOrderQueryDto = new CsOutNoticeOrderQueryDto();
        csOutResultOrderQueryDto.setDocumentNo(documentNo);
        csOutResultOrderQueryDto.setPageNum(Integer.valueOf(1));
        csOutResultOrderQueryDto.setPageSize(Integer.valueOf(1000));
        PageInfo csOutResultOrderDetailRespDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.csOutNoticeOrderQueryApi.queryDetailByPage(csOutResultOrderQueryDto));
        if (CollectionUtils.isEmpty((Collection)csOutResultOrderDetailRespDtoPageInfo.getList())) {
            return;
        }
        List<StringCodeCheckRespDto> checkRespDtos = this.loadCheckResp(csOutResultOrderRespDto, null, csOutResultOrderDetailRespDtoPageInfo.getList(), checkType, false);
        this.sendMqAndUpdateCache(checkRespDtos);
    }

    public String getThirdNo(CsOutNoticeOrderRespDto noticeOrderRespDto, int checkType) {
        switch (CsPcpBusinessTypeEnum.getByCode((String)noticeOrderRespDto.getBusinessType())) {
            case INTERNAL_DEAL: 
            case INTERNAL_DEAL_RETURN: {
                return Optional.ofNullable(RestResponseHelper.extractData((RestResponse)this.transferOrderQueryApi.queryByTransferOrderNo(noticeOrderRespDto.getRelevanceNo()))).map(CsTransferOrderRespDto::getExternalPurchaseOrderNo).orElse(noticeOrderRespDto.getExternalOrderNo());
            }
            case ALLOT_OUT: 
            case MAIYOU_ALLOT_OUT: 
            case ALLOT_IN_ONLY: 
            case ALLOT_OUT_ONLY: 
            case ALLOT_SALE: 
            case ALLOT_SALE_BH: {
                return Optional.ofNullable(noticeOrderRespDto.getExternalOrderNo()).filter(StringUtils::isNotEmpty).orElse(noticeOrderRespDto.getRelevanceNo());
            }
            case OTHER_OUT: 
            case OTHER_IN: 
            case REPLENISH_ORDER: 
            case INSPECTION_QUALIFIED: {
                return noticeOrderRespDto.getRelevanceNo();
            }
            case ALLOT_LOSE_EFFICACY: {
                return noticeOrderRespDto.getDocumentNo();
            }
            case ORDER_SALES_OUT: 
            case NUTRITION_INTEGRAL: 
            case AGENCY_ORDER: 
            case OTHER_OUT_STOCK: 
            case SHOPPE_ORDER: 
            case INTEGRAL_ORDER: 
            case REPLENISHMENT_ORDER: 
            case ACTIVITY_ORDER: 
            case INTERNAL_DISTRIBUTION: 
            case SECONDARY_DISTRIBUTION: 
            case COMPENSATION_ORDER: 
            case QUALITY_REFUNDING_ORDER: 
            case PRESALE_ORDER: 
            case CUSTOMER_REFUNDING_ORDER: 
            case CLAIM_POSTING: 
            case CLAIM_REISSUE: 
            case COMMON_ORDER: 
            case BAIJIAN_DIRECT_SALES: {
                BizSaleOrderRespDto data = (BizSaleOrderRespDto)Optional.ofNullable(this.saleOrderQueryApi.queryByOrderNo(noticeOrderRespDto.getRelevanceNo()).getData()).orElse(new BizSaleOrderRespDto());
                return this.getThirdOrderNo(noticeOrderRespDto.getRelevanceNo(), data, checkType);
            }
        }
        return noticeOrderRespDto.getExternalOrderNo();
    }

    private String getThirdOrderNo(String relevanceNo, BizSaleOrderRespDto order, int checkType) {
        String s = Optional.ofNullable(order.getSplitPlatformNo()).filter(StringUtils::isNotEmpty).orElseGet(() -> Optional.ofNullable(order.getEasOrderNo()).filter(StringUtils::isNotBlank).orElse(Objects.equals(checkType, 2) ? order.getPlatformOrderNo() : relevanceNo));
        log.info("\u4e32\u7801\u6821\u9a8c\u62c9\u53d6\u5355\u53f7:{}", (Object)s);
        return s;
    }
}

