/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cis.pms.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cis.pms.biz.service.ExternalService;
import com.dtyunxi.cis.pms.biz.service.IOtherOutOrderMergeToWmsService;
import com.dtyunxi.cube.commons.beans.mq.MessageVo;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.plugin.mq.ICommonsMqService;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.center.openapi.api.external.IExternalWmsApi;
import com.dtyunxi.yundt.cube.center.inventory.api.inventory.ICsOtherStorageOrderApi;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.req.CsOtherStorageOrderReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.resp.CsOtherStorageOrderRespDto;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsOtherStorageOrderStatusEnum;
import com.yunxi.dg.base.center.report.api.inventory.IDgLogicWarehouseApi;
import com.yunxi.dg.base.center.report.dto.inventory.DgLogicWarehouseDto;
import com.yunxi.dg.base.center.report.dto.inventory.DgLogicWarehousePageReqDto;
import com.yunxi.dg.base.commons.utils.LogUtils;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OtherOutOrderMergeToWmsServiceImpl
implements IOtherOutOrderMergeToWmsService {
    private static final Logger logger = LoggerFactory.getLogger(OtherOutOrderMergeToWmsServiceImpl.class);
    @Autowired
    private ExternalService externalService;
    @Resource
    private ICsOtherStorageOrderApi csOtherStorageOrderQueryApi;
    @Resource
    private IExternalWmsApi externalWmsApi;
    @Resource
    private IDgLogicWarehouseApi dgLogicWarehouseApi;
    @Resource
    private ICommonsMqService commonsMqService;
    @Resource
    private ICacheService cacheService;

    @Override
    public void otherOutOrderMergeToWms(String mergeOrderNo, String otherOrderNo) {
        logger.info("\u5176\u4ed6\u51fa\u5e93\u5355\u63a8\u9001\u5408\u5e76\u6307\u4ee4\u81f3WMS\uff1a{}\uff0c{}", (Object)mergeOrderNo, (Object)otherOrderNo);
        if (StringUtils.isNotBlank((CharSequence)mergeOrderNo)) {
            this.otherOutOrderMergeToWmsExecute(mergeOrderNo);
            return;
        }
        CsOtherStorageOrderRespDto csOtherStorageOrderDto = (CsOtherStorageOrderRespDto)RestResponseHelper.extractData((RestResponse)this.csOtherStorageOrderQueryApi.queryByOtherStorageNo(otherOrderNo));
        if (ObjectUtils.isEmpty((Object)csOtherStorageOrderDto) || StringUtils.isBlank((CharSequence)csOtherStorageOrderDto.getMergeOrderNo())) {
            logger.error("\u83b7\u53d6\u5176\u4ed6\u51fa\u5e93\u5355\u5355\u636e\u4fe1\u606f\u6709\u8bef\uff0c\u6216\u975e\u5176\u4ed6\u51fa\u5e93\u5355\u5355\u53f7");
            return;
        }
        this.otherOutOrderMergeToWmsExecute(csOtherStorageOrderDto.getMergeOrderNo());
    }

    private void otherOutOrderMergeToWmsExecute(String mergeOrderNo) {
        CsOtherStorageOrderReqDto reqDto = new CsOtherStorageOrderReqDto();
        reqDto.setMergeOrderNo(mergeOrderNo);
        List otherStorageOrderList = (List)RestResponseHelper.extractData((RestResponse)this.csOtherStorageOrderQueryApi.queryByParams(reqDto));
        if (CollectionUtils.isEmpty((Collection)otherStorageOrderList)) {
            logger.info("\u65e0\u76f8\u5173\u5355\u636e");
            return;
        }
        List filterList = otherStorageOrderList.stream().filter(d -> !d.getOrderStatus().equals(CsOtherStorageOrderStatusEnum.OUT.CANCEL.getCode()) && !d.getOrderStatus().equals(CsOtherStorageOrderStatusEnum.OUT.AUDIT_FAILED.getCode())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(filterList)) {
            logger.info("\u5355\u636e\u5df2\u7ec8\u7ed3\uff0c\u5df2\u65e0\u76f8\u5173\u5355\u636e");
            return;
        }
        List collect = filterList.stream().map(CsOtherStorageOrderRespDto::getOrderStatus).distinct().collect(Collectors.toList());
        if (!(collect.contains(CsOtherStorageOrderStatusEnum.OUT.WAIT_LEVEL_ONE_AUDIT.getCode()) || collect.contains(CsOtherStorageOrderStatusEnum.OUT.WAIT_LEVEL_TWO_AUDIT.getCode()) || collect.contains(CsOtherStorageOrderStatusEnum.OUT.AUDIT_FAILED.getCode()) || collect.contains(CsOtherStorageOrderStatusEnum.OUT.WAIT_COMMIT.getCode()))) {
            MessageVo messageVo = new MessageVo();
            try {
                DgLogicWarehousePageReqDto dgLogicWarehousePageReqDto = new DgLogicWarehousePageReqDto();
                dgLogicWarehousePageReqDto.setWarehouseCode(((CsOtherStorageOrderRespDto)filterList.get(0)).getWarehouseCode());
                List warehouseRespDtoList = (List)RestResponseHelper.extractData((RestResponse)this.dgLogicWarehouseApi.queryList(dgLogicWarehousePageReqDto));
                if (CollectionUtils.isEmpty((Collection)warehouseRespDtoList)) {
                    throw new BizException("-1", "\u627e\u4e0d\u5230\u4ed3\u5e93");
                }
                logger.info("warehouseRespDtoList: {}", (Object)LogUtils.buildLogContent((Collection)warehouseRespDtoList));
                messageVo.setData((Object)reqDto.getMergeOrderNo());
                messageVo.setExtValue1((Object)filterList.size());
                messageVo.setExtValue2((Object)((DgLogicWarehouseDto)warehouseRespDtoList.get(0)).getPhysicsWarehouseCode());
                Boolean flag = this.cacheService.setIfAbsent("OTHER_OUT_MERGE_" + reqDto.getMergeOrderNo(), (Object)1, 60);
                if (flag.booleanValue()) {
                    this.commonsMqService.sendDelaySingleMessage("OP_EXTERNAL_TOPIC", "ORDER_MERGE_TAG", (Object)messageVo, Long.valueOf(120L));
                } else {
                    logger.info("\u5176\u4ed6\u51fa\u63a8\u9001\u5408\u5e76\u6307\u4ee4\u64cd\u4f5c\u9891\u7e41");
                }
            }
            catch (Exception e) {
                logger.error("\u63a8\u9001\u5408\u5355\u6307\u4ee4\u5f02\u5e38\uff1a{}\uff0c{}", (Object)e.getMessage(), (Object)JSON.toJSONString((Object)messageVo));
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }
}

