/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cis.pms.biz.service.impl.opt;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cis.pms.biz.constant.OptLogTypeEnum;
import com.dtyunxi.cis.pms.biz.dto.request.OptLogReqDto;
import com.dtyunxi.cis.pms.biz.model.CommonConfigVO;
import com.dtyunxi.cis.pms.biz.service.SystemSettingCommonConfigService;
import com.dtyunxi.cis.pms.biz.service.opt.AbstractOptLogService;
import com.dtyunxi.cis.pms.biz.service.opt.IOptLogService;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CommonConfigOptLogServiceImpl
implements AbstractOptLogService {
    private static final Logger logger = LoggerFactory.getLogger(CommonConfigOptLogServiceImpl.class);
    @Autowired
    private IOptLogService optLogService;
    @Autowired
    private SystemSettingCommonConfigService systemSettingCommonConfigService;

    @Override
    public String getOptLogTypeCode() {
        return OptLogTypeEnum.COMMON_CONFIG.getCode();
    }

    @Override
    @Transactional(rollbackFor={Exception.class}, propagation=Propagation.NOT_SUPPORTED)
    public void addOptLog(OptLogReqDto optLogReqDto) {
        CommonConfigVO commonConfigVO;
        String optNo = optLogReqDto.getOptNo();
        if (StringUtils.isEmpty((CharSequence)optNo)) {
            optNo = "COMMON_CONFIG_100001";
            optLogReqDto.setOptNo(optNo);
        }
        if (Objects.isNull(commonConfigVO = (CommonConfigVO)RestResponseHelper.extractData(this.systemSettingCommonConfigService.getSystemSettingCommonConfig()))) {
            logger.info("\u7f16\u8f91\u901a\u7528\u914d\u7f6e\u64cd\u4f5c\u65e5\u5fd7\u4fe1\u606f\u4e3a\u7a7a\uff1a{}", (Object)optNo);
            return;
        }
        optLogReqDto.setSnapshot(JSON.toJSONString((Object)commonConfigVO));
        this.optLogService.addOptLog(optLogReqDto);
    }
}

