/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cis.pms.biz.service.impl;

import cn.afterturn.easypoi.excel.entity.result.ExcelImportResult;
import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.cis.pms.biz.dto.request.PhysicalWarehouseReqDto;
import com.dtyunxi.cis.pms.biz.dto.response.PhysicalInventoryRespVo;
import com.dtyunxi.cis.pms.biz.enums.BusinessTypeEnum;
import com.dtyunxi.cis.pms.biz.enums.OperationalTypeEnum;
import com.dtyunxi.cis.pms.biz.enums.OrderSrcEnum;
import com.dtyunxi.cis.pms.biz.enums.TransferOrderStatusEnum;
import com.dtyunxi.cis.pms.biz.model.AddressVO;
import com.dtyunxi.cis.pms.biz.model.AssociatedDocumentVO;
import com.dtyunxi.cis.pms.biz.model.AuditVO;
import com.dtyunxi.cis.pms.biz.model.DeliveryInfoVo;
import com.dtyunxi.cis.pms.biz.model.DtoExchangeUtils;
import com.dtyunxi.cis.pms.biz.model.GetOtherOutGoodsListBody;
import com.dtyunxi.cis.pms.biz.model.GetOtherOutListBody;
import com.dtyunxi.cis.pms.biz.model.GoodsVO;
import com.dtyunxi.cis.pms.biz.model.ImportBaseModeDto;
import com.dtyunxi.cis.pms.biz.model.ImportFileOperationCommonReqDto;
import com.dtyunxi.cis.pms.biz.model.ImportFileOperationCommonRespDto;
import com.dtyunxi.cis.pms.biz.model.ImportOtherOutVO;
import com.dtyunxi.cis.pms.biz.model.LogicalWarehouseVO;
import com.dtyunxi.cis.pms.biz.model.OtherOutGoodsVO;
import com.dtyunxi.cis.pms.biz.model.OtherOutVO;
import com.dtyunxi.cis.pms.biz.model.SubmitOtherOutBody;
import com.dtyunxi.cis.pms.biz.service.FinishedGoodsInventoryOtherOutService;
import com.dtyunxi.cis.pms.biz.service.helper.DataCheckHelper;
import com.dtyunxi.cis.pms.biz.service.helper.InventoryOtherHelper;
import com.dtyunxi.cis.pms.biz.service.helper.WmsAble;
import com.dtyunxi.cis.pms.biz.service.helper.meta.InventoryOtherMetaVo;
import com.dtyunxi.cis.pms.biz.service.operation.impl.HandlerFileOperationCommonServiceImpl;
import com.dtyunxi.cis.pms.biz.utils.AssertUtil;
import com.dtyunxi.cis.pms.biz.utils.AssertUtils;
import com.dtyunxi.cis.pms.biz.utils.CodeGenerateUtil;
import com.dtyunxi.cis.pms.biz.utils.ExcelUtils;
import com.dtyunxi.cis.search.api.query.inventory.EsOtherStorageOrderQueryApi;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.cube.utils.enums.DatePattern;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.request.CargoInventoryReqDto;
import com.dtyunxi.tcbj.api.dto.request.PhysicalInventoryReqDto;
import com.dtyunxi.tcbj.api.dto.request.es.EsOtherStorageOrderListPageParams;
import com.dtyunxi.tcbj.api.dto.response.CostCenterRespDto;
import com.dtyunxi.tcbj.api.dto.response.InPlannedOrderStatusCountRespDto;
import com.dtyunxi.tcbj.api.dto.response.LogicWarehouseRespDto;
import com.dtyunxi.tcbj.api.dto.response.es.CsOtherStorageOrderRespVo;
import com.dtyunxi.tcbj.api.query.ILogicInventoryQueryApi;
import com.dtyunxi.tcbj.api.query.IOutResultOrderQueryApi;
import com.dtyunxi.tcbj.api.query.es.InventoryEsReportQueryApi;
import com.dtyunxi.tcbj.center.openapi.common.wms.response.WmsBaseRespDto;
import com.dtyunxi.util.ParamConverter;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.BaseRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerStatusRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerStatusQueryApi;
import com.dtyunxi.yundt.cube.center.data.api.dto.request.PcpRegionReqDto;
import com.dtyunxi.yundt.cube.center.data.api.dto.response.PcpRegionRespDto;
import com.dtyunxi.yundt.cube.center.data.api.query.IPcpRegionQueryApi;
import com.dtyunxi.yundt.cube.center.func.api.dto.TwoTuple;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.inventory.ICsLogicInventoryTotalQueryApi;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.inventory.pcp.ICsPcpInventoryExposedApi;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.order.ICsOutNoticeOrderQueryApi;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.warehouse.ICsLogicWarehouseQueryApi;
import com.dtyunxi.yundt.cube.center.inventory.api.inventory.ICsBusinessTypeApi;
import com.dtyunxi.yundt.cube.center.inventory.api.inventory.ICsOtherStorageOrderApi;
import com.dtyunxi.yundt.cube.center.inventory.api.inventory.ICsOtherStorageOrderDetailApi;
import com.dtyunxi.yundt.cube.center.inventory.api.inventory.ICsStorageAuditRecordApi;
import com.dtyunxi.yundt.cube.center.inventory.constant.ConsignmentConstant;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.req.CsBusinessTypeReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.req.CsOtherStorageOrderComboReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.req.CsOtherStorageOrderDetailReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.req.CsOtherStorageOrderReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.resp.CsBusinessTypeRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.resp.CsOtherStorageOrderDetailRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.resp.CsOtherStorageOrderRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory.CsInventoryTotalQueryReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.order.CsOutNoticeOrderRespDto;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsOtherStorageOrderEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsPcpBusinessTypeEnum;
import com.dtyunxi.yundt.cube.center.item.api.base.query.IItemQueryApi;
import com.dtyunxi.yundt.cube.center.item.api.dto.response.PcpItemRespDto;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.yunxi.dg.base.commons.utils.LogUtils;
import com.yx.tcbj.center.customer.api.dto.request.PCPCustomerSearchReqDto;
import com.yx.tcbj.center.customer.api.query.ICustomerQueryApi;
import io.swagger.annotations.ApiParam;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.validation.Valid;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;

@Service(value="abstractFileOperationCommonService_other_out_warehousing")
public class FinishedGoodsInventoryOtherOutServiceServiceImpl
extends HandlerFileOperationCommonServiceImpl
implements FinishedGoodsInventoryOtherOutService {
    private static final Logger logger = LoggerFactory.getLogger(FinishedGoodsInventoryOtherOutServiceServiceImpl.class);
    @Value(value="${esQuery:true}")
    private Boolean esQuery;
    @Resource
    private ICsOtherStorageOrderApi csOtherStorageOrderApi;
    @Resource
    private ICsStorageAuditRecordApi csStorageAuditRecordQueryApi;
    @Resource
    private ICsOtherStorageOrderDetailApi csOtherStorageOrderDetailQueryApi;
    @Resource
    private EsOtherStorageOrderQueryApi esOtherStorageOrderQueryApi;
    @Resource
    private ICsBusinessTypeApi csBusinessTypeQueryApi;
    @Resource
    private ICsLogicInventoryTotalQueryApi csLogicInventoryTotalQueryApi;
    @Resource
    private IOutResultOrderQueryApi iOutResultOrderQueryApi;
    @Resource
    private IItemQueryApi iItemQueryApi;
    @Resource
    private InventoryOtherHelper inventoryOtherHelper;
    @Resource
    private DataCheckHelper dataCheckHelper;
    @Resource
    private InventoryEsReportQueryApi inventoryEsReportQueryApi;
    @Resource
    private IPcpRegionQueryApi pcpRegionQueryApi;
    @Resource
    private ILogicInventoryQueryApi iLogicInventoryQueryApi;
    @Resource
    private ICsOutNoticeOrderQueryApi csOutNoticeOrderQueryApi;
    @Resource
    private WmsAble wmsAble;
    @Resource
    private ICsPcpInventoryExposedApi csPcpInventoryExposedApi;
    @Resource
    private ICsLogicWarehouseQueryApi csLogicWarehouseQueryApi;
    @Resource
    private CodeGenerateUtil codeGenerateUtil;
    @Resource
    private ICustomerQueryApi customerQueryApi;
    @Resource
    private ICustomerStatusQueryApi customerStatusQueryApi;
    public static final String DEFUALT_PLATFORM_CODE = "DEFUALT_CODE_2022111652";

    @Override
    public RestResponse<Object> addOtherOut(@ApiParam(value="") @Valid @RequestBody(required=false) SubmitOtherOutBody submitOtherOutBody) {
        if (StringUtils.isBlank((CharSequence)submitOtherOutBody.getOperationalType())) {
            throw new BizException("\u64cd\u4f5c\u7c7b\u578b\u9519\u8bef");
        }
        String phone = submitOtherOutBody.getConsigneePhone();
        if (submitOtherOutBody.getOperationalType().equals(OperationalTypeEnum.SUBMIT.getCode())) {
            submitOtherOutBody.setBussinessOrderNo(null);
            submitOtherOutBody.setMergeOrderNo(null);
        }
        this.checkCustomerStatus(submitOtherOutBody);
        this.inventoryOtherHelper.submitSplit(submitOtherOutBody, InventoryOtherHelper.SubmitEvent.SAVE);
        return new RestResponse();
    }

    private void checkCustomerStatus(SubmitOtherOutBody submitOtherOutBody) {
        PCPCustomerSearchReqDto pcpCustomerSearchReqDto = new PCPCustomerSearchReqDto();
        pcpCustomerSearchReqDto.setCode(submitOtherOutBody.getCustomerCode());
        List customerRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.customerQueryApi.queryPCPCustomerDetail(pcpCustomerSearchReqDto));
        AssertUtil.isTrue(CollectionUtils.isNotEmpty((Collection)customerRespDtos), "\u5ba2\u6237\u4fe1\u606f\u4e0d\u5b58\u5728");
        CustomerRespDto customerRespDto = (CustomerRespDto)customerRespDtos.get(0);
        AssertUtils.notNull(customerRespDto.getStatusId(), "\u5ba2\u6237\u8d26\u53f7\u6570\u636e\u5f02\u5e38\uff1a\u72b6\u6001\u6570\u636e\u4e3a\u7a7a");
        CustomerStatusRespDto customerStatusRespDto = (CustomerStatusRespDto)RestResponseHelper.extractData((RestResponse)this.customerStatusQueryApi.queryById(customerRespDto.getStatusId()));
        AssertUtils.notNull(customerStatusRespDto, "\u5ba2\u6237\u8d26\u53f7\u6570\u636e\u5f02\u5e38\uff1a\u72b6\u6001\u6570\u636e\u4e3a\u7a7a");
        AssertUtil.assertEqual(1, customerStatusRespDto.getAccountStatus(), "\u5ba2\u6237\u8d26\u53f7\u5df2\u7981\u7528");
        AssertUtil.assertEqual(1, customerStatusRespDto.getRecordStatus(), "\u5ba2\u6237\u8d26\u53f7\u5df2\u505c\u7528");
    }

    @Override
    public RestResponse<Object> auditOtherOut(@ApiParam(value="", required=true) @PathVariable(value="id") String id, @ApiParam(value="") @Valid @RequestBody(required=false) SubmitOtherOutBody submitOtherOutBody) {
        if (StringUtils.isBlank((CharSequence)id)) {
            throw new BizException("\u5355\u636eid\u4e0d\u80fd\u4e3a\u7a7a");
        }
        submitOtherOutBody.setId(Long.valueOf(id));
        this.inventoryOtherHelper.submitSplit(submitOtherOutBody, InventoryOtherHelper.SubmitEvent.AUDIT);
        return new RestResponse();
    }

    @Override
    public RestResponse<Object> deleteOtherOut(@ApiParam(value="", required=true) @PathVariable(value="id") String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            throw new BizException("\u5355\u636eid\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return new RestResponse(RestResponseHelper.extractData((RestResponse)this.csOtherStorageOrderApi.deleteById(Long.valueOf(id))));
    }

    @Override
    public RestResponse<OtherOutVO> getOtherOutDetail(@ApiParam(value="", required=true) @PathVariable(value="bussinessOrderNo") String bussinessOrderNo) {
        List respDtos;
        List respDtoList;
        if (StringUtils.isBlank((CharSequence)bussinessOrderNo)) {
            throw new BizException("\u5355\u636eid\u4e0d\u80fd\u4e3a\u7a7a");
        }
        CsOtherStorageOrderRespDto respDto = (CsOtherStorageOrderRespDto)RestResponseHelper.extractData((RestResponse)this.csOtherStorageOrderApi.queryByOtherStorageNo(bussinessOrderNo));
        OtherOutVO vo = new OtherOutVO();
        if (Objects.isNull(respDto)) {
            return new RestResponse((Object)vo);
        }
        BeanUtils.copyProperties((Object)respDto, (Object)vo);
        vo.setBussinessOrderNo(respDto.getStorageOrderNo());
        vo.setBussinessOrderStatus(ParamConverter.convertToString((Object)respDto.getOrderStatus()));
        LogicalWarehouseVO logicalWarehouseVO = new LogicalWarehouseVO();
        logicalWarehouseVO.setWarehouseName(respDto.getWarehouseName());
        logicalWarehouseVO.setWarehouseCode(respDto.getWarehouseCode());
        vo.setCargoRightName(respDto.getOrganization());
        vo.setCargoRightId(ParamConverter.convertToString((Object)respDto.getOrganizationId()));
        vo.setLogicalWarehouse(logicalWarehouseVO);
        vo.setCustomerCode(respDto.getCustomerCode());
        vo.setCustomerName(respDto.getCustomerName());
        vo.setConsigneeName(respDto.getConsignee());
        vo.setConsigneePhone(respDto.getPhone());
        vo.setSummary(respDto.getMessage());
        StringBuilder province = new StringBuilder().append(respDto.getProvinceName()).append(respDto.getCityName()).append(respDto.getAreaName());
        vo.setProvince(String.valueOf(province).replace("null", ""));
        AddressVO addressVO = new AddressVO();
        addressVO.setProvince(respDto.getProvinceName());
        addressVO.setProvinceCode(respDto.getProvinceCode());
        addressVO.setCity(respDto.getCityName());
        addressVO.setCityCode(respDto.getCityCode());
        addressVO.setDistrict(respDto.getAreaName());
        addressVO.setDistrictCode(respDto.getAreaCode());
        addressVO.setDetailAddress(respDto.getAddress());
        vo.setConsigneeAddress(addressVO);
        vo.setIsSendEas(respDto.getIsSendEas());
        vo.setBussinessOrderType(ParamConverter.convertToString((Object)respDto.getBusinessType()));
        vo.setBussinessOrderTypeName(respDto.getBusinessTypeName());
        vo.setExternalOrderNo(respDto.getExternalOrderNo());
        vo.setRelationBussinessOrderNo(respDto.getPreOrderNo());
        if (respDto.getCreateTime() != null) {
            vo.setCreateTime(com.dtyunxi.util.DateUtil.format((Date)respDto.getCreateTime(), (String)DatePattern.DATETIME_PATTERN.getPattern()));
        }
        Optional.ofNullable(RestResponseHelper.extractData((RestResponse)this.csOtherStorageOrderDetailQueryApi.queryListByOtherOrderNo(bussinessOrderNo))).filter(CollectionUtils::isNotEmpty).map(items -> (CsOtherStorageOrderDetailRespDto)items.get(0)).ifPresent(it -> vo.setEnableBatch(StringUtils.isBlank((CharSequence)it.getBatch()) ? 0 : 1));
        Optional.ofNullable(respDto.getCostCenterCode()).filter(StringUtils::isNotEmpty).ifPresent(costCode -> {
            vo.setCostCenterCode(respDto.getCostCenterCode());
            Map<String, CostCenterRespDto> centerByCodes = this.inventoryOtherHelper.getCostCenterByCodes(Sets.newHashSet((Object[])new String[]{respDto.getCostCenterCode()}));
            vo.setCostCenterName(centerByCodes.getOrDefault(respDto.getCostCenterCode(), new CostCenterRespDto()).getCostCenterName());
        });
        List csStorageAuditRecordRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.csStorageAuditRecordQueryApi.queryListByOrderSrcNo(respDto.getStorageOrderNo()));
        if (CollectionUtils.isNotEmpty((Collection)csStorageAuditRecordRespDtos)) {
            List<AuditVO> list = csStorageAuditRecordRespDtos.stream().map(o -> {
                AuditVO auditVO = new AuditVO();
                BeanUtils.copyProperties((Object)o, (Object)auditVO);
                auditVO.setAuditResult(o.getAuditResult());
                auditVO.setAuditReason(o.getRemark());
                if (o.getCreateTime() != null) {
                    auditVO.setCreateTime(com.dtyunxi.util.DateUtil.format((Date)o.getCreateTime(), (String)DatePattern.DATETIME_PATTERN.getPattern()));
                }
                return auditVO;
            }).collect(Collectors.toList());
            vo.setAuditRecordList(list);
        }
        if (CollectionUtils.isNotEmpty((Collection)(respDtoList = (List)RestResponseHelper.extractData((RestResponse)this.csOtherStorageOrderApi.queryOtherStorageOrderRelevanceOrder(respDto.getStorageOrderNo(), CsOtherStorageOrderEnum.InOrOut.OUT.getCode()))))) {
            List<AssociatedDocumentVO> list = respDtoList.stream().map(o -> {
                AssociatedDocumentVO documentVO = new AssociatedDocumentVO();
                BeanUtils.copyProperties((Object)o, (Object)documentVO);
                if (o.getCreateTime() != null) {
                    documentVO.setCreateTime(com.dtyunxi.util.DateUtil.format((Date)o.getCreateTime(), (String)"yyyy-MM-dd HH:mm:ss"));
                }
                documentVO.setOrderNo(o.getDocumentNo());
                documentVO.setOrderType(o.getBusinessType());
                return documentVO;
            }).collect(Collectors.toList());
            vo.setAssociatedDocumentList(list);
        }
        if (CollectionUtils.isNotEmpty((Collection)(respDtos = (List)RestResponseHelper.extractData((RestResponse)this.iOutResultOrderQueryApi.queryDeliveryInformation(bussinessOrderNo))))) {
            List<DeliveryInfoVo> list = respDtos.stream().map(o -> {
                DeliveryInfoVo documentVO = new DeliveryInfoVo();
                BeanUtils.copyProperties((Object)o, (Object)documentVO);
                if (o.getConsignmentType() != null) {
                    documentVO.setConsignmentTypeName((String)ConsignmentConstant.CONSIGNMENT_TYPE.valueMap.get(o.getConsignmentType()));
                }
                return documentVO;
            }).collect(Collectors.toList());
            vo.setDeliveryInfoList(list);
        }
        return new RestResponse((Object)vo);
    }

    @Override
    public RestResponse<List<OtherOutGoodsVO>> getOtherOutGoodsList(@ApiParam(value="", required=true) @PathVariable(value="id") String bussinessOrderNo) {
        if (StringUtils.isBlank((CharSequence)bussinessOrderNo)) {
            throw new BizException("\u5355\u636e\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List respDtos = (List)RestResponseHelper.extractData((RestResponse)this.csOtherStorageOrderDetailQueryApi.queryListByOtherOrderNo(bussinessOrderNo));
        if (CollectionUtils.isEmpty((Collection)respDtos)) {
            return new RestResponse();
        }
        CsOtherStorageOrderRespDto storageOrderRespDto = (CsOtherStorageOrderRespDto)RestResponseHelper.extractData((RestResponse)this.csOtherStorageOrderApi.queryByOtherStorageNo(bussinessOrderNo));
        Map<String, BigDecimal> inventoryMap = this.inventoryOtherHelper.loadInventory(respDtos.stream().map(item -> {
            CargoInventoryReqDto cargoInventoryReqDto = new CargoInventoryReqDto();
            cargoInventoryReqDto.setBatch(item.getBatch());
            cargoInventoryReqDto.setCargoCode(item.getLongCode());
            cargoInventoryReqDto.setWarehouseCode(storageOrderRespDto.getWarehouseCode());
            return cargoInventoryReqDto;
        }).collect(Collectors.toList()));
        List list = respDtos.stream().map(o -> {
            OtherOutGoodsVO vo = new OtherOutGoodsVO();
            BeanUtils.copyProperties((Object)o, (Object)vo);
            vo.setGoodsLongCode(o.getLongCode());
            vo.setGoodsName(o.getCargoName());
            vo.setGoodsSpec(o.getSpecification());
            vo.setVolume(o.getVolume());
            vo.setOutQuantity(o.getQuantity());
            vo.setBatch(o.getBatch());
            vo.setWarehouseCode(storageOrderRespDto.getWarehouseCode());
            vo.setWarehouseName(storageOrderRespDto.getWarehouseName());
            vo.setInventoryCount((BigDecimal)inventoryMap.get(this.inventoryOtherHelper.degreeKey(storageOrderRespDto.getWarehouseCode(), o.getBatch(), o.getLongCode())));
            return vo;
        }).collect(Collectors.toList());
        return new RestResponse(list);
    }

    @Override
    public RestResponse<PageInfo<OtherOutVO>> getOtherOutList(@ApiParam(value="") @Valid @RequestBody(required=false) GetOtherOutListBody getOtherOutListBody) {
        logger.info("getOtherOutList\uff1a{}", (Object)LogUtils.buildLogContent((Object)getOtherOutListBody));
        PageInfo respVoPageInfo = new PageInfo();
        EsOtherStorageOrderListPageParams params = new EsOtherStorageOrderListPageParams();
        BeanUtil.copyProperties((Object)getOtherOutListBody, (Object)params, (String[])new String[0]);
        params.setBusinessType(getOtherOutListBody.getBussinessOrderType());
        params.setStorageOrderNo(getOtherOutListBody.getBussinessOrderNo());
        params.setPreOrderNo(ObjectUtil.isNotEmpty((Object)getOtherOutListBody.getPreOrderNo()) ? getOtherOutListBody.getPreOrderNo() : getOtherOutListBody.getRelationBussinessOrderNo());
        params.setExternalOrderNo(getOtherOutListBody.getExternalOrderNo());
        params.setOrganization(getOtherOutListBody.getCargoRightName());
        params.setOrderStatus(getOtherOutListBody.getBussinessOrderStatus());
        params.setWarehouseName(getOtherOutListBody.getLogicalWarehouseName());
        params.setCreateBeginTime(getOtherOutListBody.getCreateStartTime());
        params.setCreateEndTime(getOtherOutListBody.getCreateEndTime());
        params.setConsignee(getOtherOutListBody.getConsignee());
        params.setPhone(getOtherOutListBody.getPhone());
        params.setAddress(getOtherOutListBody.getAddress());
        params.setDeliveryPhysicsWarehouseCodeList(getOtherOutListBody.getDeliveryPhysicsWarehouseCodeList());
        params.setType(BusinessTypeEnum.OTHER_OUT.getCode());
        params.setShippingCode(getOtherOutListBody.getShippingCode());
        params.setShippingCompany(getOtherOutListBody.getShippingCompany());
        params.setShippingType(getOtherOutListBody.getShippingType());
        params.setConsignmentNo(getOtherOutListBody.getConsignmentNo());
        params.setMergeOrderNo(getOtherOutListBody.getMergeOrderNo());
        params.setProvinceName(getOtherOutListBody.getProvinceName());
        params.setCityName(getOtherOutListBody.getCityName());
        params.setAreaName(getOtherOutListBody.getAreaName());
        PageInfo csOtherStorageOrderRespVoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.inventoryEsReportQueryApi.getOtherOutList(params));
        CubeBeanUtils.copyProperties((Object)respVoPageInfo, (Object)csOtherStorageOrderRespVoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList lists = new ArrayList();
        CubeBeanUtils.copyCollection(lists, (Collection)csOtherStorageOrderRespVoPageInfo.getList(), com.dtyunxi.cis.search.api.dto.response.CsOtherStorageOrderRespVo.class);
        respVoPageInfo.setList(lists);
        PageInfo pageInfo = new PageInfo();
        if (CollectionUtils.isEmpty((Collection)respVoPageInfo.getList())) {
            return new RestResponse((Object)pageInfo);
        }
        CubeBeanUtils.copyProperties((Object)pageInfo, (Object)respVoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        List ids = respVoPageInfo.getList().stream().map(com.dtyunxi.cis.search.api.dto.response.CsOtherStorageOrderRespVo::getBusinessType).collect(Collectors.toList());
        HashMap<Long, String> map = new HashMap<Long, String>();
        if (CollectionUtils.isNotEmpty(ids)) {
            CsBusinessTypeReqDto dto = new CsBusinessTypeReqDto();
            dto.setIds(ids);
            List dtoList = (List)RestResponseHelper.extractData((RestResponse)this.csBusinessTypeQueryApi.queryByIds(dto));
            Map<Long, String> stringMap = dtoList.stream().collect(Collectors.toMap(CsBusinessTypeRespDto::getId, CsBusinessTypeRespDto::getBusinessTypeName, (o, o1) -> o));
            map.putAll(stringMap);
        }
        List list = respVoPageInfo.getList().stream().map(o -> {
            OtherOutVO vo = new OtherOutVO();
            BeanUtils.copyProperties((Object)o, (Object)vo);
            vo.setBussinessOrderNo(o.getStorageOrderNo());
            vo.setRelationBussinessOrderNo(o.getPreOrderNo());
            if (o.getBusinessType() != null) {
                vo.setBussinessOrderType(ParamConverter.convertToString((Object)o.getBusinessType()));
                vo.setBussinessOrderTypeName((String)map.get(o.getBusinessType()));
            }
            vo.setBussinessOrderStatus(o.getOrderStatus());
            LogicalWarehouseVO logicalWarehouseVO = new LogicalWarehouseVO();
            logicalWarehouseVO.setWarehouseName(o.getWarehouseName());
            logicalWarehouseVO.setWarehouseCode(o.getWarehouseCode());
            vo.setLogicalWarehouse(logicalWarehouseVO);
            vo.setCargoRightName(o.getOrganization());
            vo.setCargoRightId(ParamConverter.convertToString((Object)o.getOrganizationId()));
            vo.setCustomerCode(o.getCustomerCode());
            vo.setCustomerName(o.getCustomerName());
            if (o.getCreateTime() != null) {
                vo.setCreateTime(com.dtyunxi.util.DateUtil.format((Date)o.getCreateTime(), (String)DatePattern.DATETIME_PATTERN.getPattern()));
            }
            vo.setBizDateStr(ObjectUtil.isNotEmpty((Object)o.getBizDate()) ? com.dtyunxi.util.DateUtil.format((Date)o.getBizDate(), (String)DatePattern.DATETIME_PATTERN.getPattern()) : null);
            vo.setConsigneeName(o.getConsignee());
            vo.setConsigneePhone(o.getPhone());
            AddressVO addressVO = new AddressVO();
            addressVO.setDetailAddress(o.getProvinceName() + o.getCityName() + o.getAreaName() + o.getAddress());
            addressVO.setProvince(o.getProvinceName());
            addressVO.setProvinceCode(o.getProvinceCode());
            addressVO.setCity(o.getCityName());
            addressVO.setCityCode(o.getCityCode());
            addressVO.setDistrict(o.getAreaName());
            addressVO.setDistrictCode(o.getAreaCode());
            vo.setRemark(o.getMessage());
            vo.setConsigneeAddress(addressVO);
            if (o.getTotalCartons() != null) {
                vo.setTotalCartons(o.getTotalCartons().compareTo(BigDecimal.ZERO) == 0 ? null : o.getTotalCartons());
            }
            if (o.getMergeQuantity() != null) {
                vo.setMergeQuantity(o.getMergeQuantity().compareTo(BigDecimal.ZERO) == 0 ? null : o.getMergeQuantity());
            }
            if (o.getTotalWeight() != null) {
                vo.setTotalWeight(o.getTotalWeight().compareTo(BigDecimal.ZERO) == 0 ? null : o.getTotalWeight());
            }
            if (o.getTotalVolume() != null) {
                vo.setTotalVolume(o.getTotalVolume().compareTo(BigDecimal.ZERO) == 0 ? null : o.getTotalVolume());
            }
            return vo;
        }).collect(Collectors.toList());
        pageInfo.setList(list);
        return new RestResponse((Object)pageInfo);
    }

    @Override
    public RestResponse<Object> getOrderOutWithdraw(Long id) {
        List csOutNoticeOrderRespDtos;
        AssertUtil.isTrue(null != id, "id\u4e0d\u80fd\u4e3a\u7a7a");
        CsOtherStorageOrderRespVo csOtherStorageOrderRespVo = (CsOtherStorageOrderRespVo)RestResponseHelper.extractData((RestResponse)this.inventoryEsReportQueryApi.queryById(id));
        if (ObjectUtils.isEmpty((Object)csOtherStorageOrderRespVo)) {
            return new RestResponse();
        }
        if (Objects.equals(csOtherStorageOrderRespVo.getType(), BusinessTypeEnum.OTHER_OUT.getCode())) {
            AssertUtil.isTrue(Objects.equals(csOtherStorageOrderRespVo.getOrderStatus(), TransferOrderStatusEnum.WAIT_OUT.getCode()), "\u975e\u5f85\u51fa\u5e93\u72b6\u6001\u4e0d\u5141\u8bb8\u64cd\u4f5c\u64a4\u56de");
        }
        if (Objects.equals(csOtherStorageOrderRespVo.getType(), BusinessTypeEnum.OTHER_IN.getCode())) {
            AssertUtil.isTrue(Objects.equals(csOtherStorageOrderRespVo.getOrderStatus(), TransferOrderStatusEnum.WAIT_IN.getCode()), "\u975e\u5f85\u5165\u5e93\u72b6\u6001\u4e0d\u5141\u8bb8\u64cd\u4f5c\u64a4\u56de");
        }
        if (ObjectUtils.isEmpty((Object)(csOutNoticeOrderRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.csOutNoticeOrderQueryApi.queryByRelevanceNoList(Collections.singletonList(csOtherStorageOrderRespVo.getStorageOrderNo())))))) {
            return new RestResponse();
        }
        CsOutNoticeOrderRespDto csOutNoticeOrderRespDto = (CsOutNoticeOrderRespDto)csOutNoticeOrderRespDtos.get(0);
        WmsBaseRespDto wmsBaseRespDto = this.wmsAble.cancelWmsOutOrderWithdraw(csOutNoticeOrderRespDto);
        if (wmsBaseRespDto.isSuccess()) {
            logger.info("WMS\u53d6\u6d88\u6210\u529f\uff0c\u53d6\u6d88\u51fa\u5e93\u5355\u53f7.{}", (Object)csOutNoticeOrderRespDto.getDocumentNo());
            RestResponseHelper.extractData((RestResponse)this.csPcpInventoryExposedApi.cancelLogicAndStorageOrder(csOtherStorageOrderRespVo.getStorageOrderNo(), id));
        }
        AssertUtil.isTrue(wmsBaseRespDto.isSuccess(), "\u53d6\u6d88WMS\u5355\u636e\u5931\u8d25:" + wmsBaseRespDto.getContent());
        return new RestResponse();
    }

    @Override
    public RestResponse<List<InPlannedOrderStatusCountRespDto>> otherOutStorageOrderStatusCount(@Valid GetOtherOutListBody getOtherOutListBody) {
        EsOtherStorageOrderListPageParams params = new EsOtherStorageOrderListPageParams();
        BeanUtil.copyProperties((Object)getOtherOutListBody, (Object)params, (String[])new String[0]);
        params.setBusinessType(getOtherOutListBody.getBussinessOrderType());
        params.setStorageOrderNo(getOtherOutListBody.getBussinessOrderNo());
        params.setPreOrderNo(ObjectUtil.isNotEmpty((Object)getOtherOutListBody.getPreOrderNo()) ? getOtherOutListBody.getPreOrderNo() : getOtherOutListBody.getRelationBussinessOrderNo());
        params.setExternalOrderNo(getOtherOutListBody.getExternalOrderNo());
        params.setOrganization(getOtherOutListBody.getCargoRightName());
        params.setOrderStatus(getOtherOutListBody.getBussinessOrderStatus());
        params.setWarehouseName(getOtherOutListBody.getLogicalWarehouseName());
        params.setCreateBeginTime(getOtherOutListBody.getCreateStartTime());
        params.setCreateEndTime(getOtherOutListBody.getCreateEndTime());
        params.setType(BusinessTypeEnum.OTHER_OUT.getCode());
        params.setShippingCode(getOtherOutListBody.getShippingCode());
        params.setShippingCompany(getOtherOutListBody.getShippingCompany());
        params.setShippingType(getOtherOutListBody.getShippingType());
        params.setConsignmentNo(getOtherOutListBody.getConsignmentNo());
        params.setMergeOrderNo(getOtherOutListBody.getMergeOrderNo());
        return this.inventoryEsReportQueryApi.otherStorageOrderStatusCount(params);
    }

    @Override
    public RestResponse<Object> submitOtherOut(@ApiParam(value="", required=true) @PathVariable(value="id") String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            throw new BizException("\u5355\u636eid\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return new RestResponse(RestResponseHelper.extractData((RestResponse)this.csOtherStorageOrderApi.submitById(Long.valueOf(id))));
    }

    @Override
    public RestResponse<Object> updateOtherOut(@ApiParam(value="", required=true) @PathVariable(value="id") String id, @ApiParam(value="") @Valid @RequestBody(required=false) SubmitOtherOutBody submitOtherOutBody) {
        if (StringUtils.isBlank((CharSequence)id)) {
            throw new BizException("\u5355\u636eid\u4e0d\u80fd\u4e3a\u7a7a");
        }
        submitOtherOutBody.setId(Long.valueOf(id));
        this.inventoryOtherHelper.submitSplit(submitOtherOutBody, InventoryOtherHelper.SubmitEvent.EDIT);
        return new RestResponse();
    }

    @Override
    public RestResponse<PageInfo<GoodsVO>> queryOtherOutGoodsList(@ApiParam(value="") @Valid @RequestBody(required=false) GetOtherOutGoodsListBody getOtherOutGoodsListBody) {
        CsInventoryTotalQueryReqDto reqDto = new CsInventoryTotalQueryReqDto();
        reqDto.setCargoName(getOtherOutGoodsListBody.getGoodsName());
        reqDto.setLongCode(getOtherOutGoodsListBody.getGoodsLongCode());
        reqDto.setLogicWarehouseCode(getOtherOutGoodsListBody.getWarehouseCode());
        PageInfo respDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.csLogicInventoryTotalQueryApi.queryByLogicWarehouseCodePage(reqDto, getOtherOutGoodsListBody.getPageNum(), getOtherOutGoodsListBody.getPageSize()));
        PageInfo pageInfo = new PageInfo();
        if (CollectionUtils.isEmpty((Collection)respDtoPageInfo.getList())) {
            return new RestResponse((Object)pageInfo);
        }
        CubeBeanUtils.copyProperties((Object)pageInfo, (Object)respDtoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        List list = respDtoPageInfo.getList().stream().map(o -> {
            GoodsVO vo = new GoodsVO();
            BeanUtils.copyProperties((Object)o, (Object)vo);
            vo.setGoodsId(ParamConverter.convertToString((Object)o.getCargoId()));
            vo.setGoodsLongCode(o.getLongCode());
            vo.setGoodsCode(o.getCargoCode());
            if (o.getCargoId() != null) {
                // empty if block
            }
            return vo;
        }).collect(Collectors.toList());
        pageInfo.setList(list);
        return new RestResponse((Object)pageInfo);
    }

    @Override
    public RestResponse<PageInfo<PhysicalInventoryRespVo>> queryPhysicalByPage(PhysicalWarehouseReqDto filter) {
        PhysicalInventoryReqDto searchReqDto = new PhysicalInventoryReqDto();
        BeanUtils.copyProperties((Object)((Object)filter), (Object)searchReqDto);
        PageInfo dtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.iLogicInventoryQueryApi.queryPhysicalByPage(searchReqDto));
        if (CollectionUtils.isEmpty((Collection)dtoPageInfo.getList())) {
            return new RestResponse();
        }
        PageInfo pageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)pageInfo, (Object)dtoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        List list = dtoPageInfo.getList();
        ArrayList DeliveryTimeLimitVOS = new ArrayList(list.size());
        list.forEach(p -> {
            PhysicalInventoryRespVo deliveryTimeLimitVO = DtoExchangeUtils.createDtoBySource(p, PhysicalInventoryRespVo.class);
            DeliveryTimeLimitVOS.add(deliveryTimeLimitVO);
        });
        pageInfo.setList(DeliveryTimeLimitVOS);
        return new RestResponse((Object)pageInfo);
    }

    @Override
    public String executeImportFileOperationCommon(ExcelImportResult<ImportBaseModeDto> result, ImportFileOperationCommonReqDto commonReqDto, ImportFileOperationCommonRespDto respDto, Object obj) {
        TwoTuple twoTuple = (TwoTuple)obj;
        Optional.ofNullable(twoTuple.getFirst()).filter(CollUtil::isNotEmpty).ifPresent(list -> RestResponseHelper.checkOrThrow((RestResponse)this.csOtherStorageOrderApi.batchCreateCsOtherStorageOrder(list)));
        return Optional.ofNullable(twoTuple.getSecond()).filter(CollUtil::isNotEmpty).map(msgList -> ExcelUtils.getExportUrl(msgList, ImportOtherOutVO.class, "\u5176\u4ed6\u51fa\u5e93\u5355\u5bfc\u5165\u9519\u8bef\u4fe1\u606f", String.format("%s%s", "\u5176\u4ed6\u51fa\u5e93\u5355\u5bfc\u5165\u9519\u8bef\u4fe1\u606f", commonReqDto.getTaskCode()))).orElse(null);
    }

    @Override
    public Object verifyImportFileOperationCommon(ExcelImportResult<ImportBaseModeDto> result, ImportFileOperationCommonReqDto commonReqDto, ImportFileOperationCommonRespDto respDto) {
        ArrayList list = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)list, (Collection)result.getList(), ImportOtherOutVO.class);
        return this.executorImport(list, this.getInventoryOtherMetaVo(list));
    }

    private TwoTuple<List<CsOtherStorageOrderComboReqDto>, List<ImportOtherOutVO>> executorImport(List<ImportOtherOutVO> list, InventoryOtherMetaVo inventoryOtherMetaVo) {
        List customerStatueList;
        ArrayList saveList = Lists.newArrayList();
        ArrayList msgList = Lists.newArrayList();
        Set customerCodes = list.stream().filter(dto -> StringUtils.isNotEmpty((CharSequence)dto.getCustomerCode())).map(ImportOtherOutVO::getCustomerCode).collect(Collectors.toSet());
        Map<Object, Object> customerMap = new HashMap();
        if (CollectionUtils.isNotEmpty(customerCodes)) {
            PCPCustomerSearchReqDto searchReqDto = new PCPCustomerSearchReqDto();
            searchReqDto.setCodeInList(new ArrayList(customerCodes));
            logger.info("\u67e5\u8be2\u5ba2\u6237\u7f16\u7801\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)searchReqDto));
            List customerList = (List)RestResponseHelper.extractData((RestResponse)this.customerQueryApi.queryCustomerListByCodes(new ArrayList(customerCodes)));
            if (CollectionUtils.isNotEmpty((Collection)customerList)) {
                customerMap = customerList.stream().collect(Collectors.toMap(CustomerRespDto::getCode, Function.identity(), (k1, k2) -> k1));
            }
        }
        Map<Object, Object> customerStatusMap = new HashMap();
        if (CollectionUtils.isNotEmpty(customerCodes) && CollectionUtils.isNotEmpty((Collection)(customerStatueList = (List)RestResponseHelper.extractData((RestResponse)this.customerStatusQueryApi.queryByList(null))))) {
            customerStatusMap = customerStatueList.stream().collect(Collectors.toMap(BaseRespDto::getId, Function.identity(), (k1, k2) -> k1));
        }
        HashMap finalCustomerMap = customerMap;
        HashMap finalCustomerStatusMap = customerStatusMap;
        Map<String, List<ImportOtherOutVO>> grounp = list.stream().filter(f -> {
            if (!this.vaildBizDate((ImportOtherOutVO)((Object)f))) {
                f.setMsg("\u5176\u4ed6\u51fa\u5e93\u65f6\u95f4\u683c\u5f0f\u6709\u8bef");
                msgList.add(f);
                return false;
            }
            if (!this.vaildCustomerInfo((ImportOtherOutVO)((Object)f), finalCustomerMap, finalCustomerStatusMap)) {
                msgList.add(f);
                return false;
            }
            return Optional.ofNullable(f.getOutWarehouseCode()).map(p -> true).orElseGet(() -> {
                if (Objects.nonNull(f.getPlatformOrderCode())) {
                    return true;
                }
                f.setMsg("\u4ed3\u5e93\u7f16\u7801\u4e3a\u7a7a");
                msgList.add(f);
                return false;
            });
        }).collect(Collectors.groupingBy(importOtherInVO -> StringUtils.isNotBlank((CharSequence)importOtherInVO.getPlatformOrderCode()) ? importOtherInVO.getPlatformOrderCode() : "DEFUALT_CODE_2022111652_" + importOtherInVO.getOutWarehouseCode()));
        grounp.forEach((k, v) -> {
            if (this.isVaild(inventoryOtherMetaVo, msgList, (String)k, (List<ImportOtherOutVO>)v)) {
                msgList.addAll(v);
                return;
            }
            saveList.add(this.buildOtherOrder(inventoryOtherMetaVo, (String)k, (List<ImportOtherOutVO>)v));
        });
        try {
            this.buildMergeOrder(saveList);
        }
        catch (Exception e) {
            logger.error("\u5176\u4ed6\u51fa\u5e93\u5355\u5bfc\u5165\u751f\u6210\u5408\u5355\u53f7\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
            logger.error(e.getMessage(), (Throwable)e);
        }
        return new TwoTuple((Object)saveList, (Object)msgList);
    }

    private void buildMergeOrder(List<CsOtherStorageOrderComboReqDto> list) {
        logger.info("\u5176\u4ed6\u51fa\u5e93\u5355\u5bfc\u5165\u751f\u6210\u5408\u5355\u53f7\uff1a{}", (Object)JSON.toJSONString(list));
        list.forEach(dto -> dto.getCsOtherStorageOrderReqDto().setMergeOrderNo(this.codeGenerateUtil.generateNo("HD", 4)));
    }

    private boolean vaildBizDate(ImportOtherOutVO importOtherOutVO) {
        logger.info("\u5176\u4ed6\u51fa\u5e93\u5355\u5bfc\u5165\u8d4b\u503c\u4e1a\u52a1\u65f6\u95f4\uff1a{}", (Object)JSON.toJSONString((Object)((Object)importOtherOutVO)));
        try {
            if (StringUtils.isNotBlank((CharSequence)importOtherOutVO.getBizDateStr())) {
                importOtherOutVO.setBizDate(DateUtil.parseDate((String)importOtherOutVO.getBizDateStr(), (String)DatePattern.DATE_PATTERN.getPattern()));
                return true;
            }
            return true;
        }
        catch (Exception e) {
            logger.error("\u65f6\u95f4\u8f6c\u6362\u5f02\u5e38");
            return false;
        }
    }

    private boolean vaildCustomerInfo(ImportOtherOutVO importOtherOutVO, Map<String, CustomerRespDto> customerMap, Map<Long, CustomerStatusRespDto> customerStatusMap) {
        logger.info("\u5176\u4ed6\u51fa\u5e93\u5355\u5bfc\u5165\u6821\u9a8c\u5ba2\u6237\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)((Object)importOtherOutVO)));
        try {
            if (StringUtils.isEmpty((CharSequence)importOtherOutVO.getCustomerCode())) {
                importOtherOutVO.setMsg("\u5ba2\u6237\u7f16\u7801\u4e3a\u7a7a;");
                return false;
            }
            if (customerMap.isEmpty() || !customerMap.containsKey(importOtherOutVO.getCustomerCode())) {
                importOtherOutVO.setMsg("\u5ba2\u6237\u7f16\u7801\u9519\u8bef;");
                return false;
            }
            CustomerRespDto pcpCustomerRespDto = customerMap.get(importOtherOutVO.getCustomerCode());
            if (customerStatusMap.isEmpty() || !customerStatusMap.containsKey(pcpCustomerRespDto.getStatusId())) {
                importOtherOutVO.setMsg("\u5ba2\u6237\u72b6\u6001\u9519\u8bef;");
                return false;
            }
            CustomerStatusRespDto customerStatusRespDto = customerStatusMap.get(pcpCustomerRespDto.getStatusId());
            if (Objects.equals(0, customerStatusRespDto.getAccountStatus())) {
                importOtherOutVO.setMsg("\u5ba2\u6237\u8d26\u53f7\u5df2\u7981\u7528;");
                return false;
            }
            return true;
        }
        catch (Exception e) {
            logger.error("\u6821\u9a8c\u5ba2\u6237\u4fe1\u606f\u5f02\u5e38");
            return false;
        }
    }

    private boolean isVaild(InventoryOtherMetaVo inventoryOtherMetaVo, List<ImportOtherOutVO> msgList, String k, List<ImportOtherOutVO> v) {
        try {
            return !this.vaildCheck(k, v, inventoryOtherMetaVo);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            return true;
        }
    }

    private CsOtherStorageOrderComboReqDto buildOtherOrder(InventoryOtherMetaVo inventoryOtherMetaVo, String k, List<ImportOtherOutVO> v) {
        ImportOtherOutVO importOtherOutVO = v.get(0);
        String customerName = inventoryOtherMetaVo.getCustomerNameMap().get(importOtherOutVO.getCustomerCode());
        CsOtherStorageOrderComboReqDto orderComboReqDto = new CsOtherStorageOrderComboReqDto();
        CsOtherStorageOrderReqDto orderReqDto = new CsOtherStorageOrderReqDto();
        BeanUtil.copyProperties((Object)((Object)importOtherOutVO), (Object)orderReqDto, (String[])new String[]{"businessType"});
        CsBusinessTypeRespDto typeRespDto = inventoryOtherMetaVo.getTypeMap().get(importOtherOutVO.getBusinessType());
        orderReqDto.setBusinessType(typeRespDto.getId());
        orderReqDto.setBusinessTypeName(typeRespDto.getBusinessTypeName());
        orderReqDto.setType(CsPcpBusinessTypeEnum.OTHER_OUT.getCode());
        orderReqDto.setCostCenterCode(importOtherOutVO.getCostCode());
        orderReqDto.setOrderSrc(OrderSrcEnum.PCP.getDesc());
        orderReqDto.setCustomerName(customerName);
        orderReqDto.setProvinceName(importOtherOutVO.getProvinceName());
        orderReqDto.setProvinceCode(this.getResultCode(orderReqDto.getProvinceName()));
        orderReqDto.setCityName(importOtherOutVO.getCityName());
        orderReqDto.setCityCode(this.getResultCode(orderReqDto.getCityName()));
        orderReqDto.setAreaName(importOtherOutVO.getAreaName());
        orderReqDto.setAreaCode(this.getResultCode(orderReqDto.getAreaName()));
        orderReqDto.setExternalOrderNo(importOtherOutVO.getPlatformOrderCode());
        orderReqDto.setBusinessTypeName(importOtherOutVO.getBusinessType());
        orderReqDto.setSourceSystem(OrderSrcEnum.PCP.getCode());
        orderReqDto.setIsSendEas(Integer.valueOf("\u662f".equals(importOtherOutVO.getEasPush()) ? 1 : 0));
        if (k.startsWith(DEFUALT_PLATFORM_CODE)) {
            orderReqDto.setPreOrderNo(this.inventoryOtherHelper.codeGenerate("OTO"));
        } else {
            orderReqDto.setPreOrderNo(k);
        }
        LogicWarehouseRespDto warehouseRespDto = inventoryOtherMetaVo.getWarehouseCodeMap().get(importOtherOutVO.getOutWarehouseCode());
        orderReqDto.setWarehouseCode(importOtherOutVO.getOutWarehouseCode());
        orderReqDto.setWarehouseName(warehouseRespDto.getWarehouseName());
        orderReqDto.setWarehouseId(warehouseRespDto.getId());
        orderReqDto.setBizDate(importOtherOutVO.getBizDate());
        orderComboReqDto.setCsOtherStorageOrderReqDto(orderReqDto);
        orderComboReqDto.setDetailList(v.stream().map(item -> {
            CsOtherStorageOrderDetailReqDto detail = new CsOtherStorageOrderDetailReqDto();
            detail.setLongCode(item.getLongCode());
            detail.setQuantity(item.getQuantity());
            PcpItemRespDto pcpItemRespDto = inventoryOtherMetaVo.getItemMap().get(item.getLongCode());
            detail.setCargoName(pcpItemRespDto.getName());
            detail.setVolume(pcpItemRespDto.getVolume());
            detail.setSpecification(pcpItemRespDto.getSpecification());
            detail.setCargoName(pcpItemRespDto.getName());
            detail.setCreatePerson(pcpItemRespDto.getCreatePerson());
            detail.setCreateTime(pcpItemRespDto.getCreateTime());
            return detail;
        }).collect(Collectors.toList()));
        return orderComboReqDto;
    }

    private String getResultCode(String name) {
        PcpRegionReqDto pcpRegionReqDto = new PcpRegionReqDto();
        pcpRegionReqDto.setName(name);
        pcpRegionReqDto.setPageNum(Integer.valueOf(1));
        pcpRegionReqDto.setPageSize(Integer.valueOf(1));
        List list = ((PageInfo)this.pcpRegionQueryApi.queryByPage(pcpRegionReqDto).getData()).getList();
        String code = null;
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            code = ((PcpRegionRespDto)list.get(0)).getCode();
        }
        return code;
    }

    private boolean vaildCheck(String k, List<ImportOtherOutVO> list, InventoryOtherMetaVo inventoryOtherMetaVo) throws IllegalAccessException {
        ImportOtherOutVO importOtherOutVO = list.get(0);
        if (inventoryOtherMetaVo.getTransferMap().containsKey(importOtherOutVO.getPlatformOrderCode())) {
            this.setErrMsg(list, "\u6709\u975e\u53d6\u6d88\u72b6\u6001\u7684\u524d\u7f6e\u5355\u636e");
            return false;
        }
        if (!this.checkNullField(list, importOtherOutVO)) {
            return false;
        }
        if (!this.compareListData(list, importOtherOutVO, Lists.newArrayList((Object[])new String[]{"quantity", "longCode"}))) {
            return false;
        }
        if (Objects.isNull(inventoryOtherMetaVo.getItemMap().get(importOtherOutVO.getLongCode()))) {
            this.setErrMsg(list, "\u7269\u6599\u7f16\u7801\u4e0d\u5b58\u5728");
            return false;
        }
        if (Objects.isNull(inventoryOtherMetaVo.getCustomerNameMap().get(importOtherOutVO.getCustomerCode()))) {
            this.setErrMsg(list, "\u5ba2\u6237\u7f16\u7801\u4e0d\u5b58\u5728");
            return false;
        }
        if (Objects.isNull(inventoryOtherMetaVo.getWarehouseCodeMap().get(importOtherOutVO.getOutWarehouseCode()))) {
            this.setErrMsg(list, "\u4ed3\u5e93\u7f16\u7801\u4e0d\u5b58\u5728");
            return false;
        }
        if (Objects.isNull(inventoryOtherMetaVo.getTypeMap().get(importOtherOutVO.getBusinessType()))) {
            this.setErrMsg(list, "\u4e1a\u52a1\u7c7b\u578b\u4e0d\u5b58\u5728");
            return false;
        }
        if (StringUtils.isBlank((CharSequence)importOtherOutVO.getCostCode())) {
            return true;
        }
        if (Objects.isNull(inventoryOtherMetaVo.getCostCenterMap().get(importOtherOutVO.getCostCode()))) {
            this.setErrMsg(list, "\u6210\u672c\u4e2d\u5fc3\u4e0d\u5b58\u5728");
            return false;
        }
        if (Objects.equals(inventoryOtherMetaVo.getCostCenterMap().get(importOtherOutVO.getCostCode()).getEasCode(), inventoryOtherMetaVo.getWarehouseCodeMap().get(importOtherOutVO.getOutWarehouseCode()).getCargoEscheatageId())) {
            this.setErrMsg(list, "\u8bf7\u9009\u62e9\u5bf9\u5e94\u7684\u5e93\u5b58\u7ec4\u7ec7\u4e0b\u7684\u6210\u672c\u4e2d\u5fc3");
            return false;
        }
        return true;
    }

    private void setErrMsg(List<ImportOtherOutVO> list, String msg) {
        list.forEach(data -> data.setMsg(msg));
    }

    private boolean checkNullField(List<ImportOtherOutVO> list, ImportOtherOutVO importOtherOutVO) throws IllegalAccessException {
        for (ImportOtherOutVO otherOutVO : list) {
            DataCheckHelper.CheckResultVo checkResultVo = this.dataCheckHelper.checkNullField(otherOutVO);
            if (checkResultVo.isSuccess()) continue;
            list.forEach(d -> d.setMsg(checkResultVo.getErrorMsg()));
            return false;
        }
        return true;
    }

    public boolean compareListData(List<ImportOtherOutVO> list, ImportOtherOutVO importOtherOutVO, List<String> writeList) throws IllegalAccessException {
        DataCheckHelper.CheckResultVo checkResultVo = this.dataCheckHelper.compareListData(ImportOtherOutVO.class, list, writeList);
        if (checkResultVo.isSuccess()) {
            return true;
        }
        list.forEach(d -> d.setMsg(checkResultVo.getErrorMsg()));
        return false;
    }

    private InventoryOtherMetaVo getInventoryOtherMetaVo(List<ImportOtherOutVO> list) {
        HashSet whCodes = Sets.newHashSet();
        HashSet itemCodes = Sets.newHashSet();
        HashSet customerCodes = Sets.newHashSet();
        HashSet costCenterCodes = Sets.newHashSet();
        HashSet thirdOrderCodes = Sets.newHashSet();
        list.forEach(i -> {
            whCodes.add(i.getOutWarehouseCode());
            itemCodes.add(i.getLongCode());
            customerCodes.add(i.getCustomerCode());
            costCenterCodes.add(i.getCostCode());
            thirdOrderCodes.add(i.getPlatformOrderCode());
        });
        return this.inventoryOtherHelper.getInventoryOtherMetaVo(whCodes, itemCodes, customerCodes, costCenterCodes, "other_out", thirdOrderCodes);
    }
}

