/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cis.pms.biz.service.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.cis.pms.biz.enums.PlatformOrderTypeEnum;
import com.dtyunxi.cis.pms.biz.enums.SaleOrderTypeEnum;
import com.dtyunxi.cis.pms.biz.model.BusinessOrderInfoVO;
import com.dtyunxi.cis.pms.biz.model.DeliveryInfoVo;
import com.dtyunxi.cis.pms.biz.model.DtoExchangeUtils;
import com.dtyunxi.cis.pms.biz.model.GetReceiveResultOrderListPageParams;
import com.dtyunxi.cis.pms.biz.model.ReceiveResultOrderVO;
import com.dtyunxi.cis.pms.biz.model.RelateBillInfoVO;
import com.dtyunxi.cis.pms.biz.service.InventoryCenterBillReceiveResultOrderService;
import com.dtyunxi.cis.search.api.dto.request.EsReceiveResultOrderReqParams;
import com.dtyunxi.cis.search.api.query.delivery.EsReceiveResultOrderQueryApi;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.cube.utils.enums.DatePattern;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.request.DeliveryResultOrderReqDto;
import com.dtyunxi.tcbj.api.query.ICsLogisticsInfoQueryApi;
import com.dtyunxi.tcbj.api.query.IDeliveryNoticeOrderQueryApi;
import com.dtyunxi.tcbj.api.query.IDeliveryResultOrderQueryApi;
import com.dtyunxi.util.DateUtil;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.order.ICsReceiveResultOrderApi;
import com.dtyunxi.yundt.cube.center.inventory.constant.ConsignmentConstant;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.BizSaleOrderRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.BizSaleRefundRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.SaleOrderAddrRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.SaleRefundAddrRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.query.ISaleOrderQueryApi;
import com.dtyunxi.yundt.cube.center.trade.api.query.ISaleRefundQueryApi;
import com.dtyunxi.yundt.cube.center.transform.api.query.IPlatformOrderQueryApi;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.center.inventory.dto.domain.ContactDto;
import com.yunxi.dg.base.center.inventory.dto.domain.CsReceiveResultOrderRespDto;
import io.swagger.annotations.ApiParam;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.validation.Valid;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

@Service
public class InventoryCenterBillReceiveResultOrderServiceServiceImpl
implements InventoryCenterBillReceiveResultOrderService {
    private static final Logger LOGGER = LoggerFactory.getLogger(InventoryCenterBillReceiveResultOrderServiceServiceImpl.class);
    @Resource
    private EsReceiveResultOrderQueryApi esReceiveResultOrderQueryApi;
    @Resource
    private ICsReceiveResultOrderApi csReceiveResultOrderQueryApi;
    @Resource
    private ISaleOrderQueryApi saleOrderQueryApi;
    @Resource
    private ISaleRefundQueryApi saleRefundQueryApi;
    @Resource
    private IPlatformOrderQueryApi platformOrderQueryApi;
    @Resource
    private ICsLogisticsInfoQueryApi iCsLogisticsInfoQueryApi;
    @Value(value="${esQuery:true}")
    private Boolean esQuery;
    @Resource
    private IDeliveryNoticeOrderQueryApi deliveryNoticeOrderQueryApi;
    @Resource
    private IDeliveryResultOrderQueryApi deliveryResultOrderQueryApi;

    @Override
    public RestResponse<ReceiveResultOrderVO> getReceiveResultOrderDetail(@ApiParam(value="\u6536\u8d27\u7ed3\u679c\u5355\u53f7") @Valid @RequestParam(value="receiveResultNo", required=false) String receiveResultNo) {
        List relOrderInfoList;
        List respDtos;
        if (StringUtils.isBlank((CharSequence)receiveResultNo)) {
            throw new BizException("\u5165\u5e93\u7ed3\u679c\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        CsReceiveResultOrderRespDto respDto = (CsReceiveResultOrderRespDto)RestResponseHelper.extractData((RestResponse)this.csReceiveResultOrderQueryApi.queryVersionSecondByDocumentNo(receiveResultNo));
        ReceiveResultOrderVO vo = new ReceiveResultOrderVO();
        if (respDto == null) {
            return new RestResponse((Object)vo);
        }
        BeanUtils.copyProperties((Object)respDto, (Object)vo);
        vo.setDocumentNo(respDto.getDocumentNo());
        vo.setBusinessType(respDto.getBusinessType());
        if (respDto.getCreateTime() != null) {
            vo.setCreateTime(DateUtil.format((Date)respDto.getCreateTime(), (String)DatePattern.DATETIME_PATTERN.getPattern()));
        }
        vo.setDocumentStatus(respDto.getOrderStatus());
        vo.setDeliveryPhysicalWarehouseName(respDto.getDeliveryPhysicsWarehouseName());
        vo.setDeliveryPhysicalWarehouseCode(respDto.getDeliveryPhysicsWarehouseCode());
        vo.setDeliveryLogicalWarehouseCode(respDto.getDeliveryWarehouseCode());
        vo.setDeliveryLogicalWarehouseName(respDto.getDeliveryWarehouseName());
        vo.setReceiveLogicalWarehouseCode(respDto.getWarehouseCode());
        vo.setReceiveLogicalWarehouseName(respDto.getWarehouseName());
        vo.setReceivePhysicalWarehouseCode(respDto.getReceivePhysicsWarehouseCode());
        vo.setReceivePhysicalWarehouseName(respDto.getReceivePhysicsWarehouseName());
        vo.setSummary(respDto.getTotalQuantity() == null ? BigDecimal.ZERO : respDto.getTotalQuantity());
        vo.setTotalSku(respDto.getSkuNum() == null ? BigDecimal.ZERO : respDto.getSkuNum());
        vo.setBizDateStr(ObjectUtil.isNotEmpty((Object)respDto.getBizDate()) ? DateUtil.format((Date)respDto.getBizDate(), (String)DatePattern.DATETIME_PATTERN.getPattern()) : null);
        ContactDto contactDto = respDto.getContactDto();
        if (Objects.nonNull(contactDto)) {
            BusinessOrderInfoVO businessOrderInfo = new BusinessOrderInfoVO();
            BeanUtils.copyProperties((Object)contactDto, (Object)businessOrderInfo);
            vo.setBusinessOrderInfo(businessOrderInfo);
        }
        if (CollectionUtils.isNotEmpty((Collection)(respDtos = (List)RestResponseHelper.extractData((RestResponse)this.iCsLogisticsInfoQueryApi.queryTakeDeliveryResultInformation(receiveResultNo))))) {
            List<DeliveryInfoVo> list = respDtos.stream().map(o -> {
                DeliveryInfoVo documentVO = new DeliveryInfoVo();
                BeanUtils.copyProperties((Object)o, (Object)documentVO);
                if (o.getConsignmentType() != null) {
                    documentVO.setConsignmentTypeName((String)ConsignmentConstant.CONSIGNMENT_TYPE.valueMap.get(o.getConsignmentType()));
                }
                return documentVO;
            }).collect(Collectors.toList());
            vo.setDeliveryInfoList(list);
        }
        if (CollectionUtils.isNotEmpty((Collection)(relOrderInfoList = respDto.getRelOrderInfoList()))) {
            List<RelateBillInfoVO> list = relOrderInfoList.stream().filter(o -> StringUtils.isNotBlank((CharSequence)o.getOrderNo())).map(o -> {
                RelateBillInfoVO relateBillInfoVO = new RelateBillInfoVO();
                if (PlatformOrderTypeEnum.PLATFORM_ORDER_NO.getCode().equals(o.getOrderType())) {
                    BeanUtils.copyProperties((Object)o, (Object)relateBillInfoVO);
                    relateBillInfoVO.setIsExternalOrder(true);
                } else if (SaleOrderTypeEnum.getStatusByCode(o.getOrderType()) != null) {
                    if (SaleOrderTypeEnum.ORDER_SALES_REFUND.getCode().equals(o.getOrderType())) {
                        BizSaleRefundRespDto bizSaleRefundRespDto = (BizSaleRefundRespDto)RestResponseHelper.extractData((RestResponse)this.saleRefundQueryApi.queryByRefundNo(o.getOrderNo()));
                        if (bizSaleRefundRespDto != null) {
                            BeanUtils.copyProperties((Object)o, (Object)relateBillInfoVO);
                            relateBillInfoVO.setOrderStatus(bizSaleRefundRespDto.getRefundStatus());
                            SaleRefundAddrRespDto saleRefundAddrRespDto = bizSaleRefundRespDto.getSaleRefundAddrRespDto();
                            if (saleRefundAddrRespDto != null) {
                                BusinessOrderInfoVO businessOrderInfo = new BusinessOrderInfoVO();
                                businessOrderInfo.setReciveName(saleRefundAddrRespDto.getReceiveName());
                                businessOrderInfo.setRecivePhone(saleRefundAddrRespDto.getReceivePhone());
                                businessOrderInfo.setAddress(saleRefundAddrRespDto.getProvince() + saleRefundAddrRespDto.getCity() + saleRefundAddrRespDto.getCounty() + saleRefundAddrRespDto.getReceiveAddress());
                                vo.setBusinessOrderInfo(businessOrderInfo);
                            }
                        }
                    } else {
                        BizSaleOrderRespDto saleOrderRespDto = (BizSaleOrderRespDto)RestResponseHelper.extractData((RestResponse)this.saleOrderQueryApi.queryByOrderNo(o.getOrderNo()));
                        if (saleOrderRespDto != null) {
                            BeanUtils.copyProperties((Object)o, (Object)relateBillInfoVO);
                            relateBillInfoVO.setOrderStatus(saleOrderRespDto.getOrderStatus());
                            SaleOrderAddrRespDto orderAddrRespDto = saleOrderRespDto.getOrderAddrRespDto();
                            if (orderAddrRespDto != null) {
                                BusinessOrderInfoVO businessOrderInfo = new BusinessOrderInfoVO();
                                businessOrderInfo.setReciveName(orderAddrRespDto.getReceiveName());
                                businessOrderInfo.setRecivePhone(orderAddrRespDto.getReceivePhone());
                                businessOrderInfo.setAddress(orderAddrRespDto.getProvince() + orderAddrRespDto.getCity() + orderAddrRespDto.getCounty() + orderAddrRespDto.getReceiveAddress());
                                businessOrderInfo.setRemark(saleOrderRespDto.getRemark());
                                vo.setBusinessOrderInfo(businessOrderInfo);
                            }
                        }
                    }
                } else {
                    BeanUtils.copyProperties((Object)o, (Object)relateBillInfoVO);
                    relateBillInfoVO.setLogisticsCompany(o.getShippingCompany());
                    relateBillInfoVO.setLogisticsNo(o.getShippingCode());
                    relateBillInfoVO.setDeliveryWay(o.getShippingType());
                    relateBillInfoVO.setWmsNo(o.getWmsOrderNo());
                    if (o.getEstimatedTime() != null) {
                        relateBillInfoVO.setExpectedArriveTime(DateUtil.format((Date)o.getEstimatedTime(), (String)DatePattern.DATETIME_PATTERN.getPattern()));
                    }
                }
                return relateBillInfoVO;
            }).collect(Collectors.toList());
            vo.setRelateBillInfoList(list);
        }
        return new RestResponse((Object)vo);
    }

    @Override
    public RestResponse<PageInfo<ReceiveResultOrderVO>> getReceiveResultOrderListPage(@ApiParam(value="") @Valid @RequestBody(required=false) GetReceiveResultOrderListPageParams getReceiveResultOrderListPageParams) {
        if (!this.esQuery.booleanValue()) {
            PageInfo respDtoPageInfo = new PageInfo();
            PageInfo pageInfo = new PageInfo();
            DeliveryResultOrderReqDto reqDto = new DeliveryResultOrderReqDto();
            BeanUtils.copyProperties((Object)getReceiveResultOrderListPageParams, (Object)reqDto);
            reqDto.setBusinessType(getReceiveResultOrderListPageParams.getBusinessType());
            reqDto.setOrderNo(getReceiveResultOrderListPageParams.getDocumentNo());
            reqDto.setOrderStatus(getReceiveResultOrderListPageParams.getDocumentStatus());
            reqDto.setWarehouseName(getReceiveResultOrderListPageParams.getDeliveryLogicalWarehouseName());
            reqDto.setReceiveWarehouseName(getReceiveResultOrderListPageParams.getReceiveLogicalWarehouseName());
            if (StringUtils.isNotBlank((CharSequence)getReceiveResultOrderListPageParams.getStartTime()) && StringUtils.isNotBlank((CharSequence)getReceiveResultOrderListPageParams.getEndTime())) {
                reqDto.setCreateBeginTime(DateUtil.parse((String)(getReceiveResultOrderListPageParams.getStartTime() + " 00:00:00"), (String)DatePattern.DATETIME_PATTERN.getPattern()));
                reqDto.setCreateEndTime(DateUtil.parse((String)(getReceiveResultOrderListPageParams.getEndTime() + " 23:59:59"), (String)DatePattern.DATETIME_PATTERN.getPattern()));
            }
            reqDto.setOrderType("receive");
            respDtoPageInfo = (PageInfo)this.deliveryResultOrderQueryApi.queryByPage(reqDto).getData();
            LOGGER.info("\u7ed3\u679c\uff1a {}", (Object)JSON.toJSONString((Object)respDtoPageInfo));
            if (CollectionUtils.isEmpty((Collection)respDtoPageInfo.getList())) {
                return new RestResponse();
            }
            CubeBeanUtils.copyProperties((Object)pageInfo, (Object)respDtoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
            ArrayList deliveryNoticeOrderVOS = new ArrayList(respDtoPageInfo.getList().size());
            respDtoPageInfo.getList().forEach(o -> {
                ReceiveResultOrderVO deliveryNoticeOrderVO = DtoExchangeUtils.createDtoBySource(o, ReceiveResultOrderVO.class);
                if (Objects.nonNull(o.getCreateTime())) {
                    deliveryNoticeOrderVO.setCreateTime(DateUtil.format((Date)o.getCreateTime(), (String)DatePattern.DATETIME_PATTERN.getPattern()));
                }
                deliveryNoticeOrderVO.setDocumentStatus(o.getOrderStatus());
                deliveryNoticeOrderVO.setBusinessOrderNo(o.getRelevanceNo());
                deliveryNoticeOrderVO.setExternalOrderNo(o.getExternalOrderNo());
                deliveryNoticeOrderVO.setDeliveryLogicalWarehouseCode(o.getDeliveryLogicWarehouseCode());
                deliveryNoticeOrderVO.setDeliveryLogicalWarehouseName(o.getDeliveryLogicWarehouseName());
                deliveryNoticeOrderVO.setReceiveLogicalWarehouseCode(o.getReceiveLogicWarehouseCode());
                deliveryNoticeOrderVO.setReceiveLogicalWarehouseName(o.getReceiveLogicWarehouseName());
                if (ObjectUtil.isNotEmpty((Object)o.getTotalSku())) {
                    deliveryNoticeOrderVO.setTotalSku(new BigDecimal(String.valueOf(o.getTotalSku())));
                }
                deliveryNoticeOrderVOS.add(deliveryNoticeOrderVO);
            });
            pageInfo.setList(deliveryNoticeOrderVOS);
            return new RestResponse((Object)pageInfo);
        }
        EsReceiveResultOrderReqParams pageQueryDto = new EsReceiveResultOrderReqParams();
        BeanUtils.copyProperties((Object)getReceiveResultOrderListPageParams, (Object)pageQueryDto);
        pageQueryDto.setOrderNo(getReceiveResultOrderListPageParams.getDocumentNo());
        pageQueryDto.setOrderStatus(getReceiveResultOrderListPageParams.getDocumentStatus());
        pageQueryDto.setCreateBeginTime(getReceiveResultOrderListPageParams.getStartTime());
        pageQueryDto.setCreateEndTime(getReceiveResultOrderListPageParams.getEndTime());
        PageInfo esReceiveResultOrderRespVoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.esReceiveResultOrderQueryApi.queryReceiveResultOrderPage(pageQueryDto));
        if (CollectionUtils.isEmpty((Collection)esReceiveResultOrderRespVoPageInfo.getList())) {
            return new RestResponse();
        }
        PageInfo pageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)pageInfo, (Object)esReceiveResultOrderRespVoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        List list = esReceiveResultOrderRespVoPageInfo.getList().stream().map(p -> {
            ReceiveResultOrderVO vo = new ReceiveResultOrderVO();
            BeanUtils.copyProperties((Object)p, (Object)vo);
            vo.setCreateTime(DateUtil.format((Date)p.getCreateTime(), (String)DatePattern.DATETIME_PATTERN.getPattern()));
            vo.setNoticeNo(p.getDeliveryNoticeNo());
            vo.setBusinessOrderNo(p.getRelevanceNo());
            vo.setDocumentStatus(p.getOrderStatus());
            vo.setDeliveryLogicalWarehouseCode(p.getDeliveryLogicWarehouseCode());
            vo.setDeliveryLogicalWarehouseName(p.getDeliveryLogicWarehouseName());
            vo.setReceiveLogicalWarehouseCode(p.getReceiveLogicWarehouseCode());
            vo.setReceiveLogicalWarehouseName(p.getReceiveLogicWarehouseName());
            vo.setBizDateStr(ObjectUtil.isNotEmpty((Object)p.getBizDate()) ? DateUtil.format((Date)p.getBizDate(), (String)DatePattern.DATETIME_PATTERN.getPattern()) : null);
            vo.setTotalBoxesNum(p.getTotalCartons() == null ? new BigDecimal(0) : p.getTotalCartons());
            vo.setMixBoxesNum(p.getMergeQuantity() == null ? new BigDecimal(0) : p.getTotalCartons());
            return vo;
        }).collect(Collectors.toList());
        pageInfo.setList(list);
        return new RestResponse((Object)pageInfo);
    }
}

