/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cis.pms.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cis.pms.biz.model.LinkageSettingOilPriceListEditParams;
import com.dtyunxi.cis.pms.biz.model.LinkageSettingOilPriceListPageParams;
import com.dtyunxi.cis.pms.biz.model.LinkageSettingOilPriceListReportVO;
import com.dtyunxi.cis.pms.biz.service.ReportCenterLogisticsFreightLinkageSettingOilPriceListService;
import com.dtyunxi.cis.pms.biz.utils.DateTimeUtils;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.finance.api.ILogisticApi;
import com.dtyunxi.finance.api.dto.request.logistic.OilLinkQueryReqDto;
import com.dtyunxi.finance.api.dto.request.logistic.OilLinkReqDto;
import com.dtyunxi.finance.api.dto.response.logistic.OilLinkQueryRespDto;
import com.dtyunxi.finance.api.dto.response.logistic.OilLinkRespDto;
import com.dtyunxi.finance.api.query.ILogisticQueryApi;
import com.dtyunxi.rest.RestResponse;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import io.swagger.annotations.ApiParam;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import javax.annotation.Resource;
import javax.validation.Valid;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.RequestBody;

@Service
public class ReportCenterLogisticsFreightLinkageSettingOilPriceListServiceServiceImpl
implements ReportCenterLogisticsFreightLinkageSettingOilPriceListService {
    private static final Logger log = LoggerFactory.getLogger(ReportCenterLogisticsFreightLinkageSettingOilPriceListServiceServiceImpl.class);
    @Resource
    private ILogisticApi logisticApi;
    @Resource
    private ILogisticQueryApi iLogisticQueryApi;

    @Override
    public RestResponse<LinkageSettingOilPriceListReportVO> getLinkageSettingOilPriceEditPage(@ApiParam(value="") @Valid @RequestBody(required=false) LinkageSettingOilPriceListEditParams linkageSettingOilPriceListEditParams) {
        AssertUtils.notBlank((String)linkageSettingOilPriceListEditParams.getAdjustmentDate(), (String)"\u6cb9\u4ef7\u8c03\u6574\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.notBlank((String)linkageSettingOilPriceListEditParams.getUnitPriceOf0Diesel(), (String)"0\u53f7\u67f4\u6cb9\u5355\u4ef7\u4e0d\u80fd\u4e3a\u7a7a");
        if (linkageSettingOilPriceListEditParams.getId() == null) {
            AssertUtils.notBlank((String)linkageSettingOilPriceListEditParams.getBookkeeping(), (String)"\u8bb0\u8d26\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a");
            AssertUtils.notBlank((String)linkageSettingOilPriceListEditParams.getWarehouseName(), (String)"\u4ed3\u5e93\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
            AssertUtils.notBlank((String)linkageSettingOilPriceListEditParams.getWarehouseCode(), (String)"\u4ed3\u5e93\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        OilLinkReqDto oilLinkReqDto = new OilLinkReqDto();
        oilLinkReqDto.setId(linkageSettingOilPriceListEditParams.getId());
        if (StringUtils.isNotBlank((CharSequence)linkageSettingOilPriceListEditParams.getWarehouseCode())) {
            oilLinkReqDto.setWarehouseId(linkageSettingOilPriceListEditParams.getWarehouseCode());
            oilLinkReqDto.setWarehouseName(linkageSettingOilPriceListEditParams.getWarehouseName());
        }
        if (StringUtils.isNotBlank((CharSequence)linkageSettingOilPriceListEditParams.getBookkeeping())) {
            oilLinkReqDto.setLastTime(DateTimeUtils.parseDateMonth(linkageSettingOilPriceListEditParams.getBookkeeping()));
        }
        if (StringUtils.isNotBlank((CharSequence)linkageSettingOilPriceListEditParams.getAdjustmentDate())) {
            oilLinkReqDto.setAdjustDate(DateTimeUtils.parseDate(linkageSettingOilPriceListEditParams.getAdjustmentDate()));
        }
        if (StringUtils.isNotBlank((CharSequence)linkageSettingOilPriceListEditParams.getUnitPriceOf0Diesel())) {
            oilLinkReqDto.setAmount(new BigDecimal(linkageSettingOilPriceListEditParams.getUnitPriceOf0Diesel()));
        }
        log.info("logisticApi.saveOilLink(oilLinkReqDto):{}", (Object)JSON.toJSONString((Object)oilLinkReqDto));
        RestResponse response = this.logisticApi.saveOilLink(oilLinkReqDto);
        if ("0".equals(response.getResultCode())) {
            OilLinkRespDto respDto = (OilLinkRespDto)response.getData();
            LinkageSettingOilPriceListReportVO vo = new LinkageSettingOilPriceListReportVO();
            vo.setId(respDto.getId());
            return new RestResponse((Object)vo);
        }
        throw new BizException("\u65b0\u589e\u5931\u8d25");
    }

    @Override
    public RestResponse<LinkageSettingOilPriceListReportVO> linkageSettingOilPriceDelete(@ApiParam(value="") @Valid @RequestBody(required=false) LinkageSettingOilPriceListEditParams linkageSettingOilPriceListEditParams) {
        AssertUtils.notEmpty(linkageSettingOilPriceListEditParams.getIdList(), (String)"\u9700\u5220\u9664\u7684id\u96c6\u5408\u4e3a\u7a7a");
        linkageSettingOilPriceListEditParams.getIdList().forEach(id -> RestResponseHelper.extractData((RestResponse)this.logisticApi.removeOilLink(id)));
        return new RestResponse();
    }

    @Override
    public RestResponse<PageInfo<LinkageSettingOilPriceListReportVO>> getLinkageSettingOilPricePage(@ApiParam(value="") @Valid @RequestBody(required=false) LinkageSettingOilPriceListPageParams linkageSettingOilPriceListPageParams) {
        OilLinkQueryReqDto reqDto = new OilLinkQueryReqDto();
        if (StringUtils.isNotEmpty((CharSequence)linkageSettingOilPriceListPageParams.getWarehouseCode())) {
            reqDto.setWarehouseId(linkageSettingOilPriceListPageParams.getWarehouseCode());
        }
        if (StringUtils.isNotEmpty((CharSequence)linkageSettingOilPriceListPageParams.getBookkeeping())) {
            reqDto.setLastTime(DateTimeUtils.parseDateMonth(linkageSettingOilPriceListPageParams.getBookkeeping()));
        }
        reqDto.setPageNum(linkageSettingOilPriceListPageParams.getPageNum());
        reqDto.setPageSize(linkageSettingOilPriceListPageParams.getPageSize());
        RestResponse response = this.iLogisticQueryApi.queryOilLinkList(reqDto);
        if ("0".equals(response.getResultCode())) {
            PageInfo dtoPageInfo = (PageInfo)response.getData();
            PageInfo pageInfo = new PageInfo();
            CubeBeanUtils.copyProperties((Object)pageInfo, (Object)dtoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
            if (CollectionUtils.isNotEmpty((Collection)dtoPageInfo.getList())) {
                ArrayList<LinkageSettingOilPriceListReportVO> reportVOS = new ArrayList<LinkageSettingOilPriceListReportVO>();
                for (OilLinkQueryRespDto respDto : dtoPageInfo.getList()) {
                    LinkageSettingOilPriceListReportVO listReportVO = new LinkageSettingOilPriceListReportVO();
                    listReportVO.setId(respDto.getId());
                    listReportVO.setWarehouseName(respDto.getWarehouseName());
                    listReportVO.setWarehouseCode(respDto.getWarehouseId());
                    listReportVO.setBookkeeping(Optional.ofNullable(respDto.getLastTime()).map(DateTimeUtils::getDateMonth).orElse(""));
                    listReportVO.setAdjustmentDate(Optional.ofNullable(respDto.getAdjustDate()).map(DateTimeUtils::getDateTimeStr).orElse(""));
                    listReportVO.setUnitPriceOfZeroDiesel(Optional.ofNullable(respDto.getAmount()).map(BigDecimal::toString).orElse(""));
                    listReportVO.setWebsiteNDRC(respDto.getPostUrl());
                    listReportVO.setCreatePerson(respDto.getCreatePerson());
                    listReportVO.setCreateTime(DateTimeUtils.getDateTimeStr(respDto.getCreateTime()));
                    listReportVO.setUpdatePerson(respDto.getUpdatePerson());
                    listReportVO.setUpdateTime(DateTimeUtils.getDateTimeStr(respDto.getUpdateTime()));
                    reportVOS.add(listReportVO);
                }
                pageInfo.setList(reportVOS);
            }
            return new RestResponse((Object)pageInfo);
        }
        return new RestResponse();
    }
}

