/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cis.pms.biz.service.scheduler.task;

import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.ISaleOrderApportionApi;
import com.dtyunxi.tcbj.api.dto.request.SaleOrderApportionReqDto;
import com.dtyunxi.tcbj.api.dto.response.SaleOrderRespDto;
import com.dtyunxi.tcbj.api.query.ISaleOrderReportQueryApi;
import com.dtyunxi.yundt.cube.center.scheduler.client.event.SingleTupleScheduleEvent;
import com.dtyunxi.yundt.cube.center.scheduler.common.msg.TaskMsg;
import com.dtyunxi.yundt.cube.center.trade.api.ISaleOrderOptApi;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.CspUpdateEasOrderReqDto;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component(value="strCodeAutoSuccess")
@Scope(value="prototype")
public class StringCodeAutoSuccessTask
extends SingleTupleScheduleEvent {
    private static final Logger log = LoggerFactory.getLogger(StringCodeAutoSuccessTask.class);
    @Resource
    private ISaleOrderOptApi saleOrderOptApi;
    @Resource
    private ISaleOrderReportQueryApi saleOrderReportQueryApi;
    @Resource
    private ISaleOrderApportionApi saleOrderApportionApi;

    public void before(TaskMsg taskMsg) {
        log.info("\u7279\u6e20\u8ba2\u5355\u65e0\u9700\u4e32\u7801\u6821\u9a8c\uff0c\u81ea\u52a8\u8bbe\u7f6e\u8bfb\u53d6\u6210\u529f");
    }

    public boolean execute(TaskMsg taskMsg) {
        List saleOrderList = (List)RestResponseHelper.extractData((RestResponse)this.saleOrderReportQueryApi.specialChannelOrderStringCodeData());
        if (CollectionUtils.isEmpty((Collection)saleOrderList)) {
            return true;
        }
        for (SaleOrderRespDto dto : saleOrderList) {
            CspUpdateEasOrderReqDto cspUpdateEasOrderReqDto = new CspUpdateEasOrderReqDto();
            cspUpdateEasOrderReqDto.setPlatformOrderNo(dto.getPlatformOrderNo());
            cspUpdateEasOrderReqDto.setCheckResult(true);
            RestResponseHelper.extractData((RestResponse)this.saleOrderOptApi.updateSaleOrderStringCodeResult(cspUpdateEasOrderReqDto));
            this.refreshFinanceOpenPullDate(dto.getSaleOrderNo());
        }
        return true;
    }

    public void after(TaskMsg taskMsg) {
        log.info("=========\u7ed3\u675f\u7279\u6e20\u8ba2\u5355\u81ea\u52a8\u8bfb\u53d6\u4e32\u7801\u6210\u529f\u4efb\u52a1==========");
    }

    private void refreshFinanceOpenPullDate(String easSaleOrderNo) {
        try {
            log.info("\u7279\u6e20\u8ba2\u5355\u5237\u65b0\u5141\u8bb8\u8d22\u52a1\u62c9\u5355\u65f6\u95f4\uff1a{}", (Object)easSaleOrderNo);
            SaleOrderApportionReqDto reqDto = new SaleOrderApportionReqDto();
            reqDto.setOrderNo(easSaleOrderNo);
            RestResponseHelper.extractData((RestResponse)this.saleOrderApportionApi.refreshOpenPullDate(reqDto));
        }
        catch (Exception e) {
            log.error("\u5237\u65b0\u5141\u8bb8\u8d22\u52a1\u62c9\u5355\u65f6\u95f4\u5f02\u5e38\uff01");
            log.error(e.getMessage(), (Throwable)e);
        }
    }
}

