/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cis.pms.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cis.pms.biz.model.ExportFileOperationCommonReqDto;
import com.dtyunxi.cis.pms.biz.model.ExportInsuranceBillVO;
import com.dtyunxi.cis.pms.biz.model.insurance.InsurancePageParams;
import com.dtyunxi.cis.pms.biz.service.operation.ModeTypeEnum;
import com.dtyunxi.cis.pms.biz.service.operation.impl.HandlerFileOperationCommonServiceImpl;
import com.dtyunxi.cis.pms.biz.utils.EasyPoiExportUtil;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.cube.utils.enums.DatePattern;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.request.ReInsuranceBillReqDto;
import com.dtyunxi.tcbj.api.query.IReInsuranceBillQueryApi;
import com.dtyunxi.util.DateUtil;
import com.dtyunxi.util.ParamConverter;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service(value="abstractFileOperationCommonService_insurance_bill")
public class InsuranceBillServiceImpl
extends HandlerFileOperationCommonServiceImpl {
    private static final Logger logger = LoggerFactory.getLogger(InsuranceBillServiceImpl.class);
    @Resource
    private IReInsuranceBillQueryApi billQueryApi;

    @Override
    public String exportFileOperationCommon(ExportFileOperationCommonReqDto commonReqDto) {
        logger.info("\u4fdd\u8d39\u8d26\u5355\u5bfc\u51fa\uff1a{}", (Object)JSON.toJSONString((Object)commonReqDto.getFilter()));
        InsurancePageParams params = new InsurancePageParams();
        if (StringUtils.isNotBlank((CharSequence)commonReqDto.getFilter())) {
            params = (InsurancePageParams)JSON.parseObject((String)commonReqDto.getFilter(), InsurancePageParams.class);
        }
        ReInsuranceBillReqDto billReqDto = new ReInsuranceBillReqDto();
        CubeBeanUtils.copyProperties((Object)billReqDto, (Object)params, (boolean)false, (String[])new String[0]);
        billReqDto.setExternalOrderNo(params.getEasNo());
        ArrayList list = Lists.newArrayList();
        billReqDto.setPageNum(Integer.valueOf(1));
        billReqDto.setPageSize(Integer.valueOf(5000));
        PageInfo respDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.billQueryApi.queryByPage(JSONObject.toJSONString((Object)billReqDto), billReqDto.getPageNum(), billReqDto.getPageSize()));
        long total = respDtoPageInfo.getTotal();
        long maxpage = total / 5000L + 1L;
        while ((long)params.getPageNum().intValue() <= maxpage && CollectionUtils.isNotEmpty((Collection)respDtoPageInfo.getList()) && respDtoPageInfo.getList().size() > 0) {
            List collect = respDtoPageInfo.getList().stream().map(o -> {
                ExportInsuranceBillVO vo = new ExportInsuranceBillVO();
                BeanUtils.copyProperties((Object)o, (Object)((Object)vo));
                if (o.getInOutTime() != null) {
                    vo.setInOutTime(DateUtil.format((Date)o.getInOutTime(), (String)DatePattern.DATE_PATTERN.getPattern()));
                }
                vo.setEasNo(o.getExternalOrderNo());
                return vo;
            }).collect(Collectors.toList());
            list.addAll(collect);
            if ((long)params.getPageNum().intValue() == maxpage) break;
            billReqDto.setPageNum(Integer.valueOf(billReqDto.getPageNum() + 1));
            respDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.billQueryApi.queryByPage(JSONObject.toJSONString((Object)billReqDto), billReqDto.getPageNum(), billReqDto.getPageSize()));
        }
        ModeTypeEnum anEnum = ModeTypeEnum.getInstance(commonReqDto.getKey());
        return EasyPoiExportUtil.uploadFile((List)list, anEnum.getExportTemplate(), commonReqDto.getFileName());
    }

    @Override
    public Integer exportTotal(ExportFileOperationCommonReqDto commonReqDto) {
        RestResponse pageInfoRestResponse;
        PageInfo respDtoPageInfo;
        InsurancePageParams params = new InsurancePageParams();
        if (StringUtils.isNotBlank((CharSequence)commonReqDto.getFilter())) {
            params = (InsurancePageParams)JSON.parseObject((String)commonReqDto.getFilter(), InsurancePageParams.class);
        }
        if (CollectionUtils.isEmpty((Collection)(respDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)(pageInfoRestResponse = this.billQueryApi.queryByPage(JSONObject.toJSONString((Object)params), Integer.valueOf(1), Integer.valueOf(1))))).getList())) {
            return 0;
        }
        return ParamConverter.convertToInteger((Object)respDtoPageInfo.getTotal());
    }
}

