/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cis.pms.biz.service.impl;

import cn.hutool.core.bean.BeanUtil;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.cis.pms.biz.model.ExportFileOperationCommonReqDto;
import com.dtyunxi.cis.pms.biz.model.ExportInsuranceBillVO;
import com.dtyunxi.cis.pms.biz.model.insurance.InsuranceBillReportRespVo;
import com.dtyunxi.cis.pms.biz.model.insurance.InsurancePageParams;
import com.dtyunxi.cis.pms.biz.service.ExportLogicalInventoryService;
import com.dtyunxi.cis.pms.biz.service.ReportCenterInsurancePremiumBillService;
import com.dtyunxi.cis.pms.biz.service.operation.impl.HandlerFileOperationCommonServiceImpl;
import com.dtyunxi.cis.pms.biz.utils.AssertUtil;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.request.FeeReportPlaceUpdateReqDto;
import com.dtyunxi.tcbj.api.query.IReInsuranceBillQueryApi;
import com.dtyunxi.util.ParamConverter;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.pagehelper.PageInfo;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="abstractFileOperationCommonService_insurance_bill_place_export")
public class ExportInsuranceBillPlaceServiceImpl
extends HandlerFileOperationCommonServiceImpl
implements ExportLogicalInventoryService {
    private static final Logger log = LoggerFactory.getLogger(ExportInsuranceBillPlaceServiceImpl.class);
    @Resource
    private ReportCenterInsurancePremiumBillService premiumBillService;
    @Resource
    private IReInsuranceBillQueryApi billQueryApi;

    @Override
    public String exportFileOperationCommon(ExportFileOperationCommonReqDto commonReqDto) {
        ArrayList<Long> waitPlaceIdList = new ArrayList<Long>();
        List<String> urls = null;
        AtomicReference<String> errorMsg = new AtomicReference<String>("");
        this.getDate(commonReqDto);
        InsurancePageParams insurancePageParams = new InsurancePageParams();
        if (StringUtils.isNotBlank((CharSequence)commonReqDto.getFilter())) {
            insurancePageParams = (InsurancePageParams)JSON.parseObject((String)commonReqDto.getFilter(), InsurancePageParams.class);
            log.info("\u4fdd\u8d39\u8d26\u5355\u62a5\u8868\u67e5\u8be2\u53c2\u65701:{}", (Object)JSON.toJSONString((Object)insurancePageParams));
        }
        try {
            urls = this.exportExcelHelper.doBigDataDivideDataExport(re -> {
                log.info("\u4fdd\u8d39\u8d26\u5355\u62a5\u8868\u5f52\u6863\u5bfc\u51fa\u67e5\u8be2\uff1a{}", (Object)JSON.toJSONString((Object)re));
                PageInfo respVoPageInfo = (PageInfo)RestResponseHelper.extractData(this.premiumBillService.getReInsuranceBillListPage((InsurancePageParams)re));
                PageInfo pageInfo = new PageInfo();
                CubeBeanUtils.copyProperties((Object)pageInfo, (Object)respVoPageInfo, (String[])new String[]{"navigatepageNums", "list"});
                List billVOList = BeanUtil.copyToList((Collection)respVoPageInfo.getList(), ExportInsuranceBillVO.class);
                pageInfo.setList(billVOList);
                if (CollectionUtils.isNotEmpty((Collection)respVoPageInfo.getList())) {
                    waitPlaceIdList.addAll(respVoPageInfo.getList().stream().map(InsuranceBillReportRespVo::getId).filter(Objects::nonNull).collect(Collectors.toList()));
                }
                log.info("\u4fdd\u8d39\u8d26\u5355\u62a5\u8868\u5f52\u6863\u5bfc\u51fa\u67e5\u8be2\u7ed3\u679c\uff1a{}", (Object)JSON.toJSONString((Object)pageInfo));
                return pageInfo;
            }, insurancePageParams, ExportInsuranceBillVO.class, commonReqDto.getFileName());
            log.info("\u751f\u6210\u6587\u4ef6\u94fe\u63a5\uff1a{}", urls);
            AssertUtil.isFalse(CollectionUtils.isEmpty(urls), "\u4fdd\u8d39\u8d26\u5355\u62a5\u8868\u5f52\u6863\u5bfc\u51fa\u5f02\u5e38\uff0c\u6ca1\u6709\u751f\u6210\u6587\u4ef6\u94fe\u63a5");
        }
        catch (Exception e) {
            errorMsg.set("\u5bfc\u51fa\u6267\u884c\u5931\u8d25:" + e.getMessage());
            log.error(e.getMessage(), (Throwable)e);
            throw e;
        }
        finally {
            this.placeCallBack(commonReqDto, errorMsg, String.join((CharSequence)",", urls), waitPlaceIdList, list -> {
                try {
                    FeeReportPlaceUpdateReqDto feeReportPlaceUpdateReqDto = new FeeReportPlaceUpdateReqDto();
                    feeReportPlaceUpdateReqDto.setModuleRecordIdList(waitPlaceIdList);
                    feeReportPlaceUpdateReqDto.setPlacedFlag(Integer.valueOf(1));
                    log.info("\u66f4\u65b0\u4fdd\u8d39\u8d26\u5355\u5f52\u6863\u72b6\u6001\uff1a{}", (Object)waitPlaceIdList.size());
                    this.billQueryApi.updatePlaceStatus(feeReportPlaceUpdateReqDto);
                }
                catch (Exception e) {
                    log.error("\u66f4\u65b0\u4fdd\u8d39\u8d26\u5355\u5f52\u6863\u72b6\u6001\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
                    log.error(e.getMessage(), (Throwable)e);
                    errorMsg.set("\u66f4\u65b0\u4fdd\u8d39\u8d26\u5355\u5f52\u6863\u72b6\u6001\u5f02\u5e38\uff1a" + e.getMessage());
                }
            });
        }
        return String.join((CharSequence)",", urls);
    }

    @Override
    public Integer exportTotal(ExportFileOperationCommonReqDto commonReqDto) {
        this.getDate(commonReqDto);
        InsurancePageParams insurancePageParams = (InsurancePageParams)JSON.parseObject((String)commonReqDto.getFilter(), InsurancePageParams.class);
        insurancePageParams.setPageSize(1);
        insurancePageParams.setPageNum(1);
        RestResponse<PageInfo<InsuranceBillReportRespVo>> pageInfoRestResponse = this.premiumBillService.getReInsuranceBillListPage(insurancePageParams);
        PageInfo respDtoPageInfo = (PageInfo)pageInfoRestResponse.getData();
        List list = respDtoPageInfo.getList();
        if (CollectionUtils.isEmpty((Collection)list)) {
            return 0;
        }
        return ParamConverter.convertToInteger((Object)list.size());
    }

    private void getDate(ExportFileOperationCommonReqDto commonReqDto) {
        String filter = commonReqDto.getFilter();
        ObjectMapper objectMapper = new ObjectMapper();
        try {
            JsonNode outerJsonNode = objectMapper.readTree(filter);
            JsonNode paramsNode = outerJsonNode.path("params");
            if (!paramsNode.isTextual()) {
                log.error("params \u5b57\u6bb5\u4e0d\u5b58\u5728\u6216\u4e0d\u662f\u5b57\u7b26\u4e32");
                return;
            }
            JsonNode innerParamsNode = objectMapper.readTree(paramsNode.asText());
            String time = innerParamsNode.path("placedFlagDate").asText();
            if (time == null || time.trim().isEmpty()) {
                log.error("placedFlagDate\u5b57\u6bb5\u4e0d\u5b58\u5728");
                return;
            }
            LocalDate yearMonth = LocalDate.parse(time + "-01", DateTimeFormatter.ofPattern("yyyy-MM-dd"));
            LocalDate firstDayOfMonth = yearMonth.withDayOfMonth(1);
            LocalDate lastDayOfMonth = yearMonth.withDayOfMonth(yearMonth.lengthOfMonth());
            ((ObjectNode)outerJsonNode).put("inOutTimeBegin", String.valueOf(firstDayOfMonth));
            ((ObjectNode)outerJsonNode).put("inOutTimeEnd", String.valueOf(lastDayOfMonth));
            commonReqDto.setFilter(outerJsonNode.toString());
        }
        catch (Exception e) {
            log.error("\u89e3\u6790JSON\u5931\u8d25", (Throwable)e);
        }
    }
}

