/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cis.pms.biz.service.impl;

import cn.afterturn.easypoi.excel.entity.result.ExcelImportResult;
import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.cis.pms.biz.model.AddSystemSettingNotSplitOrderWhiteListParams;
import com.dtyunxi.cis.pms.biz.model.CommonCreateVO;
import com.dtyunxi.cis.pms.biz.model.CustomerVO;
import com.dtyunxi.cis.pms.biz.model.ExportDismantleWhiteDto;
import com.dtyunxi.cis.pms.biz.model.ExportDismantleWhiteMsgDto;
import com.dtyunxi.cis.pms.biz.model.ExportFileOperationCommonReqDto;
import com.dtyunxi.cis.pms.biz.model.GetSystemSettingNotSplitOrderWhiteListParams;
import com.dtyunxi.cis.pms.biz.model.ImportBaseModeDto;
import com.dtyunxi.cis.pms.biz.model.ImportDismantleWhiteDto;
import com.dtyunxi.cis.pms.biz.model.ImportFileOperationCommonReqDto;
import com.dtyunxi.cis.pms.biz.model.ImportFileOperationCommonRespDto;
import com.dtyunxi.cis.pms.biz.service.SystemSettingNotSplitOrderWhiteListService;
import com.dtyunxi.cis.pms.biz.service.operation.ModeTypeEnum;
import com.dtyunxi.cis.pms.biz.service.operation.impl.HandlerFileOperationCommonServiceImpl;
import com.dtyunxi.cis.pms.biz.utils.EasyPoiExportUtil;
import com.dtyunxi.cis.pms.biz.utils.ExcelUtils;
import com.dtyunxi.cube.center.source.api.IDismantleWhiteApi;
import com.dtyunxi.cube.center.source.api.dto.request.DismantleWhiteReqDto;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.request.DismantleWhiteReportReqDto;
import com.dtyunxi.tcbj.api.dto.response.PCPCustomerRespDto;
import com.dtyunxi.tcbj.api.query.IDismantleWhiteReportQueryApi;
import com.dtyunxi.tcbj.api.query.IPCPCustomerQueryApi;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.yx.tcbj.center.customer.api.dto.request.PCPCustomerSearchReqDto;
import io.swagger.annotations.ApiParam;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.validation.Valid;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;

@Service(value="abstractFileOperationCommonService_dismantle_white")
public class SystemSettingNotSplitOrderWhiteListServiceServiceImpl
extends HandlerFileOperationCommonServiceImpl
implements SystemSettingNotSplitOrderWhiteListService {
    private static final Logger logger = LoggerFactory.getLogger(SystemSettingNotSplitOrderWhiteListServiceServiceImpl.class);
    @Resource
    private IPCPCustomerQueryApi ipcpCustomerQueryApi;
    @Resource
    private IDismantleWhiteApi iDismantleWhiteApi;
    @Resource
    private IDismantleWhiteReportQueryApi iDismantleWhiteReportQueryApi;

    @Override
    public Object verifyImportFileOperationCommon(ExcelImportResult<ImportBaseModeDto> result, ImportFileOperationCommonReqDto commonReqDto, ImportFileOperationCommonRespDto respDto) {
        ArrayList list = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)list, (Collection)result.getList(), ImportDismantleWhiteDto.class);
        Set customerCodes = list.stream().map(ImportDismantleWhiteDto::getCustomerCode).collect(Collectors.toSet());
        PCPCustomerSearchReqDto searchReqDto = new PCPCustomerSearchReqDto();
        searchReqDto.setCodeInList(new ArrayList(customerCodes));
        List customerList = (List)RestResponseHelper.extractData((RestResponse)this.ipcpCustomerQueryApi.queryPCPCustomerDetail(searchReqDto));
        Map customerMap = null;
        if (CollectionUtils.isNotEmpty((Collection)customerList)) {
            customerMap = customerList.stream().collect(Collectors.toMap(PCPCustomerRespDto::getCustomerCode, Function.identity(), (k1, k2) -> k1));
        }
        Map finalCustomerMap = customerMap;
        ArrayList msgList = Lists.newArrayList();
        ArrayList saveList = Lists.newArrayList();
        HashSet checkCustomerSet = Sets.newHashSet();
        list.stream().forEach(i -> {
            String customerCode = i.getCustomerCode();
            if (CollectionUtil.isNotEmpty((Map)finalCustomerMap) && finalCustomerMap.containsKey(customerCode)) {
                DismantleWhiteReqDto saveDto = new DismantleWhiteReqDto();
                saveDto.setCustomerId(((PCPCustomerRespDto)finalCustomerMap.get(customerCode)).getId());
                saveDto.setOperator(commonReqDto.getOperator());
                ExportDismantleWhiteMsgDto msgDto = new ExportDismantleWhiteMsgDto();
                if (checkCustomerSet.contains(saveDto.getCustomerId())) {
                    msgDto.setMsg("\u5ba2\u6237\u7f16\u7801\u91cd\u590d");
                    msgDto.setCustomerCode(customerCode);
                    msgList.add(msgDto);
                } else {
                    saveList.add(saveDto);
                    checkCustomerSet.add(saveDto.getCustomerId());
                }
            } else {
                ExportDismantleWhiteMsgDto msgDto = new ExportDismantleWhiteMsgDto();
                msgDto.setMsg("\u5ba2\u6237\u7f16\u7801\u4e0d\u6b63\u786e");
                msgDto.setCustomerCode(customerCode);
                msgList.add(msgDto);
            }
        });
        HashMap map = Maps.newHashMap();
        map.put("saveList", saveList);
        map.put("msgList", msgList);
        return map;
    }

    @Override
    public String executeImportFileOperationCommon(ExcelImportResult<ImportBaseModeDto> result, ImportFileOperationCommonReqDto commonReqDto, ImportFileOperationCommonRespDto respDto, Object obj) {
        List msgList;
        List saveList;
        Map map = (Map)obj;
        Object saveObj = map.get("saveList");
        Object msgObj = map.get("msgList");
        if (saveObj != null && CollectionUtil.isNotEmpty((Collection)(saveList = (List)saveObj))) {
            this.iDismantleWhiteApi.batchSaveDismantleWhite(saveList);
        }
        String errorMsgUrl = null;
        if (msgObj != null && CollectionUtil.isNotEmpty((Collection)(msgList = (List)msgObj))) {
            String excelName = String.format("%s%s", "\u4e0d\u62c6\u5355\u767d\u540d\u5355\u5bfc\u5165\u9519\u8bef\u4fe1\u606f", commonReqDto.getTaskCode());
            errorMsgUrl = ExcelUtils.getExportUrl(msgList, ExportDismantleWhiteMsgDto.class, null, excelName);
        }
        return errorMsgUrl;
    }

    @Override
    public Integer exportTotal(ExportFileOperationCommonReqDto commonReqDto) {
        DismantleWhiteReportReqDto reportReqDto = new DismantleWhiteReportReqDto();
        if (StringUtils.isNotBlank((CharSequence)commonReqDto.getFilter())) {
            reportReqDto = (DismantleWhiteReportReqDto)JSON.parseObject((String)commonReqDto.getFilter(), DismantleWhiteReportReqDto.class);
        }
        return (Integer)RestResponseHelper.extractData((RestResponse)this.iDismantleWhiteReportQueryApi.queryCount(reportReqDto));
    }

    @Override
    public String exportFileOperationCommon(ExportFileOperationCommonReqDto commonReqDto) {
        String filter = commonReqDto.getFilter();
        DismantleWhiteReportReqDto reportReqDto = new DismantleWhiteReportReqDto();
        if (StringUtils.isNotBlank((CharSequence)filter)) {
            reportReqDto = (DismantleWhiteReportReqDto)JSON.parseObject((String)filter, DismantleWhiteReportReqDto.class);
        }
        reportReqDto.setPageNum(commonReqDto.getPageNum());
        reportReqDto.setPageSize(commonReqDto.getPageSize());
        PageInfo respDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.iDismantleWhiteReportQueryApi.queryByPage(reportReqDto));
        List<Object> list = Lists.newArrayList();
        if (CollectionUtil.isNotEmpty((Collection)respDtoPageInfo.getList())) {
            list = respDtoPageInfo.getList().stream().map(i -> {
                ExportDismantleWhiteDto dto = new ExportDismantleWhiteDto();
                dto.setCustomerCode(i.getCustomerCode());
                dto.setCustomerName(i.getCustomerName());
                return dto;
            }).collect(Collectors.toList());
        }
        ModeTypeEnum anEnum = ModeTypeEnum.getInstance(commonReqDto.getKey());
        return EasyPoiExportUtil.uploadFile((List)list, anEnum.getExportTemplate(), commonReqDto.getFileName());
    }

    @Override
    public RestResponse<CommonCreateVO> addSystemSettingNotSplitOrderWhiteList(@ApiParam(value="") @Valid @RequestBody(required=false) AddSystemSettingNotSplitOrderWhiteListParams addReqDto) {
        if (addReqDto == null || StringUtils.isBlank((CharSequence)addReqDto.getCustomerCode())) {
            throw new BizException("\u5ba2\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        PCPCustomerRespDto pcpCustomerRespDto = (PCPCustomerRespDto)RestResponseHelper.extractData((RestResponse)this.ipcpCustomerQueryApi.queryPCPCustomerDetailByCode(addReqDto.getCustomerCode()));
        if (pcpCustomerRespDto == null) {
            throw new BizException("\u5ba2\u6237\u7f16\u7801\u4e0d\u6b63\u786e");
        }
        DismantleWhiteReqDto reqDto = new DismantleWhiteReqDto();
        reqDto.setCustomerId(pcpCustomerRespDto.getId());
        Long id = (Long)RestResponseHelper.extractData((RestResponse)this.iDismantleWhiteApi.addDismantleWhite(reqDto));
        CommonCreateVO vo = new CommonCreateVO();
        vo.setId(id);
        return new RestResponse((Object)vo);
    }

    @Override
    public RestResponse<Object> delSystemSettingNotSplitOrderWhiteById(@ApiParam(value="", required=true) @PathVariable(value="id") String id) {
        RestResponseHelper.extractData((RestResponse)this.iDismantleWhiteApi.removeDismantleWhite(id));
        return new RestResponse();
    }

    @Override
    public RestResponse<PageInfo<CustomerVO>> getSystemSettingNotSplitOrderWhiteList(@ApiParam(value="") @Valid @RequestBody(required=false) GetSystemSettingNotSplitOrderWhiteListParams reqDto) {
        DismantleWhiteReportReqDto reportReqDto = new DismantleWhiteReportReqDto();
        reportReqDto.setCustomerCode(reqDto.getCustomerCode());
        reportReqDto.setCustomerName(reqDto.getCustomerName());
        reportReqDto.setPageNum(reqDto.getPageNum());
        reportReqDto.setPageSize(reqDto.getPageSize());
        PageInfo respDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.iDismantleWhiteReportQueryApi.queryByPage(reportReqDto));
        if (CollectionUtils.isNotEmpty((Collection)respDtoPageInfo.getList())) {
            PageInfo pageInfo = new PageInfo();
            CubeBeanUtils.copyProperties((Object)pageInfo, (Object)respDtoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
            List list = respDtoPageInfo.getList().stream().map(o -> {
                CustomerVO vo = new CustomerVO();
                vo.setId(o.getId());
                vo.setCustomerName(o.getCustomerName());
                vo.setCustomerCode(o.getCustomerCode());
                return vo;
            }).collect(Collectors.toList());
            pageInfo.setList(list);
            return new RestResponse((Object)pageInfo);
        }
        return new RestResponse();
    }
}

