/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cis.pms.biz.service.impl;

import cn.hutool.core.util.ObjectUtil;
import com.dtyunxi.cis.pms.biz.enums.PlatformOrderTypeEnum;
import com.dtyunxi.cis.pms.biz.enums.SaleOrderTypeEnum;
import com.dtyunxi.cis.pms.biz.model.BusinessOrderInfoVO;
import com.dtyunxi.cis.pms.biz.model.DeliveryInfoVo;
import com.dtyunxi.cis.pms.biz.model.GetInNoticeListPageParams;
import com.dtyunxi.cis.pms.biz.model.RelateBillInfoVO;
import com.dtyunxi.cis.pms.biz.service.InventoryCenterBillInNoticeOrderService;
import com.dtyunxi.cis.search.api.dto.request.GetNoticeOrderPageParams;
import com.dtyunxi.cis.search.api.dto.response.InNoticeOrderVO;
import com.dtyunxi.cis.search.api.query.inventory.EsInventoryOrderQueryApi;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.cube.utils.enums.DatePattern;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.query.ICsLogisticsInfoQueryApi;
import com.dtyunxi.tcbj.api.query.es.InventoryEsReportQueryApi;
import com.dtyunxi.util.DateUtil;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.order.ICsInNoticeOrderApi;
import com.dtyunxi.yundt.cube.center.inventory.constant.ConsignmentConstant;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.order.CsInNoticeOrderRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.BizSaleOrderRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.BizSaleRefundRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.SaleOrderAddrRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.SaleRefundAddrRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.query.ISaleOrderQueryApi;
import com.dtyunxi.yundt.cube.center.trade.api.query.ISaleRefundQueryApi;
import com.dtyunxi.yundt.cube.center.transform.api.query.IPlatformOrderQueryApi;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.center.inventory.dto.domain.ContactDto;
import io.swagger.annotations.ApiParam;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.validation.Valid;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

@Service
public class InventoryCenterBillInNoticeOrderServiceServiceImpl
implements InventoryCenterBillInNoticeOrderService {
    private static final Logger logger = LoggerFactory.getLogger(InventoryCenterBillInNoticeOrderServiceServiceImpl.class);
    @Value(value="${esQuery:true}")
    private Boolean esQuery;
    @Resource
    private EsInventoryOrderQueryApi esInventoryOrderQueryApi;
    @Resource
    private ICsInNoticeOrderApi csInNoticeOrderQueryApi;
    @Resource
    private ISaleOrderQueryApi saleOrderQueryApi;
    @Resource
    private ISaleRefundQueryApi saleRefundQueryApi;
    @Resource
    private IPlatformOrderQueryApi platformOrderQueryApi;
    @Resource
    private InventoryEsReportQueryApi inventoryEsReportQueryApi;
    @Resource
    private ICsLogisticsInfoQueryApi iCsLogisticsInfoQueryApi;

    @Override
    public RestResponse<PageInfo<com.dtyunxi.cis.pms.biz.model.InNoticeOrderVO>> getInNoticeListPage(@ApiParam(value="") @Valid @RequestBody(required=false) GetInNoticeListPageParams getInNoticeListPageParams) {
        PageInfo orderVOPageInfo = new PageInfo();
        GetNoticeOrderPageParams params = new GetNoticeOrderPageParams();
        BeanUtils.copyProperties((Object)getInNoticeListPageParams, (Object)params);
        params.setOrderNo(getInNoticeListPageParams.getDocumentNo());
        params.setWarehouse(getInNoticeListPageParams.getReceiveLogicalWarehouseName());
        params.setInLogicWarehouseName(getInNoticeListPageParams.getReceiveLogicalWarehouseName());
        params.setOutLogicWarehouseName(getInNoticeListPageParams.getDeliveryLogicalWarehouseName());
        params.setOrderStatus(getInNoticeListPageParams.getDocumentStatus());
        if (this.esQuery.booleanValue()) {
            logger.info("es\u67e5\u8be2");
            orderVOPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.esInventoryOrderQueryApi.queryNoticeOrderPage(params));
        } else {
            logger.info("\u62a5\u8868\u4e2d\u5fc3\u67e5\u8be2");
            com.dtyunxi.tcbj.api.dto.request.es.GetNoticeOrderPageParams pageQueryDto = new com.dtyunxi.tcbj.api.dto.request.es.GetNoticeOrderPageParams();
            BeanUtils.copyProperties((Object)getInNoticeListPageParams, (Object)pageQueryDto);
            pageQueryDto.setOrderNo(getInNoticeListPageParams.getDocumentNo());
            pageQueryDto.setWarehouse(getInNoticeListPageParams.getReceiveLogicalWarehouseName());
            pageQueryDto.setInLogicWarehouseName(getInNoticeListPageParams.getReceiveLogicalWarehouseName());
            pageQueryDto.setOutLogicWarehouseName(getInNoticeListPageParams.getDeliveryLogicalWarehouseName());
            pageQueryDto.setOrderStatus(getInNoticeListPageParams.getDocumentStatus());
            PageInfo inNoticeOrderVOPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.inventoryEsReportQueryApi.queryNoticeOrderPage(pageQueryDto));
            CubeBeanUtils.copyProperties((Object)orderVOPageInfo, (Object)inNoticeOrderVOPageInfo, (String[])new String[]{"list", "navigatepageNums"});
            ArrayList lists = new ArrayList();
            CubeBeanUtils.copyCollection(lists, (Collection)inNoticeOrderVOPageInfo.getList(), InNoticeOrderVO.class);
            orderVOPageInfo.setList(lists);
        }
        PageInfo pageInfo = new PageInfo();
        if (CollectionUtils.isEmpty((Collection)orderVOPageInfo.getList())) {
            return new RestResponse((Object)pageInfo);
        }
        CubeBeanUtils.copyProperties((Object)pageInfo, (Object)orderVOPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        List list = orderVOPageInfo.getList().stream().map(o -> {
            com.dtyunxi.cis.pms.biz.model.InNoticeOrderVO vo = new com.dtyunxi.cis.pms.biz.model.InNoticeOrderVO();
            BeanUtils.copyProperties((Object)o, (Object)vo);
            vo.setCreateTime(DateUtil.format((Date)o.getCreateTime(), (String)DatePattern.DATETIME_PATTERN.getPattern()));
            vo.setBusinessOrderNo(o.getRelevanceNo());
            vo.setExternalOrderNo(o.getExternalOrderNo());
            vo.setDocumentStatus(o.getOrderStatus());
            vo.setDeliveryLogicalWarehouseName(o.getOutLogicWarehouseName());
            vo.setDeliveryLogicalWarehouseCode(o.getOutLogicWarehouseCode());
            vo.setReceiveLogicalWarehouseName(o.getInLogicWarehouseName());
            vo.setReceiveLogicalWarehouseCode(o.getInLogicWarehouseCode());
            vo.setBizDateStr(ObjectUtil.isNotEmpty((Object)o.getBizDate()) ? DateUtil.format((Date)o.getBizDate(), (String)DatePattern.DATETIME_PATTERN.getPattern()) : null);
            return vo;
        }).collect(Collectors.toList());
        pageInfo.setList(list);
        return new RestResponse((Object)pageInfo);
    }

    @Override
    public RestResponse<com.dtyunxi.cis.pms.biz.model.InNoticeOrderVO> getInNoticeOrderDetail(@ApiParam(value="\u5165\u5e93\u901a\u77e5\u5355\u53f7") @Valid @RequestParam(value="inNoticeNo", required=false) String inNoticeNo) {
        List relOrderInfoList;
        List respDtos;
        if (StringUtils.isBlank((CharSequence)inNoticeNo)) {
            throw new BizException("\u5165\u5e93\u901a\u77e5\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        CsInNoticeOrderRespDto respDto = (CsInNoticeOrderRespDto)RestResponseHelper.extractData((RestResponse)this.csInNoticeOrderQueryApi.queryByDocumentNo(inNoticeNo));
        com.dtyunxi.cis.pms.biz.model.InNoticeOrderVO vo = new com.dtyunxi.cis.pms.biz.model.InNoticeOrderVO();
        if (respDto == null) {
            return new RestResponse((Object)vo);
        }
        BeanUtils.copyProperties((Object)respDto, (Object)vo);
        vo.setDocumentNo(respDto.getDocumentNo());
        vo.setBusinessType(respDto.getBusinessType());
        if (respDto.getCreateTime() != null) {
            vo.setCreateTime(DateUtil.format((Date)respDto.getCreateTime(), (String)DatePattern.DATETIME_PATTERN.getPattern()));
        }
        vo.setDocumentStatus(respDto.getOrderStatus());
        vo.setDeliveryPhysicalWarehouseName(respDto.getOutWarehouseName());
        vo.setDeliveryPhysicalWarehouseCode(respDto.getOutWarehouseCode());
        vo.setDeliveryLogicalWarehouseName(respDto.getOutLogicWarehouseName());
        vo.setDeliveryLogicalWarehouseCode(respDto.getOutLogicWarehouseCode());
        vo.setReceiveLogicalWarehouseCode(respDto.getInLogicWarehouseCode());
        vo.setReceiveLogicalWarehouseName(respDto.getInLogicWarehouseName());
        vo.setReceivePhysicalWarehouseCode(respDto.getWarehouseCode());
        vo.setReceivePhysicalWarehouseName(respDto.getWarehouseName());
        vo.setSummary(respDto.getTotalQuantity() == null ? BigDecimal.ZERO : respDto.getTotalQuantity());
        vo.setTotalSku(respDto.getSkuNum() == null ? BigDecimal.ZERO : respDto.getSkuNum());
        vo.setBizDateStr(ObjectUtil.isNotEmpty((Object)respDto.getBizDate()) ? DateUtil.format((Date)respDto.getBizDate(), (String)DatePattern.DATETIME_PATTERN.getPattern()) : null);
        ContactDto contactDto = respDto.getContactDto();
        if (Objects.nonNull(contactDto)) {
            BusinessOrderInfoVO businessOrderInfo = new BusinessOrderInfoVO();
            BeanUtils.copyProperties((Object)contactDto, (Object)businessOrderInfo);
            vo.setBusinessOrderInfo(businessOrderInfo);
        }
        if (CollectionUtils.isNotEmpty((Collection)(respDtos = (List)RestResponseHelper.extractData((RestResponse)this.iCsLogisticsInfoQueryApi.queryOutDeliveryInformation(inNoticeNo))))) {
            List<DeliveryInfoVo> list = respDtos.stream().map(o -> {
                DeliveryInfoVo documentVO = new DeliveryInfoVo();
                BeanUtils.copyProperties((Object)o, (Object)documentVO);
                if (o.getConsignmentType() != null) {
                    documentVO.setConsignmentTypeName((String)ConsignmentConstant.CONSIGNMENT_TYPE.valueMap.get(o.getConsignmentType()));
                }
                return documentVO;
            }).collect(Collectors.toList());
            vo.setDeliveryInfoList(list);
        }
        if (CollectionUtils.isNotEmpty((Collection)(relOrderInfoList = respDto.getRelOrderInfoList()))) {
            List<RelateBillInfoVO> list = relOrderInfoList.stream().filter(o -> StringUtils.isNotBlank((CharSequence)o.getOrderNo())).map(o -> {
                RelateBillInfoVO relateBillInfoVO = new RelateBillInfoVO();
                if (PlatformOrderTypeEnum.PLATFORM_ORDER_NO.getCode().equals(o.getOrderType())) {
                    BeanUtils.copyProperties((Object)o, (Object)relateBillInfoVO);
                    relateBillInfoVO.setIsExternalOrder(true);
                } else if (SaleOrderTypeEnum.getStatusByCode(o.getOrderType()) != null) {
                    if (SaleOrderTypeEnum.ORDER_SALES_REFUND.getCode().equals(o.getOrderType())) {
                        BizSaleRefundRespDto bizSaleRefundRespDto = (BizSaleRefundRespDto)RestResponseHelper.extractData((RestResponse)this.saleRefundQueryApi.queryByRefundNo(o.getOrderNo()));
                        if (bizSaleRefundRespDto != null) {
                            BeanUtils.copyProperties((Object)o, (Object)relateBillInfoVO);
                            relateBillInfoVO.setOrderStatus(bizSaleRefundRespDto.getRefundStatus());
                            SaleRefundAddrRespDto saleRefundAddrRespDto = bizSaleRefundRespDto.getSaleRefundAddrRespDto();
                            if (saleRefundAddrRespDto != null) {
                                BusinessOrderInfoVO businessOrderInfo = new BusinessOrderInfoVO();
                                businessOrderInfo.setReciveName(saleRefundAddrRespDto.getReceiveName());
                                businessOrderInfo.setRecivePhone(saleRefundAddrRespDto.getReceivePhone());
                                businessOrderInfo.setAddress(Optional.ofNullable(saleRefundAddrRespDto.getProvince()).orElse("") + Optional.ofNullable(saleRefundAddrRespDto.getCity()).orElse("") + Optional.ofNullable(saleRefundAddrRespDto.getCounty()).orElse("") + Optional.ofNullable(saleRefundAddrRespDto.getReceiveAddress()).orElse(""));
                                businessOrderInfo.setAddress(StringUtils.defaultString((String)saleRefundAddrRespDto.getProvince()) + StringUtils.defaultString((String)saleRefundAddrRespDto.getCity()) + StringUtils.defaultString((String)saleRefundAddrRespDto.getCounty()) + StringUtils.defaultString((String)saleRefundAddrRespDto.getReceiveAddress()));
                                vo.setBusinessOrderInfo(businessOrderInfo);
                            }
                        }
                    } else {
                        BizSaleOrderRespDto saleOrderRespDto = (BizSaleOrderRespDto)RestResponseHelper.extractData((RestResponse)this.saleOrderQueryApi.queryByOrderNo(o.getOrderNo()));
                        if (saleOrderRespDto != null) {
                            BeanUtils.copyProperties((Object)o, (Object)relateBillInfoVO);
                            relateBillInfoVO.setOrderStatus(saleOrderRespDto.getOrderStatus());
                            SaleOrderAddrRespDto orderAddrRespDto = saleOrderRespDto.getOrderAddrRespDto();
                            if (orderAddrRespDto != null) {
                                BusinessOrderInfoVO businessOrderInfo = new BusinessOrderInfoVO();
                                businessOrderInfo.setReciveName(orderAddrRespDto.getReceiveName());
                                businessOrderInfo.setRecivePhone(orderAddrRespDto.getReceivePhone());
                                businessOrderInfo.setAddress(Optional.ofNullable(orderAddrRespDto.getProvince()).orElse("") + Optional.ofNullable(orderAddrRespDto.getCity()).orElse("") + Optional.ofNullable(orderAddrRespDto.getCounty()).orElse("") + Optional.ofNullable(orderAddrRespDto.getReceiveAddress()).orElse(""));
                                businessOrderInfo.setAddress(StringUtils.defaultString((String)orderAddrRespDto.getProvince()) + StringUtils.defaultString((String)orderAddrRespDto.getCity()) + StringUtils.defaultString((String)orderAddrRespDto.getCounty()) + StringUtils.defaultString((String)orderAddrRespDto.getReceiveAddress()));
                                businessOrderInfo.setRemark(saleOrderRespDto.getRemark());
                                vo.setBusinessOrderInfo(businessOrderInfo);
                            }
                        }
                    }
                } else {
                    BeanUtils.copyProperties((Object)o, (Object)relateBillInfoVO);
                    relateBillInfoVO.setLogisticsCompany(o.getShippingCompany());
                    relateBillInfoVO.setLogisticsNo(o.getShippingCode());
                    relateBillInfoVO.setDeliveryWay(o.getShippingType());
                    relateBillInfoVO.setWmsNo(o.getWmsOrderNo());
                    if (o.getEstimatedTime() != null) {
                        relateBillInfoVO.setExpectedArriveTime(DateUtil.format((Date)o.getEstimatedTime(), (String)DatePattern.DATETIME_PATTERN.getPattern()));
                    }
                }
                return relateBillInfoVO;
            }).collect(Collectors.toList());
            vo.setRelateBillInfoList(list);
        }
        return new RestResponse((Object)vo);
    }
}

