/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cis.pms.biz.service.impl;

import cn.afterturn.easypoi.excel.entity.result.ExcelImportResult;
import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.cis.pms.biz.enums.LogStatusEnum;
import com.dtyunxi.cis.pms.biz.model.ExportFileOperationCommonReqDto;
import com.dtyunxi.cis.pms.biz.model.ExportStorageChargeBillVO;
import com.dtyunxi.cis.pms.biz.model.ImportBaseModeDto;
import com.dtyunxi.cis.pms.biz.model.ImportFileOperationCommonReqDto;
import com.dtyunxi.cis.pms.biz.model.ImportFileOperationCommonRespDto;
import com.dtyunxi.cis.pms.biz.model.ImportStorageChargeBillVO;
import com.dtyunxi.cis.pms.biz.service.IStorageChargeBillService;
import com.dtyunxi.cis.pms.biz.service.operation.ModeTypeEnum;
import com.dtyunxi.cis.pms.biz.service.operation.impl.HandlerFileOperationCommonServiceImpl;
import com.dtyunxi.cis.pms.biz.utils.EasyPoiExportUtil;
import com.dtyunxi.cis.pms.biz.utils.ExcelUtils;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.IStorageChargeBillApi;
import com.dtyunxi.tcbj.api.dto.constant.enums.IsSatisfyContract;
import com.dtyunxi.tcbj.api.dto.request.ApportionOtherReqDto;
import com.dtyunxi.tcbj.api.dto.request.StatisticsBillReqDto;
import com.dtyunxi.tcbj.api.dto.request.StorageChargeBillReqDto;
import com.dtyunxi.tcbj.api.dto.request.UpdateStorageDetailDto;
import com.dtyunxi.tcbj.api.dto.response.ApportionOtherCostRespDto;
import com.dtyunxi.tcbj.api.dto.response.LogicWarehouseRespDto;
import com.dtyunxi.tcbj.api.dto.response.StatisticsBillRespDto;
import com.dtyunxi.tcbj.api.dto.response.StorageChargeBillPrintDto;
import com.dtyunxi.tcbj.api.dto.response.StorageChargeBillRespDto;
import com.dtyunxi.tcbj.api.query.ILogicWarehouseQueryApi;
import com.dtyunxi.tcbj.api.query.IStorageChargeBillQueryApi;
import com.dtyunxi.util.ParamConverter;
import com.dtyunxi.yundt.cube.center.data.api.dto.TwoTuple;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.warehouse.ICsPhysicsWarehouseExposedApi;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.warehouse.CsPhysicsWarehousePageQueryDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.warehouse.CsPhysicsWarehousePageRespDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.ThridOrganizationReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.OrgAdvDetailRespDto;
import com.dtyunxi.yundt.cube.center.user.api.query.IOrganizationQueryExtApi;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.yunxi.dg.base.commons.utils.decimal.BigDecimalUtils;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service(value="abstractFileOperationCommonService_storage_charge_bill")
public class StorageChargeBillServiceImpl
extends HandlerFileOperationCommonServiceImpl
implements IStorageChargeBillService {
    private final Logger LOGGER = LoggerFactory.getLogger(StorageChargeBillServiceImpl.class);
    @Resource
    private IStorageChargeBillApi storageChargeBillApi;
    @Resource
    private IStorageChargeBillQueryApi storageChargeBillQueryApi;
    @Resource
    private IStorageChargeBillService storageChargeBillService;
    @Resource
    private ICsPhysicsWarehouseExposedApi csPhysicsWarehouseExposedQueryApi;
    @Resource
    private ILogicWarehouseQueryApi logicWarehouseQueryApi;
    @Resource
    private IOrganizationQueryExtApi organizationQueryExtApi;

    @Override
    public RestResponse<PageInfo<StorageChargeBillRespDto>> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        PageInfo pageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.storageChargeBillQueryApi.queryByPage(filter, pageNum, pageSize));
        if (CollectionUtil.isNotEmpty((Collection)pageInfo.getList())) {
            pageInfo.getList().forEach(info -> {
                if (ObjectUtils.isNotEmpty((Object)info.getIsSatisfy()) && info.getIsSatisfy() == 1) {
                    info.setContractAverageSupport(null);
                }
            });
        }
        return new RestResponse((Object)pageInfo);
    }

    @Override
    public RestResponse<List<StorageChargeBillRespDto>> apportionOtherList(ApportionOtherReqDto apportionOtherReqDto) {
        return this.storageChargeBillApi.apportionOtherList(apportionOtherReqDto);
    }

    @Override
    public RestResponse<ApportionOtherCostRespDto> apportionOther(ApportionOtherReqDto apportionOtherReqDto) {
        return this.storageChargeBillApi.apportionOther(apportionOtherReqDto);
    }

    @Override
    public RestResponse<Void> updateStorageBill(UpdateStorageDetailDto updateStorageReqDto) {
        return this.storageChargeBillApi.updateStorageBill(updateStorageReqDto);
    }

    @Override
    public RestResponse<List<StorageChargeBillPrintDto>> printBill(String filter) {
        return this.storageChargeBillQueryApi.printBill(filter);
    }

    @Override
    public String exportFileOperationCommon(ExportFileOperationCommonReqDto commonReqDto) {
        RestResponse<PageInfo<StorageChargeBillRespDto>> pageInfoRestResponse = this.storageChargeBillService.queryByPage(commonReqDto.getFilter(), commonReqDto.getPageNum(), commonReqDto.getPageSize());
        PageInfo respDtoPageInfo = (PageInfo)pageInfoRestResponse.getData();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM");
        List<Object> list = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty((Collection)respDtoPageInfo.getList())) {
            list = respDtoPageInfo.getList().stream().map(o -> {
                BigDecimal checkNum = new BigDecimal("-1");
                String errorStr = "\u5f02\u5e38";
                ExportStorageChargeBillVO vo = new ExportStorageChargeBillVO();
                BeanUtils.copyProperties((Object)o, (Object)((Object)vo));
                vo.setBillTime(dateFormat.format(o.getBillTime()));
                vo.setChargeOrgName(o.getChargeOrgName());
                if (ObjectUtils.isNotEmpty((Object)o.getContractAverageSupport())) {
                    if (o.getContractAverageSupport().compareTo(checkNum) == 0) {
                        vo.setContractAverageSupport(BigDecimal.ZERO);
                    } else {
                        vo.setContractAverageSupport(o.getContractAverageSupport());
                    }
                }
                if (ObjectUtils.isNotEmpty((Object)o.getAllMonthSupport())) {
                    if (o.getAllMonthSupport().compareTo(checkNum) == 0) {
                        vo.setAllMonthSupport(BigDecimal.ZERO);
                    } else {
                        vo.setAllMonthSupport(o.getAllMonthSupport());
                    }
                }
                if (o.getStatus() != null) {
                    vo.setStatus(Optional.ofNullable(LogStatusEnum.getStatusByCode(String.valueOf(o.getStatus()))).orElse(String.valueOf(o.getStatus())));
                }
                vo.setCreatePerson(o.getCreatePerson());
                vo.setCreateTime(o.getCreateTime());
                vo.setDaysNum(o.getDaysNum() != null ? o.getDaysNum().toString() : null);
                vo.setExtension(o.getExtension());
                vo.setInstanceId(o.getInstanceId());
                IsSatisfyContract isSatisfyContract = IsSatisfyContract.keyOfEnum((Integer)o.getIsSatisfy());
                vo.setIsSatisfy(isSatisfyContract != null ? isSatisfyContract.getDesc() : null);
                vo.setLogicWarehouseCode(o.getLogicWarehouseCode());
                vo.setLogicWarehouseName(o.getLogicWarehouseName());
                vo.setOrgId(o.getOrgId());
                vo.setOtherCost(o.getOtherCost());
                vo.setOutDeliveryProperty(o.getOutDeliveryProperty());
                DecimalFormat decimalFormat = new DecimalFormat("0.00000%");
                if (o.getOutPercentageProperty() != null) {
                    BigDecimal bigDecimal = new BigDecimal(100);
                    BigDecimal divide = o.getOutPercentageProperty().divide(bigDecimal, 5, 4);
                    String format = decimalFormat.format(divide.doubleValue());
                    vo.setOutPercentageProperty(new BigDecimal(format));
                }
                vo.setTenantId(o.getTenantId());
                if (o.getTotalWarehouseCost() != null && o.getTotalWarehouseCost().compareTo(checkNum) != 0) {
                    vo.setTotalWarehouseCost(o.getTotalWarehouseCost());
                } else {
                    vo.setTotalWarehouseCost(BigDecimal.ZERO);
                }
                if (o.getUnitPrice() != null && o.getUnitPrice().compareTo(checkNum) != 0) {
                    vo.setUnitPrice(o.getUnitPrice());
                } else {
                    vo.setUnitPrice(BigDecimal.ZERO);
                }
                vo.setUpdatePerson(o.getUpdatePerson());
                vo.setUpdateTime(o.getUpdateTime());
                vo.setWarehouseCode(o.getWarehouseCode());
                if (o.getWarehouseCost() != null && o.getWarehouseCost().compareTo(checkNum) != 0) {
                    vo.setWarehouseCost(o.getWarehouseCost());
                } else {
                    vo.setWarehouseCost(BigDecimal.ZERO);
                }
                vo.setWarehouseName(o.getWarehouseName());
                return vo;
            }).collect(Collectors.toList());
        }
        ModeTypeEnum anEnum = ModeTypeEnum.getInstance(commonReqDto.getKey());
        return EasyPoiExportUtil.uploadFile((List)list, anEnum.getExportTemplate(), commonReqDto.getFileName());
    }

    @Override
    public Integer exportTotal(ExportFileOperationCommonReqDto commonReqDto) {
        RestResponse<PageInfo<StorageChargeBillRespDto>> pageInfoRestResponse = this.storageChargeBillService.queryByPage(commonReqDto.getFilter(), commonReqDto.getPageNum(), commonReqDto.getPageSize());
        PageInfo respDtoPageInfo = (PageInfo)pageInfoRestResponse.getData();
        if (CollectionUtils.isEmpty((Collection)respDtoPageInfo.getList())) {
            return 0;
        }
        return ParamConverter.convertToInteger((Object)respDtoPageInfo.getTotal());
    }

    @Override
    public Object verifyImportFileOperationCommon(ExcelImportResult<ImportBaseModeDto> result, ImportFileOperationCommonReqDto commonReqDto, ImportFileOperationCommonRespDto respDto) {
        ArrayList list = Lists.newArrayList();
        ArrayList verificationList = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)list, (Collection)result.getList(), ImportStorageChargeBillVO.class);
        CubeBeanUtils.copyCollection((Collection)verificationList, (Collection)result.getList(), ImportStorageChargeBillVO.class);
        HashSet uniqueKeys = Sets.newHashSet();
        HashSet logiscWarehouseCodes = Sets.newHashSet();
        ArrayList billTimes = Lists.newArrayList();
        ArrayList warehouseCodes = Lists.newArrayList();
        list.forEach(i -> {
            if (StringUtils.isNotBlank((CharSequence)i.getLogicWarehouseCode())) {
                logiscWarehouseCodes.add(i.getLogicWarehouseCode());
            }
            if (StringUtils.isNotBlank((CharSequence)i.getBillTime())) {
                billTimes.add(String.format("%s-01", i.getBillTime()));
            }
            if (StringUtils.isNotBlank((CharSequence)i.getWarehouseCode())) {
                warehouseCodes.add(i.getWarehouseCode());
            }
        });
        Map<String, CsPhysicsWarehousePageRespDto> physicsWarehouseMap = this.queryPhysicalWareshouse();
        Map<String, LogicWarehouseRespDto> logicWarehouseMap = this.getLogicWarehouseMap(logiscWarehouseCodes);
        Map<String, OrgAdvDetailRespDto> orgInfoMap = this.queryOrgInfoMap();
        ArrayList errorList = Lists.newArrayList();
        ArrayList saveList = Lists.newArrayList();
        ArrayList updateList = Lists.newArrayList();
        ArrayList increaseList = Lists.newArrayList();
        verificationList.forEach(i -> {
            this.checkOrg((ImportStorageChargeBillVO)((Object)i), orgInfoMap);
            this.checkIsSatisfy((ImportStorageChargeBillVO)((Object)i));
            if (StringUtils.isBlank((CharSequence)i.getMsg())) {
                StorageChargeBillReqDto dto = this.assembleData((ImportStorageChargeBillVO)((Object)i));
                this.LOGGER.info("dto,\u5165\u53c2\u67e5\u8be2:{}", (Object)JSON.toJSONString((Object)dto));
                StorageChargeBillRespDto storageChargeBillRespDto = (StorageChargeBillRespDto)RestResponseHelper.extractData((RestResponse)this.storageChargeBillApi.queryBillDto(dto));
                this.LOGGER.info("storageChargeBillRespDto,\u67e5\u8be2\u7ed3\u679c:{}", (Object)JSON.toJSONString((Object)storageChargeBillRespDto));
                if (ObjectUtils.isNotEmpty((Object)storageChargeBillRespDto)) {
                    dto.setId(storageChargeBillRespDto.getId());
                    updateList.add(dto);
                }
                increaseList.add(dto);
            }
        });
        this.LOGGER.info("updateList,\u66f4\u65b0\u7684\u5217\u8868:{}", (Object)JSON.toJSONString((Object)updateList));
        this.LOGGER.info("increaseList,\u5168\u90e8\u7684\u5217\u8868:{}", (Object)JSON.toJSONString((Object)increaseList));
        Map<String, Double> increaseMap = increaseList.stream().collect(Collectors.groupingBy(r -> r.getBillTime() + "_" + r.getWarehouseCode(), Collectors.summingDouble(r -> BigDecimalUtils.check((BigDecimal)r.getOutPercentageProperty()).doubleValue())));
        List<Long> ids = updateList.stream().map(StorageChargeBillReqDto::getId).collect(Collectors.toList());
        Map<String, StatisticsBillRespDto> stringListMap = this.queryOutPercentageProperty(warehouseCodes, billTimes, ids);
        this.LOGGER.info("increaseMap,\u5168\u90e8\u7b97\u8d77\u6765\u7684:{}", (Object)JSON.toJSONString(increaseMap));
        this.LOGGER.info("stringListMap,\u6570\u636e\u5e93\u67e5\u8be2\u7684:{}", (Object)JSON.toJSONString(stringListMap));
        list.stream().forEach(i -> {
            this.checkRepeatData(i.getUniqueKey(), uniqueKeys, (ImportStorageChargeBillVO)((Object)i));
            this.checkPhysicsWarehouse((ImportStorageChargeBillVO)((Object)i), physicsWarehouseMap);
            this.checkLogicWarehouse((ImportStorageChargeBillVO)((Object)i), logicWarehouseMap);
            this.checkOrg((ImportStorageChargeBillVO)((Object)i), orgInfoMap);
            this.checkIsSatisfy((ImportStorageChargeBillVO)((Object)i));
            this.verification((ImportStorageChargeBillVO)((Object)i), increaseMap, stringListMap);
            if (StringUtils.isBlank((CharSequence)i.getMsg())) {
                saveList.add(this.assembleData((ImportStorageChargeBillVO)((Object)i)));
            } else {
                errorList.add(i);
            }
        });
        TwoTuple twoTuple = new TwoTuple((Object)saveList, (Object)errorList);
        return twoTuple;
    }

    private void verification(ImportStorageChargeBillVO vo, Map<String, Double> increaseMap, Map<String, StatisticsBillRespDto> stringListMap) {
        String format = String.format("%s-01", vo.getBillTime());
        String key = format + "_" + vo.getWarehouseCode();
        if (increaseMap.containsKey(key) && stringListMap.containsKey(key)) {
            Double increase = increaseMap.get(key);
            StatisticsBillRespDto dto = stringListMap.get(key);
            double sum = BigDecimalUtils.check((BigDecimal)dto.getOutPercentagePropertySum()).doubleValue() + increase;
            Double aDouble = new Double(sum);
            int i = aDouble.intValue();
            this.LOGGER.info("aDouble,\u7b2c\u4e00\u4e2a\u603b\u548c:{}", (Object)JSON.toJSONString((Object)i));
        } else {
            Double sumIncrease = increaseMap.get(key);
            Double aDouble = new Double(sumIncrease);
            int i = aDouble.intValue();
            this.LOGGER.info("aDouble,\u7b2c\u4e8c\u4e2a\u603b\u548c:{}", (Object)JSON.toJSONString((Object)i));
        }
    }

    private StorageChargeBillReqDto assembleData(ImportStorageChargeBillVO vo) {
        StorageChargeBillReqDto reqDto = new StorageChargeBillReqDto();
        reqDto.setBillTime(String.format("%s-01", vo.getBillTime()));
        reqDto.setWarehouseCode(vo.getWarehouseCode());
        reqDto.setWarehouseName(vo.getWarehouseName());
        reqDto.setBillType(Integer.valueOf(2));
        if (StringUtils.isNotBlank((CharSequence)vo.getLogicWarehouseCode())) {
            reqDto.setLogicWarehouseCode(vo.getLogicWarehouseCode());
            reqDto.setLogicWarehouseName(vo.getLogicWarehouseName());
        }
        if (StringUtils.isNotBlank((CharSequence)vo.getChargeOrgName())) {
            reqDto.setChargeOrgName(vo.getChargeOrgName());
            reqDto.setChargeOrgId(vo.getChargeOrgId());
        }
        if (StringUtils.isNotBlank((CharSequence)vo.getAllMonthSupport())) {
            reqDto.setAllMonthSupport(new BigDecimal(vo.getAllMonthSupport()));
        }
        if (StringUtils.isNotBlank((CharSequence)vo.getContractAverageSupport())) {
            reqDto.setContractAverageSupport(new BigDecimal(vo.getContractAverageSupport()));
        }
        if (StringUtils.isNotBlank((CharSequence)vo.getDaysNum())) {
            reqDto.setDaysNum(Integer.valueOf(vo.getDaysNum()));
        }
        if (StringUtils.isNotBlank((CharSequence)vo.getIsSatisfy())) {
            reqDto.setIsSatisfy(Integer.valueOf(vo.getIsSatisfy()));
        }
        if (StringUtils.isNotBlank((CharSequence)vo.getUnitPrice())) {
            reqDto.setUnitPrice(new BigDecimal(vo.getUnitPrice()));
        }
        reqDto.setWarehouseCost(new BigDecimal(vo.getWarehouseCost()));
        if (StringUtils.isNotBlank((CharSequence)vo.getOutDeliveryVolumeNum())) {
            reqDto.setOutDeliveryProperty(new BigDecimal(vo.getOutDeliveryVolumeNum()));
        }
        if (StringUtils.isNotBlank((CharSequence)vo.getOutPercentageProperty())) {
            String outPercentageProperty = vo.getOutPercentageProperty();
            reqDto.setOutPercentageProperty(new BigDecimal(outPercentageProperty).multiply(new BigDecimal("100")).setScale(2, 4));
        }
        if (StringUtils.isNotBlank((CharSequence)vo.getOtherCost())) {
            reqDto.setOtherCost(new BigDecimal(vo.getOtherCost()));
        }
        reqDto.setTotalWarehouseCost(new BigDecimal(vo.getTotalWarehouseCost()));
        if (StringUtils.isNotBlank((CharSequence)vo.getRemark())) {
            reqDto.setRemark(vo.getRemark());
        }
        this.LOGGER.info("reqDto,\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)reqDto));
        return reqDto;
    }

    private void checkIsSatisfy(ImportStorageChargeBillVO i) {
        String isSatisfy = i.getIsSatisfy();
        if (StringUtils.isBlank((CharSequence)isSatisfy)) {
            return;
        }
        if (Objects.equals(isSatisfy, "\u4e0d\u6ee1\u8db3")) {
            i.setIsSatisfy("0");
        } else if (Objects.equals(isSatisfy, "\u6ee1\u8db3")) {
            i.setIsSatisfy("1");
        } else {
            this.setMsg(i, "\u662f\u5426\u6ee1\u8db3\u5408\u540c\u7ea6\u5b9a\u53ea\u80fd\u586b\u5199\u6ee1\u8db3/\u4e0d\u6ee1\u8db3");
        }
    }

    private void checkOrg(ImportStorageChargeBillVO i, Map<String, OrgAdvDetailRespDto> orgInfoMap) {
        String chargeOrgName = i.getChargeOrgName();
        if (StringUtils.isBlank((CharSequence)chargeOrgName)) {
            return;
        }
        if (orgInfoMap.containsKey(chargeOrgName)) {
            OrgAdvDetailRespDto orgInfo = orgInfoMap.get(chargeOrgName);
            i.setChargeOrgId(String.valueOf(orgInfo.getId()));
        } else {
            this.setMsg(i, "\u5e93\u5b58\u7ec4\u7ec7\u540d\u79f0\u4e0d\u6b63\u786e");
        }
    }

    private void checkLogicWarehouse(ImportStorageChargeBillVO i, Map<String, LogicWarehouseRespDto> logicWarehouseMap) {
        String logicWarehouseCode = i.getLogicWarehouseCode();
        if (StringUtils.isBlank((CharSequence)logicWarehouseCode)) {
            return;
        }
        if (logicWarehouseMap.containsKey(logicWarehouseCode)) {
            LogicWarehouseRespDto logicWarehouseRespDto = logicWarehouseMap.get(logicWarehouseCode);
            i.setLogicWarehouseName(logicWarehouseRespDto.getWarehouseName());
        } else {
            this.setMsg(i, "\u903b\u8f91\u4ed3\u7f16\u7801\u4e0d\u6b63\u786e");
        }
    }

    private void checkPhysicsWarehouse(ImportStorageChargeBillVO i, Map<String, CsPhysicsWarehousePageRespDto> physicsWarehouseMap) {
        if (physicsWarehouseMap.containsKey(i.getWarehouseCode())) {
            CsPhysicsWarehousePageRespDto physicsWarehouse = physicsWarehouseMap.get(i.getWarehouseCode());
            i.setWarehouseName(physicsWarehouse.getWarehouseName());
        } else {
            this.setMsg(i, "\u7269\u7406\u4ed3\u7f16\u7801\u4e0d\u6b63\u786e");
        }
    }

    @Override
    public String executeImportFileOperationCommon(ExcelImportResult<ImportBaseModeDto> result, ImportFileOperationCommonReqDto commonReqDto, ImportFileOperationCommonRespDto respDto, Object obj) {
        TwoTuple twoTuple = (TwoTuple)obj;
        List saveList = (List)twoTuple.getFirst();
        List errorList = (List)twoTuple.getSecond();
        if (CollectionUtil.isNotEmpty((Collection)saveList)) {
            this.LOGGER.info("saveList,\u62a5\u5b58\u8d26\u5355\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)saveList));
            this.storageChargeBillApi.batchSave(saveList);
        }
        String errorMsgUrl = null;
        if (CollectionUtil.isNotEmpty((Collection)errorList)) {
            String excelName = String.format("%s%s", "\u4ed3\u50a8\u8d26\u5355\u5bfc\u5165\u9519\u8bef\u4fe1\u606f", commonReqDto.getTaskCode());
            errorMsgUrl = ExcelUtils.getExportUrl(errorList, ImportStorageChargeBillVO.class, null, excelName);
        }
        return errorMsgUrl;
    }

    private Map<String, CsPhysicsWarehousePageRespDto> queryPhysicalWareshouse() {
        CsPhysicsWarehousePageQueryDto csPhysicsWarehousePageQueryDto = new CsPhysicsWarehousePageQueryDto();
        csPhysicsWarehousePageQueryDto.setPageSize(Integer.valueOf(100));
        csPhysicsWarehousePageQueryDto.setPageNum(Integer.valueOf(1));
        RestResponse pageInfo = this.csPhysicsWarehouseExposedQueryApi.queryPageInfo(csPhysicsWarehousePageQueryDto);
        PageInfo page = (PageInfo)RestResponseHelper.extractData((RestResponse)pageInfo);
        return page.getList().stream().collect(Collectors.toMap(CsPhysicsWarehousePageRespDto::getWarehouseCode, Function.identity(), (k1, k2) -> k1));
    }

    private Map<String, StatisticsBillRespDto> queryOutPercentageProperty(List<String> warehouseCodes, List<String> billTimes, List<Long> ids) {
        HashMap listMap = Maps.newHashMap();
        StatisticsBillReqDto dto = new StatisticsBillReqDto();
        dto.setBillTimes(billTimes);
        dto.setWarehouseCodes(warehouseCodes);
        dto.setIds(ids);
        this.LOGGER.info("dto,\u67e5\u8be2\u4f53\u79ef\u677f\u6570\u5360\u6bd4\u603b\u548c\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)dto));
        List dtos = (List)RestResponseHelper.extractData((RestResponse)this.storageChargeBillApi.statisticsBillSum(dto));
        if (CollectionUtil.isNotEmpty((Collection)dtos)) {
            Map map = dtos.stream().collect(Collectors.toMap(i -> i.getBillTime() + "_" + i.getWarehouseCode(), Function.identity()));
            listMap.putAll(map);
        }
        return listMap;
    }

    private Map<String, OrgAdvDetailRespDto> queryOrgInfoMap() {
        Map<Object, Object> map = Maps.newHashMap();
        ThridOrganizationReqDto thridOrganizationReqDto = new ThridOrganizationReqDto();
        thridOrganizationReqDto.setPageNum(Integer.valueOf(1));
        thridOrganizationReqDto.setPageSize(Integer.valueOf(10000));
        PageInfo pageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.organizationQueryExtApi.queryOrgList(thridOrganizationReqDto));
        if (CollectionUtil.isNotEmpty((Collection)pageInfo.getList())) {
            map = pageInfo.getList().stream().collect(Collectors.toMap(OrgAdvDetailRespDto::getName, Function.identity(), (k1, k3) -> k1));
        }
        return map;
    }

    private void checkRepeatData(String uniqueKey, Set<String> checkRepeatData, ImportStorageChargeBillVO msgDto) {
        if (checkRepeatData.contains(uniqueKey)) {
            this.setMsg(msgDto, "\u6570\u636e\u91cd\u590d");
        } else {
            checkRepeatData.add(uniqueKey);
        }
    }

    private void setMsg(ImportStorageChargeBillVO msgDto, String errorMsg) {
        if (StringUtils.isBlank((CharSequence)msgDto.getErrorMsg())) {
            msgDto.setMsg(errorMsg);
        } else {
            msgDto.setMsg(String.format("%s\u3001%s", msgDto.getErrorMsg(), errorMsg));
        }
    }

    private Map<String, LogicWarehouseRespDto> getLogicWarehouseMap(Set<String> warehouseCodes) {
        Map<Object, Object> logicWarehouseMap = Maps.newHashMap();
        List warehouses = (List)RestResponseHelper.extractData((RestResponse)this.logicWarehouseQueryApi.queryWarehouseByCode((List)Lists.newArrayList(warehouseCodes)));
        if (CollectionUtil.isNotEmpty((Collection)warehouses)) {
            logicWarehouseMap = warehouses.stream().collect(Collectors.toMap(LogicWarehouseRespDto::getWarehouseCode, Function.identity(), (k1, k2) -> k1));
        }
        return logicWarehouseMap;
    }
}

