/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cis.pms.biz.service.impl;

import cn.afterturn.easypoi.excel.entity.result.ExcelImportResult;
import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.cis.pms.biz.constant.PmsCsShipmentLogisticsTypeEnum;
import com.dtyunxi.cis.pms.biz.model.BaseAreaVO;
import com.dtyunxi.cis.pms.biz.model.ImportBaseModeDto;
import com.dtyunxi.cis.pms.biz.model.ImportFileOperationCommonReqDto;
import com.dtyunxi.cis.pms.biz.model.ImportFileOperationCommonRespDto;
import com.dtyunxi.cis.pms.biz.model.logistic.TemplateFixPriceDto;
import com.dtyunxi.cis.pms.biz.model.logistic.TemplateFixPriceErrorDto;
import com.dtyunxi.cis.pms.biz.service.BasedataCenterAreaService;
import com.dtyunxi.cis.pms.biz.service.IImportCostReportDataCheckCommonService;
import com.dtyunxi.cis.pms.biz.service.operation.impl.HandlerFileOperationCommonServiceImpl;
import com.dtyunxi.cis.pms.biz.utils.DateConverterUtil;
import com.dtyunxi.cis.pms.biz.utils.ExcelUtils;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.finance.api.exception.ChargeModeEnum;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.IFinLogisticsReportApi;
import com.dtyunxi.tcbj.api.dto.constant.enums.LogisticDocumentTypeEnum;
import com.dtyunxi.tcbj.api.dto.request.FinLogisticDetailReqDto;
import com.dtyunxi.tcbj.api.dto.request.FinLogisticReportReqDto;
import com.dtyunxi.tcbj.api.dto.request.FinLogisticsReportDto;
import com.dtyunxi.tcbj.api.dto.request.OutResultOrderReqDto;
import com.dtyunxi.tcbj.api.dto.request.es.EsOutNoticeOrderListPageParams;
import com.dtyunxi.tcbj.api.dto.response.FinLogisticDetailRespDto;
import com.dtyunxi.tcbj.api.dto.response.LogicWarehouseRespDto;
import com.dtyunxi.tcbj.api.dto.response.OutResultOrderRespDto;
import com.dtyunxi.tcbj.api.dto.response.PCPCustomerRespDto;
import com.dtyunxi.tcbj.api.dto.response.es.OutNoticeOrderVO;
import com.dtyunxi.tcbj.api.query.IFinLogisticsReportQueryApi;
import com.dtyunxi.tcbj.api.query.ILogicWarehouseQueryApi;
import com.dtyunxi.tcbj.api.query.IOutResultOrderQueryApi;
import com.dtyunxi.tcbj.api.query.IPCPCustomerQueryApi;
import com.dtyunxi.tcbj.api.query.es.InventoryEsReportQueryApi;
import com.dtyunxi.yundt.cube.center.customer.api.dto.response.EasCostOrgRespDto;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.other.IcsShipmenetEnterpriseQueryApi;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.warehouse.ICsPhysicsWarehouseExposedApi;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.other.CsShipmenetEnterpriseQueryDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.warehouse.CsPhysicsWarehousePageQueryDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.other.CsShipmenetEnterpriseRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.warehouse.CsPhysicsWarehousePageRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.warehouse.CsPhysicsWarehouseRespDto;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsPcpBusinessTypeEnum;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.ThridOrganizationReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.OrgAdvDetailRespDto;
import com.dtyunxi.yundt.cube.center.user.api.query.IOrganizationQueryExtApi;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.yunxi.dg.base.center.report.api.entity.IDailyDeliveryReportApi;
import com.yunxi.dg.base.center.report.dto.entity.DailyDeliveryReportDto;
import com.yunxi.dg.base.center.report.dto.report.DailyDeliveryReportListQueryDto;
import com.yx.tcbj.center.customer.api.dto.request.PCPCustomerSearchReqDto;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service(value="abstractFileOperationCommonService_logistics_fix_price_import")
public class LogisticsFixPriceImportServiceImpl
extends HandlerFileOperationCommonServiceImpl {
    private static final Logger log = LoggerFactory.getLogger(LogisticsFixPriceImportServiceImpl.class);
    @Resource
    private IFinLogisticsReportQueryApi finLogisticsReportQueryApi;
    @Resource
    private IDailyDeliveryReportApi dailyDeliveryReportApi;
    @Resource
    private IFinLogisticsReportApi finLogisticsReportApi;
    @Resource
    private IOutResultOrderQueryApi outResultOrderQueryApi;
    @Resource
    private InventoryEsReportQueryApi inventoryEsReportQueryApi;
    @Resource
    private ICsPhysicsWarehouseExposedApi csPhysicsWarehouseExposedQueryApi;
    @Resource
    private IcsShipmenetEnterpriseQueryApi csShipmenetEnterpriseQueryApi;
    @Resource
    private ILogicWarehouseQueryApi logicWarehouseQueryApi;
    @Resource
    private IOrganizationQueryExtApi organizationQueryExtApi;
    @Resource
    private BasedataCenterAreaService basedataCenterAreaService;
    @Resource
    private IPCPCustomerQueryApi pcpCustomerQueryApi;
    @Resource
    private IImportCostReportDataCheckCommonService dataCheckCommonService;
    public static Map<String, String> BUSINESS_TYPE = new HashMap<String, String>();
    private final String ADD = "\u65b0\u589e";
    private final String UPD = "\u8986\u76d6";

    @Override
    public Object verifyImportFileOperationCommon(ExcelImportResult<ImportBaseModeDto> result, ImportFileOperationCommonReqDto commonReqDto, ImportFileOperationCommonRespDto respDto) {
        List mergeCodeList;
        ArrayList list = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)list, (Collection)result.getList(), TemplateFixPriceDto.class);
        log.info("\u7269\u6d41\u8d39\u7528\u5b9a\u4ef7\u5bfc\u5165\u6821\u9a8c\uff1a{}", (Object)JSON.toJSONString((Object)list));
        this.checkData(list);
        Map detailRespDtoMap = new HashMap();
        List detailRespDtoList = new ArrayList();
        List detailIds = list.stream().map(TemplateFixPriceDto::getId).filter(ObjectUtils::isNotEmpty).collect(Collectors.toList());
        if (CollectionUtil.isNotEmpty(detailIds)) {
            FinLogisticDetailReqDto detailReqDto = new FinLogisticDetailReqDto();
            detailReqDto.setIds(detailIds);
            log.info("\u67e5\u8be2\u660e\u7ec6\u4fe1\u606f\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)detailReqDto));
            detailRespDtoList = (List)RestResponseHelper.extractData((RestResponse)this.finLogisticsReportQueryApi.queryDetailList(detailReqDto));
            log.info("\u67e5\u8be2\u660e\u7ec6\u4fe1\u606f\u7ed3\u679c\uff1a{}", (Object)(CollectionUtil.isNotEmpty(detailRespDtoList) ? JSON.toJSONString(detailRespDtoList) : null));
            detailRespDtoMap = Optional.ofNullable(detailRespDtoList).map(m -> m.stream().collect(Collectors.toMap(FinLogisticDetailRespDto::getId, Function.identity(), (k1, k2) -> k1))).orElse(new HashMap());
        }
        Map masterDetailRespDtoMap = new HashMap();
        if (CollectionUtil.isNotEmpty(detailRespDtoList) && CollectionUtil.isNotEmpty(mergeCodeList = detailRespDtoList.stream().filter(f -> f.getType().equals(LogisticDocumentTypeEnum.MERGE_CHILD.getCode().toString()) && StringUtils.isNotBlank((CharSequence)f.getMergeCode())).map(FinLogisticDetailRespDto::getMergeCode).distinct().collect(Collectors.toList()))) {
            FinLogisticDetailReqDto masterDetailReqDto = new FinLogisticDetailReqDto();
            masterDetailReqDto.setType(LogisticDocumentTypeEnum.MERGE_MASTER.getCode().toString());
            masterDetailReqDto.setMergeCodeList(mergeCodeList);
            log.info("\u67e5\u8be2\u4e3b\u5355\u4fe1\u606f\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)masterDetailReqDto));
            List masterDetailRespDtoList = (List)RestResponseHelper.extractData((RestResponse)this.finLogisticsReportQueryApi.queryDetailList(masterDetailReqDto));
            log.info("\u67e5\u8be2\u4e3b\u5355\u4fe1\u606f\u7ed3\u679c\uff1a{}", (Object)(CollectionUtil.isNotEmpty((Collection)masterDetailRespDtoList) ? JSON.toJSONString((Object)masterDetailRespDtoList) : null));
            masterDetailRespDtoMap = Optional.ofNullable(masterDetailRespDtoList).map(m -> m.stream().collect(Collectors.toMap(FinLogisticDetailRespDto::getMergeCode, Function.identity(), (k1, k2) -> k1))).orElse(new HashMap());
        }
        Map<String, BaseAreaVO> areaMap = this.dataCheckCommonService.getAreaMap();
        this.addListCheck(list);
        for (TemplateFixPriceDto dto : list) {
            List collect;
            log.info("\u904d\u5386\u5904\u7406\u6570\u636e\uff1a{}", (Object)JSON.toJSONString((Object)((Object)dto)));
            if (StringUtils.isNotBlank((CharSequence)dto.getErrorMsg())) continue;
            if (StringUtils.isNotBlank((CharSequence)dto.getRangeOilPrice()) && !dto.getRangeOilPrice().contains("%")) {
                BigDecimal bigDecimal = new BigDecimal(dto.getRangeOilPrice());
                BigDecimal percentage = bigDecimal.movePointRight(2).setScale(2, RoundingMode.HALF_UP);
                dto.setRangeOilPrice(percentage + "%");
            }
            if (StringUtils.isNotBlank((CharSequence)dto.getSpecialExpense()) && StringUtils.isNotBlank((CharSequence)dto.getTotalFreight())) {
                BigDecimal subtract = new BigDecimal(dto.getTotalFreight()).subtract(new BigDecimal(dto.getSpecialExpense()));
                dto.setTotalFreight(subtract.toString());
            }
            if (dto.getImportType().equals("\u8986\u76d6")) {
                FinLogisticDetailRespDto detailRespDto = (FinLogisticDetailRespDto)detailRespDtoMap.get(dto.getId());
                if (ObjectUtils.isEmpty((Object)detailRespDto)) {
                    dto.setErrorMsg("\u627e\u4e0d\u5230\u5355\u636e\u4fe1\u606f\uff0c\u6570\u636eID\u5bf9\u5e94\u4e0d\u4e0a\u6570\u636e");
                    continue;
                }
                if (detailRespDto.getType().equals(LogisticDocumentTypeEnum.MERGE_CHILD.getCode().toString())) {
                    FinLogisticDetailRespDto masterDetailRespDto = (FinLogisticDetailRespDto)masterDetailRespDtoMap.get(detailRespDto.getMergeCode());
                    if (ObjectUtils.isEmpty((Object)masterDetailRespDto)) {
                        dto.setErrorMsg("\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u4e3b\u5355");
                        continue;
                    }
                    detailRespDto = masterDetailRespDto;
                }
                dto.setIfUpd(true);
                FinLogisticDetailReqDto updDto = (FinLogisticDetailReqDto)BeanUtil.copyProperties((Object)detailRespDto, FinLogisticDetailReqDto.class, (String[])new String[0]);
                updDto.setTransportPrice(StringUtils.isNotBlank((CharSequence)dto.getFreightPrice()) ? new BigDecimal(dto.getFreightPrice()) : null);
                updDto.setTransportAmount(StringUtils.isNotBlank((CharSequence)dto.getFreightAmount()) ? new BigDecimal(dto.getFreightAmount()) : null);
                updDto.setMinCharge(StringUtils.isNotBlank((CharSequence)dto.getMinimumCharge()) ? new BigDecimal(dto.getMinimumCharge()) : null);
                updDto.setDeliveryAmount(StringUtils.isNotBlank((CharSequence)dto.getDeliveryFee()) ? new BigDecimal(dto.getDeliveryFee()) : null);
                updDto.setUnloadAmount(StringUtils.isNotBlank((CharSequence)dto.getUnloadingFee()) ? new BigDecimal(dto.getUnloadingFee()) : null);
                updDto.setContractOilPrice(ObjectUtils.isNotEmpty((Object)dto.getContractOilPrice()) ? dto.getContractOilPrice() : null);
                updDto.setLinkOilPrice(ObjectUtils.isNotEmpty((Object)dto.getLinkOilPrice()) ? dto.getLinkOilPrice() : null);
                updDto.setRangeOilPrice(ObjectUtils.isNotEmpty((Object)dto.getRangeOilPrice()) ? dto.getRangeOilPrice() : null);
                updDto.setAdjustOilPrice(ObjectUtils.isNotEmpty((Object)dto.getAdjustOilPrice()) ? dto.getAdjustOilPrice() : null);
                updDto.setOilPrice(StringUtils.isNotBlank((CharSequence)dto.getOilPriceLinkage()) ? new BigDecimal(dto.getOilPriceLinkage()) : null);
                updDto.setSpecialType(StringUtils.isNotBlank((CharSequence)dto.getSpecialExpenseType()) ? dto.getSpecialExpenseType() : null);
                updDto.setSpecialAmount(StringUtils.isNotBlank((CharSequence)dto.getSpecialExpense()) ? new BigDecimal(dto.getSpecialExpense()) : null);
                updDto.setTotalTransportAmount(StringUtils.isNotBlank((CharSequence)dto.getTotalFreight()) ? new BigDecimal(dto.getTotalFreight()) : null);
                updDto.setAmountAttribution(StringUtils.isNotBlank((CharSequence)dto.getCostAttribution()) ? dto.getCostAttribution() : null);
                updDto.setRemark(dto.getRemark());
                updDto.setCalUnitName(dto.getCalUnitName());
                updDto.setStatus(Integer.valueOf(0));
                updDto.setAbnormalCauses("");
                dto.setDisDto(updDto);
                continue;
            }
            Map<String, String> checkAreaResp = this.dataCheckCommonService.checkAreaResp(areaMap, dto.getProvince(), dto.getAddressInfo(), dto.getArea());
            if (StringUtils.isNotBlank((CharSequence)checkAreaResp.get("error"))) {
                dto.setErrorMsg(checkAreaResp.get("error"));
            }
            dto.setIfUpd(false);
            FinLogisticDetailReqDto insDto = (FinLogisticDetailReqDto)BeanUtil.copyProperties((Object)((Object)dto), FinLogisticDetailReqDto.class, (String[])new String[0]);
            insDto.setHarvestPeople(dto.getConsignee());
            insDto.setEasNo(dto.getEasNo());
            insDto.setOutResultCode(dto.getDocumentNo());
            insDto.setOutNoticeCode(dto.getOutDocumentNo());
            insDto.setWmsOutboundCode(dto.getWmSDocumentNo());
            insDto.setHarvestAddress(dto.getReceiverAddress());
            insDto.setTransportCode(dto.getShippingNo());
            insDto.setOutboundTime(dto.getOrderShippingTime());
            insDto.setTransportNo(dto.getLogisticsNo());
            insDto.setBusinessCode(dto.getBusinessOrderNo());
            if (StringUtils.isNotBlank((CharSequence)dto.getBusinessType())) {
                for (CsPcpBusinessTypeEnum type : CsPcpBusinessTypeEnum.values()) {
                    if (!type.getDesc().equals(dto.getBusinessType())) continue;
                    insDto.setBusinessCode(type.getCode());
                    break;
                }
            }
            insDto.setBusinessType(dto.getBusinessType());
            try {
                insDto.setBottle(StringUtils.isNotBlank((CharSequence)dto.getBottlesNumber()) ? new BigDecimal(dto.getBottlesNumber()) : null);
            }
            catch (Exception e) {
                dto.setErrorMsg("\u74f6\u6570\u683c\u5f0f\u5f02\u5e38");
                continue;
            }
            try {
                insDto.setBox(StringUtils.isNotBlank((CharSequence)dto.getBoxNum()) ? new BigDecimal(dto.getBoxNum()) : null);
            }
            catch (Exception e) {
                dto.setErrorMsg("\u7bb1\u6570\u683c\u5f0f\u5f02\u5e38");
                continue;
            }
            try {
                insDto.setTotalBox(StringUtils.isNotBlank((CharSequence)dto.getAllBoxNum()) ? new BigDecimal(dto.getAllBoxNum()) : null);
            }
            catch (Exception e) {
                dto.setErrorMsg("\u7d2f\u8ba1\u5408\u5e76\u7bb1\u6570\u683c\u5f0f\u5f02\u5e38");
                continue;
            }
            try {
                insDto.setTotalVolume(StringUtils.isNotBlank((CharSequence)dto.getAllVolume()) ? new BigDecimal(dto.getAllVolume()) : null);
            }
            catch (Exception e) {
                dto.setErrorMsg("\u7d2f\u8ba1\u5408\u5e76\u4f53\u79ef\u683c\u5f0f\u5f02\u5e38");
                continue;
            }
            try {
                insDto.setTotalWeight(StringUtils.isNotBlank((CharSequence)dto.getAllWeight()) ? new BigDecimal(dto.getAllWeight()) : null);
            }
            catch (Exception e) {
                dto.setErrorMsg("\u7d2f\u8ba1\u5408\u5e76\u91cd\u91cf\u683c\u5f0f\u5f02\u5e38");
                continue;
            }
            insDto.setCalUnitName(dto.getCalUnitName());
            if (StringUtils.isNotBlank((CharSequence)dto.getBillingMethodName()) && CollectionUtil.isNotEmpty(collect = Arrays.stream(ChargeModeEnum.values()).filter(f -> f.getName().equals(dto.getBillingMethodName())).collect(Collectors.toList()))) {
                insDto.setChargeMode(((ChargeModeEnum)collect.get(0)).getType().toString());
            }
            insDto.setId(null);
            insDto.setBillingFeeFlag(Integer.valueOf(1));
            insDto.setType(LogisticDocumentTypeEnum.MERGE_OTHER.getCode().toString());
            insDto.setMergeCode(null);
            insDto.setLinkDailyReportId(null);
            insDto.setPlacedFlag(Integer.valueOf(0));
            insDto.setStatus(Integer.valueOf(0));
            insDto.setAbnormalCauses("");
            insDto.setBookkeepingDate(dto.getBookkeepingDate());
            insDto.setTransportPrice(StringUtils.isNotBlank((CharSequence)dto.getFreightPrice()) ? new BigDecimal(dto.getFreightPrice()) : null);
            insDto.setTransportAmount(StringUtils.isNotBlank((CharSequence)dto.getFreightAmount()) ? new BigDecimal(dto.getFreightAmount()) : null);
            insDto.setMinCharge(StringUtils.isNotBlank((CharSequence)dto.getMinimumCharge()) ? new BigDecimal(dto.getMinimumCharge()) : null);
            insDto.setDeliveryAmount(StringUtils.isNotBlank((CharSequence)dto.getDeliveryFee()) ? new BigDecimal(dto.getDeliveryFee()) : null);
            insDto.setUnloadAmount(StringUtils.isNotBlank((CharSequence)dto.getUnloadingFee()) ? new BigDecimal(dto.getUnloadingFee()) : null);
            insDto.setContractOilPrice(ObjectUtils.isNotEmpty((Object)dto.getContractOilPrice()) ? dto.getContractOilPrice() : null);
            insDto.setLinkOilPrice(ObjectUtils.isNotEmpty((Object)dto.getLinkOilPrice()) ? dto.getLinkOilPrice() : null);
            insDto.setRangeOilPrice(ObjectUtils.isNotEmpty((Object)dto.getRangeOilPrice()) ? dto.getRangeOilPrice() : null);
            insDto.setAdjustOilPrice(ObjectUtils.isNotEmpty((Object)dto.getAdjustOilPrice()) ? dto.getAdjustOilPrice() : null);
            insDto.setOilPrice(StringUtils.isNotBlank((CharSequence)dto.getOilPriceLinkage()) ? new BigDecimal(dto.getOilPriceLinkage()) : null);
            insDto.setSpecialType(StringUtils.isNotBlank((CharSequence)dto.getSpecialExpenseType()) ? dto.getSpecialExpenseType() : null);
            insDto.setSpecialAmount(StringUtils.isNotBlank((CharSequence)dto.getSpecialExpense()) ? new BigDecimal(dto.getSpecialExpense()) : null);
            insDto.setTotalTransportAmount(StringUtils.isNotBlank((CharSequence)dto.getTotalFreight()) ? new BigDecimal(dto.getTotalFreight()) : null);
            insDto.setAmountAttribution(StringUtils.isNotBlank((CharSequence)dto.getCostAttribution()) ? dto.getCostAttribution() : null);
            insDto.setRemark(dto.getRemark());
            insDto.setCalUnitName(dto.getCalUnitName());
            insDto.setShopName(dto.getShopName());
            insDto.setWarehouseName(dto.getOutPhysicsWarehouseName());
            insDto.setWarehouseOut(dto.getTransferIOutWarehouse());
            insDto.setWarehouseOutCode(dto.getTransferIOutWarehouseCode());
            insDto.setWarehouseEnter(dto.getTransferIIntoWarehouse());
            insDto.setWarehouseEnterCode(dto.getTransferIIntoWarehouseCode());
            insDto.setOrganizationOut(dto.getOutCargoRightName());
            insDto.setOrganizationEnter(dto.getInCargoRightName());
            insDto.setLogisticCompany(dto.getLogisticsCompany());
            insDto.setLogisticCompanyCode(dto.getLogisticsCode());
            insDto.setTransportType(dto.getLogisticsType());
            insDto.setProvince(dto.getProvince());
            insDto.setProvinceCode(checkAreaResp.get("province"));
            insDto.setCity(dto.getAddressInfo());
            insDto.setCityCode(checkAreaResp.get("city"));
            insDto.setArea(dto.getArea());
            insDto.setAreaCode(checkAreaResp.get("region"));
            if (ObjectUtils.isNotEmpty((Object)dto.getBillingDate())) {
                insDto.setBillingDate(DateUtil.getDateFormat((Date)dto.getBillingDate(), (String)"yyyy-MM-dd"));
            }
            dto.setDisDto(insDto);
        }
        return list;
    }

    private void addListCheck(List<TemplateFixPriceDto> list) {
        List addList = list.stream().filter(f -> f.getImportType().equals("\u65b0\u589e")).collect(Collectors.toList());
        if (CollectionUtil.isEmpty(addList)) {
            log.info("\u65e0\u65b0\u589e\u6570\u636e\u6821\u9a8c");
            return;
        }
        Map<String, EasCostOrgRespDto> costOrg = this.dataCheckCommonService.getCostOrg();
        Map<String, CsPhysicsWarehouseRespDto> physicsWarehouse = this.dataCheckCommonService.getPhysicsWarehouse();
        List<String> logicalWarehouseNameList = addList.stream().flatMap(vo -> Stream.of(vo.getTransferIOutWarehouse(), vo.getTransferIIntoWarehouse())).distinct().collect(Collectors.toList());
        Map<String, LogicWarehouseRespDto> logicalWarehouse = this.dataCheckCommonService.getLogicalWarehouse(logicalWarehouseNameList);
        Map<String, CsShipmenetEnterpriseRespDto> carrierMap = this.dataCheckCommonService.getCarrier();
        for (TemplateFixPriceDto vo2 : list) {
            if (!vo2.getImportType().equals("\u65b0\u589e")) continue;
            EasCostOrgRespDto easCostOrgRespDto = costOrg.get(vo2.getCostAttribution());
            if (ObjectUtil.isNotEmpty((Object)easCostOrgRespDto)) {
                vo2.setCostAttributionCode(easCostOrgRespDto.getEasOrgCode());
            }
            if (StringUtils.isNotBlank((CharSequence)vo2.getOutCargoRightName()) && ObjectUtil.isNotEmpty((Object)costOrg.get(vo2.getOutCargoRightName()))) {
                vo2.setOutCargoRightCode(costOrg.get(vo2.getOutCargoRightName()).getEasOrgCode());
            }
            if (StringUtils.isNotBlank((CharSequence)vo2.getInCargoRightName()) && ObjectUtil.isNotEmpty((Object)costOrg.get(vo2.getInCargoRightName()))) {
                vo2.setInCargoRightCode(costOrg.get(vo2.getInCargoRightName()).getEasOrgCode());
            }
            if (StringUtils.isNotBlank((CharSequence)vo2.getOutPhysicsWarehouseName())) {
                if (ObjectUtil.isEmpty((Object)physicsWarehouse.get(vo2.getOutPhysicsWarehouseName()))) {
                    vo2.setErrorMsg("\u51fa\u5e93\u7269\u7406\u4ed3\u4e0d\u5b58\u5728\uff1b");
                    continue;
                }
                vo2.setOutPhysicsWarehouseCode(physicsWarehouse.get(vo2.getOutPhysicsWarehouseName()).getWarehouseCode());
            }
            if (StringUtils.isNotBlank((CharSequence)vo2.getTransferIOutWarehouse())) {
                if (ObjectUtil.isEmpty((Object)logicalWarehouse.get(vo2.getTransferIOutWarehouse()))) {
                    vo2.setErrorMsg("\u51fa\u5e93\u903b\u8f91\u4ed3\u4e0d\u5b58\u5728\uff1b");
                    continue;
                }
                vo2.setTransferIOutWarehouseCode(logicalWarehouse.get(vo2.getTransferIOutWarehouse()).getWarehouseCode());
            }
            if (StringUtils.isNotBlank((CharSequence)vo2.getTransferIIntoWarehouse())) {
                if (ObjectUtil.isEmpty((Object)logicalWarehouse.get(vo2.getTransferIIntoWarehouse()))) {
                    vo2.setErrorMsg("\u5165\u5e93\u903b\u8f91\u4ed3\u4e0d\u5b58\u5728\uff1b");
                    continue;
                }
                vo2.setTransferIIntoWarehouseCode(logicalWarehouse.get(vo2.getTransferIIntoWarehouse()).getWarehouseCode());
            }
            if (!ObjectUtil.isNotEmpty((Object)carrierMap.get(vo2.getLogisticsCompany()))) {
                vo2.setErrorMsg("\u7269\u6d41\u5546\u4e0d\u5b58\u5728\uff1b");
                continue;
            }
            vo2.setLogisticsCode(carrierMap.get(vo2.getLogisticsCompany()).getShipmentEnterpriseCode());
            vo2.setLogisticCompanyTransportType(carrierMap.get(vo2.getLogisticsCompany()).getLogisticsType());
            Integer shippingTypeCode = PmsCsShipmentLogisticsTypeEnum.getTypeByDesc(vo2.getLogisticsType());
            if (ObjectUtil.isEmpty((Object)shippingTypeCode)) {
                vo2.setErrorMsg("\u627f\u8fd0\u65b9\u5f0f\u4e0d\u5b58\u5728\uff1b");
                continue;
            }
            vo2.setLogisticsTypeCode(shippingTypeCode.toString());
            if (!vo2.getLogisticCompanyTransportType().contains(vo2.getLogisticsTypeCode())) {
                vo2.setErrorMsg("\u8be5\u7269\u6d41\u5546\u4e0b\u4e0d\u5b58\u5728\u8be5\u627f\u8fd0\u65b9\u5f0f\uff1b");
                continue;
            }
            if (StringUtils.isNotBlank((CharSequence)vo2.getRangeOilPrice()) && !vo2.getRangeOilPrice().contains("%")) {
                BigDecimal bigDecimal = new BigDecimal(vo2.getRangeOilPrice());
                BigDecimal percentage = bigDecimal.movePointRight(2).setScale(2, RoundingMode.HALF_UP);
                vo2.setRangeOilPrice(percentage + "%");
            }
            if (!StringUtils.isNotBlank((CharSequence)vo2.getShippingNo())) continue;
            FinLogisticReportReqDto reqDto = new FinLogisticReportReqDto();
            reqDto.setTransportNo(vo2.getShippingNo());
            List respDtoList = ((PageInfo)RestResponseHelper.extractData((RestResponse)this.finLogisticsReportQueryApi.queryByPageForDailyDeliveryReport(reqDto))).getList();
            if (!CollectionUtils.isNotEmpty((Collection)respDtoList)) continue;
            vo2.setErrorMsg(vo2.getShippingNo() + "\uff0c\u7269\u6d41\u8fd0\u8d39\u62a5\u8868\u7684\u6258\u8fd0\u5355\u53f7\u5df2\u7ecf\u5b58\u4e0b\uff1b");
        }
    }

    @Override
    public String executeImportFileOperationCommon(ExcelImportResult<ImportBaseModeDto> result, ImportFileOperationCommonReqDto commonReqDto, ImportFileOperationCommonRespDto respDto, Object obj) {
        List list = (List)obj;
        log.info("\u7269\u6d41\u8d39\u7528\u5b9a\u4ef7\u5bfc\u5165\u6267\u884c\uff1a{}", (Object)JSON.toJSONString((Object)list));
        for (TemplateFixPriceDto dto : list) {
            if (StringUtils.isNotBlank((CharSequence)dto.getErrorMsg())) continue;
            try {
                Long l = (Long)RestResponseHelper.extractData((RestResponse)this.finLogisticsReportApi.updOrIns(dto.getDisDto()));
            }
            catch (Exception e) {
                log.error("\u7269\u6d41\u8d39\u7528\u5b9a\u4ef7\u5bfc\u5165\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
                log.error(e.getMessage(), (Throwable)e);
                dto.setErrorMsg((dto.getIfUpd() != false ? "\u66f4\u65b0" : "\u65b0\u589e") + "\u8d39\u7528\u4fe1\u606f\u5f02\u5e38\uff1a" + (e.getMessage().contains("\u6570\u636e\u5df2\u5f52\u6863\uff0c\u65e0\u6cd5\u8fdb\u884c\u64cd\u4f5c") ? "\u6570\u636e\u5df2\u5f52\u6863\uff0c\u65e0\u6cd5\u8fdb\u884c\u64cd\u4f5c" : e.getMessage()));
            }
        }
        String errorMsgUrl = null;
        List errorList = list.stream().filter(f -> StringUtils.isNotBlank((CharSequence)f.getErrorMsg())).collect(Collectors.toList());
        if (CollectionUtil.isNotEmpty(errorList)) {
            String excelName = String.format("%s%s", "\u7269\u6d41\u8d39\u7528\u5b9a\u4ef7\u5bfc\u5165\u9519\u8bef\u4fe1\u606f", commonReqDto.getTaskCode());
            errorMsgUrl = ExcelUtils.getExportUrl(errorList, TemplateFixPriceDto.class, null, excelName);
        }
        return errorMsgUrl;
    }

    public Object verifyImportFileOperationCommon2(ExcelImportResult<ImportBaseModeDto> result, ImportFileOperationCommonReqDto commonReqDto, ImportFileOperationCommonRespDto respDto) {
        ArrayList list = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)list, (Collection)result.getList(), TemplateFixPriceDto.class);
        HashMap<String, Map<String, List<FinLogisticDetailRespDto>>> yesMap = new HashMap<String, Map<String, List<FinLogisticDetailRespDto>>>();
        HashMap<String, List<FinLogisticDetailRespDto>> noMap = new HashMap<String, List<FinLogisticDetailRespDto>>();
        this.getFinLogisticDetailRespDtoMap(list, yesMap, noMap);
        log.info("\u83b7\u53d6\u4e00\u5355\u591a\u53d1\u7684\u7269\u6d41\u8d39\u7528\u62a5\u8868 \u548c \u975e\u4e00\u5355\u591a\u53d1\u7684\u7269\u6d41\u8d39\u7528\u62a5\u8868 ===== yesMap: {}, noMap: {}", (Object)JSON.toJSONString(yesMap), (Object)JSON.toJSONString(noMap));
        Map<String, OutResultOrderRespDto> allOutResultOrderMap = this.getAllOutResultOrderMap(list);
        log.info("\u83b7\u53d6\u6240\u6709\u51fa\u5e93\u7ed3\u679c\u5355\u53f7 ===== {}", allOutResultOrderMap.keySet());
        Map<String, OutNoticeOrderVO> allOutNoticeOrderMap = this.getAllOutNoticeOrderMap(list);
        log.info("\u83b7\u53d6\u6240\u6709\u51fa\u5e93\u901a\u77e5\u5355\u53f7 ===== {}", allOutNoticeOrderMap.keySet());
        Map<String, CsPhysicsWarehousePageRespDto> allPhysicsWarehouseMap = this.getAllPhysicsWarehouseMap();
        log.info("\u83b7\u53d6\u6240\u6709\u7269\u7406\u4ed3\u540d\u79f0 ===== {}", allPhysicsWarehouseMap.keySet());
        Map<String, CsShipmenetEnterpriseRespDto> allShipmenetEnterpriseMap = this.getAllShipmenetEnterpriseMap();
        log.info("\u83b7\u53d6\u6240\u6709\u7269\u6d41\u5546\u540d\u79f0 ===== {}", allShipmenetEnterpriseMap.keySet());
        Set<String> listLogicWarehouseNames = list.stream().flatMap(obj -> Stream.of(obj.getTransferIOutWarehouse(), obj.getTransferIIntoWarehouse())).collect(Collectors.toSet());
        Map<String, LogicWarehouseRespDto> allLogicWarehouseMap = this.getAllLogicWarehouseMap(listLogicWarehouseNames);
        log.info("\u83b7\u53d6\u6240\u6709\u903b\u8f91\u4ed3\u540d\u79f0 ===== {}", allShipmenetEnterpriseMap.keySet());
        Map<String, OrgAdvDetailRespDto> allOrg = this.getAllOrg();
        log.info("\u83b7\u53d6\u6240\u6709\u5e93\u5b58\u7ec4\u7ec7\u540d\u79f0 ====== {}", allOrg.keySet());
        List baseAres = (List)this.basedataCenterAreaService.getBaseAreaTreeByLevel("3").getData();
        log.info("\u83b7\u53d6\u6240\u6709\u7701\u4efd\u57ce\u5e02\u533a\u53bf ====== {}", (Object)JSON.toJSONString((Object)baseAres));
        Map<String, PCPCustomerRespDto> allCustomerMap = this.getAllCustomerMap();
        log.info("\u83b7\u53d6\u6240\u6709\u5ba2\u6237\u540d\u79f0 ===== {}", allCustomerMap.keySet());
        ArrayList saveList = Lists.newArrayList();
        ArrayList errorList = Lists.newArrayList();
        list.forEach(e -> {
            FinLogisticsReportDto saveDto = new FinLogisticsReportDto();
            TemplateFixPriceErrorDto error = new TemplateFixPriceErrorDto();
            BeanUtils.copyProperties((Object)e, (Object)((Object)error));
            StringBuffer errorMsg = new StringBuffer();
            this.checkDateFormat("\u8bb0\u8d26\u6708\u4efd", e.getBookkeepingDate(), "yyyy-MM", true, errorMsg);
            if (CollectionUtil.isEmpty((Map)yesMap) && CollectionUtil.isEmpty((Map)noMap)) {
                errorMsg.append("\u53d1\u8d27\u4fe1\u606f\u4e0d\u5b58\u5728\uff1b");
            } else if (!CollectionUtil.isEmpty((Map)yesMap) && yesMap.containsKey(e.getShippingNo())) {
                Map map = (Map)yesMap.get(e.getShippingNo());
                if (!map.containsKey(Optional.ofNullable(e.getWmSDocumentNo()).orElse(""))) {
                    errorMsg.append("\u53d1\u8d27\u4fe1\u606f\u4e0d\u5b58\u5728\uff1b");
                } else {
                    List list2 = (List)map.get(e.getWmSDocumentNo());
                    if (CollectionUtil.isEmpty((Collection)list2)) {
                        errorMsg.append("\u53d1\u8d27\u4fe1\u606f\u4e0d\u5b58\u5728\uff1b");
                    } else {
                        FinLogisticDetailRespDto dto = (FinLogisticDetailRespDto)list2.get(0);
                        log.info("\u5bfc\u5165\u4fe1\u606f\uff1a{}\uff1b\u6570\u636e\u5e93\u83b7\u53d6\u5230\u6570\u636e\uff1a{}", (Object)JSON.toJSONString((Object)e), (Object)JSON.toJSONString((Object)dto));
                        if (!Objects.equals(dto.getBookkeepingDate(), Optional.ofNullable(e.getBookkeepingDate()).orElse(""))) throw new BizException("\u6539\u5355\u636e\u5df2\u8ba1\u8d39\uff0c\u662f\u5426\u8981\u91cd\u590d\u5bfc\u5165");
                        saveDto.setId(dto.getId());
                        saveDto.setOilPrice(dto.getOilPrice());
                        saveDto.setDeliveryAmount(dto.getDeliveryAmount());
                        saveDto.setUnloadAmount(dto.getUnloadAmount());
                        saveDto.setSpecialAmount(dto.getSpecialAmount());
                    }
                }
            } else if (!CollectionUtil.isEmpty((Map)noMap) && noMap.containsKey(e.getShippingNo())) {
                List list2 = (List)noMap.get(e.getShippingNo());
                if (CollectionUtil.isEmpty((Collection)list2)) {
                    error.setErrorMsg("\u53d1\u8d27\u4fe1\u606f\u4e0d\u5b58\u5728");
                } else {
                    FinLogisticDetailRespDto dto = (FinLogisticDetailRespDto)list2.get(0);
                    saveDto.setId(dto.getId());
                    saveDto.setOilPrice(dto.getOilPrice());
                    saveDto.setDeliveryAmount(dto.getDeliveryAmount());
                    saveDto.setUnloadAmount(dto.getUnloadAmount());
                    saveDto.setSpecialAmount(dto.getSpecialAmount());
                }
            } else {
                error.setErrorMsg("\u53d1\u8d27\u4fe1\u606f\u4e0d\u5b58\u5728");
            }
            this.checkEnglishAndNumeralsFormat("WMS\u5408\u5355\u53f7", e.getWmsMergeDocumentNo(), 1, false, errorMsg);
            this.checkEnglishAndNumeralsFormat("EAS\u8ba2\u5355\u53f7", e.getEasNo(), 1, false, errorMsg);
            this.checkEnglishAndNumeralsFormat("\u627f\u8fd0\u5546\u5355\u53f7", e.getLogisticsNo(), 1, false, errorMsg);
            this.checkExistInSet("\u51fa\u5e93\u7ed3\u679c\u5355\u53f7", e.getDocumentNo(), allOutResultOrderMap.keySet(), false, errorMsg);
            this.checkExistInSet("\u51fa\u5e93\u901a\u77e5\u5355\u53f7", e.getOutDocumentNo(), allOutNoticeOrderMap.keySet(), false, errorMsg);
            if (StringUtils.isNotEmpty((CharSequence)e.getBusinessType()) && !BUSINESS_TYPE.containsKey(e.getBusinessType())) {
                errorMsg.append("\u4e1a\u52a1\u7c7b\u578b\u4e0d\u5b58\u5728\uff1b");
            }
            this.checkExistInSet("\u51fa\u5e93\u7269\u7406\u4ed3", e.getOutPhysicsWarehouseName(), allPhysicsWarehouseMap.keySet(), true, errorMsg);
            this.checkExistInSet("\u7269\u6d41\u516c\u53f8", e.getLogisticsCompany(), allShipmenetEnterpriseMap.keySet(), true, errorMsg);
            if (StringUtils.isNotEmpty((CharSequence)e.getLogisticsCompany()) && StringUtils.isNotEmpty((CharSequence)e.getLogisticsType())) {
                String logisticsType;
                List<String> logisticsTypeList;
                CsShipmenetEnterpriseRespDto csShipmenetEnterpriseRespDto = (CsShipmenetEnterpriseRespDto)allShipmenetEnterpriseMap.get(e.getLogisticsCompany());
                if (ObjectUtils.isNotEmpty((Object)csShipmenetEnterpriseRespDto) && !(logisticsTypeList = Arrays.asList((logisticsType = csShipmenetEnterpriseRespDto.getLogisticsType()).split(","))).contains(PmsCsShipmentLogisticsTypeEnum.getTypeByDesc(e.getLogisticsType()).toString())) {
                    errorMsg.append("\u627f\u8fd0\u65b9\u5f0f\u4e0d\u5b58\u5728\uff1b");
                }
            } else {
                errorMsg.append("\u627f\u8fd0\u65b9\u5f0f\u672a\u586b\u5199\uff1b");
            }
            this.checkEnglishAndNumeralsFormat("\u74f6\u6570", e.getBottlesNumber(), 2, false, errorMsg);
            this.checkEnglishAndNumeralsFormat("\u7bb1\u6570", e.getBoxNum(), 2, false, errorMsg);
            this.checkEnglishAndNumeralsFormat("\u4f53\u79ef", e.getVolume(), 3, false, errorMsg);
            this.checkEnglishAndNumeralsFormat("\u91cd\u91cf", e.getWeight(), 3, false, errorMsg);
            this.checkEnglishAndNumeralsFormat("\u5408\u5e76\u7bb1\u6570", e.getAllBoxNum(), 2, false, errorMsg);
            this.checkEnglishAndNumeralsFormat("\u7d2f\u8ba1\u5408\u5e76\u4f53\u79ef", e.getAllVolume(), 3, false, errorMsg);
            this.checkEnglishAndNumeralsFormat("\u7d2f\u8ba1\u5408\u5e76\u91cd\u91cf", e.getAllWeight(), 3, false, errorMsg);
            this.checkExistInSet("\u903b\u8f91\u4ed3", e.getTransferIOutWarehouse(), allLogicWarehouseMap.keySet(), false, errorMsg);
            this.checkExistInSet("\u5e93\u5b58\u7ec4\u7ec7", e.getOutCargoRightName(), allOrg.keySet(), false, errorMsg);
            this.checkExistInSet("\u903b\u8f91\u4ed3", e.getTransferIIntoWarehouse(), allLogicWarehouseMap.keySet(), false, errorMsg);
            this.checkExistInSet("\u5e93\u5b58\u7ec4\u7ec7", e.getInCargoRightName(), allOrg.keySet(), false, errorMsg);
            this.checkExistInSet("\u8ba1\u8d39\u7ec4\u7ec7", e.getCostAttribution(), allOrg.keySet(), true, errorMsg);
            if (StringUtils.isNotEmpty((CharSequence)e.getProvince())) {
                List province = baseAres.stream().filter(pro -> Objects.equals(pro.getName(), e.getProvince())).collect(Collectors.toList());
                if (CollectionUtils.isNotEmpty(province)) {
                    e.setProvinceCode(((BaseAreaVO)province.get(0)).getCode());
                    if (StringUtils.isNotEmpty((CharSequence)e.getAddressInfo())) {
                        List<BaseAreaVO> cities = ((BaseAreaVO)province.get(0)).getChildren();
                        List city = cities.stream().filter(cit -> Objects.equals(cit.getName(), e.getAddressInfo())).collect(Collectors.toList());
                        if (CollectionUtils.isNotEmpty(city)) {
                            e.setAddressInfoCode(((BaseAreaVO)city.get(0)).getCode());
                            if (StringUtils.isNotEmpty((CharSequence)e.getArea())) {
                                List<BaseAreaVO> areas = ((BaseAreaVO)city.get(0)).getChildren();
                                List area = areas.stream().filter(are -> Objects.equals(are.getName(), e.getArea())).collect(Collectors.toList());
                                if (CollectionUtils.isNotEmpty(area)) {
                                    e.setAreaCode(((BaseAreaVO)area.get(0)).getCode());
                                } else {
                                    errorMsg.append("\u533a\u53bf\u4e0d\u5b58\u5728\uff0c\u8bf7\u6309\u7167OCS\u7684\u5730\u5740\u5e93\u586b\u5199");
                                }
                            }
                        } else {
                            errorMsg.append("\u57ce\u5e02\u4e0d\u5b58\u5728\uff0c\u8bf7\u6309\u7167OCS\u7684\u5730\u5740\u5e93\u586b\u5199");
                        }
                    }
                } else {
                    errorMsg.append("\u7701\u4efd\u4e0d\u5b58\u5728\uff0c\u8bf7\u6309\u7167OCS\u7684\u5730\u5740\u5e93\u586b\u5199");
                }
            }
            this.checkExistInSet("\u5ba2\u6237\u540d\u79f0", e.getCustomerName(), allCustomerMap.keySet(), false, errorMsg);
            String errorMsgStr = errorMsg.toString();
            if (StringUtils.isNotEmpty((CharSequence)errorMsgStr)) {
                error.setErrorMsg(errorMsgStr);
                errorList.add(error);
                return;
            } else {
                saveDto.setType(StringUtils.isNotEmpty((CharSequence)e.getWmsMergeDocumentNo()) ? "5" : "6");
                saveDto.setOutNoticeCode(e.getOutDocumentNo());
                saveDto.setOutResultCode(e.getDocumentNo());
                saveDto.setWmsOutboundCode(e.getWmSDocumentNo());
                saveDto.setBusinessCode(e.getBusinessOrderNo());
                saveDto.setWarehouseName(e.getOutPhysicsWarehouseName());
                if (ObjectUtils.isNotEmpty(allPhysicsWarehouseMap.get(e.getOutPhysicsWarehouseName()))) {
                    saveDto.setWarehouseCode(((CsPhysicsWarehousePageRespDto)allPhysicsWarehouseMap.get(e.getOutPhysicsWarehouseName())).getWarehouseCode());
                }
                saveDto.setLogisticCompany(e.getLogisticsCompany());
                if (ObjectUtils.isNotEmpty(allShipmenetEnterpriseMap.get(e.getLogisticsCompany()))) {
                    saveDto.setLogisticCompanyCode(((CsShipmenetEnterpriseRespDto)allShipmenetEnterpriseMap.get(e.getLogisticsCompany())).getShipmentEnterpriseCode());
                }
                if (StringUtils.isNotEmpty((CharSequence)e.getLogisticsType())) {
                    saveDto.setTransportType(PmsCsShipmentLogisticsTypeEnum.getTypeByDesc(e.getLogisticsType()).toString());
                }
                saveDto.setTransportCode(e.getShippingNo());
                saveDto.setBottle(new BigDecimal(Optional.ofNullable(e.getBottlesNumber()).orElse("0")));
                saveDto.setBox(new BigDecimal(Optional.ofNullable(e.getBoxNum()).orElse("0")));
                saveDto.setVolume(new BigDecimal(Optional.ofNullable(e.getVolume()).orElse("0")).setScale(6, RoundingMode.HALF_UP));
                saveDto.setWeight(new BigDecimal(Optional.ofNullable(e.getWeight()).orElse("0")).setScale(6, RoundingMode.HALF_UP));
                saveDto.setTotalBox(new BigDecimal(Optional.ofNullable(e.getAllBoxNum()).orElse("0")));
                saveDto.setTotalVolume(new BigDecimal(Optional.ofNullable(e.getAllVolume()).orElse("0")).setScale(6, RoundingMode.HALF_UP));
                saveDto.setTotalWeight(new BigDecimal(Optional.ofNullable(e.getAllWeight()).orElse("0")).setScale(6, RoundingMode.HALF_UP));
                saveDto.setChargeMode("5");
                saveDto.setTransportPrice(new BigDecimal(Optional.ofNullable(e.getFreightPrice()).orElse("0")).setScale(10, RoundingMode.HALF_UP));
                saveDto.setTransportAmount(new BigDecimal(Optional.ofNullable(e.getFreightAmount()).orElse("0")).setScale(10, RoundingMode.HALF_UP));
                saveDto.setMinCharge(new BigDecimal(Optional.ofNullable(e.getMinimumCharge()).orElse("0")).setScale(10, RoundingMode.HALF_UP));
                saveDto.setDeliveryAmount(new BigDecimal(Optional.ofNullable(e.getDeliveryFee()).orElse("0")).setScale(10, RoundingMode.HALF_UP));
                saveDto.setUnloadAmount(new BigDecimal(Optional.ofNullable(e.getUnloadingFee()).orElse("0")).setScale(10, RoundingMode.HALF_UP));
                saveDto.setOilPrice(new BigDecimal(Optional.ofNullable(e.getOilPriceLinkage()).orElse("0")).setScale(10, RoundingMode.HALF_UP));
                saveDto.setSpecialType(e.getSpecialExpenseType());
                saveDto.setSpecialAmount(new BigDecimal(Optional.ofNullable(e.getSpecialExpense()).orElse("0")).setScale(10, RoundingMode.HALF_UP));
                saveDto.setTotalTransportAmount(new BigDecimal(Optional.ofNullable(e.getTotalFreight()).orElse("0")).setScale(10, RoundingMode.HALF_UP));
                if (ObjectUtils.isNotEmpty(allLogicWarehouseMap.get(e.getTransferIOutWarehouse()))) {
                    saveDto.setWarehouseOut(e.getTransferIOutWarehouse());
                    saveDto.setWarehouseOutCode(((LogicWarehouseRespDto)allLogicWarehouseMap.get(e.getTransferIOutWarehouse())).getWarehouseCode());
                }
                saveDto.setOrganizationOut(e.getOutCargoRightName());
                if (ObjectUtils.isNotEmpty(allLogicWarehouseMap.get(e.getTransferIIntoWarehouse()))) {
                    saveDto.setWarehouseEnter(e.getTransferIOutWarehouse());
                    saveDto.setWarehouseEnterCode(((LogicWarehouseRespDto)allLogicWarehouseMap.get(e.getTransferIIntoWarehouse())).getWarehouseCode());
                }
                saveDto.setOrganizationEnter(e.getInCargoRightName());
                saveDto.setAmountAttribution(e.getCostAttribution());
                saveDto.setHarvestPeople(e.getConsignee());
                saveDto.setProvince(e.getProvince());
                saveDto.setProvinceCode(e.getProvinceCode());
                saveDto.setCity(e.getAddressInfo());
                saveDto.setCityCode(e.getAddressInfoCode());
                saveDto.setArea(e.getArea());
                saveDto.setAreaCode(e.getAreaCode());
                saveDto.setHarvestAddress(e.getReceiverAddress());
                saveDto.setStatus(Integer.valueOf(0));
                saveDto.setRemark(e.getRemark());
                saveDto.setContractOilPrice(e.getContractOilPrice());
                saveDto.setRangeOilPrice(e.getRangeOilPrice());
                saveDto.setAdjustOilPrice(e.getAdjustOilPrice());
                saveDto.setCalUnitName(e.getCalUnitName());
                saveList.add(saveDto);
            }
        });
        HashMap map = Maps.newHashMap();
        map.put("saveList", saveList);
        map.put("msgList", errorList);
        return map;
    }

    public String executeImportFileOperationCommon2(ExcelImportResult<ImportBaseModeDto> result, ImportFileOperationCommonReqDto commonReqDto, ImportFileOperationCommonRespDto respDto, Object obj) {
        List msgList;
        List saveList;
        Map map = (Map)obj;
        Object saveObj = map.get("saveList");
        Object msgObj = map.get("msgList");
        if (saveObj != null && CollectionUtil.isNotEmpty((Collection)(saveList = (List)saveObj))) {
            this.finLogisticsReportApi.importLogisticsReport(saveList);
        }
        String errorMsgUrl = null;
        if (msgObj != null && CollectionUtil.isNotEmpty((Collection)(msgList = (List)msgObj))) {
            String excelName = String.format("%s%s", "\u5355\u636e\u8d39\u7528\u5bfc\u5165\u9519\u8bef\u4fe1\u606f", commonReqDto.getTaskCode());
            errorMsgUrl = ExcelUtils.getExportUrl(msgList, TemplateFixPriceErrorDto.class, null, excelName);
        }
        return errorMsgUrl;
    }

    private void checkDateFormat(String dateName, String dateStr, String format, boolean required, StringBuffer errorMsg) {
        if (StringUtils.isNotEmpty((CharSequence)dateStr)) {
            try {
                DateUtil.parseDate((String)dateStr, (String)format);
            }
            catch (Exception exception) {
                errorMsg.append(dateName).append("\u683c\u5f0f\u4e0d\u6b63\u786e\uff1b");
            }
        } else if (required) {
            errorMsg.append(dateName).append("\u672a\u586b\u5199\uff1b");
        }
    }

    private void checkEnglishAndNumeralsFormat(String dataName, String dataStr, Integer type, boolean required, StringBuffer errorMsg) {
        String regex1 = "^[A-Za-z0-9]+$";
        String regex2 = "^[1-9]\\d*$";
        String regex3 = "^[0-9]+(\\.[0-9]+)?$";
        if (StringUtils.isNotEmpty((CharSequence)dataStr)) {
            if (Objects.equals(type, 1) && !dataStr.matches(regex1) || Objects.equals(type, 2) && !dataStr.matches(regex2) || Objects.equals(type, 3) && !dataStr.matches(regex3)) {
                errorMsg.append(dataName).append("\u586b\u5199\u683c\u5f0f\u4e0d\u6b63\u786e\uff1b");
            }
        } else if (required) {
            errorMsg.append(dataName).append("\u672a\u586b\u5199\uff1b");
        }
    }

    private void checkExistInSet(String dataName, String dataStr, Set<String> allNos, boolean required, StringBuffer errorMsg) {
        log.info("\u6821\u9a8c {}\uff1a{} \u662f\u5426\u5b58\u5728\u67d0\u4e2a set \u4e2d", (Object)dataName, (Object)dataStr);
        if (StringUtils.isNotEmpty((CharSequence)dataStr)) {
            if (!allNos.contains(dataStr)) {
                errorMsg.append(dataName).append("\u4e0d\u5b58\u5728\uff1b");
            }
        } else if (required) {
            errorMsg.append(dataName).append("\u672a\u586b\u5199\uff1b");
        }
    }

    private Map<String, OutResultOrderRespDto> getAllOutResultOrderMap(List<TemplateFixPriceDto> list) {
        if (CollectionUtils.isEmpty(list)) {
            return new HashMap<String, OutResultOrderRespDto>();
        }
        List collect = list.stream().map(TemplateFixPriceDto::getDocumentNo).filter(StringUtils::isNotEmpty).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(collect)) {
            return new HashMap<String, OutResultOrderRespDto>();
        }
        OutResultOrderReqDto outResultOrderReqDto = new OutResultOrderReqDto();
        outResultOrderReqDto.setPageNum(Integer.valueOf(1));
        outResultOrderReqDto.setPageNum(Integer.valueOf(1000));
        outResultOrderReqDto.setDocumentNos(collect);
        ArrayList outResultOrderRespDtoList = new ArrayList();
        while (true) {
            log.info("\u83b7\u53d6\u6240\u6709\u51fa\u5e93\u7ed3\u679c\u5355\u53f7\uff1a{}", (Object)JSON.toJSONString((Object)outResultOrderReqDto));
            PageInfo pageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.outResultOrderQueryApi.queryByPage(outResultOrderReqDto));
            if (!CollectionUtils.isNotEmpty((Collection)pageInfo.getList())) break;
            outResultOrderRespDtoList.addAll(pageInfo.getList());
            outResultOrderReqDto.setPageNum(Integer.valueOf(outResultOrderReqDto.getPageNum() + 1));
        }
        if (CollectionUtils.isNotEmpty(outResultOrderRespDtoList)) {
            return outResultOrderRespDtoList.stream().collect(Collectors.toMap(OutResultOrderRespDto::getDocumentNo, Function.identity(), (o1, o2) -> o2));
        }
        return new HashMap<String, OutResultOrderRespDto>();
    }

    private Map<String, OutNoticeOrderVO> getAllOutNoticeOrderMap(List<TemplateFixPriceDto> list) {
        if (CollectionUtils.isEmpty(list)) {
            return new HashMap<String, OutNoticeOrderVO>();
        }
        List collect = list.stream().map(TemplateFixPriceDto::getOutDocumentNo).filter(StringUtils::isNotEmpty).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(collect)) {
            return new HashMap<String, OutNoticeOrderVO>();
        }
        EsOutNoticeOrderListPageParams esOutNoticeOrderListPageParams = new EsOutNoticeOrderListPageParams();
        esOutNoticeOrderListPageParams.setPageNum(Integer.valueOf(1));
        esOutNoticeOrderListPageParams.setPageSize(Integer.valueOf(1000));
        esOutNoticeOrderListPageParams.setDocumentNos(collect);
        ArrayList outNoticeOrderVOList = new ArrayList();
        while (true) {
            log.info("\u83b7\u53d6\u6240\u6709\u51fa\u5e93\u7ed3\u679c\u5355\u53f7\uff1a{}", (Object)JSON.toJSONString((Object)esOutNoticeOrderListPageParams));
            PageInfo pageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.inventoryEsReportQueryApi.queryOutNoticeOrderPage(esOutNoticeOrderListPageParams));
            if (!CollectionUtils.isNotEmpty((Collection)pageInfo.getList())) break;
            outNoticeOrderVOList.addAll(pageInfo.getList());
            esOutNoticeOrderListPageParams.setPageNum(Integer.valueOf(esOutNoticeOrderListPageParams.getPageNum() + 1));
        }
        if (CollectionUtils.isNotEmpty(outNoticeOrderVOList)) {
            outNoticeOrderVOList.stream().collect(Collectors.toMap(OutNoticeOrderVO::getDocumentNo, Function.identity(), (o1, o2) -> o2));
        }
        return new HashMap<String, OutNoticeOrderVO>();
    }

    private Map<String, CsPhysicsWarehousePageRespDto> getAllPhysicsWarehouseMap() {
        CsPhysicsWarehousePageQueryDto csPhysicsWarehousePageQueryDto = new CsPhysicsWarehousePageQueryDto();
        csPhysicsWarehousePageQueryDto.setPageNum(Integer.valueOf(1));
        csPhysicsWarehousePageQueryDto.setPageSize(Integer.valueOf(1000));
        RestResponse pageInfoRestResponse = this.csPhysicsWarehouseExposedQueryApi.queryPageInfo(csPhysicsWarehousePageQueryDto);
        if (CollectionUtils.isNotEmpty((Collection)((PageInfo)pageInfoRestResponse.getData()).getList())) {
            return ((PageInfo)pageInfoRestResponse.getData()).getList().stream().collect(Collectors.toMap(CsPhysicsWarehousePageRespDto::getWarehouseName, Function.identity(), (o1, o2) -> o2));
        }
        return new HashMap<String, CsPhysicsWarehousePageRespDto>();
    }

    private Map<String, CsShipmenetEnterpriseRespDto> getAllShipmenetEnterpriseMap() {
        CsShipmenetEnterpriseQueryDto csShipmenetEnterpriseQueryDto = new CsShipmenetEnterpriseQueryDto();
        csShipmenetEnterpriseQueryDto.setPageNum(Integer.valueOf(1));
        csShipmenetEnterpriseQueryDto.setPageSize(Integer.valueOf(1000));
        RestResponse pageInfoRestResponse = this.csShipmenetEnterpriseQueryApi.queryByPage(csShipmenetEnterpriseQueryDto);
        if (CollectionUtils.isNotEmpty((Collection)((PageInfo)pageInfoRestResponse.getData()).getList())) {
            return ((PageInfo)pageInfoRestResponse.getData()).getList().stream().collect(Collectors.toMap(CsShipmenetEnterpriseRespDto::getShipmentEnterpriseName, Function.identity(), (o1, o2) -> o2));
        }
        return new HashMap<String, CsShipmenetEnterpriseRespDto>();
    }

    private Map<String, LogicWarehouseRespDto> getAllLogicWarehouseMap(Set<String> warehouseNames) {
        List logicWarehouseRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.logicWarehouseQueryApi.queryWarehouseByName((List)Lists.newArrayList(warehouseNames)));
        if (CollectionUtils.isNotEmpty((Collection)logicWarehouseRespDtos)) {
            return logicWarehouseRespDtos.stream().collect(Collectors.toMap(LogicWarehouseRespDto::getWarehouseName, Function.identity(), (o1, o2) -> o2));
        }
        return new HashMap<String, LogicWarehouseRespDto>();
    }

    private Map<String, OrgAdvDetailRespDto> getAllOrg() {
        ThridOrganizationReqDto thridOrganizationReqDto = new ThridOrganizationReqDto();
        thridOrganizationReqDto.setPageNum(Integer.valueOf(1));
        thridOrganizationReqDto.setPageSize(Integer.valueOf(1000));
        RestResponse pageInfoRestResponse = this.organizationQueryExtApi.queryOrgList(thridOrganizationReqDto);
        if (CollectionUtils.isNotEmpty((Collection)((PageInfo)pageInfoRestResponse.getData()).getList())) {
            return ((PageInfo)pageInfoRestResponse.getData()).getList().stream().collect(Collectors.toMap(OrgAdvDetailRespDto::getName, Function.identity(), (o1, o2) -> o2));
        }
        return new HashMap<String, OrgAdvDetailRespDto>();
    }

    private Map<String, PCPCustomerRespDto> getAllCustomerMap() {
        PCPCustomerSearchReqDto searchReqDto = new PCPCustomerSearchReqDto();
        searchReqDto.setPageNum(Integer.valueOf(1));
        searchReqDto.setPageSize(Integer.valueOf(1000));
        searchReqDto.setOption(new ArrayList(1));
        RestResponse pageInfoRestResponse = this.pcpCustomerQueryApi.queryPCPCustomerDetailByPage(searchReqDto);
        if (CollectionUtils.isNotEmpty((Collection)((PageInfo)pageInfoRestResponse.getData()).getList())) {
            return ((PageInfo)pageInfoRestResponse.getData()).getList().stream().collect(Collectors.toMap(PCPCustomerRespDto::getCustomerName, Function.identity(), (o1, o2) -> o2));
        }
        return new HashMap<String, PCPCustomerRespDto>();
    }

    private void getFinLogisticDetailRespDtoMap(List<TemplateFixPriceDto> list, Map<String, Map<String, List<FinLogisticDetailRespDto>>> yesMap, Map<String, List<FinLogisticDetailRespDto>> noMap) {
        Map map = list.stream().collect(Collectors.groupingBy(TemplateFixPriceDto::getShippingNo, Collectors.mapping(TemplateFixPriceDto::getWmSDocumentNo, Collectors.toList())));
        for (Map.Entry entry : map.entrySet()) {
            String key = entry.getKey();
            DailyDeliveryReportListQueryDto queryDto = new DailyDeliveryReportListQueryDto();
            queryDto.setOrderNumber(key);
            PageInfo restResp = (PageInfo)RestResponseHelper.extractData((RestResponse)this.dailyDeliveryReportApi.queryByPage(queryDto, Integer.valueOf(1), Integer.valueOf(10)));
            List list2 = restResp.getList();
            if (!CollectionUtil.isNotEmpty((Collection)list2)) continue;
            if (((DailyDeliveryReportDto)list2.get(0)).getMuchDeliveryFlag() == 1) {
                HashMap<String, List> finLogisticDetailRespDtoMap = new HashMap<String, List>();
                List wmsOutboundCodes = entry.getValue();
                for (String wmsOutboundCode : wmsOutboundCodes) {
                    FinLogisticReportReqDto reqDto = new FinLogisticReportReqDto();
                    reqDto.setTransportCode(key);
                    reqDto.setWmsOutboundCode(Optional.ofNullable(wmsOutboundCode).orElse(""));
                    List list1 = ((PageInfo)RestResponseHelper.extractData((RestResponse)this.finLogisticsReportQueryApi.queryByPageForDailyDeliveryReport(reqDto))).getList();
                    finLogisticDetailRespDtoMap.put(wmsOutboundCode, list1);
                }
                yesMap.put(key, finLogisticDetailRespDtoMap);
                continue;
            }
            FinLogisticReportReqDto reqDto = new FinLogisticReportReqDto();
            reqDto.setTransportCode(key);
            List list1 = ((PageInfo)RestResponseHelper.extractData((RestResponse)this.finLogisticsReportQueryApi.queryByPageForDailyDeliveryReport(reqDto))).getList();
            noMap.put(key, list1);
        }
    }

    private void checkData(List<TemplateFixPriceDto> list) {
        list.forEach(dto -> {
            if (dto.getImportType().equals("\u65b0\u589e")) {
                if (StringUtils.isNotBlank((CharSequence)dto.getBillingDateStr())) {
                    try {
                        Date billingDate = DateConverterUtil.convertToStandardFormat(dto.getBillingDateStr());
                        dto.setBillingDate(billingDate);
                    }
                    catch (Exception e) {
                        dto.setErrorMsg("\u5f00\u5355\u65e5\u671f\u683c\u5f0f\u5f02\u5e38");
                    }
                }
                if (StringUtils.isNotBlank((CharSequence)dto.getOrderShippingTimeStr())) {
                    try {
                        Date orderShippingTime = DateConverterUtil.convertToStandardFormat(dto.getOrderShippingTimeStr());
                        dto.setOrderShippingTime(orderShippingTime);
                    }
                    catch (Exception e) {
                        dto.setErrorMsg("\u53d1\u8d27\u65e5\u671f\u683c\u5f0f\u5f02\u5e38");
                    }
                }
            }
        });
    }

    static {
        BUSINESS_TYPE.put("\u666e\u901a\u8ba2\u5355", "common_order");
        BUSINESS_TYPE.put("\u7ecf\u9500\u8ba2\u5355", "agency_order");
        BUSINESS_TYPE.put("\u7ecf\u9500\u5546\u79ef\u5206", "integral_order");
        BUSINESS_TYPE.put("\u6d88\u8d39\u8005\u9000\u6362\u8d27", "customer_refunding_order");
        BUSINESS_TYPE.put("\u7d22\u8d54\u8865\u53d1", "compensation_order");
        BUSINESS_TYPE.put("\u8425\u517b\u5bb6\u8d27\u8865", "replenishment_order");
        BUSINESS_TYPE.put("\u8d28\u91cf\u9000\u6362\u8d27", "quality_refunding_order");
        BUSINESS_TYPE.put("\u5c11\u8d27\u8865\u53d1", "replenish_order");
        BUSINESS_TYPE.put("\u4ed3\u5e93\u7d22\u8d54\u8865\u53d1", "claim_reissue");
        BUSINESS_TYPE.put("\u5176\u4ed6\u51fa\u5e93\u5355", "other_out_stock");
        BUSINESS_TYPE.put("\u5185\u90e8\u5206\u9500", "internal_distribution");
        BUSINESS_TYPE.put("\u4e8c\u7ea7\u5206\u9500", "secondary_distribution");
        BUSINESS_TYPE.put("\u5b50\u516c\u53f8\u76f4\u9500", "child_direct_sales");
        BUSINESS_TYPE.put("\u9884\u552e\u8ba2\u5355", "presale_order");
        BUSINESS_TYPE.put("\u8425\u517b\u5bb6\u6d3b\u52a8", "activity_order");
        BUSINESS_TYPE.put("\u8425\u517b\u5bb6\u79ef\u5206", "nutrition_integral");
        BUSINESS_TYPE.put("\u59d4\u5916\u8ba2\u5355\u9000\u8d27", "outsource_refund");
        BUSINESS_TYPE.put("\u91c7\u8d2d\u4fc3\u9500\u7269\u6599\u9000\u8d27", "purchase_refund");
        BUSINESS_TYPE.put("\u8c03\u62e8\u5355\uff08\u666e\u901a\u8c03\u62e8\uff09", "allot_out");
        BUSINESS_TYPE.put("\u5176\u4ed6\u51fa\u5e93", "other_out");
        BUSINESS_TYPE.put("\u5e93\u5b58\u8c03\u62e8\u5355\uff08\u8c03\u62e8\u51fa\u5e93\uff09", "allot_out_only");
        BUSINESS_TYPE.put("bc\u8c03\u62e8", "bc_allot");
        BUSINESS_TYPE.put("\u4f70\u5065\u76f4\u9500", "baijian_direct_sales");
        BUSINESS_TYPE.put("\u9500\u552e\u8c03\u62e8", "allot_sale");
        BUSINESS_TYPE.put("\u9ea6\u4f18\u666e\u901a\u8c03\u62e8", "maiyou_allot_out");
        BUSINESS_TYPE.put("\u9ea6\u4f18bc\u8de8\u7ec4\u7ec7\u8c03\u62e8", "maiyou_bc_allot");
        BUSINESS_TYPE.put("\u7279\u6e20\u8ba2\u5355", "special_channel_order");
    }
}

