/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cis.pms.biz.service.impl;

import cn.afterturn.easypoi.excel.entity.result.ExcelImportResult;
import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.cis.pms.biz.model.ExportCostSharingVo;
import com.dtyunxi.cis.pms.biz.model.ExportFileOperationCommonReqDto;
import com.dtyunxi.cis.pms.biz.model.ImportBaseModeDto;
import com.dtyunxi.cis.pms.biz.model.ImportChannelInventoryReportVo;
import com.dtyunxi.cis.pms.biz.model.ImportFileOperationCommonReqDto;
import com.dtyunxi.cis.pms.biz.model.ImportFileOperationCommonRespDto;
import com.dtyunxi.cis.pms.biz.service.IStorageChargeApportionService;
import com.dtyunxi.cis.pms.biz.service.operation.impl.HandlerFileOperationCommonServiceImpl;
import com.dtyunxi.cis.pms.biz.utils.ExcelUtils;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.cube.utils.enums.DatePattern;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.IStorageChargeApportionApi;
import com.dtyunxi.tcbj.api.dto.request.ApportionOrgReqDto;
import com.dtyunxi.tcbj.api.dto.request.StorageChargeApportionReqDto;
import com.dtyunxi.tcbj.api.dto.response.StorageChargeApportionRespDto;
import com.dtyunxi.tcbj.api.query.IStorageChargeApportionQueryApi;
import com.dtyunxi.util.DateUtil;
import com.dtyunxi.util.ParamConverter;
import com.dtyunxi.yundt.cube.center.data.api.dto.TwoTuple;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.warehouse.ICsLogicWarehouseQueryApi;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.warehouse.CsLogicWarehouseRespDto;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service(value="abstractFileOperationCommonService_cost_sharing")
public class StorageChargeApportionServiceImpl
extends HandlerFileOperationCommonServiceImpl
implements IStorageChargeApportionService {
    private final Logger LOGGER = LoggerFactory.getLogger(IStorageChargeApportionService.class);
    @Resource
    private IStorageChargeApportionApi storageChargeApportionApi;
    @Resource
    private IStorageChargeApportionQueryApi storageChargeApportionQueryApi;
    @Resource
    private ICsLogicWarehouseQueryApi csLogicWarehouseQueryApi;

    @Override
    public RestResponse<PageInfo<StorageChargeApportionRespDto>> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        return this.storageChargeApportionQueryApi.queryByPage(filter, pageNum, pageSize);
    }

    @Override
    public String exportFileOperationCommon(ExportFileOperationCommonReqDto commonReqDto) {
        String filter = commonReqDto.getFilter();
        List<String> urls = this.exportExcelHelper.doBigDataDivideDataExport(re -> {
            PageInfo pageInfo = (PageInfo)RestResponseHelper.extractData(this.queryByPage(filter, commonReqDto.getPageNum(), commonReqDto.getPageSize()));
            PageInfo voPageInfo = new PageInfo();
            BeanUtils.copyProperties((Object)pageInfo, (Object)voPageInfo);
            voPageInfo.setList(pageInfo.getList().stream().map(o -> {
                ExportCostSharingVo vo = new ExportCostSharingVo();
                BeanUtils.copyProperties((Object)o, (Object)((Object)vo));
                vo.setRecordMonth(DateUtil.format((Date)o.getStartRecordMonth(), (String)DatePattern.DATE_PATTERN.getPattern()) + "~" + DateUtil.format((Date)o.getEndRecordMonth(), (String)DatePattern.DATE_PATTERN.getPattern()));
                return vo;
            }).collect(Collectors.toList()));
            return voPageInfo;
        }, filter, ExportCostSharingVo.class, commonReqDto.getFileName());
        return String.join((CharSequence)",", urls);
    }

    @Override
    public Integer exportTotal(ExportFileOperationCommonReqDto commonReqDto) {
        RestResponse<PageInfo<StorageChargeApportionRespDto>> pageInfoRestResponse = this.queryByPage(commonReqDto.getFilter(), 1, 1);
        PageInfo respDtoPageInfo = (PageInfo)pageInfoRestResponse.getData();
        if (CollectionUtils.isEmpty((Collection)respDtoPageInfo.getList())) {
            return 0;
        }
        return ParamConverter.convertToInteger((Object)respDtoPageInfo.getTotal());
    }

    public RestResponse storageChargeApportion(StorageChargeApportionReqDto storageChargeApportionReqDto) {
        RestResponseHelper.extractData((RestResponse)this.storageChargeApportionApi.storageChargeApportion(storageChargeApportionReqDto));
        return RestResponse.SUCCESS;
    }

    @Override
    public String executeImportFileOperationCommon(ExcelImportResult<ImportBaseModeDto> result, ImportFileOperationCommonReqDto commonReqDto, ImportFileOperationCommonRespDto respDto, Object obj) {
        TwoTuple twoTuple = (TwoTuple)obj;
        this.LOGGER.info("\u4ed3\u50a8\u8d39\u7528\u5206\u644a\u5bfc\u5165\u6570\u636e\u6267\u884c\uff1a{}", (Object)JSON.toJSONString((Object)twoTuple));
        List saveList = (List)twoTuple.getFirst();
        List errorList = (List)twoTuple.getSecond();
        Map<Long, List<ImportChannelInventoryReportVo>> saveGroupList = saveList.stream().collect(Collectors.groupingBy(ImportChannelInventoryReportVo::getId));
        saveGroupList.forEach((k, v) -> {
            ImportChannelInventoryReportVo vo = (ImportChannelInventoryReportVo)((Object)((Object)v.get(0)));
            StorageChargeApportionReqDto reqDto = new StorageChargeApportionReqDto();
            reqDto.setId(vo.getId());
            reqDto.setBillTime(vo.getBillTime());
            List detailList = v.stream().map(l -> {
                ApportionOrgReqDto detail = new ApportionOrgReqDto();
                detail.setApportionNum(l.getApportionNum());
                detail.setApportionOrgId(l.getApportionOrgId());
                detail.setApportionOrgName(l.getApportionOrgName());
                detail.setLogicWarehouseName(l.getApportionLogicWarehouseName());
                return detail;
            }).collect(Collectors.toList());
            reqDto.setApportionOrgReqDtoList(detailList);
            try {
                RestResponseHelper.extractData((RestResponse)this.storageChargeApportion(reqDto));
            }
            catch (Exception e) {
                this.LOGGER.error(e.getMessage(), (Throwable)e);
                v.forEach(dto -> this.setErrorList((ImportChannelInventoryReportVo)((Object)((Object)dto)), "\u6267\u884c\u5931\u8d25\uff1a" + e.getMessage(), errorList));
            }
        });
        String errorMsgUrl = null;
        if (CollectionUtil.isNotEmpty((Collection)errorList)) {
            String excelName = String.format("%s%s", "\u4ed3\u50a8\u8d39\u7528\u5206\u644a\u5bfc\u5165\u9519\u8bef\u4fe1\u606f", commonReqDto.getTaskCode());
            errorMsgUrl = ExcelUtils.getExportUrl(errorList, ImportChannelInventoryReportVo.class, null, excelName);
        }
        return errorMsgUrl;
    }

    @Override
    public Object verifyImportFileOperationCommon(ExcelImportResult<ImportBaseModeDto> result, ImportFileOperationCommonReqDto commonReqDto, ImportFileOperationCommonRespDto respDto) {
        this.LOGGER.info("\u4ed3\u50a8\u8d39\u7528\u5206\u644a\u5bfc\u5165\u6570\u636e\u6821\u9a8c\uff1a{}", (Object)JSON.toJSONString((Object)result.getList()));
        ArrayList<ImportChannelInventoryReportVo> errorList = new ArrayList<ImportChannelInventoryReportVo>();
        ArrayList<ImportChannelInventoryReportVo> saveList = new ArrayList<ImportChannelInventoryReportVo>();
        ArrayList resultList = new ArrayList();
        CubeBeanUtils.copyCollection(resultList, (Collection)result.getList(), ImportChannelInventoryReportVo.class);
        Map<Object, Object> cargoOrgNameMap = new HashMap();
        Map<Object, Object> logicWarehouseMap = new HashMap();
        List logicWarehouseRespDtoList = (List)RestResponseHelper.extractData((RestResponse)this.csLogicWarehouseQueryApi.queryListAll());
        if (CollectionUtils.isNotEmpty((Collection)logicWarehouseRespDtoList)) {
            cargoOrgNameMap = logicWarehouseRespDtoList.stream().filter(f -> StringUtils.isNotBlank((CharSequence)f.getCargoEscheatageName()) && ObjectUtils.isNotEmpty((Object)f.getOrganizationId())).collect(Collectors.toMap(CsLogicWarehouseRespDto::getCostOrgName, CsLogicWarehouseRespDto::getCostOrgId, (k1, k3) -> k1));
            logicWarehouseMap = logicWarehouseRespDtoList.stream().filter(f -> StringUtils.isNotBlank((CharSequence)f.getCostOrgName())).collect(Collectors.toMap(r -> r.getCostOrgName() + r.getPhysicsWarehouseName() + r.getWarehouseName(), Function.identity(), (k1, k3) -> k1));
        }
        for (ImportChannelInventoryReportVo vo : resultList) {
            if (ObjectUtils.isEmpty((Object)vo.getId())) {
                this.setErrorList(vo, "\u4eba\u5de5\u5206\u644aID\u4e0d\u80fd\u7a7a", errorList);
                continue;
            }
            if (StringUtils.isBlank((CharSequence)vo.getApportionOrgName())) {
                this.setErrorList(vo, "\u5206\u644a\u5e93\u5b58\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a", errorList);
                continue;
            }
            if (ObjectUtils.isEmpty((Object)cargoOrgNameMap.get(vo.getApportionOrgName()))) {
                this.setErrorList(vo, "\u5206\u644a\u7ec4\u7ec7\u4e0d\u5b58\u5728", errorList);
                continue;
            }
            vo.setApportionOrgId((Long)cargoOrgNameMap.get(vo.getApportionOrgName()));
            if (StringUtils.isNotBlank((CharSequence)vo.getApportionLogicWarehouseName())) {
                CsLogicWarehouseRespDto warehouseRespDto = (CsLogicWarehouseRespDto)logicWarehouseMap.get(vo.getApportionOrgName() + vo.getPhysicsWarehouseName() + vo.getApportionLogicWarehouseName());
                if (ObjectUtils.isEmpty((Object)warehouseRespDto)) {
                    this.setErrorList(vo, "\u903b\u8f91\u4ed3\u5e93\u4e0d\u5b58\u5728\uff0c\u6216\u975e\u8be5\u5e93\u5b58\u7ec4\u7ec7\u53ca\u7269\u7406\u4ed3\u4e0b", errorList);
                    continue;
                }
                vo.setApportionLogicWarehouseCode(warehouseRespDto.getWarehouseCode());
            }
            if (ObjectUtils.isEmpty((Object)vo.getApportionNum()) || vo.getApportionNum() <= 0) {
                this.setErrorList(vo, "\u5206\u644a\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a\u4e0d\u80fd\u4e3a0", errorList);
                continue;
            }
            if (StringUtils.isBlank((CharSequence)vo.getBillTime())) {
                if (StringUtils.isBlank((CharSequence)vo.getRecordMonth())) {
                    this.setErrorList(vo, "\u8bb0\u8d26\u6708\u4efd\u548c\u7edf\u8ba1\u65e5\u671f\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a", errorList);
                    continue;
                }
                vo.setBillTime(vo.getRecordMonth());
            }
            saveList.add(vo);
        }
        return new TwoTuple(saveList, errorList);
    }

    private void setErrorList(ImportChannelInventoryReportVo vo, String msg, List<ImportChannelInventoryReportVo> errorList) {
        vo.setErrorMsg(msg);
        vo.setMsg(msg);
        errorList.add(vo);
    }
}

