/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cis.pms.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cis.pms.biz.enums.DeriveTypeEnum;
import com.dtyunxi.cis.pms.biz.model.ExportFileOperationCommonReqDto;
import com.dtyunxi.cis.pms.biz.model.ExportInventoryDetailReportVO;
import com.dtyunxi.cis.pms.biz.model.GetInventoryDetailReportListPageParams;
import com.dtyunxi.cis.pms.biz.model.InventoryDetailReportVO;
import com.dtyunxi.cis.pms.biz.service.ReportCenterInventoryReportInventoryDetailReportService;
import com.dtyunxi.cis.pms.biz.service.operation.ModeTypeEnum;
import com.dtyunxi.cis.pms.biz.service.operation.impl.HandlerFileOperationCommonServiceImpl;
import com.dtyunxi.cis.pms.biz.utils.EasyPoiExportUtil;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.cube.utils.enums.DatePattern;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.request.InventoryDetailReportListPageReqDto;
import com.dtyunxi.tcbj.api.query.IInventoryDetailReportQueryApi;
import com.dtyunxi.util.DateUtil;
import com.dtyunxi.util.ParamConverter;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import io.swagger.annotations.ApiParam;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.validation.Valid;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.RequestBody;

@Service(value="abstractFileOperationCommonService_inventory_detail_report")
public class ReportCenterInventoryReportInventoryDetailReportServiceServiceImpl
extends HandlerFileOperationCommonServiceImpl
implements ReportCenterInventoryReportInventoryDetailReportService {
    private static final Logger logger = LoggerFactory.getLogger(ReportCenterInventoryReportInventoryDetailReportServiceServiceImpl.class);
    @Resource
    private IInventoryDetailReportQueryApi inventoryDetailReportQueryApi;

    @Override
    public RestResponse<PageInfo<InventoryDetailReportVO>> getInventoryDetailReportListPage(@ApiParam(value="") @Valid @RequestBody(required=false) GetInventoryDetailReportListPageParams getInventoryDetailReportListPageParams) {
        InventoryDetailReportListPageReqDto pageParams = new InventoryDetailReportListPageReqDto();
        this.getParams(getInventoryDetailReportListPageParams, pageParams);
        PageInfo respVoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.inventoryDetailReportQueryApi.queryInventoryDetailReport(pageParams));
        logger.info("respVoPageInfo,\u67e5\u8be2\u7ed3\u679c\uff1a{}", (Object)JSON.toJSONString((Object)respVoPageInfo));
        if (CollectionUtils.isEmpty((Collection)respVoPageInfo.getList())) {
            return new RestResponse();
        }
        PageInfo pageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)pageInfo, (Object)respVoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        List list = respVoPageInfo.getList().stream().map(o -> {
            InventoryDetailReportVO vo = new InventoryDetailReportVO();
            BeanUtils.copyProperties((Object)o, (Object)vo);
            if (!ObjectUtils.isEmpty((Object)o.getExpireTime())) {
                vo.setExpireTime(DateUtil.format((Date)o.getExpireTime(), (String)DatePattern.DATE_PATTERN.getPattern()));
            }
            if (!ObjectUtils.isEmpty((Object)o.getProduceTime())) {
                vo.setProduceTime(DateUtil.format((Date)o.getProduceTime(), (String)DatePattern.DATE_PATTERN.getPattern()));
            }
            if (!ObjectUtils.isEmpty((Object)o.getStatisticsTime())) {
                vo.setStatisticsTime(DateUtil.format((Date)o.getStatisticsTime(), (String)DatePattern.DATE_PATTERN.getPattern()));
            }
            if (!ObjectUtils.isEmpty((Object)o.getCreateTime())) {
                vo.setCreateTime(DateUtil.format((Date)o.getCreateTime(), (String)DatePattern.DATETIME_PATTERN.getPattern()));
            }
            return vo;
        }).collect(Collectors.toList());
        pageInfo.setList(list);
        logger.info("pageInfo,\u67e5\u8be2\u7ed3\u679c\uff1a{}", (Object)JSON.toJSONString((Object)pageInfo));
        return new RestResponse((Object)pageInfo);
    }

    private void getParams(GetInventoryDetailReportListPageParams getInventoryDetailReportListPageParams, InventoryDetailReportListPageReqDto pageParams) {
        BeanUtils.copyProperties((Object)getInventoryDetailReportListPageParams, (Object)pageParams);
    }

    @Override
    public Integer exportTotal(ExportFileOperationCommonReqDto commonReqDto) {
        String filter = commonReqDto.getFilter();
        GetInventoryDetailReportListPageParams params = new GetInventoryDetailReportListPageParams();
        InventoryDetailReportListPageReqDto queryDto = new InventoryDetailReportListPageReqDto();
        if (StringUtils.isNotBlank((CharSequence)commonReqDto.getFilter())) {
            params = (GetInventoryDetailReportListPageParams)JSON.parseObject((String)commonReqDto.getFilter(), GetInventoryDetailReportListPageParams.class);
            this.getParams(params, queryDto);
        }
        queryDto.setPageNum(Integer.valueOf(1));
        queryDto.setPageSize(Integer.valueOf(1));
        logger.info("\u5e93\u5b58\u6536\u53d1\u660e\u7ec6\u62a5\u8868\u603b\u6570\u67e5\u8be2\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)queryDto));
        PageInfo respVoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.inventoryDetailReportQueryApi.queryInventoryDetailReport(queryDto));
        logger.info("\u5e93\u5b58\u6536\u53d1\u660e\u7ec6\u62a5\u8868\u603b\u6570\u67e5\u8be2\u51fa\u53c2:{}", (Object)JSON.toJSONString((Object)respVoPageInfo));
        if (CollectionUtils.isEmpty((Collection)respVoPageInfo.getList())) {
            return 0;
        }
        return ParamConverter.convertToInteger((Object)respVoPageInfo.getTotal());
    }

    @Override
    public String exportFileOperationCommon(ExportFileOperationCommonReqDto commonReqDto) {
        String filter = commonReqDto.getFilter();
        GetInventoryDetailReportListPageParams params = new GetInventoryDetailReportListPageParams();
        InventoryDetailReportListPageReqDto queryDto = new InventoryDetailReportListPageReqDto();
        if (StringUtils.isNotBlank((CharSequence)commonReqDto.getFilter())) {
            params = (GetInventoryDetailReportListPageParams)JSON.parseObject((String)commonReqDto.getFilter(), GetInventoryDetailReportListPageParams.class);
            this.getParams(params, queryDto);
        }
        Integer dtoPageSize = commonReqDto.getPageSize();
        Integer dtoPageNum = commonReqDto.getPageNum();
        ArrayList list = Lists.newArrayList();
        for (int i = 0; i < dtoPageNum; ++i) {
            Integer pageSize = 10000;
            Integer pageNum = 0 + i * 5;
            if (dtoPageSize <= pageSize) {
                pageNum = 1 + i * 5;
                pageSize = dtoPageSize;
            } else {
                pageNum = dtoPageSize % pageSize > 0 ? Integer.valueOf(dtoPageSize / pageSize + 1 + i * 5) : Integer.valueOf(dtoPageSize / pageSize + i * 5);
            }
            for (int j = 1 + i * 5; j < pageNum + 1; ++j) {
                queryDto.setPageNum(Integer.valueOf(j));
                queryDto.setPageSize(pageSize);
                logger.info("\u5e93\u5b58\u6536\u53d1\u660e\u7ec6\u62a5\u8868\u603b\u6570\u67e5\u8be2\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)queryDto));
                PageInfo respVoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.inventoryDetailReportQueryApi.queryInventoryDetailReport(queryDto));
                logger.info("\u5e93\u5b58\u6536\u53d1\u660e\u7ec6\u62a5\u8868\u603b\u6570\u67e5\u8be2\u51fa\u53c2:{}", (Object)respVoPageInfo.getTotal());
                if (!CollectionUtils.isNotEmpty((Collection)respVoPageInfo.getList())) continue;
                respVoPageInfo.getList().forEach(o -> {
                    ExportInventoryDetailReportVO vo = new ExportInventoryDetailReportVO();
                    BeanUtils.copyProperties((Object)o, (Object)((Object)vo));
                    if (!ObjectUtils.isEmpty((Object)o.getStatisticsTime())) {
                        vo.setStatisticsTime(DateUtil.format((Date)o.getStatisticsTime(), (String)DatePattern.DATE_PATTERN.getPattern()));
                    }
                    if (!ObjectUtils.isEmpty((Object)o.getCreateTime())) {
                        vo.setCreateTime(DateUtil.format((Date)o.getCreateTime(), (String)DatePattern.DATE_PATTERN.getPattern()));
                    }
                    if (!ObjectUtils.isEmpty((Object)o.getProduceTime())) {
                        vo.setProduceTime(DateUtil.format((Date)o.getProduceTime(), (String)DatePattern.DATE_PATTERN.getPattern()));
                    }
                    if (!ObjectUtils.isEmpty((Object)o.getExpireTime())) {
                        vo.setExpireTime(DateUtil.format((Date)o.getExpireTime(), (String)DatePattern.DATE_PATTERN.getPattern()));
                    }
                    vo.setInventoryQuantity(o.getInventoryQuantity().setScale(0, 1).toString());
                    vo.setBusinessType(Optional.ofNullable(DeriveTypeEnum.getMsgByCode(o.getBusinessType())).orElse(""));
                    list.add(vo);
                });
            }
        }
        ModeTypeEnum anEnum = ModeTypeEnum.getInstance(commonReqDto.getKey());
        return EasyPoiExportUtil.uploadFile((List)list, anEnum.getExportTemplate(), commonReqDto.getFileName());
    }
}

