/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cis.pms.biz.service.impl;

import cn.afterturn.easypoi.excel.entity.result.ExcelImportResult;
import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cis.pms.biz.model.ImportBaseModeDto;
import com.dtyunxi.cis.pms.biz.model.ImportFileOperationCommonReqDto;
import com.dtyunxi.cis.pms.biz.model.ImportFileOperationCommonRespDto;
import com.dtyunxi.cis.pms.biz.model.InspectionReleasePlanMsgVo;
import com.dtyunxi.cis.pms.biz.model.InspectionReleasePlanVo;
import com.dtyunxi.cis.pms.biz.service.ImportTransferOrderAssistService;
import com.dtyunxi.cis.pms.biz.service.operation.impl.HandlerFileOperationCommonServiceImpl;
import com.dtyunxi.cis.pms.biz.utils.ExcelUtils;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.request.InspectionReleaseOrderReportReqDto;
import com.dtyunxi.tcbj.api.dto.request.InspectionReleasePlanReqDto;
import com.dtyunxi.tcbj.api.dto.response.InspectionReleaseOrderReportRespDto;
import com.dtyunxi.tcbj.api.dto.response.InspectionReleasePlanRespDto;
import com.dtyunxi.tcbj.api.dto.response.LogicInventoryRespDto;
import com.dtyunxi.tcbj.api.query.IInspectionReleaseOrderQueryReportApi;
import com.dtyunxi.tcbj.api.query.IInspectionReleasePlanQueryApi;
import com.dtyunxi.yundt.cube.center.inventory.api.IInspectionReleasePlanApi;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.ImportInspectionReleasePlanReqDto;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service(value="abstractFileOperationCommonService_planned_release_quantity")
public class InspectionReleasePlanImportImpl
extends HandlerFileOperationCommonServiceImpl
implements ImportTransferOrderAssistService {
    private static final Logger log = LoggerFactory.getLogger(InspectionReleasePlanImportImpl.class);
    @Resource
    private IInspectionReleasePlanQueryApi iInspectionReleasePlanQueryApi;
    @Resource
    private IInspectionReleasePlanApi iInspectionReleasePlanApi;
    @Resource
    private IInspectionReleaseOrderQueryReportApi inspectionReleaseOrderQueryReportApi;

    @Override
    public Object verifyImportFileOperationCommon(ExcelImportResult<ImportBaseModeDto> result, ImportFileOperationCommonReqDto commonReqDto, ImportFileOperationCommonRespDto respDto) {
        ArrayList list = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)list, (Collection)result.getList(), InspectionReleasePlanVo.class);
        HashSet checkRepeatData = Sets.newHashSet();
        Map<String, LogicInventoryRespDto> availableMap = this.getAvailableMap(list);
        log.info("\u67e5\u8be2\u5546\u54c1\u957f\u7f16\u7801\u548c\u6279\u6b21\u9700\u6ee1\u8db3\u5f85\u68c0\u4ed3\u4fe1\u606favailableMap:{}", (Object)JSON.toJSONString(availableMap));
        ArrayList msgList = Lists.newArrayList();
        ArrayList saveList = Lists.newArrayList();
        list.forEach(i -> {
            InspectionReleasePlanMsgVo msgDto = new InspectionReleasePlanMsgVo();
            CubeBeanUtils.copyProperties((Object)msgDto, (Object)i, (String[])new String[0]);
            if (StringUtils.isBlank((CharSequence)i.getPlanReleaseNum())) {
                msgDto.setErrorMsg("\u8ba1\u5212\u653e\u884c\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
            } else {
                String pattern = "^[+]{0,1}(\\d+)$";
                boolean matches = i.getPlanReleaseNum().matches(pattern);
                if (!matches) {
                    msgDto.setErrorMsg("\u8ba1\u5212\u653e\u884c\u6570\u91cf\u683c\u5f0f\u8981\u6c42\uff1a\u6b63\u6574\u6570");
                }
            }
            this.checkAvailable((InspectionReleasePlanVo)((Object)i), availableMap, msgDto);
            this.checkRepeatData(i.getUniqueKey(), checkRepeatData, msgDto);
            if (StringUtils.isNotBlank((CharSequence)msgDto.getErrorMsg())) {
                msgList.add(msgDto);
            } else {
                saveList.add(i);
            }
        });
        HashMap map = Maps.newHashMap();
        map.put("saveList", saveList);
        map.put("msgList", msgList);
        return map;
    }

    @Override
    public String executeImportFileOperationCommon(ExcelImportResult<ImportBaseModeDto> result, ImportFileOperationCommonReqDto commonReqDto, ImportFileOperationCommonRespDto respDto, Object obj) {
        List saveList;
        Map map = (Map)obj;
        Object saveObj = map.get("saveList");
        Object msgObj = map.get("msgList");
        ServiceContext.getContext().setAttachment("yes.req.userCode", commonReqDto.getOperator());
        ArrayList msgList = Lists.newArrayList();
        if (saveObj != null && CollectionUtil.isNotEmpty((Collection)(saveList = (List)saveObj))) {
            Map<String, List<InspectionReleasePlanVo>> importMap = saveList.stream().collect(Collectors.groupingBy(InspectionReleasePlanVo::getSkuCode));
            ArrayList dtoList = Lists.newArrayList();
            for (InspectionReleasePlanVo vo : saveList) {
                ImportInspectionReleasePlanReqDto dto = new ImportInspectionReleasePlanReqDto();
                BeanUtils.copyProperties((Object)((Object)vo), (Object)dto);
                dto.setPlanReleaseNum(new BigDecimal(vo.getPlanReleaseNum()));
                dtoList.add(dto);
            }
            dtoList.forEach(i -> {
                block2: {
                    try {
                        this.iInspectionReleasePlanApi.modifyInspectionReleasePlan(i);
                    }
                    catch (Exception e) {
                        String key = String.format("%s", i.getSkuCode());
                        if (!importMap.containsKey(key)) break block2;
                        List importTransferOrderVos = (List)importMap.get(key);
                        ArrayList list = Lists.newArrayList();
                        CubeBeanUtils.copyCollection((Collection)list, (Collection)importTransferOrderVos, InspectionReleasePlanMsgVo.class);
                        list.forEach(j -> j.setErrorMsg(e.getMessage()));
                        msgList.addAll(list);
                    }
                }
            });
        }
        String errorMsgUrl = null;
        if (msgObj != null) {
            List checkMsgList = (List)msgObj;
            msgList.addAll(checkMsgList);
        }
        if (CollectionUtil.isNotEmpty((Collection)msgList)) {
            String excelName = String.format("%s%s", "\u5ba2\u6237\u8d44\u6599\u5bfc\u5165\u9519\u8bef\u4fe1\u606f", commonReqDto.getTaskCode());
            errorMsgUrl = ExcelUtils.getExportUrl(msgList, InspectionReleasePlanMsgVo.class, null, excelName);
        }
        return errorMsgUrl;
    }

    private Map<String, InspectionReleasePlanRespDto> getcodesMap(List<InspectionReleasePlanVo> list) {
        Map<Object, Object> skuCodesMap = Maps.newHashMap();
        List codes = list.stream().map(InspectionReleasePlanVo::getSkuCode).distinct().collect(Collectors.toList());
        InspectionReleasePlanReqDto dto = new InspectionReleasePlanReqDto();
        dto.setSkuCodeList(codes);
        List respDtos = (List)RestResponseHelper.extractData((RestResponse)this.iInspectionReleasePlanQueryApi.queryBatchByPage(dto));
        if (CollectionUtil.isNotEmpty((Collection)respDtos)) {
            skuCodesMap = respDtos.stream().collect(Collectors.toMap(InspectionReleasePlanRespDto::getSkuCode, Function.identity(), (k1, k2) -> k1));
        }
        return skuCodesMap;
    }

    private Map<String, InspectionReleasePlanRespDto> getbatchMap(List<InspectionReleasePlanVo> list) {
        Map<Object, Object> batchMap = Maps.newHashMap();
        List batchs = list.stream().map(InspectionReleasePlanVo::getBatch).distinct().collect(Collectors.toList());
        InspectionReleasePlanReqDto dto = new InspectionReleasePlanReqDto();
        dto.setBatchList(batchs);
        List respDtos = (List)RestResponseHelper.extractData((RestResponse)this.iInspectionReleasePlanQueryApi.queryBatchByPage(dto));
        if (CollectionUtil.isNotEmpty((Collection)respDtos)) {
            batchMap = respDtos.stream().collect(Collectors.toMap(InspectionReleasePlanRespDto::getBatch, Function.identity(), (k1, k2) -> k1));
        }
        return batchMap;
    }

    private Map<String, LogicInventoryRespDto> getAvailableMap(List<InspectionReleasePlanVo> list) {
        Map<Object, Object> availableMap = Maps.newHashMap();
        List codes = list.stream().map(InspectionReleasePlanVo::getSkuCode).distinct().collect(Collectors.toList());
        List batchs = list.stream().map(InspectionReleasePlanVo::getBatch).distinct().collect(Collectors.toList());
        InspectionReleasePlanReqDto dto = new InspectionReleasePlanReqDto();
        dto.setBatchList(batchs);
        dto.setSkuCodeList(codes);
        List respDtos = (List)RestResponseHelper.extractData((RestResponse)this.iInspectionReleasePlanQueryApi.queryAvailableByPage(dto));
        if (CollectionUtil.isNotEmpty((Collection)respDtos)) {
            availableMap = respDtos.stream().collect(Collectors.toMap(o -> o.getSkuCode() + "_" + o.getBatch(), Function.identity(), (k1, k2) -> k1));
        }
        return availableMap;
    }

    private Map<String, InspectionReleaseOrderReportRespDto> queryReleaseOrder(List<InspectionReleasePlanVo> reportVOList) {
        InspectionReleaseOrderReportReqDto reqDto = new InspectionReleaseOrderReportReqDto();
        ArrayList statusList = Lists.newArrayList((Object[])new Integer[]{0, 1});
        reqDto.setOrderStatusList((List)statusList);
        reqDto.setSkuCodeList(reportVOList.stream().map(InspectionReleasePlanVo::getSkuCode).collect(Collectors.toList()));
        reqDto.setBatchList(reportVOList.stream().map(InspectionReleasePlanVo::getBatch).collect(Collectors.toList()));
        List list = (List)RestResponseHelper.extractData((RestResponse)this.inspectionReleaseOrderQueryReportApi.queryByParams(reqDto));
        Map<String, Object> map = new HashMap<String, InspectionReleaseOrderReportRespDto>();
        if (CollectionUtil.isNotEmpty((Collection)list)) {
            map = list.stream().collect(Collectors.toMap(e -> e.getSkuCode() + "_" + e.getBatch(), Function.identity(), (k1, k2) -> k1));
        }
        return map;
    }

    private Map<String, InspectionReleasePlanRespDto> getbatchCodeMap(List<InspectionReleasePlanVo> list) {
        Map<Object, Object> batchCodeMap = Maps.newHashMap();
        List batchs = list.stream().map(InspectionReleasePlanVo::getBatch).distinct().collect(Collectors.toList());
        List codes = list.stream().map(InspectionReleasePlanVo::getSkuCode).distinct().collect(Collectors.toList());
        InspectionReleasePlanReqDto dto = new InspectionReleasePlanReqDto();
        dto.setBatchList(batchs);
        dto.setSkuCodeList(codes);
        List respDtos = (List)RestResponseHelper.extractData((RestResponse)this.iInspectionReleasePlanQueryApi.queryBatchByPage(dto));
        if (CollectionUtil.isNotEmpty((Collection)respDtos)) {
            batchCodeMap = respDtos.stream().collect(Collectors.toMap(o -> o.getSkuCode() + "_" + o.getBatch(), Function.identity(), (k1, k2) -> k1));
        }
        return batchCodeMap;
    }

    private void checkCode(InspectionReleasePlanVo i, Map<String, InspectionReleasePlanRespDto> codesMap, InspectionReleasePlanMsgVo msgDto) {
        InspectionReleasePlanRespDto dto = codesMap.get(i.getSkuCode());
        if (ObjectUtils.isNotEmpty((Object)dto)) {
            i.setSkuName(dto.getSkuName());
        } else {
            msgDto.setErrorMsg("\u5546\u54c1\u957f\u7f16\u7801\u627e\u4e0d\u5230");
        }
    }

    private void checkEasCode(InspectionReleasePlanVo i, Map<String, InspectionReleasePlanRespDto> codesMap, InspectionReleasePlanMsgVo msgDto) {
        InspectionReleasePlanRespDto dto = codesMap.get(i.getBatch());
        if (ObjectUtils.isEmpty((Object)dto)) {
            msgDto.setErrorMsg("\u6279\u6b21\u627e\u4e0d\u5230");
        }
    }

    private void checkAvailable(InspectionReleasePlanVo i, Map<String, LogicInventoryRespDto> codesMap, InspectionReleasePlanMsgVo msgDto) {
        String key = i.getSkuCode() + "_" + i.getBatch();
        LogicInventoryRespDto dto = codesMap.get(key);
        if (ObjectUtils.isEmpty((Object)dto)) {
            msgDto.setErrorMsg("\u8be5\u5546\u54c1\u957f\u7f16\u7801\u548c\u6279\u6b21\u5728\u5f85\u68c0\u4ed3\u4e0d\u5b58\u5728");
        }
    }

    private void checkId(InspectionReleasePlanVo i, Map<String, InspectionReleasePlanRespDto> codesMap, InspectionReleasePlanMsgVo msgDto) {
        String key = i.getSkuCode() + "_" + i.getBatch();
        InspectionReleasePlanRespDto dto = codesMap.get(key);
        if (ObjectUtils.isNotEmpty((Object)dto)) {
            i.setId(dto.getId());
        } else {
            msgDto.setErrorMsg("\u8be5\u5546\u54c1\u957f\u7f16\u7801\u548c\u6279\u6b21\u4e0d\u5b58\u5728");
        }
    }

    private void checkRepeatData(String uniqueKey, Set<String> checkRepeatData, InspectionReleasePlanMsgVo msgDto) {
        if (checkRepeatData.contains(uniqueKey)) {
            this.setErrorMsg(msgDto, "\u6570\u636e\u91cd\u590d");
        } else {
            checkRepeatData.add(uniqueKey);
        }
    }

    private void setErrorMsg(InspectionReleasePlanMsgVo msgDto, String errorMsg) {
        if (StringUtils.isBlank((CharSequence)msgDto.getErrorMsg())) {
            msgDto.setErrorMsg(errorMsg);
        } else {
            msgDto.setErrorMsg(String.format("%s\u3001%s", msgDto.getErrorMsg(), errorMsg));
        }
    }
}

