/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cis.pms.biz.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.dtyunxi.cis.pms.biz.constant.EasCancelTypeRelationEnum;
import com.dtyunxi.cis.pms.biz.constant.ExpressBusinessTypeEnum;
import com.dtyunxi.cis.pms.biz.enums.BusinessTypeEnum;
import com.dtyunxi.cis.pms.biz.enums.FinishedGoodsInventoryTypeEnum;
import com.dtyunxi.cis.pms.biz.service.ExternalDispatchEasService;
import com.dtyunxi.cis.pms.biz.service.ExternalPointService;
import com.dtyunxi.cis.pms.biz.service.impl.DispatchEasInventoryAllotImpl;
import com.dtyunxi.cis.pms.biz.utils.AssertUtil;
import com.dtyunxi.cis.pms.biz.utils.DateUtils;
import com.dtyunxi.cube.commons.beans.mq.MessageVo;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.component.track.commons.constant.pcp.OpenapiDefineEnum;
import com.dtyunxi.cube.plugin.mq.ICommonsMqService;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.cube.utils.enums.DatePattern;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.IOrderPushInterceptRecordApi;
import com.dtyunxi.tcbj.api.dto.constant.enums.ApportionOrderEnum;
import com.dtyunxi.tcbj.api.dto.request.CostCenterReqDto;
import com.dtyunxi.tcbj.api.dto.request.CsLogisticsInfoSyncDto;
import com.dtyunxi.tcbj.api.dto.request.DeliveryResultOrderReqDto;
import com.dtyunxi.tcbj.api.dto.request.OrderPushInterceptRecordReqDto;
import com.dtyunxi.tcbj.api.dto.response.CostCenterRespDto;
import com.dtyunxi.tcbj.api.dto.response.DeliveryInformationRespDto;
import com.dtyunxi.tcbj.api.dto.response.DeliveryResultOrderRespDto;
import com.dtyunxi.tcbj.api.query.ICostCenterQueryApi;
import com.dtyunxi.tcbj.api.query.ICsOutNoticeOrderDetailQueryApi;
import com.dtyunxi.tcbj.api.query.IDeliveryResultOrderQueryApi;
import com.dtyunxi.tcbj.api.query.IOutResultOrderQueryApi;
import com.dtyunxi.tcbj.api.query.ISaleOrderReportQueryApi;
import com.dtyunxi.tcbj.center.openapi.api.IApiLogApi;
import com.dtyunxi.tcbj.center.openapi.api.enums.SapGoodsMovementEnum;
import com.dtyunxi.tcbj.center.openapi.api.external.IExternalCspApi;
import com.dtyunxi.tcbj.center.openapi.api.external.IExternalE3Api;
import com.dtyunxi.tcbj.center.openapi.api.external.IExternalFinanceZTApi;
import com.dtyunxi.tcbj.center.openapi.api.external.IExternalNutritionApi;
import com.dtyunxi.tcbj.center.openapi.api.external.IExternalOutSapApi;
import com.dtyunxi.tcbj.center.openapi.api.external.IExternalPsiApi;
import com.dtyunxi.tcbj.center.openapi.common.csp.dto.CSPItemDto;
import com.dtyunxi.tcbj.center.openapi.common.csp.dto.CSPPurchaseCreateReqDto;
import com.dtyunxi.tcbj.center.openapi.common.csp.dto.CSPPurchaseInOrderCreateReqDto;
import com.dtyunxi.tcbj.center.openapi.common.csp.dto.CSPPurchaseOrderCreateReqDto;
import com.dtyunxi.tcbj.center.openapi.common.csp.dto.CSPUpdateCspOrderReqDto;
import com.dtyunxi.tcbj.center.openapi.common.csp.dto.CSPUpdateExchangeGoodsHeadReqDto;
import com.dtyunxi.tcbj.center.openapi.common.csp.dto.CSPUpdateSpecialChannelOrderReqDto;
import com.dtyunxi.tcbj.center.openapi.common.csp.dto.ShippingDto;
import com.dtyunxi.tcbj.center.openapi.common.e3.dto.E3BSPurchaseAddDetailReqDto;
import com.dtyunxi.tcbj.center.openapi.common.e3.dto.E3BSPurchaseAddReqDto;
import com.dtyunxi.tcbj.center.openapi.common.eas.constant.EASBillTypeEnum;
import com.dtyunxi.tcbj.center.openapi.common.eas.constant.EASBizTypeEnum;
import com.dtyunxi.tcbj.center.openapi.common.eas.constant.EASExtendKeyEnum;
import com.dtyunxi.tcbj.center.openapi.common.eas.constant.EASGeneralSubBillFlagEnum;
import com.dtyunxi.tcbj.center.openapi.common.eas.constant.EASOrderKayEnum;
import com.dtyunxi.tcbj.center.openapi.common.eas.constant.EASSourceBillTypeEnum;
import com.dtyunxi.tcbj.center.openapi.common.eas.constant.EASTransactionTypeEnum;
import com.dtyunxi.tcbj.center.openapi.common.eas.constant.RouteMultiAllotNodeEnum;
import com.dtyunxi.tcbj.center.openapi.common.eas.dto.Bill;
import com.dtyunxi.tcbj.center.openapi.common.eas.dto.BillEntry;
import com.dtyunxi.tcbj.center.openapi.common.eas.dto.CancelOrderReqDto;
import com.dtyunxi.tcbj.center.openapi.common.eas.dto.EASBillReqDto;
import com.dtyunxi.tcbj.center.openapi.common.eas.dto.EASOrderAuditReqDto;
import com.dtyunxi.tcbj.center.openapi.common.eas.dto.EASOrderBaseResult;
import com.dtyunxi.tcbj.center.openapi.common.eas.dto.InventoryReqDto;
import com.dtyunxi.tcbj.center.openapi.common.eas.dto.MoveIssueBill;
import com.dtyunxi.tcbj.center.openapi.common.eas.dto.MoveIssueBillEntry;
import com.dtyunxi.tcbj.center.openapi.common.eas.dto.SaleOrderUpdate;
import com.dtyunxi.tcbj.center.openapi.common.finance.constant.YdBusinesstypeEnum;
import com.dtyunxi.tcbj.center.openapi.common.finance.dto.FinanceZTAllotOrderDetailDto;
import com.dtyunxi.tcbj.center.openapi.common.finance.dto.FinanceZTAllotOrderDto;
import com.dtyunxi.tcbj.center.openapi.common.finance.dto.FinanceZTDealOrderDetailDto;
import com.dtyunxi.tcbj.center.openapi.common.finance.dto.FinanceZTDealOrderDto;
import com.dtyunxi.tcbj.center.openapi.common.nutrition.constant.NutritionOrderStatus;
import com.dtyunxi.tcbj.center.openapi.common.nutrition.dto.ReceiveCheckoutInfoReqDto;
import com.dtyunxi.tcbj.center.openapi.common.nutrition.dto.ReceiveExpressInfoReqDto;
import com.dtyunxi.tcbj.center.openapi.common.psi.dto.PSIOrderDto;
import com.dtyunxi.tcbj.center.openapi.common.psi.dto.PSIOrderItemDto;
import com.dtyunxi.tcbj.center.openapi.common.sap.dto.DeliveryOrderSignReqDto;
import com.dtyunxi.tcbj.center.openapi.common.sap.dto.InventoryMoveItemDto;
import com.dtyunxi.tcbj.center.openapi.common.sap.dto.InventoryMoveReqDto;
import com.dtyunxi.tcbj.center.openapi.common.sap.dto.InventoryStoItemDto;
import com.dtyunxi.tcbj.center.openapi.common.sap.dto.InventoryStoReqDto;
import com.dtyunxi.tcbj.center.openapi.common.sap.dto.SalesOrderCreateReqDto;
import com.dtyunxi.tcbj.center.openapi.common.sap.dto.SalesOrderItemInfo;
import com.dtyunxi.tcbj.center.openapi.common.sap.dto.SalesOrderPartnerInfo;
import com.dtyunxi.tcbj.center.openapi.common.wms.request.WmsItemLine;
import com.dtyunxi.tcbj.center.openapi.common.wms.request.WmsStockEntryOrderReqDto;
import com.dtyunxi.util.DateUtil;
import com.dtyunxi.util.JacksonUtil;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerExtDetailRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerExtQueryApi;
import com.dtyunxi.yundt.cube.center.customer.api.dto.response.CustomerOrgPartnerRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.query.ICustomerOrgPartnerQueryApi;
import com.dtyunxi.yundt.cube.center.data.api.IPcpDictApi;
import com.dtyunxi.yundt.cube.center.data.api.dto.DictDto;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.inventory.ICsLogicInventoryQueryApi;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.order.ICsDeliveryResultOrderQueryApi;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.order.ICsOutNoticeOrderQueryApi;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.order.ICsOutResultOrderQueryApi;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.warehouse.ICsLogicWarehouseExposedApi;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.warehouse.ICsPhysicsWarehouseApi;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.warehouse.ICsWarehouseAddressApi;
import com.dtyunxi.yundt.cube.center.inventory.api.inventory.IAdjustmentInventoryApi;
import com.dtyunxi.yundt.cube.center.inventory.api.inventory.ICsBusinessTypeApi;
import com.dtyunxi.yundt.cube.center.inventory.api.inventory.ICsOtherStorageOrderApi;
import com.dtyunxi.yundt.cube.center.inventory.api.inventory.ICsTransferOrderApi;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.req.CsTransferOrderReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.resp.AdjustmentInventoryDetailRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.resp.AdjustmentInventoryRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.resp.CsBusinessTypeRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.resp.CsOtherStorageOrderRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory.CsLogicInventoryQueryDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.warehouse.CsPhysicsWarehouseQueryDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.warehouse.CsWarehouseAddressParamQueryDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.inventory.CsLogicInventoryRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.order.CsDeliveryReceiveResultDetailRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.order.CsDeliveryReceiveResultRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.order.CsDeliveryResultOrderRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.order.CsOutNoticeOrderRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.warehouse.CsLogicWarehouseRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.warehouse.CsPhysicsWarehouseRespDto;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsInventorySourceTypeEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsPcpBusinessTypeEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.WarehouseCorrespondingSystemEnum;
import com.dtyunxi.yundt.cube.center.trade.api.ISaleRefundApi;
import com.dtyunxi.yundt.cube.center.trade.api.ISaleTransferOrderApi;
import com.dtyunxi.yundt.cube.center.trade.api.constant.CspOrderStatusEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constant.SaleOrderStatusEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constant.SaleOrderTypeEnum;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.BizSaleOrderReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.SaleOrderReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.SaleRefundReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.SaleTransferOrderReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.BizSaleOrderRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.BizSaleRefundRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.OrderTagBaseRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.SaleOrderAddrRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.SaleOrderItemExtRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.SaleOrderItemRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.SaleRefundItemRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.query.IOrderTagRecordQueryApi;
import com.dtyunxi.yundt.cube.center.trade.api.query.ISaleOrderQueryApi;
import com.dtyunxi.yundt.cube.center.trade.api.query.ISaleRefundQueryApi;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.basicdata.enums.DictEnum;
import com.yunxi.dg.base.center.enums.BasicsOrderOperateTypeEnum;
import com.yunxi.dg.base.center.enums.CsRelevanceTableNameEnum;
import com.yunxi.dg.base.center.inventory.api.entity.IInOutNoticeOrderDetailApi;
import com.yunxi.dg.base.center.inventory.api.entity.IReceiveDeliveryNoticeOrderApi;
import com.yunxi.dg.base.center.inventory.dto.domain.CsDeliveryResultOrderQueryDto;
import com.yunxi.dg.base.center.inventory.dto.domain.CsOutNoticeOrderQueryDto;
import com.yunxi.dg.base.center.inventory.dto.domain.CsOutResultOrderQueryDto;
import com.yunxi.dg.base.center.inventory.dto.domain.CsOutResultOrderRespDto;
import com.yunxi.dg.base.center.inventory.dto.domain.CsTransferOrderRespDto;
import com.yunxi.dg.base.center.inventory.dto.domain.CsWmsShippingInfoReqDto;
import com.yunxi.dg.base.center.inventory.dto.entity.InOutNoticeOrderDetailDto;
import com.yunxi.dg.base.center.inventory.dto.entity.ReceiveDeliveryNoticeOrderDetailDto;
import com.yunxi.dg.base.center.inventory.dto.entity.ReceiveDeliveryNoticeOrderDto;
import com.yunxi.dg.base.center.report.api.inventory.IDgLogicWarehouseApi;
import com.yunxi.dg.base.center.report.dto.inventory.DgLogicWarehouseDto;
import com.yunxi.dg.base.center.report.dto.inventory.DgLogicWarehousePageReqDto;
import com.yunxi.dg.base.commons.enums.YesNoEnum;
import com.yx.tcbj.center.customer.api.query.ICustomerQueryApi;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ExternalPointServiceImpl
implements ExternalPointService {
    private static final Logger logger = LoggerFactory.getLogger(ExternalPointServiceImpl.class);
    private static final String PUSH_ERP_LOCK_KEY = "PUSH_ERP_LOCK_KEY";
    private final String[] allotBusinessTypes = new String[]{CsPcpBusinessTypeEnum.ALLOT_OUT.getCode(), CsPcpBusinessTypeEnum.ALLOT_BC_EFFICACY.getCode(), CsPcpBusinessTypeEnum.ALLOT_OUT_ONLY.getCode(), CsPcpBusinessTypeEnum.ALLOT_IN_ONLY.getCode()};
    private final String DELIVERY = "delivery";
    private final String RECEIVE = "receive";
    private final String EAS_PURCHASE_ORDER_ID = "EAS_PURCHASE_ORDER_ID";
    private final List<String> saleOrderToPsiTypes = Lists.newArrayList((Object[])new String[]{SaleOrderTypeEnum.AGENCY_ORDER.getType(), SaleOrderTypeEnum.AGENCY_ORDER.getType(), SaleOrderTypeEnum.PRE_SALE_ORDER.getType(), SaleOrderTypeEnum.INTERNAL_DISTRIBUTION.getType(), SaleOrderTypeEnum.SECONDARY_DISTRIBUTION.getType(), SaleOrderTypeEnum.INTEGRAL_ORDER.getType(), SaleOrderTypeEnum.REPLENISHMENT_ORDER.getType(), SaleOrderTypeEnum.CUSTOMER_REFUNDING_ORDER.getType(), SaleOrderTypeEnum.COMPENSATION_ORDER.getType(), SaleOrderTypeEnum.QUALITY_REFUNDING_ORDER.getType(), SaleOrderTypeEnum.REPLENISH_ORDER.getType()});
    @Resource
    private ExternalDispatchEasService[] externalDispatchServices;
    @Resource
    private ICsLogicInventoryQueryApi csLogicInventoryQueryApi;
    @Resource
    private ICsDeliveryResultOrderQueryApi csDeliveryResultOrderQueryApi;
    @Resource
    private ICustomerQueryApi customerQueryApi;
    @Resource
    private ISaleOrderQueryApi saleOrderQueryApi;
    @Resource
    private IExternalCspApi externalCspApi;
    @Resource
    private IExternalNutritionApi externalNutritionApi;
    @Resource
    private ISaleOrderReportQueryApi saleOrderReportQueryApi;
    @Resource
    private ICustomerExtQueryApi customerExtQueryApi;
    @Resource
    private DispatchEasInventoryAllotImpl dispatchEasInventoryAllot;
    @Resource
    private ICsOtherStorageOrderApi csOtherStorageOrderQueryApi;
    @Resource
    private ICsBusinessTypeApi csBusinessTypeQueryApi;
    @Resource
    private ICustomerOrgPartnerQueryApi customerOrgPartnerQueryApi;
    @Resource
    private IExternalPsiApi externalPsiApi;
    @Resource
    private ICsTransferOrderApi csTransferOrderApi;
    @Resource
    private IAdjustmentInventoryApi adjustmentInventoryQueryApi;
    @Resource
    private ICsOutResultOrderQueryApi csOutResultOrderQueryApi;
    @Resource
    private IDeliveryResultOrderQueryApi deliveryResultOrderQueryApi;
    @Resource
    private ICostCenterQueryApi costCenterQueryApi;
    @Resource
    private ISaleRefundQueryApi saleRefundQueryApi;
    @Resource
    private ISaleRefundApi saleRefundApi;
    @Resource
    private IPcpDictApi pcpDictApi;
    @Resource
    private IOrderPushInterceptRecordApi orderPushInterceptRecordApi;
    @Resource
    private IExternalFinanceZTApi externalFinanceZTApi;
    @Resource
    private ICsOutNoticeOrderQueryApi csOutNoticeOrderQueryApi;
    @Resource
    private ISaleTransferOrderApi saleTransferOrderApi;
    @Resource
    private IOrderTagRecordQueryApi orderTagRecordQueryApi;
    @Resource
    private IExternalE3Api externalE3Api;
    @Resource
    private ICacheService cacheService;
    @Resource
    private ICsOutNoticeOrderDetailQueryApi csOutNoticeOrderDetailQueryApi;
    @Resource
    private IReceiveDeliveryNoticeOrderApi receiveDeliveryNoticeOrderApi;
    @Resource
    private ICommonsMqService commonsMqService;
    @Resource
    private ICsWarehouseAddressApi csWarehouseAddressApi;
    @Resource
    private ICsLogicWarehouseExposedApi csLogicWarehouseExposedQueryApi;
    @Resource
    private ICsPhysicsWarehouseApi csPhysicsWarehouseApi;
    @Resource
    private IApiLogApi apiLogApi;
    @Resource
    private ICsTransferOrderApi csTransferOrderQueryApi;
    @Resource
    private IInOutNoticeOrderDetailApi inOutNoticeOrderDetailApi;
    @Autowired
    IDgLogicWarehouseApi dgLogicWarehouseApi;
    @Resource
    private IOutResultOrderQueryApi iOutResultOrderQueryApi;
    @Resource
    private IExternalOutSapApi iExternalOutSapApi;

    @Override
    public void receiveDeliveryResultToEasPoint(CsDeliveryReceiveResultRespDto dto) {
        logger.info("\u6536\u53d1\u8d27\u7ed3\u679c\u8bf7\u6c42EAS\u8282\u70b9\uff1a{}", (Object)JSON.toJSONString((Object)dto));
        switch (CsPcpBusinessTypeEnum.getByCode((String)dto.getBusinessType())) {
            case PURCHASE: 
            case PURCHASE_REFUND: 
            case OUTSOURCE: 
            case PRODUCTION: 
            case PRODUCT_REPAIR: 
            case PRODUCTIONRETREAT: 
            case PRODUCTION_MATERIALS: 
            case PRODUCTION_MATERIALS_RETURN: 
            case OTHER_OUT: 
            case BATCH_ADJUST: 
            case OTHER_IN: {
                this.sapInventoryMove(dto);
                break;
            }
            case INTERNAL_ALLOT: 
            case ROUTE_INTERNAL_ALLOT: 
            case INTERNAL_EXPORT_DEAL: {
                if (!dto.getOrderType().equals("receive")) break;
                this.sapInventoryMove(dto);
                break;
            }
            case INTERNAL_DEAL: 
            case INTERNAL_DEAL_RETURN: 
            case SALE_RETURN_INTERNAL_DEAL: 
            case ROUTE_INTERNAL_DEAL: {
                if (!dto.getOrderType().equals("receive")) break;
                this.sapInventorySto(dto);
                break;
            }
            case ALLOT_OUT: 
            case MAIYOU_ALLOT_OUT: {
                CsTransferOrderRespDto transferOrderRespDto = (CsTransferOrderRespDto)RestResponseHelper.extractData((RestResponse)this.csTransferOrderApi.queryByTransferOrderNo(dto.getRelevanceNo()));
                AssertUtil.assertNotNull(transferOrderRespDto, "\u8c03\u62e8\u5355\u4e0d\u5b58\u5728");
                if (!transferOrderRespDto.getSourceSystem().equals("EAS") && StringUtils.isNotBlank((CharSequence)transferOrderRespDto.getInPhysicsWarehouseCode()) && StringUtils.isNotBlank((CharSequence)transferOrderRespDto.getOutPhysicsWarehouseCode()) && !transferOrderRespDto.getInPhysicsWarehouseCode().equals(transferOrderRespDto.getOutPhysicsWarehouseCode())) {
                    logger.info("PCP\u53d1\u8d77\u8c03\u62e8\u8de8\u7269\u7406\u4ed3\u901a\u8fc7\u8c03\u6574\u6761\u4e0eEAS\u4ea4\u4e92");
                    break;
                }
                this.easInventory(dto);
                break;
            }
            case ALLOT_LOGIC_OUT: {
                this.easInventory(dto);
                break;
            }
            case ALLOT_OUT_ONLY: {
                if (dto.getOrderType().equals("delivery")) {
                    this.easInventory(dto);
                    break;
                }
                logger.info("\u8c03\u62e8\u53ea\u51fa\u4e0d\u63a8\u9001\u6536\u8d27\u7ed3\u679c");
                break;
            }
            case ALLOT_IN_ONLY: {
                if (dto.getOrderType().equals("receive")) {
                    this.easInventory(dto);
                    break;
                }
                logger.info("\u8c03\u62e8\u53ea\u5165\u4e0d\u63a8\u9001\u53d1\u8d27\u7ed3\u679c");
                break;
            }
            case INSPECTION_QUALIFIED: 
            case ALLOT_LOSE_EFFICACY: {
                if (dto.getOrderType().equals("receive")) {
                    this.easInventoryAllotSpecial(dto);
                    break;
                }
            }
            case IN_TRANSIT_TRANSFER: {
                logger.info("ToEas\u5728\u9014\u8f6c\u5408\u683c\uff0c\u4e0d\u505a\u5904\u7406\uff0c\u901a\u8fc7\u8c03\u6574\u5355\u4e0eEAS\u4ea4\u4e92");
                break;
            }
            default: {
                logger.info("EAS\u65e0\u9700\u5904\u7406\u7684\u4e1a\u52a1\u7c7b\u578b");
            }
        }
    }

    @Override
    public void saleOrderReceiveDeliveryResultToEasOtherPoint(CsDeliveryReceiveResultRespDto dto, BizSaleOrderRespDto saleOrder) {
        logger.info("\u9500\u552e\u5355\u6536\u53d1\u7ed3\u679c\u8bf7\u6c42EAS\u8282\u70b9\uff1a{}", (Object)JSON.toJSONString((Object)dto));
        if (!CsRelevanceTableNameEnum.CS_ORDER_SALE.getCode().equals(dto.getRelevanceTableName())) {
            logger.info("\u975e\u9500\u552e\u5355\uff0c\u65e0\u987b\u8bf7\u6c42");
            return;
        }
        if (ObjectUtil.isEmpty((Object)saleOrder)) {
            logger.info("\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u9500\u552e\u5355");
            return;
        }
        switch (CsPcpBusinessTypeEnum.getByCode((String)dto.getBusinessType())) {
            case OTHER_OUT_STOCK: {
                this.easOtherOutOfOtherOutStock(dto, saleOrder);
                break;
            }
            case CUSTOMER_REFUNDING_ORDER: {
                this.easOtherOutOfCustomerRefunding(dto, saleOrder);
                break;
            }
            case QUALITY_REFUNDING_ORDER: {
                this.easOtherOutOfQualityRefunding(dto, saleOrder);
                break;
            }
            case REPLENISH_ORDER: {
                this.easOtherOutOfReplenishOrder(dto, saleOrder);
                break;
            }
            default: {
                logger.info("\u65e0\u9700\u63a8\u9001");
            }
        }
    }

    @Override
    public String saleOrderReceiveDeliveryResultToEasOtherPointOffset(String documentNo) {
        logger.info("\u9500\u552e\u5355\u6536\u53d1\u7ed3\u679c\u8bf7\u6c42EAS\u8282\u70b9\uff0c\u4eba\u5de5\u8865\u507f\uff1a{}", (Object)documentNo);
        CsDeliveryResultOrderQueryDto queryDto = new CsDeliveryResultOrderQueryDto();
        queryDto.setDocumentNo(documentNo);
        CsDeliveryReceiveResultRespDto dto = (CsDeliveryReceiveResultRespDto)RestResponseHelper.extractData((RestResponse)this.csDeliveryResultOrderQueryApi.queryDeliveryReceiveResultDetail(queryDto));
        if (ObjectUtil.isEmpty((Object)dto)) {
            throw new BizException("-1", "\u627e\u4e0d\u5230\u6536\u53d1\u7ed3\u679c\u5355\u4fe1\u606f");
        }
        BizSaleOrderRespDto saleOrder = (BizSaleOrderRespDto)RestResponseHelper.extractData((RestResponse)this.saleOrderQueryApi.queryByOrderNo(dto.getRelevanceNo()));
        if (ObjectUtil.isEmpty((Object)saleOrder)) {
            throw new BizException("-1", "\u627e\u4e0d\u5230\u9500\u552e\u5355\u4fe1\u606f");
        }
        this.saleOrderReceiveDeliveryResultToEasOtherPoint(dto, saleOrder);
        return null;
    }

    @Override
    public void saleOrderReceiveDeliveryResultToPsiPoint(CsDeliveryReceiveResultRespDto dto, BizSaleOrderRespDto saleOrder) {
        logger.info("\u9500\u552e\u5355\u6536\u53d1\u7ed3\u679c\u8bf7\u6c42\u8fdb\u9500\u5b58\u8282\u70b9\uff1a{}", (Object)JSON.toJSONString((Object)dto));
        if (ObjectUtil.isEmpty((Object)saleOrder)) {
            logger.info("\u975e\u9500\u552e\u5355\u65e0\u987b\u63a8\u9001");
            return;
        }
        this.psiCreateOrder(dto, saleOrder, false);
    }

    @Override
    public String saleOrderReceiveDeliveryResultToPsiPointOffset(String documentNo) {
        logger.info("\u9500\u552e\u5355\u6536\u53d1\u7ed3\u679c\u8bf7\u6c42\u8fdb\u9500\u5b58\u8282\u70b9\uff0c\u4eba\u5de5\u8865\u507f\uff1a{}", (Object)documentNo);
        CsDeliveryResultOrderQueryDto queryDto = new CsDeliveryResultOrderQueryDto();
        queryDto.setDocumentNo(documentNo);
        CsDeliveryReceiveResultRespDto dto = (CsDeliveryReceiveResultRespDto)RestResponseHelper.extractData((RestResponse)this.csDeliveryResultOrderQueryApi.queryDeliveryReceiveResultDetail(queryDto));
        if (ObjectUtil.isEmpty((Object)dto)) {
            throw new BizException("-1", "\u627e\u4e0d\u5230\u6536\u53d1\u7ed3\u679c\u5355\u4fe1\u606f");
        }
        BizSaleOrderRespDto saleOrder = (BizSaleOrderRespDto)RestResponseHelper.extractData((RestResponse)this.saleOrderQueryApi.queryByOrderNo(dto.getRelevanceNo()));
        if (ObjectUtil.isEmpty((Object)saleOrder)) {
            throw new BizException("-1", "\u627e\u4e0d\u5230\u9500\u552e\u5355\u4fe1\u606f");
        }
        this.psiCreateOrder(dto, saleOrder, true);
        return "\u8bf7\u6c42\u6210\u529f";
    }

    @Override
    public String receiveDeliveryResultToEasPointOffset(String documentNo) {
        logger.info("\u6536\u53d1\u8d27\u7ed3\u679c\u8bf7\u6c42EAS\u8282\u70b9\uff08\u4eba\u5de5\u8865\u507f\uff09\uff1a{}", (Object)documentNo);
        CsDeliveryResultOrderQueryDto queryDto = new CsDeliveryResultOrderQueryDto();
        queryDto.setDocumentNo(documentNo);
        CsDeliveryReceiveResultRespDto dto = (CsDeliveryReceiveResultRespDto)RestResponseHelper.extractData((RestResponse)this.csDeliveryResultOrderQueryApi.queryDeliveryReceiveResultDetail(queryDto));
        if (ObjectUtil.isEmpty((Object)dto)) {
            return "\u627e\u4e0d\u5230\u7ed3\u679c\u5355";
        }
        this.receiveDeliveryResultToEasPoint(dto);
        return "\u6267\u884c\u5b8c\u6bd5\uff01";
    }

    @Override
    public void receiveDeliveryNoticeCancelToEasPoint(String easNo, String businessType, String remake) {
        logger.info("\u6536\u53d1\u8d27\u901a\u77e5\u53d6\u6d88\u8bf7\u6c42EAS\u8282\u70b9\uff1a{}\uff0c{}", (Object)easNo, (Object)businessType);
        if (StringUtils.isBlank((CharSequence)easNo) || StringUtils.isBlank((CharSequence)businessType)) {
            logger.error("\u53c2\u6570\u5f02\u5e38\uff0c\u4e0d\u8fdb\u884c\u63a8\u9001");
            return;
        }
        if (businessType.equals(ExpressBusinessTypeEnum.ALLOT_OUT.getBusinessType())) {
            logger.info("\u666e\u901a\u8c03\u62e8\u53d6\u6d88\uff0c\u4e0d\u63a8\u9001EAS");
            return;
        }
        CancelOrderReqDto cancelOrderReqDto = new CancelOrderReqDto();
        cancelOrderReqDto.setFnumber(easNo);
        cancelOrderReqDto.setBillName(easNo);
        cancelOrderReqDto.setRemark(remake);
        EasCancelTypeRelationEnum easCancelTypeRelationEnum = EasCancelTypeRelationEnum.fromCsPlannedOrderType(businessType);
        if (null == easCancelTypeRelationEnum) {
            logger.info("\u65e0\u5b9a\u4e49\u4e1a\u52a1");
            return;
        }
        cancelOrderReqDto.setBillType(easCancelTypeRelationEnum.getEasBillType());
        this.executeToEas(OpenapiDefineEnum.EAS001, cancelOrderReqDto);
    }

    @Override
    public void receiveDeliveryResultToCspPoint(BizSaleOrderRespDto saleOrder, CsDeliveryReceiveResultRespDto dto) {
        logger.info("\u6536\u53d1\u8d27\u7ed3\u679c\u8bf7\u6c42CSP\u8282\u70b9\uff1a{}", (Object)JSON.toJSONString((Object)saleOrder));
        if (ObjectUtil.isEmpty((Object)saleOrder)) {
            logger.info("\u975e\u9500\u552e\u5355\u4e0d\u6267\u884c");
            return;
        }
        this.cspUpdateOrderStatus(saleOrder, CspOrderStatusEnum.DELIVERED, false);
    }

    @Override
    public String saleOrderStatusUpdateToCspPointOffset(String saleOrderNo, Integer status) {
        logger.info("\u9500\u552e\u5355\u72b6\u6001\u66f4\u65b0\u63a8\u9001CSP\uff0c\u4eba\u5de5\u8865\u507f\uff1a{}", (Object)saleOrderNo);
        BizSaleOrderRespDto saleOrder = (BizSaleOrderRespDto)RestResponseHelper.extractData((RestResponse)this.saleOrderQueryApi.queryByOrderNo(saleOrderNo));
        this.cspUpdateOrderStatus(saleOrder, CspOrderStatusEnum.enumOf((String)status.toString()), true);
        return "\u6267\u884c\u5b8c\u6bd5\uff01";
    }

    @Override
    public void orderSignToCspPoint(SaleOrderReqDto reqDto) {
        logger.info("\u8ba2\u5355\u5b8c\u6210\u7b7e\u6536\u901a\u77e5CSP\u8282\u70b9\uff1a{}", (Object)JSON.toJSONString((Object)reqDto));
        BizSaleOrderRespDto bizSaleOrderRespDto = new BizSaleOrderRespDto();
        bizSaleOrderRespDto.setId(reqDto.getId());
        bizSaleOrderRespDto.setSaleOrderNo(reqDto.getSaleOrderNo());
        bizSaleOrderRespDto.setPlatformOrderNo(reqDto.getPlatformOrderNo());
        bizSaleOrderRespDto.setPlatformOrderId(reqDto.getPlatformOrderId());
        bizSaleOrderRespDto.setChannelCode(reqDto.getChannelCode());
        bizSaleOrderRespDto.setOrderType(reqDto.getOrderType());
        this.cspUpdateOrderStatus(bizSaleOrderRespDto, CspOrderStatusEnum.RECEIVED, false);
    }

    @Override
    public void refundOrderStatusUpdateToCspPoint(SaleRefundReqDto reqDto) {
        logger.info("\u9000\u5355\u72b6\u6001\u53d8\u66f4CSP\u8282\u70b9\uff1a{}", (Object)JSON.toJSONString((Object)reqDto));
        if (reqDto.getRefundStatus().equals(SaleOrderStatusEnum.COMPLETE.getCode())) {
            CSPUpdateCspOrderReqDto cspUpdateCspOrderReqDto = new CSPUpdateCspOrderReqDto();
            cspUpdateCspOrderReqDto.setOrderNo(reqDto.getPlatformRefundNo());
            cspUpdateCspOrderReqDto.setStatus(CspOrderStatusEnum.RECEIVED.getType());
            this.externalCspApi.updateCspOrderStatus(cspUpdateCspOrderReqDto);
            return;
        }
        logger.info("\u672a\u6ee1\u8db3\u63a8\u9001\u6761\u4ef6");
    }

    @Override
    public void refundOrderToSap(Long orderId) {
        BizSaleRefundRespDto respDto = (BizSaleRefundRespDto)RestResponseHelper.extractData((RestResponse)this.saleRefundQueryApi.queryById(orderId));
        logger.info("\u9500\u552e\u9000\u8d27\u5355\u63a8\u9001sap\uff1a{}", (Object)JSON.toJSONString((Object)respDto));
        SalesOrderCreateReqDto sapOrderCreateReqDto = new SalesOrderCreateReqDto();
        sapOrderCreateReqDto.setSalesOrderType(respDto.getRefundType());
        sapOrderCreateReqDto.setSalesOrganization(respDto.getOrganizationCode());
        sapOrderCreateReqDto.setDistributionChannel(respDto.getOrderChannelCode());
        sapOrderCreateReqDto.setSoldToParty(respDto.getCustomerCode());
        sapOrderCreateReqDto.setPurchaseOrderByCustomer(respDto.getSaleRefundNo());
        sapOrderCreateReqDto.setSdDocumentReason(respDto.getRemark());
        if (StringUtils.isNotBlank((CharSequence)respDto.getPartnerNo())) {
            ArrayList<SalesOrderPartnerInfo> toPartner = new ArrayList<SalesOrderPartnerInfo>();
            SalesOrderPartnerInfo partnerInfo = new SalesOrderPartnerInfo();
            partnerInfo.setCustomer(respDto.getPartnerNo());
            partnerInfo.setPartnerFunction(respDto.getPartnerFunction());
            toPartner.add(partnerInfo);
            sapOrderCreateReqDto.setToPartner(toPartner);
        }
        List goodsList = respDto.getGoodsList();
        ArrayList<SalesOrderItemInfo> toItem = new ArrayList<SalesOrderItemInfo>();
        for (SaleRefundItemRespDto item : goodsList) {
            SalesOrderItemInfo sapItem = new SalesOrderItemInfo();
            sapItem.setSalesOrderItemCategory(item.getOrderLine());
            sapItem.setPurchaseOrderByCustomer(respDto.getSaleRefundNo());
            sapItem.setMaterial(item.getSkuCode());
            sapItem.setRequestedQuantity(String.valueOf(item.getItemNum()));
            sapItem.setRequestedQuantityUnit(item.getItemUnit());
            sapItem.setZfield1(String.valueOf(item.getGift()));
            sapItem.setZfield2(String.valueOf(item.getLineAmount()));
            toItem.add(sapItem);
        }
        String sapNo = (String)RestResponseHelper.extractData((RestResponse)this.iExternalOutSapApi.salesOrderCreate(sapOrderCreateReqDto));
        SaleRefundReqDto modifyReqDto = new SaleRefundReqDto();
        modifyReqDto.setId(respDto.getId());
        modifyReqDto.setSapOrderNo(sapNo);
        this.saleRefundApi.modifySaleRefund(modifyReqDto);
    }

    @Override
    public void updateSaleOrderSignToEas(SaleOrderReqDto reqDto) {
        logger.info("\u9500\u552e\u5355\u7b7e\u6536\u63a8\u9001EAS\u7b7e\u6536\uff1a{}", (Object)JSON.toJSONString((Object)reqDto));
        if (reqDto.getOrderType().equals(CsInventorySourceTypeEnum.INTERNAL_DEAL.getCode()) || reqDto.getOrderType().equals(CsPcpBusinessTypeEnum.ROUTE_INTERNAL_DEAL.getCode())) {
            logger.info("\u5185\u90e8\u4ea4\u6613\uff0c\u5728\u9014\u5185\u90e8\u4ea4\u6613\u9500\u552e\u5355");
            CsTransferOrderRespDto transferOrder = (CsTransferOrderRespDto)RestResponseHelper.extractData((RestResponse)this.csTransferOrderApi.queryByTransferOrderNo(reqDto.getSaleOrderNo()));
            if (ObjectUtil.isNotEmpty((Object)transferOrder) && StringUtils.isNotBlank((CharSequence)transferOrder.getExtension())) {
                String easOrder = null;
                Map extension = (Map)JSON.parseObject((String)transferOrder.getExtension(), (TypeReference)new TypeReference<Map<String, String>>(){}, (Feature[])new Feature[0]);
                if (StringUtils.isNotBlank((CharSequence)((CharSequence)extension.get("EAS_PURCHASE_ORDER_ID")))) {
                    easOrder = (String)extension.get("EAS_PURCHASE_ORDER_ID");
                } else {
                    CsDeliveryResultOrderQueryDto queryDto = new CsDeliveryResultOrderQueryDto();
                    queryDto.setRelevanceNo(transferOrder.getTransferOrderNo());
                    queryDto.setExternalOrderNo(transferOrder.getExternalPurchaseOrderNo());
                    queryDto.setPageSize(Integer.valueOf(1));
                    queryDto.setPageNum(Integer.valueOf(1));
                    PageInfo dtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.csDeliveryResultOrderQueryApi.queryByPage(queryDto));
                    if (CollectionUtil.isEmpty((Collection)dtoPageInfo.getList())) {
                        logger.info("\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u7ed3\u679c\u5355\u4fe1\u606f");
                        return;
                    }
                    if (StringUtils.isNotBlank((CharSequence)((CsDeliveryResultOrderRespDto)dtoPageInfo.getList().get(0)).getExtension())) {
                        extension = (Map)JSON.parseObject((String)((CsDeliveryResultOrderRespDto)dtoPageInfo.getList().get(0)).getExtension(), (TypeReference)new TypeReference<Map<String, String>>(){}, (Feature[])new Feature[0]);
                        easOrder = (String)extension.get(EASOrderKayEnum.PURCHASE_IN.getCode());
                    }
                }
                if (StringUtils.isBlank((CharSequence)easOrder)) {
                    logger.info("\u6269\u5c55\u4fe1\u606f\u5f02\u5e38\uff0c\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u5355\u53f7");
                    return;
                }
                EASOrderAuditReqDto auditReqDto = new EASOrderAuditReqDto();
                auditReqDto.setFnumber(easOrder);
                auditReqDto.setBillType(EASBillTypeEnum.IMPORT_AUDIT_001_TYPE_103.code);
                this.executeToEas(OpenapiDefineEnum.EAS016, auditReqDto);
                return;
            }
            logger.info("\u627e\u4e0d\u5230\u8c03\u62e8\u5355");
        } else if (reqDto.getOrderType().equals(CsInventorySourceTypeEnum.INTERNAL_DEAL_RETURN.getCode()) || reqDto.getOrderType().equals(CsInventorySourceTypeEnum.SALE_RETURN_INTERNAL_DEAL.getCode())) {
            logger.info("\u5185\u90e8\u4ea4\u6613\u9000\u9500\u552e\u7ea2\u5355\u3001\u9500\u552e\u9000\u8f6c\u5185\u90e8\u4ea4\u6613\u9500\u552e\u7ea2\u5355");
        } else {
            logger.info("\u9500\u552e\u5355\u7b7e\u6536\u4e14\u8d22\u52a1\u4e2d\u53f0\u8fc7\u8d26\uff0c\u4fc3\u53d1EAS\u7b7e\u6536\uff1a{}", (Object)reqDto.getSaleOrderNo());
            this.saleSignToSAP(reqDto.getSaleOrderNo());
        }
    }

    @Override
    public void updateSaleOrderSignToEasOffset(String orderNo, String orderType) {
        SaleOrderReqDto reqDto = new SaleOrderReqDto();
        reqDto.setSaleOrderNo(orderNo);
        reqDto.setOrderType(orderType);
        this.updateSaleOrderSignToEas(reqDto);
    }

    private void saleSignToEAS(String saleOrderNo) {
        logger.info("\u9500\u552e\u5355\u7b7e\u6536\u63a8\u9001EAS\u66f4\u65b0\u72b6\u6001\uff1a{}", (Object)saleOrderNo);
        BizSaleOrderRespDto saleOrderRespDto = (BizSaleOrderRespDto)RestResponseHelper.extractData((RestResponse)this.saleOrderQueryApi.queryByOrderNo(saleOrderNo));
        logger.info("\u9500\u552e\u5355\u636e\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)saleOrderRespDto));
        if (this.saleSignToEASTypes().contains(saleOrderRespDto.getOrderType()) && StringUtils.isNotBlank((CharSequence)saleOrderRespDto.getEasOutOrderNo()) && saleOrderRespDto.getOrderStatus().equals(SaleOrderStatusEnum.RECEIVED.getCode())) {
            List collect = Arrays.stream(saleOrderRespDto.getEasOutOrderNo().replace("\uff0c", ",").split(",")).map(str -> {
                SaleOrderUpdate saleOrderUpdate = new SaleOrderUpdate();
                saleOrderUpdate.setNumber(str);
                saleOrderUpdate.setSignStatus(Boolean.valueOf(true));
                saleOrderUpdate.setOutSysNum(saleOrderRespDto.getSaleOrderNo());
                saleOrderUpdate.setSignDate(ObjectUtil.isNotEmpty((Object)saleOrderRespDto.getConfirmReceiveTime()) ? new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(saleOrderRespDto.getConfirmReceiveTime()) : null);
                return saleOrderUpdate;
            }).collect(Collectors.toList());
            this.executeToEas(OpenapiDefineEnum.EAS015, JSON.toJSONString(collect));
        } else {
            logger.info("\u4e0d\u6ee1\u8db3\u5904\u7406\u6761\u4ef6\uff1a{}", (Object)saleOrderNo);
        }
    }

    private void saleSignToSAP(String saleOrderNo) {
        logger.info("\u9500\u552e\u5355\u7b7e\u6536\u63a8\u9001SAP\u66f4\u65b0\u72b6\u6001\uff1a{}", (Object)saleOrderNo);
        BizSaleOrderRespDto saleOrderRespDto = (BizSaleOrderRespDto)RestResponseHelper.extractData((RestResponse)this.saleOrderQueryApi.queryByOrderNo(saleOrderNo));
        DeliveryResultOrderReqDto filter = new DeliveryResultOrderReqDto();
        ArrayList<String> relevanceNos = new ArrayList<String>();
        relevanceNos.add(saleOrderRespDto.getSaleOrderNo());
        filter.setRelevanceNos(relevanceNos);
        filter.setOrderType("delivery");
        PageInfo resp = (PageInfo)RestResponseHelper.extractData((RestResponse)this.deliveryResultOrderQueryApi.queryByPage(filter));
        List list = resp.getList();
        DeliveryResultOrderRespDto deliveryResult = new DeliveryResultOrderRespDto();
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            deliveryResult = (DeliveryResultOrderRespDto)list.get(0);
        }
        DeliveryResultOrderRespDto res = deliveryResult;
        logger.info("\u9500\u552e\u5355\u636e\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)saleOrderRespDto));
        if (this.saleSignToEASTypes().contains(saleOrderRespDto.getOrderType()) && StringUtils.isNotBlank((CharSequence)saleOrderRespDto.getEasOutOrderNo()) && saleOrderRespDto.getOrderStatus().equals(SaleOrderStatusEnum.RECEIVED.getCode())) {
            Arrays.stream(saleOrderRespDto.getEasOutOrderNo().replace("\uff0c", ",").split(",")).forEach(str -> {
                DeliveryOrderSignReqDto reqDto = new DeliveryOrderSignReqDto();
                reqDto.setSapOrderNo(str);
                reqDto.setExtSysNo(res.getDocumentNo());
                reqDto.setSignDate(ObjectUtil.isNotEmpty((Object)saleOrderRespDto.getConfirmReceiveTime()) ? saleOrderRespDto.getConfirmReceiveTime() : null);
                this.iExternalOutSapApi.deliveryOrderSign(reqDto);
            });
        } else {
            logger.info("\u4e0d\u6ee1\u8db3\u5904\u7406\u6761\u4ef6\uff1a{}", (Object)saleOrderNo);
        }
    }

    private List<String> saleSignToEASTypes() {
        return Lists.newArrayList((Object[])new String[]{SaleOrderTypeEnum.AGENCY_ORDER.getType(), SaleOrderTypeEnum.INTERNAL_DISTRIBUTION.getType(), SaleOrderTypeEnum.SECONDARY_DISTRIBUTION.getType(), SaleOrderTypeEnum.INTEGRAL_ORDER.getType(), SaleOrderTypeEnum.COMPENSATION_ORDER.getType(), SaleOrderTypeEnum.CLAIM_REISSUE.getType(), SaleOrderTypeEnum.CLAIM_POSTING.getType(), SaleOrderTypeEnum.PRESALE_ORDER.getType(), SaleOrderTypeEnum.CHILD_DIRECT_SALES.getType(), SaleOrderTypeEnum.SHOPPE_ORDER.getType(), SaleOrderTypeEnum.SPECIAL_CHANNEL_ORDER.getType()});
    }

    @Override
    public void updateSaleOrderSignToEasPoint(String saleOrderNo) {
        logger.info("\u9500\u552e\u5355\u7b7e\u6536\u63a8\u9001EAS\u7b7e\u6536\uff0c\u4eba\u5de5\u8865\u507f\uff1a{}", (Object)JSON.toJSONString((Object)saleOrderNo));
        this.saleSignToSAP(saleOrderNo);
    }

    @Override
    public void receiveDeliveryResultToYYJPoint(CsDeliveryReceiveResultRespDto dto) {
        logger.info("\u6536\u53d1\u8d27\u8282\u70b9\u4fc3\u53d1\u8425\u517b\u5bb6\uff1a{}", (Object)JSON.toJSONString((Object)dto));
        BizSaleOrderRespDto saleOrder = (BizSaleOrderRespDto)RestResponseHelper.extractData((RestResponse)this.saleOrderQueryApi.queryByOrderNo(dto.getRelevanceNo()));
        if (ObjectUtil.isEmpty((Object)saleOrder) || !saleOrder.getChannelCode().equals("YYJ") || StringUtils.isBlank((CharSequence)dto.getBusinessType())) {
            logger.info("\u4e0d\u7b26\u5408\u7684\u9500\u552e\u5355\uff1a{}", (Object)JSON.toJSONString((Object)saleOrder));
            return;
        }
        switch (CsPcpBusinessTypeEnum.getByCode((String)dto.getBusinessType())) {
            case NUTRITION_INTEGRAL: 
            case ACTIVITY_ORDER: {
                this.yyjUpdateOrderStatus(saleOrder, NutritionOrderStatus.SENDED);
                this.yyjExpress(saleOrder.getPlatformOrderNo(), dto);
                break;
            }
            case REPLENISHMENT_ORDER: {
                this.yyjUpdateOrderStatus(saleOrder, NutritionOrderStatus.SENDED);
                this.yyjExpress(saleOrder.getPlatformOrderNo(), dto);
                this.psiCreateOrder(dto, saleOrder, false);
                break;
            }
            default: {
                logger.info("\u672a\u5904\u7406\u7684\u8425\u517b\u5bb6\u7c7b\u578b\u8ba2\u5355\uff1a{}", (Object)dto.getBusinessType());
            }
        }
    }

    private void cspUpdateExchangeGoodsHeadSheet(CsDeliveryReceiveResultRespDto deliveryReceiveResultRespDto) {
        logger.info("\u66f4\u65b0\u6d88\u8d39\u8005\u9000\u6362\u8d27\u63a5\u53e3\uff1a{}\uff0c{}", (Object)deliveryReceiveResultRespDto.getExternalOrderNo(), (Object)JSON.toJSONString((Object)deliveryReceiveResultRespDto));
        try {
            if (StringUtils.isNotBlank((CharSequence)deliveryReceiveResultRespDto.getShippingCode())) {
                CSPUpdateExchangeGoodsHeadReqDto reqDto = new CSPUpdateExchangeGoodsHeadReqDto();
                reqDto.setBillNo(deliveryReceiveResultRespDto.getExternalOrderNo());
                reqDto.setApprovalStatus("8");
                reqDto.setCourierNumber(deliveryReceiveResultRespDto.getShippingCode());
                RestResponseHelper.extractData((RestResponse)this.externalCspApi.updateExchangeGoodsHeadSheet(reqDto));
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public String receiveDeliveryResultToYYJPointOffset(String documentNo) {
        logger.info("\u6536\u53d1\u8d27\u7ed3\u679c\u8bf7\u6c42\u8425\u517b\u5bb6\u8282\u70b9\uff08\u4eba\u5de5\u8865\u507f\uff09\uff1a{}", (Object)documentNo);
        CsDeliveryResultOrderQueryDto queryDto = new CsDeliveryResultOrderQueryDto();
        queryDto.setDocumentNo(documentNo);
        CsDeliveryReceiveResultRespDto csDeliveryReceiveResultRespDto = (CsDeliveryReceiveResultRespDto)RestResponseHelper.extractData((RestResponse)this.csDeliveryResultOrderQueryApi.queryDeliveryReceiveResultDetail(queryDto));
        if (ObjectUtil.isEmpty((Object)csDeliveryReceiveResultRespDto)) {
            return "\u627e\u4e0d\u5230\u7ed3\u679c\u5355";
        }
        this.receiveDeliveryResultToYYJPoint(csDeliveryReceiveResultRespDto);
        return "\u6267\u884c\u5b8c\u6bd5\uff01";
    }

    @Override
    public void orderSignToYYJPoint(SaleOrderReqDto dto) {
        logger.info("\u8ba2\u5355\u5b8c\u6210\u7b7e\u6536\u901a\u77e5\u8425\u517b\u5bb6\u8282\u70b9\uff1a{}", (Object)JSON.toJSONString((Object)dto));
        if (ObjectUtil.isNotEmpty((Object)dto) && dto.getChannelCode().equals("YYJ")) {
            BizSaleOrderRespDto saleOrderRespDto = new BizSaleOrderRespDto();
            BeanUtil.copyProperties((Object)dto, (Object)saleOrderRespDto, (String[])new String[0]);
            this.yyjUpdateOrderStatus(saleOrderRespDto, NutritionOrderStatus.FINISH);
        }
    }

    @Override
    public String orderSignToYYJPointOffset(String saleOrderNo) {
        logger.info("\u8ba2\u5355\u5b8c\u6210\u7b7e\u6536\u901a\u77e5\u8425\u517b\u5bb6\u8282\u70b9\uff0c\u4eba\u5de5\u8865\u507f\uff1a{}", (Object)saleOrderNo);
        BizSaleOrderRespDto bizSaleOrderRespDto = (BizSaleOrderRespDto)RestResponseHelper.extractData((RestResponse)this.saleOrderQueryApi.queryByOrderNo(saleOrderNo));
        if (ObjectUtil.isNotEmpty((Object)bizSaleOrderRespDto)) {
            BizSaleOrderReqDto reqDto = new BizSaleOrderReqDto();
            BeanUtil.copyProperties((Object)bizSaleOrderRespDto, (Object)reqDto, (String[])new String[0]);
            this.orderSignToYYJPoint((SaleOrderReqDto)reqDto);
            return "\u6267\u884c\u6210\u529f";
        }
        return "\u627e\u4e0d\u5230\u9500\u552e\u8ba2\u5355";
    }

    @Override
    public void logisticsToYYJ(CsLogisticsInfoSyncDto.DataInfo dto) {
    }

    @Override
    public void adjustmentInventoryToEasPoint(AdjustmentInventoryRespDto respDto) {
        logger.info("\u5728\u9014\u5e93\u5b58\u8c03\u6574\u5355\u63a8\u9001EAS\u8282\u70b9\uff1a{}", (Object)JSON.toJSONString((Object)respDto));
        String type = ((AdjustmentInventoryDetailRespDto)respDto.getDetailRespDtoList().get(0)).getChangeType().equals("increase") ? "add" : "reduce";
        logger.info("\u5224\u65ad\u8c03\u6574\u7c7b\u578b\uff1a{}", (Object)type);
        if (respDto.getSourceType().equals("in_transit_transfer") && type.equals("add")) {
            CsTransferOrderRespDto transferOrderRespDto = (CsTransferOrderRespDto)RestResponseHelper.extractData((RestResponse)this.csTransferOrderApi.queryByTransferOrderNo(respDto.getPreOrderNo()));
            this.dispatchEasInventoryAllot.create(respDto, transferOrderRespDto, EASGeneralSubBillFlagEnum.CODE_110110, type, null);
        } else if (respDto.getSourceType().equals("deliverResult") || respDto.getSourceType().equals("receiveResult")) {
            CsOutResultOrderRespDto csOutResultOrderRespDto = (CsOutResultOrderRespDto)RestResponseHelper.extractData((RestResponse)this.csOutResultOrderQueryApi.queryByDocumentNo(respDto.getPreOrderNo()));
            if (ObjectUtil.isEmpty((Object)csOutResultOrderRespDto)) {
                logger.info("\u53d1\u8d27\u7ed3\u679c\u4e0d\u5b58\u5728");
                return;
            }
            CsTransferOrderRespDto transferOrderRespDto = (CsTransferOrderRespDto)RestResponseHelper.extractData((RestResponse)this.csTransferOrderApi.queryByTransferOrderNo(csOutResultOrderRespDto.getRelevanceNo()));
            if (ObjectUtil.isEmpty((Object)transferOrderRespDto)) {
                logger.info("\u8c03\u62e8\u5355\u4e0d\u5b58\u5728");
                return;
            }
            this.dispatchEasInventoryAllot.create(respDto, transferOrderRespDto, EASGeneralSubBillFlagEnum.CODE_110110, type, csOutResultOrderRespDto);
        } else {
            logger.info("\u672a\u77e5\u7c7b\u578b");
        }
    }

    @Override
    public String adjustmentInventoryToEasPointOffset(String adjustmentNo) {
        logger.info("\u5728\u9014\u5e93\u5b58\u8c03\u6574\u5355\u63a8\u9001EAS\u8282\u70b9\uff0c\u4eba\u5de5\u8865\u507f\uff1a{}", (Object)adjustmentNo);
        AdjustmentInventoryRespDto adjustmentInventoryRespDto = (AdjustmentInventoryRespDto)RestResponseHelper.extractData((RestResponse)this.adjustmentInventoryQueryApi.queryByAdjustmentNo(adjustmentNo));
        if (ObjectUtil.isEmpty((Object)adjustmentInventoryRespDto) || CollectionUtil.isEmpty((Collection)adjustmentInventoryRespDto.getDetailRespDtoList())) {
            return "\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u8c03\u6574\u5355";
        }
        this.adjustmentInventoryToEasPoint(adjustmentInventoryRespDto);
        return "\u6267\u884c\u6210\u529f";
    }

    @Override
    public void saleOrderResultApportion(CsDeliveryReceiveResultRespDto dto) {
        logger.info("\u9500\u552e\u5355\u7ed3\u679c\u5206\u644a\uff1a{}", (Object)JSON.toJSONString((Object)dto));
        String type = null;
        switch (CsRelevanceTableNameEnum.getStatusByCode((String)dto.getRelevanceTableName())) {
            case CS_ORDER_SALE: {
                type = ApportionOrderEnum.SALE.getCode();
                break;
            }
            case CS_ORDER_SALE_REFUND: {
                logger.info("\u9500\u552e\u9000\u5206\u644a\u7b49\u5355\u636e\u5b8c\u6210\u901a\u77e5\u5728\u8fdb\u884c\u89e6\u53d1");
                break;
            }
            case CS_TRANSFER_ORDER: {
                if (dto.getOrderType().equals("delivery") && (dto.getBusinessType().equals(CsPcpBusinessTypeEnum.INTERNAL_DEAL.getCode()) || dto.getBusinessType().equals(CsPcpBusinessTypeEnum.ROUTE_INTERNAL_DEAL.getCode()) || dto.getBusinessType().equals(CsPcpBusinessTypeEnum.ALLOT_SALE.getCode()))) {
                    type = dto.getBusinessType();
                    break;
                }
                if (dto.getOrderType().equals("receive") && (dto.getBusinessType().equals(CsPcpBusinessTypeEnum.INTERNAL_DEAL_RETURN.getCode()) || dto.getBusinessType().equals(CsPcpBusinessTypeEnum.SALE_RETURN_INTERNAL_DEAL.getCode()))) {
                    type = dto.getBusinessType();
                    break;
                }
                logger.info("\u975e\u6307\u5b9a\u8c03\u62e8\uff0c\u4e0d\u8fdb\u884c\u5206\u644a");
                break;
            }
            default: {
                logger.info("\u672a\u5904\u7406\u7684\u5206\u644a\u7c7b\u578b");
            }
        }
        if (StringUtils.isNotBlank((CharSequence)type)) {
            logger.info("\u5206\u644a\u7c7b\u578b\uff1a{}", (Object)type);
            try {
                Thread.sleep(5000L);
                RestResponseHelper.extractData((RestResponse)this.deliveryResultOrderQueryApi.orderDetailApportionBase((List)Lists.newArrayList((Object[])new String[]{dto.getRelevanceNo()}), type));
            }
            catch (Exception e) {
                logger.error("\u5ef6\u8fdf\u5206\u644a\u5f02\u5e38\uff1a" + e.getMessage());
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    @Override
    public void saleRefundResultApportion(SaleRefundReqDto dto) {
        logger.info("\u9500\u552e\u9000\u5355\u7ed3\u679c\u5206\u644a\uff1a{}", (Object)JSON.toJSONString((Object)dto));
        RestResponseHelper.extractData((RestResponse)this.deliveryResultOrderQueryApi.orderDetailApportionBase((List)Lists.newArrayList((Object[])new String[]{dto.getSaleRefundNo()}), ApportionOrderEnum.SALE_REFUND.getCode()));
    }

    @Override
    public void transferOrderReceiveDeliveryResultToFinanceZT(CsDeliveryReceiveResultRespDto dto) {
        logger.info("\u8c03\u62e8\u5355\u6536\u53d1\u8d27\u63a8\u9001\u8d22\u52a1\u4e2d\u53f0\uff1a{}", (Object)JSON.toJSONString((Object)dto));
        switch (CsPcpBusinessTypeEnum.getByCode((String)dto.getBusinessType())) {
            case BC_ALLOT: 
            case MAIYOU_BC_ALLOT: {
                if (!dto.getOrderType().equals(BasicsOrderOperateTypeEnum.DELIVERY.getCode().toLowerCase())) break;
                this.transferOrderReceiveDeliveryResultToFinanceZTExecute(dto);
                break;
            }
            case CB_ALLOT: 
            case CC_ALLOT: {
                CsTransferOrderRespDto transferOrderRespDto = (CsTransferOrderRespDto)RestResponseHelper.extractData((RestResponse)this.csTransferOrderApi.queryByTransferOrderNo(dto.getRelevanceNo()));
                if (ObjectUtil.isEmpty((Object)transferOrderRespDto) || StringUtils.isBlank((CharSequence)transferOrderRespDto.getOutLogicWarehouseCode())) {
                    throw new BizException("-1", "\u627e\u4e0d\u5230\u8c03\u62e8\u5355\u636e\u6216\u65e0\u51fa\u5e93\u903b\u8f91\u4ed3");
                }
                boolean ifF = false;
                DgLogicWarehousePageReqDto logicQueryDto = new DgLogicWarehousePageReqDto();
                logicQueryDto.setWarehouseCode(transferOrderRespDto.getOutLogicWarehouseCode());
                List warehouseList = (List)RestResponseHelper.extractData((RestResponse)this.dgLogicWarehouseApi.queryList(logicQueryDto));
                if (CollectionUtil.isEmpty((Collection)warehouseList) || StringUtils.isBlank((CharSequence)((DgLogicWarehouseDto)warehouseList.get(0)).getWarehouseCorrespondingSystem())) {
                    throw new BizException("-1", "\u627e\u4e0d\u5230\u903b\u8f91\u4ed3\u5e93\u4fe1\u606f");
                }
                DgLogicWarehouseDto warehouseRespDto = (DgLogicWarehouseDto)warehouseList.get(0);
                logger.info("\u6536\u8d27\u4ed3\u5e93\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)warehouseRespDto));
                if (StringUtils.isNotBlank((CharSequence)warehouseRespDto.getWarehouseCorrespondingSystem()) && warehouseRespDto.getWarehouseCorrespondingSystem().equals(WarehouseCorrespondingSystemEnum.E3_BS.getCode())) {
                    ifF = true;
                }
                if (ifF) {
                    logger.info("\u96c6\u56e2\u51fa");
                    if (!dto.getOrderType().equals(BasicsOrderOperateTypeEnum.DELIVERY.getCode().toLowerCase())) break;
                    this.transferOrderReceiveDeliveryResultToFinanceZTExecute(dto);
                    break;
                }
                logger.info("\u9ea6\u4f18\u51fa");
                if (!dto.getOrderType().equals(BasicsOrderOperateTypeEnum.RECEIVE.getCode().toLowerCase())) break;
                this.transferOrderReceiveDeliveryResultToFinanceZTExecute(dto);
                break;
            }
            default: {
                logger.info("\u975eE3\u76f8\u5173\u8c03\u62e8");
            }
        }
    }

    @Override
    public void transferOrderReceiveDeliveryResultToFinanceZTBA(CsDeliveryReceiveResultRespDto dto) {
        logger.info("\u5185\u90e8\u4ea4\u6613\u5355(\u4f70\u50b2)\u63a8\u9001\u8d22\u52a1\u4e2d\u53f0\uff1a{}", (Object)JSON.toJSONString((Object)dto));
        switch (CsPcpBusinessTypeEnum.getByCode((String)dto.getBusinessType())) {
            case INTERNAL_DEAL_BA: 
            case INTERNAL_DEAL_RETURN_BA: 
            case SALE_RETURN_INTERNAL_DEAL_BA: 
            case ROUTE_INTERNAL_DEAL_BA: {
                if (!dto.getOrderType().equals(BasicsOrderOperateTypeEnum.RECEIVE.getCode().toLowerCase())) break;
                this.transferOrderReceiveDeliveryResultToFinanceZTExecuteBA(dto);
                break;
            }
            default: {
                logger.info("\u975e\u4f70\u50b2\u4ee3\u7406\u5185\u90e8\u4ea4\u6613\u5355");
            }
        }
    }

    private void transferOrderReceiveDeliveryResultToFinanceZTExecute(CsDeliveryReceiveResultRespDto dto) {
        logger.info("\u6267\u884c\u8c03\u62e8\u5355\u6536\u53d1\u8d27\u63a8\u9001\u8d22\u52a1\u4e2d\u53f0");
        if (ObjectUtil.isEmpty((Object)dto) || CollectionUtil.isEmpty((Collection)dto.getDeliveryReceiveResultDetailRespDtoList())) {
            logger.info("\u7ed3\u679c\u4fe1\u606f\u6709\u8bef");
            return;
        }
        CsTransferOrderRespDto transferOrder = (CsTransferOrderRespDto)RestResponseHelper.extractData((RestResponse)this.csTransferOrderApi.queryByTransferOrderNo(dto.getRelevanceNo()));
        AssertUtil.isFalse(ObjectUtil.isEmpty((Object)transferOrder), "\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u8c03\u62e8\u5355");
        CsDeliveryResultOrderQueryDto queryDto = new CsDeliveryResultOrderQueryDto();
        queryDto.setRelevanceNo(dto.getRelevanceNo());
        List resultOrderRespDtoList = (List)RestResponseHelper.extractData((RestResponse)this.csDeliveryResultOrderQueryApi.queryByParam(queryDto));
        this.gainDetailMoreIfo(dto, dto.getDeliveryLogicWarehouseCode());
        FinanceZTAllotOrderDto orderDto = new FinanceZTAllotOrderDto();
        orderDto.setYd_businesstype(YdBusinesstypeEnum.CROSS_ORGANIZATION_TRANSFER.code);
        orderDto.setBillno(dto.getRelevanceNo());
        orderDto.setYd_bizdate(ObjectUtil.isNotEmpty((Object)dto.getCreateTime()) ? DateUtil.format((Date)dto.getCreateTime(), (String)DatePattern.DATE_PATTERN.getPattern()) : null);
        orderDto.setYd_interoutorg(this.getOrgCodeByWarehouseCode(transferOrder.getOutLogicWarehouseCode()));
        orderDto.setYd_interinorg(this.getOrgCodeByWarehouseCode(transferOrder.getInLogicWarehouseCode()));
        orderDto.setYd_interoutwarehouse(transferOrder.getOutLogicWarehouseCode());
        orderDto.setYd_interinwarehouse(transferOrder.getInLogicWarehouseCode());
        orderDto.setYd_description(dto.getRemark());
        orderDto.setYd_srcbillid(orderDto.getBillno());
        if (CollectionUtil.isNotEmpty((Collection)resultOrderRespDtoList)) {
            logger.info("\u7ed3\u679c\u5355\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)resultOrderRespDtoList));
            resultOrderRespDtoList.forEach(result -> {
                if (result.getOrderType().equals("delivery")) {
                    orderDto.setYd_ocs_dsnumber(result.getDocumentNo());
                }
                if (result.getOrderType().equals("receive")) {
                    orderDto.setYd_ocs_rsnumber(result.getDocumentNo());
                }
            });
        }
        orderDto.setEntryentity(dto.getDeliveryReceiveResultDetailRespDtoList().stream().map(detail -> {
            FinanceZTAllotOrderDetailDto detailDto = new FinanceZTAllotOrderDetailDto();
            detailDto.setYd_srcbillentryid(detail.getId().toString());
            detailDto.setYd_intermaterial(detail.getLongCode());
            detailDto.setYd_intermaterialname(detail.getCargoName());
            detailDto.setYd_batchno(detail.getBatch());
            detailDto.setYd_probegindate(ObjectUtil.isNotEmpty((Object)detail.getProduceTime()) ? DateUtil.format((Date)detail.getProduceTime(), (String)DatePattern.DATE_PATTERN.getPattern()) : null);
            detailDto.setYd_proenddate(ObjectUtil.isNotEmpty((Object)detail.getExpireTime()) ? DateUtil.format((Date)detail.getExpireTime(), (String)DatePattern.DATE_PATTERN.getPattern()) : null);
            detailDto.setYd_quantity(detail.getQuantity().stripTrailingZeros().toPlainString());
            return detailDto;
        }).collect(Collectors.toList()));
        RestResponseHelper.extractData((RestResponse)this.externalFinanceZTApi.pushAllotOrder(orderDto, transferOrder.getTransferOrderNo()));
    }

    private void transferOrderReceiveDeliveryResultToFinanceZTExecuteBA(CsDeliveryReceiveResultRespDto dto) {
        logger.info("\u6267\u884c\u8c03\u62e8\u5355\u6536\u53d1\u8d27\u63a8\u9001\u8d22\u52a1\u4e2d\u53f0");
        if (ObjectUtil.isEmpty((Object)dto) || CollectionUtil.isEmpty((Collection)dto.getDeliveryReceiveResultDetailRespDtoList())) {
            logger.info("\u7ed3\u679c\u4fe1\u606f\u6709\u8bef");
            return;
        }
        CsTransferOrderRespDto transferOrder = (CsTransferOrderRespDto)RestResponseHelper.extractData((RestResponse)this.csTransferOrderApi.queryByTransferOrderNo(dto.getRelevanceNo()));
        AssertUtil.isFalse(ObjectUtil.isEmpty((Object)transferOrder), "\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u8c03\u62e8\u5355");
        CsDeliveryResultOrderQueryDto queryDto = new CsDeliveryResultOrderQueryDto();
        queryDto.setRelevanceNo(dto.getRelevanceNo());
        List resultOrderRespDtoList = (List)RestResponseHelper.extractData((RestResponse)this.csDeliveryResultOrderQueryApi.queryByParam(queryDto));
        this.gainDetailMoreIfo(dto, dto.getDeliveryLogicWarehouseCode());
        FinanceZTDealOrderDto orderDto = new FinanceZTDealOrderDto();
        orderDto.setYd_srcbillid(transferOrder.getId().toString());
        orderDto.setYd_businesstype(dto.getBusinessType());
        orderDto.setBillno(dto.getRelevanceNo());
        orderDto.setYd_bizdate(ObjectUtil.isNotEmpty((Object)dto.getCreateTime()) ? DateUtil.format((Date)dto.getCreateTime(), (String)DatePattern.DATE_PATTERN.getPattern()) : null);
        orderDto.setYd_interoutorg(this.getOrgCodeByWarehouseCode(transferOrder.getOutLogicWarehouseCode()));
        orderDto.setYd_interinorg(this.getOrgCodeByWarehouseCode(transferOrder.getInLogicWarehouseCode()));
        orderDto.setYd_interoutwarehouse(transferOrder.getOutLogicWarehouseCode());
        orderDto.setYd_interinwarehouse(transferOrder.getInLogicWarehouseCode());
        orderDto.setYd_description(dto.getRemark());
        JSONObject extensionJson = JSONObject.parseObject((String)dto.getExtension());
        orderDto.setYd_purorderid(extensionJson.getString(EASExtendKeyEnum.PURCHASE_ORDER_ID.code));
        orderDto.setYd_purorderno(extensionJson.getString(EASExtendKeyEnum.PURCHASE_ORDER_NO.code));
        orderDto.setYd_purreturnid(extensionJson.getString(EASExtendKeyEnum.PURCHASE_RETURN_ORDER_ID.code));
        orderDto.setYd_purreturnno(extensionJson.getString(EASExtendKeyEnum.PURCHASE_RETURN_ORDER_NO.code));
        orderDto.setYd_saleorderid(extensionJson.getString(EASExtendKeyEnum.SALE_ORDER_ID.code));
        orderDto.setYd_saleorderno(extensionJson.getString(EASExtendKeyEnum.SALE_ORDER_NO.code));
        orderDto.setYd_salereturnid(extensionJson.getString(EASExtendKeyEnum.SALE_RETURN_ORDER_ID.code));
        orderDto.setYd_salereturnno(extensionJson.getString(EASExtendKeyEnum.SALE_RETURN_ORDER_NO.code));
        orderDto.setYd_platformorderno(transferOrder.getPreOrderNo());
        if (CollectionUtil.isNotEmpty((Collection)resultOrderRespDtoList)) {
            logger.info("\u7ed3\u679c\u5355\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)resultOrderRespDtoList));
            resultOrderRespDtoList.forEach(result -> {
                if (result.getOrderType().equals("delivery")) {
                    orderDto.setYd_ocs_dsnumber(result.getDocumentNo());
                }
                if (result.getOrderType().equals("receive")) {
                    orderDto.setYd_ocs_rsnumber(result.getDocumentNo());
                }
            });
        }
        orderDto.setEntryentity(dto.getDeliveryReceiveResultDetailRespDtoList().stream().map(detail -> {
            FinanceZTDealOrderDetailDto detailDto = new FinanceZTDealOrderDetailDto();
            detailDto.setYd_srcbillentryid(detail.getId().toString());
            JSONObject itemExtensionJson = JSONObject.parseObject((String)detail.getExtension());
            detailDto.setYd_purorderentryid(itemExtensionJson.getString(EASExtendKeyEnum.PURCHASE_ORDER_ENTRYID.code));
            detailDto.setYd_purreturnentryid(itemExtensionJson.getString(EASExtendKeyEnum.PURCHASE_RETURN_ORDER_ENTRYID.code));
            detailDto.setYd_saleorderentryid(itemExtensionJson.getString(EASExtendKeyEnum.SALE_ORDER_ENTRYID.code));
            detailDto.setYd_salereturnentryid(itemExtensionJson.getString(EASExtendKeyEnum.SALE_RETURN_ORDER_ENTRYID.code));
            detailDto.setYd_intermaterial(detail.getLongCode());
            detailDto.setYd_intermaterialname(detail.getCargoName());
            detailDto.setYd_batchno(detail.getBatch());
            detailDto.setYd_probegindate(ObjectUtil.isNotEmpty((Object)detail.getProduceTime()) ? DateUtil.format((Date)detail.getProduceTime(), (String)DatePattern.DATE_PATTERN.getPattern()) : null);
            detailDto.setYd_proenddate(ObjectUtil.isNotEmpty((Object)detail.getExpireTime()) ? DateUtil.format((Date)detail.getExpireTime(), (String)DatePattern.DATE_PATTERN.getPattern()) : null);
            detailDto.setYd_quantity(detail.getQuantity().stripTrailingZeros().toPlainString());
            return detailDto;
        }).collect(Collectors.toList()));
        RestResponseHelper.extractData((RestResponse)this.externalFinanceZTApi.pushDealTransBill(orderDto, transferOrder.getTransferOrderNo()));
    }

    @Override
    public String transferOrderReceiveDeliveryResultToFinanceZTOffset(String documentNo) {
        logger.info("\u8c03\u62e8\u5355\u6536\u53d1\u8d27\u63a8\u9001\u8d22\u52a1\u4e2d\u53f0\uff0c\u4eba\u5de5\u8865\u507f\uff1a{}", (Object)documentNo);
        CsDeliveryResultOrderQueryDto queryDto = new CsDeliveryResultOrderQueryDto();
        queryDto.setDocumentNo(documentNo);
        CsDeliveryReceiveResultRespDto csDeliveryReceiveResultRespDto = (CsDeliveryReceiveResultRespDto)RestResponseHelper.extractData((RestResponse)this.csDeliveryResultOrderQueryApi.queryDeliveryReceiveResultDetail(queryDto));
        if (ObjectUtil.isEmpty((Object)csDeliveryReceiveResultRespDto)) {
            return "\u627e\u4e0d\u5230\u7ed3\u679c\u5355";
        }
        this.transferOrderReceiveDeliveryResultToFinanceZT(csDeliveryReceiveResultRespDto);
        return "\u6267\u884c\u5b8c\u6bd5\uff01";
    }

    @Override
    public String transferOrderReceiveDeliveryResultToFinanceZTOffsetBA(String documentNo) {
        logger.info("\u5185\u90e8\u4ea4\u6613\u5355(\u4f70\u50b2)\u63a8\u9001\u8d22\u52a1\u4e2d\u53f0\uff0c\u4eba\u5de5\u8865\u507f\uff1a{}", (Object)documentNo);
        CsDeliveryResultOrderQueryDto queryDto = new CsDeliveryResultOrderQueryDto();
        queryDto.setDocumentNo(documentNo);
        CsDeliveryReceiveResultRespDto csDeliveryReceiveResultRespDto = (CsDeliveryReceiveResultRespDto)RestResponseHelper.extractData((RestResponse)this.csDeliveryResultOrderQueryApi.queryDeliveryReceiveResultDetail(queryDto));
        if (ObjectUtil.isEmpty((Object)csDeliveryReceiveResultRespDto)) {
            return "\u627e\u4e0d\u5230\u7ed3\u679c\u5355";
        }
        this.transferOrderReceiveDeliveryResultToFinanceZTBA(csDeliveryReceiveResultRespDto);
        return "\u6267\u884c\u5b8c\u6bd5\uff01";
    }

    private FinanceZTAllotOrderDto buildFinanceZTAllotOrder(CsDeliveryReceiveResultRespDto dto) {
        FinanceZTAllotOrderDto orderDto = new FinanceZTAllotOrderDto();
        orderDto.setBillno(dto.getDocumentNo());
        orderDto.setYd_bizdate(ObjectUtil.isNotEmpty((Object)dto.getCreateTime()) ? DateUtil.format((Date)dto.getCreateTime(), (String)DatePattern.DATE_PATTERN.getPattern()) : null);
        return orderDto;
    }

    @Override
    public void saleTransferOrderClear(String noticeOrderNo) {
        logger.info("\u8c03\u62e8\u5355\u53d6\u6d88\uff0c\u9500\u552e\u8c03\u62e8\u6e05\u695a\u5173\u8054\u8bb0\u5f55");
        CsOutNoticeOrderRespDto noticeOrderRespDto = (CsOutNoticeOrderRespDto)RestResponseHelper.extractData((RestResponse)this.csOutNoticeOrderQueryApi.queryByDocumentNo(noticeOrderNo));
        AssertUtil.isFalse(ObjectUtil.isEmpty((Object)noticeOrderNo), "\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u901a\u77e5\u5355\u4fe1\u606f");
        if (noticeOrderRespDto.getRelevanceTableName().equals(CsRelevanceTableNameEnum.CS_TRANSFER_ORDER.getCode()) && (noticeOrderRespDto.getBusinessType().equals(FinishedGoodsInventoryTypeEnum.ALLOT_SALE.getCode()) || noticeOrderRespDto.getBusinessType().equals(FinishedGoodsInventoryTypeEnum.ALLOT_SALE_BH.getCode()))) {
            SaleTransferOrderReqDto reqDto = new SaleTransferOrderReqDto();
            reqDto.setTransferOrderNo(noticeOrderRespDto.getRelevanceNo());
            RestResponseHelper.extractData((RestResponse)this.saleTransferOrderApi.removeSaleTransferOrderByParam(reqDto));
        } else {
            logger.info("\u975e\u9500\u552e\u8c03\u62e8\u6216\u9500\u552e\u8865\u8d27\u8c03\u62e8\uff0c\u65e0\u9700\u5904\u7406");
        }
    }

    @Override
    public void transferOrderReceiveDeliveryResultToBSE3(CsDeliveryReceiveResultRespDto dto) {
        logger.info("\u8c03\u62e8\u5355\u51fa\u5165\u63a8\u9001\u96c6\u56e2E3\u91c7\u8d2d\u5165\u53ca\u91c7\u8d2d\uff1a{}", (Object)JSON.toJSONString((Object)dto));
        if (StringUtils.isNotBlank((CharSequence)dto.getBusinessType()) && dto.getBusinessType().equals(FinishedGoodsInventoryTypeEnum.ALLOT_LOGIC_OUT.getCode())) {
            CsTransferOrderRespDto transferOrder = (CsTransferOrderRespDto)RestResponseHelper.extractData((RestResponse)this.csTransferOrderApi.queryByTransferOrderNo(dto.getRelevanceNo()));
            if (ObjectUtil.isEmpty((Object)transferOrder)) {
                logger.info("\u627e\u4e0d\u5230\u8c03\u62e8\u5355\u4fe1\u606f");
                return;
            }
            DgLogicWarehousePageReqDto params = new DgLogicWarehousePageReqDto();
            params.setWarehouseCode(dto.getOrderType().equals(BasicsOrderOperateTypeEnum.DELIVERY.getCode().toLowerCase()) ? dto.getDeliveryLogicWarehouseCode() : dto.getReceiveLogicWarehouseCode());
            List warehouseRespDtoList = (List)RestResponseHelper.extractData((RestResponse)this.dgLogicWarehouseApi.queryList(params));
            if (CollectionUtil.isEmpty((Collection)warehouseRespDtoList)) {
                logger.info("\u627e\u4e0d\u5230\u4ed3\u5e93\u4fe1\u606f");
                return;
            }
            DgLogicWarehouseDto warehouseRespDto = (DgLogicWarehouseDto)warehouseRespDtoList.get(0);
            if (ObjectUtil.isEmpty((Object)warehouseRespDto.getIsBcShare()) || warehouseRespDto.getIsBcShare() != 1) {
                logger.info("\u975eBC\u5171\u4ed3\uff0c\u4e0d\u8fdb\u884c\u5904\u7406");
                return;
            }
            E3BSPurchaseAddReqDto reqDto = new E3BSPurchaseAddReqDto();
            reqDto.setDjbh(dto.getDocumentNo());
            reqDto.setWarehouseCode(warehouseRespDto.getWarehouseCode());
            reqDto.setGhsCode("001");
            reqDto.setZdr("");
            reqDto.setZdrq(ObjectUtil.isNotEmpty((Object)transferOrder.getCreateTime()) ? DateUtil.format((Date)transferOrder.getCreateTime(), (String)DatePattern.DATETIME_PATTERN.getPattern()) : null);
            reqDto.setBz(dto.getRemark());
            reqDto.setIsAutoComplete("1");
            List collect = dto.getDeliveryReceiveResultDetailRespDtoList().stream().map(item -> {
                E3BSPurchaseAddDetailReqDto detailReqDto = new E3BSPurchaseAddDetailReqDto();
                detailReqDto.setSku(item.getLongCode().substring(item.getLongCode().lastIndexOf(".") + 1));
                detailReqDto.setDj("1");
                detailReqDto.setSl(item.getQuantity().toString());
                detailReqDto.setGoods_sn("");
                detailReqDto.setSize_code("");
                detailReqDto.setBatchCode(item.getBatch());
                detailReqDto.setProductDate(ObjectUtil.isNotEmpty((Object)item.getProduceTime()) ? DateUtil.format((Date)item.getProduceTime(), (String)DatePattern.DATETIME_PATTERN.getPattern()) : null);
                detailReqDto.setExpireDate(ObjectUtil.isNotEmpty((Object)item.getExpireTime()) ? DateUtil.format((Date)item.getExpireTime(), (String)DatePattern.DATETIME_PATTERN.getPattern()) : null);
                return detailReqDto;
            }).collect(Collectors.toList());
            reqDto.setSku(collect);
            if (dto.getOrderType().equals(BasicsOrderOperateTypeEnum.DELIVERY.getCode().toLowerCase())) {
                RestResponseHelper.extractData((RestResponse)this.externalE3Api.bsPurchaseRefund(reqDto, transferOrder.getTransferOrderNo()));
            } else {
                RestResponseHelper.extractData((RestResponse)this.externalE3Api.bsPurchaseAdd(reqDto, transferOrder.getTransferOrderNo()));
            }
        }
    }

    @Override
    public String transferOrderReceiveDeliveryResultToBSE3Offset(String documentNo) {
        logger.info("\u8c03\u62e8\u5355\u51fa\u5165\u63a8\u9001\u96c6\u56e2E3\u91c7\u8d2d\u5165\u53ca\u91c7\u8d2d\uff0c\u4eba\u5de5\u8865\u507f\uff1a{}", (Object)documentNo);
        CsDeliveryResultOrderQueryDto queryDto = new CsDeliveryResultOrderQueryDto();
        queryDto.setDocumentNo(documentNo);
        CsDeliveryReceiveResultRespDto csDeliveryReceiveResultRespDto = (CsDeliveryReceiveResultRespDto)RestResponseHelper.extractData((RestResponse)this.csDeliveryResultOrderQueryApi.queryDeliveryReceiveResultDetail(queryDto));
        if (ObjectUtil.isEmpty((Object)csDeliveryReceiveResultRespDto)) {
            return "\u627e\u4e0d\u5230\u7ed3\u679c\u5355";
        }
        this.transferOrderReceiveDeliveryResultToBSE3(csDeliveryReceiveResultRespDto);
        return "\u6267\u884c\u5b8c\u6bd5\uff01";
    }

    @Override
    public void routeInternalDealFinish(CsTransferOrderRespDto transferOrder) {
        CsOutNoticeOrderRespDto noticeOrder;
        logger.info("\u5728\u9014\u5185\u90e8\u4ea4\u6613\u5b8c\u6210\uff0c\u5904\u7406\u540e\u7eed\u540e\u7eed\u6d41\u7a0b\uff1a{}", (Object)JacksonUtil.toJson((Object)transferOrder));
        String noticeOrderNo = this.getExtensionValue(transferOrder.getExtension(), EASExtendKeyEnum.ROUTE_DEAL_NOTICE_NO.code);
        String detailIds = this.getExtensionValue(transferOrder.getExtension(), EASExtendKeyEnum.ROUTE_DEAL_DETAIL_ID.code);
        CsOutNoticeOrderQueryDto noticeOrderQueryDto = new CsOutNoticeOrderQueryDto();
        noticeOrderQueryDto.setDocumentNo(noticeOrderNo);
        List csOutNoticeOrderRespDtoList = (List)RestResponseHelper.extractData((RestResponse)this.csOutNoticeOrderQueryApi.queryByParam(noticeOrderQueryDto));
        AssertUtil.isFalse(CollectionUtil.isEmpty((Collection)csOutNoticeOrderRespDtoList), "\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u901a\u77e5\u5355");
        CsOutNoticeOrderRespDto noticeOrderRespDto = (CsOutNoticeOrderRespDto)csOutNoticeOrderRespDtoList.get(0);
        DgLogicWarehousePageReqDto reqDto = new DgLogicWarehousePageReqDto();
        reqDto.setWarehouseCode(transferOrder.getInLogicWarehouseCode());
        List routeWarehouse = (List)RestResponseHelper.extractData((RestResponse)this.dgLogicWarehouseApi.queryList(reqDto));
        AssertUtil.isFalse(CollectionUtil.isEmpty((Collection)routeWarehouse), "\u627e\u4e0d\u5230\u4ed3\u5e93\u4fe1\u606f\uff1a" + reqDto.getWarehouseCode());
        AssertUtil.isFalse(ObjectUtil.isEmpty((Object)((DgLogicWarehouseDto)routeWarehouse.get(0)).getSubordinateLogicWarehouseId()), "\u627e\u4e0d\u5230\u4ed3\u5e93\u7684\u5408\u683c\u4ed3\u4fe1\u606f\uff1a" + JacksonUtil.toJson((Object)routeWarehouse));
        DgLogicWarehouseDto inWarehouse = (DgLogicWarehouseDto)RestResponseHelper.extractData((RestResponse)this.dgLogicWarehouseApi.get(((DgLogicWarehouseDto)routeWarehouse.get(0)).getSubordinateLogicWarehouseId()));
        AssertUtil.isFalse(ObjectUtil.isEmpty((Object)inWarehouse), "\u627e\u4e0d\u5230\u4ed3\u5e93\u4fe1\u606f\uff1a" + ((DgLogicWarehouseDto)routeWarehouse.get(0)).getSubordinateLogicWarehouseId());
        ReceiveDeliveryNoticeOrderDto orderDto = new ReceiveDeliveryNoticeOrderDto();
        BeanUtil.copyProperties((Object)noticeOrderRespDto, (Object)orderDto, (String[])new String[0]);
        orderDto.setId(null);
        orderDto.setDocumentNo(null);
        orderDto.setBizDate(new Date());
        orderDto.setWmsOrderNo(null);
        orderDto.setOrderStatus(null);
        orderDto.setPreOrderNo(null);
        orderDto.setCreateTime(null);
        orderDto.setCreatePerson(null);
        orderDto.setDeliveryLogicWarehouseCode(noticeOrderRespDto.getOutLogicWarehouseCode());
        orderDto.setDeliveryLogicWarehouseName(noticeOrderRespDto.getOutLogicWarehouseName());
        orderDto.setDeliveryPhysicsWarehouseCode(noticeOrderRespDto.getOutPhysicsWarehouseCode());
        orderDto.setDeliveryPhysicsWarehouseName(noticeOrderRespDto.getOutPhysicsWarehouseName());
        orderDto.setReceiveLogicWarehouseCode(inWarehouse.getWarehouseCode());
        orderDto.setReceiveLogicWarehouseName(inWarehouse.getWarehouseName());
        orderDto.setReceivePhysicsWarehouseCode(inWarehouse.getPhysicsWarehouseCode());
        orderDto.setReceivePhysicsWarehouseName(inWarehouse.getPhysicsWarehouseName());
        orderDto.setSendWms(Boolean.valueOf(false));
        orderDto.setAutoComplete(Boolean.valueOf(false));
        orderDto.setIgnoreRepeat(Boolean.valueOf(true));
        List<String> detailIdList = Arrays.asList(detailIds.split(","));
        List createDetailDtoList = detailIdList.stream().map(detailId -> {
            InOutNoticeOrderDetailDto detailRespDto = (InOutNoticeOrderDetailDto)RestResponseHelper.extractData((RestResponse)this.inOutNoticeOrderDetailApi.get(Long.valueOf(detailId)));
            ReceiveDeliveryNoticeOrderDetailDto createDetailDto = new ReceiveDeliveryNoticeOrderDetailDto();
            BeanUtil.copyProperties((Object)detailRespDto, (Object)createDetailDto, (String[])new String[0]);
            createDetailDto.setId(null);
            createDetailDto.setDocumentNo(null);
            createDetailDto.setWmsOrderNo(null);
            createDetailDto.setCancelQuantity(null);
            createDetailDto.setCreateTime(null);
            createDetailDto.setCreatePerson(null);
            createDetailDto.setUpdateTime(null);
            createDetailDto.setUpdatePerson(null);
            createDetailDto.setOriginPlanQuantity(createDetailDto.getPlanQuantity());
            if (ObjectUtil.isEmpty((Object)detailRespDto.getTradeOrderItemId())) {
                createDetailDto.setTradeOrderItemId(detailRespDto.getPreOrderItemId());
            }
            return createDetailDto;
        }).collect(Collectors.toList());
        orderDto.setReceiveDeliveryNoticeOrderDetailDtos(createDetailDtoList);
        logger.info("\u5728\u9014\u5185\u90e8\u4ea4\u6613\u5b8c\u6210\uff0c\u8bf7\u6c42\u521b\u5efa\u5165\u5e93\u901a\u77e5\u5355\uff1a{}", (Object)JacksonUtil.toJson((Object)orderDto));
        try {
            ReceiveDeliveryNoticeOrderDto noticeOrderResult = (ReceiveDeliveryNoticeOrderDto)RestResponseHelper.extractData((RestResponse)this.receiveDeliveryNoticeOrderApi.create(orderDto));
            logger.info("\u8bf7\u6c42\u521b\u5efa\u5165\u5e93\u901a\u77e5\u5355\u5b8c\u6210\uff1a{}", (Object)JacksonUtil.toJson((Object)noticeOrderResult));
            AssertUtil.isFalse(StringUtils.isBlank((CharSequence)noticeOrderResult.getDocumentNo()), "\u54cd\u5e94\u6ca1\u6709\u5355\u53f7");
            CsOutNoticeOrderQueryDto queryDto = new CsOutNoticeOrderQueryDto();
            queryDto.setPreOrderNo(noticeOrderResult.getDocumentNo());
            List noticeOrderList = (List)RestResponseHelper.extractData((RestResponse)this.csOutNoticeOrderQueryApi.queryByParam(queryDto));
            AssertUtil.isFalse(CollectionUtil.isEmpty((Collection)noticeOrderList), "\u627e\u4e0d\u5230\u65b0\u521b\u5efa\u7684\u5165\u5e93\u901a\u77e5");
            noticeOrder = (CsOutNoticeOrderRespDto)noticeOrderList.get(0);
            this.apiLogApi.addRouteInternalDeal(transferOrder.getTransferOrderNo(), RouteMultiAllotNodeEnum.COMPLETE_OCS.getCode(), true, noticeOrder.getDocumentNo());
        }
        catch (Exception e) {
            this.apiLogApi.addRouteInternalDeal(transferOrder.getTransferOrderNo(), RouteMultiAllotNodeEnum.COMPLETE_OCS.getCode(), false, e.getMessage());
            logger.error("\u8bf7\u6c42\u521b\u5efa\u5165\u5e93\u901a\u77e5\u5355\u5f02\u5e38\uff1a" + e.getMessage());
            logger.error(e.getMessage(), (Throwable)e);
            return;
        }
        CsTransferOrderReqDto updDto = new CsTransferOrderReqDto();
        updDto.setId(transferOrder.getId());
        HashMap<String, String> params = new HashMap<String, String>();
        params.put(EASExtendKeyEnum.ROUTE_DEAL_NEXT_NOTICE_NO.code, noticeOrder.getDocumentNo());
        updDto.setExtension(JacksonUtil.toJson(params));
        this.csTransferOrderApi.modifyCsTransferOrderExtension(updDto);
        noticeOrderRespDto.setDocumentNo(noticeOrder.getDocumentNo());
        noticeOrderRespDto.setId(noticeOrder.getId());
        noticeOrderRespDto.setInLogicWarehouseCode(noticeOrder.getInLogicWarehouseCode());
        ArrayList<InOutNoticeOrderDetailDto> noticeOrderDetailDtoList = new ArrayList<InOutNoticeOrderDetailDto>();
        CubeBeanUtils.copyCollection(noticeOrderDetailDtoList, createDetailDtoList, InOutNoticeOrderDetailDto.class);
        noticeOrderDetailDtoList.forEach(f -> {
            f.setDocumentNo(noticeOrder.getDocumentNo());
            f.setPreOrderItemId(f.getTradeOrderItemId());
        });
        MessageVo messageVo = new MessageVo();
        messageVo.setData((Object)this.buildInWmsSendInfo(noticeOrderRespDto, noticeOrderDetailDtoList));
        logger.info("\u5728\u9014\u5185\u90e8\u4ea4\u6613\u5b8c\u6210\uff0c\u63a8\u9001WMS\uff1a{}", (Object)JacksonUtil.toJson((Object)messageVo));
        this.commonsMqService.sendSingleMessage("OP_EXTERNAL_TOPIC", "WMS_OUT_DELIVERY_ADD", (Object)messageVo);
    }

    @Override
    public void routeInternalDealFinishOffset(String transferOrderNo) {
        CsTransferOrderRespDto transferOrder = (CsTransferOrderRespDto)RestResponseHelper.extractData((RestResponse)this.csTransferOrderQueryApi.queryByTransferOrderNo(transferOrderNo));
        this.routeInternalDealFinish(transferOrder);
    }

    private String buildInWmsSendInfo(CsOutNoticeOrderRespDto outNoticeOrderEo, List<InOutNoticeOrderDetailDto> detailEoList) {
        WmsStockEntryOrderReqDto wmsStockEntryOrderReqDto = new WmsStockEntryOrderReqDto();
        CsWarehouseAddressParamQueryDto addressDto = new CsWarehouseAddressParamQueryDto();
        addressDto.setWarehouseCode(outNoticeOrderEo.getInPhysicsWarehouseCode());
        List csWarehouseAddressRespDtoList = (List)RestResponseHelper.extractData((RestResponse)this.csWarehouseAddressApi.queryParam(addressDto));
        if (CollectionUtil.isNotEmpty((Collection)csWarehouseAddressRespDtoList)) {
            CubeBeanUtils.copyProperties((Object)wmsStockEntryOrderReqDto, csWarehouseAddressRespDtoList.get(0), (String[])new String[0]);
        }
        wmsStockEntryOrderReqDto.setExtensionExternal(this.getExtensionExternal(outNoticeOrderEo.getRelevanceNo()));
        wmsStockEntryOrderReqDto.setDocumentNo(outNoticeOrderEo.getDocumentNo());
        wmsStockEntryOrderReqDto.setRelevanceNo(outNoticeOrderEo.getRelevanceNo());
        wmsStockEntryOrderReqDto.setThirdOrderNo(outNoticeOrderEo.getExternalOrderNo());
        wmsStockEntryOrderReqDto.setOrderCreateTime(DateUtils.formatYMDHms(outNoticeOrderEo.getCreateTime()));
        wmsStockEntryOrderReqDto.setRemark(outNoticeOrderEo.getRemark());
        wmsStockEntryOrderReqDto.setOrderType(outNoticeOrderEo.getOrderType());
        wmsStockEntryOrderReqDto.setBusinessType(outNoticeOrderEo.getBusinessType());
        wmsStockEntryOrderReqDto.setWarehouseCode(outNoticeOrderEo.getInPhysicsWarehouseCode());
        wmsStockEntryOrderReqDto.setLogicWarehouseCode(outNoticeOrderEo.getInLogicWarehouseCode());
        wmsStockEntryOrderReqDto.setEnableBatch(!YesNoEnum.YES.getValue().equals(outNoticeOrderEo.getNoBatch()));
        List<WmsItemLine> itemLines = this.getWmsItemLines(detailEoList);
        CsLogicWarehouseRespDto warehouseRespDto = (CsLogicWarehouseRespDto)RestResponseHelper.extractData((RestResponse)this.csLogicWarehouseExposedQueryApi.queryWarehouseTypeByCode(wmsStockEntryOrderReqDto.getLogicWarehouseCode()));
        if (ObjectUtil.isNotEmpty((Object)warehouseRespDto)) {
            wmsStockEntryOrderReqDto.setOrganizationCode(warehouseRespDto.getCargoEscheatageId() + "");
            wmsStockEntryOrderReqDto.setOrganizationName(warehouseRespDto.getCargoEscheatageName());
        }
        CsPhysicsWarehouseQueryDto warehouseQueryDto = new CsPhysicsWarehouseQueryDto();
        warehouseQueryDto.setWarehouseCode(wmsStockEntryOrderReqDto.getWarehouseCode());
        List physicsWarehouseRespDtoList = (List)RestResponseHelper.extractData((RestResponse)this.csPhysicsWarehouseApi.queryByParam(warehouseQueryDto));
        if (CollectionUtil.isNotEmpty((Collection)physicsWarehouseRespDtoList)) {
            wmsStockEntryOrderReqDto.setPhysicsOrganizationCode(((CsPhysicsWarehouseRespDto)physicsWarehouseRespDtoList.get(0)).getOrganizationCode());
            wmsStockEntryOrderReqDto.setPhysicsOrganizationName(((CsPhysicsWarehouseRespDto)physicsWarehouseRespDtoList.get(0)).getOrganizationName());
        }
        wmsStockEntryOrderReqDto.setItemLines(itemLines);
        return JSON.toJSONString((Object)wmsStockEntryOrderReqDto);
    }

    private String getExtensionExternal(String relevanceNo) {
        logger.info("\u83b7\u53d6\u51fa\u5e93\u7ed3\u679c\u5355\uff1a{}", (Object)relevanceNo);
        CsOutResultOrderQueryDto queryDto = new CsOutResultOrderQueryDto();
        queryDto.setRelevanceNo(relevanceNo);
        List respDtoList = (List)RestResponseHelper.extractData((RestResponse)this.csOutResultOrderQueryApi.queryByParam(queryDto));
        if (CollectionUtils.isNotEmpty((Collection)respDtoList)) {
            return ((CsOutResultOrderRespDto)respDtoList.get(0)).getExtensionExternal();
        }
        return null;
    }

    private List<WmsItemLine> getWmsItemLines(List<InOutNoticeOrderDetailDto> detailEoList) {
        ArrayList<WmsItemLine> itemLines = new ArrayList<WmsItemLine>();
        for (InOutNoticeOrderDetailDto InOutNoticeOrderDetailEo : detailEoList) {
            WmsItemLine itemLine = new WmsItemLine();
            itemLine.setCargoCode(InOutNoticeOrderDetailEo.getSkuCode());
            itemLine.setCargoName(InOutNoticeOrderDetailEo.getSkuName());
            itemLine.setBatch(InOutNoticeOrderDetailEo.getBatch());
            itemLine.setPlanQuantity(InOutNoticeOrderDetailEo.getPlanQuantity());
            itemLine.setTradeOrderItemId(null != InOutNoticeOrderDetailEo.getPreOrderItemId() ? InOutNoticeOrderDetailEo.getPreOrderItemId().toString() : InOutNoticeOrderDetailEo.getId().toString());
            itemLines.add(itemLine);
            String productDate = null != InOutNoticeOrderDetailEo.getProduceTime() ? DateUtils.formatYMDHms(InOutNoticeOrderDetailEo.getProduceTime()) : null;
            String arrivalDate = null != InOutNoticeOrderDetailEo.getExpireTime() ? DateUtils.formatYMDHms(InOutNoticeOrderDetailEo.getExpireTime()) : null;
            itemLine.setProductDate(productDate);
            itemLine.setArrivalDate(arrivalDate);
        }
        return itemLines;
    }

    private void easInventory(CsDeliveryReceiveResultRespDto dto, CsTransferOrderRespDto transferOrderRespDto) {
        logger.info("EAS\u8c03\u62e8\u51fa\u5165");
        if (dto.getOrderType().equals("delivery")) {
            this.dispatchEasInventoryAllot.create(transferOrderRespDto.getTransferOrderNo(), EASGeneralSubBillFlagEnum.CODE_110000, dto, true);
        } else {
            this.easInventoryInbound(dto);
        }
    }

    private void easInventory(CsDeliveryReceiveResultRespDto dto) {
        logger.info("EAS\u8c03\u62e8\u51fa\u5165");
        if (dto.getOrderType().equals("delivery")) {
            this.easInventoryOutbound(dto);
        } else if (dto.getOrderType().equals("receive")) {
            try {
                if (CsPcpBusinessTypeEnum.ALLOT_LOGIC_OUT.getCode().equals(dto.getBusinessType())) {
                    logger.info("\u903b\u8f91\u8c03\u62e8\uff0c\u6536\u8d27\u5ef6\u8fdf\u5904\u7406");
                    Thread.sleep(6000L);
                }
            }
            catch (Exception e) {
                logger.error("\u6536\u8d27\u5ef6\u8fdf\u5904\u7406\u5f02\u5e38");
                logger.error(e.getMessage(), (Throwable)e);
            }
            this.easInventoryInbound(dto);
        } else {
            logger.info("\u672a\u77e5\u8c03\u62e8\u7684\u4ea4\u6613\u7c7b\u578b\uff01");
        }
    }

    private void easInventoryOutbound(CsDeliveryReceiveResultRespDto dto) {
        logger.info("EAS\u8c03\u62e8\u51fa\u5e93\uff1a{}", (Object)JSON.toJSONString((Object)dto));
        InventoryReqDto inventoryReqDto = this.allotDataBuild(dto, dto.getDeliveryLogicWarehouseCode());
        this.executeToEas(OpenapiDefineEnum.EAS011, inventoryReqDto);
    }

    private void easInventoryInbound(CsDeliveryReceiveResultRespDto dto) {
        logger.info("EAS\u8c03\u62e8\u5165\u5e93\uff1a{}", (Object)JSON.toJSONString((Object)dto));
        InventoryReqDto inventoryReqDto = this.allotDataBuild(dto, dto.getReceiveLogicWarehouseCode());
        this.executeToEas(OpenapiDefineEnum.EAS012, inventoryReqDto);
    }

    private Object easPurchaseIn(CsDeliveryReceiveResultRespDto dto, boolean autoAudit) {
        logger.info("EAS\u91c7\u8d2d\u5165\u5e93\uff1a{}", (Object)JSON.toJSONString((Object)dto));
        EASBillReqDto easBillReqDto = this.outsourcePurchaseOrderDataBuild(dto, dto.getReceiveLogicWarehouseCode());
        ((Bill)easBillReqDto.getPurInWarehsBills().get(0)).setTransactionType(EASTransactionTypeEnum.TYPE_001.code);
        ((Bill)easBillReqDto.getPurInWarehsBills().get(0)).setBizType(EASBizTypeEnum.IMPORT_002_PURCHASE.code);
        ((Bill)easBillReqDto.getPurInWarehsBills().get(0)).setSourceBillType(EASSourceBillTypeEnum.PURCHASE.code);
        easBillReqDto.setAutoAudit(Boolean.valueOf(autoAudit));
        return this.executeToEas(OpenapiDefineEnum.EAS002, easBillReqDto);
    }

    private void easPurchaseReturn(CsDeliveryReceiveResultRespDto dto) {
        logger.info("EAS\u91c7\u8d2d\u9000\u8d27\uff1a{}", (Object)JSON.toJSONString((Object)dto));
        EASBillReqDto easBillReqDto = this.outsourcePurchaseOrderDataBuild(dto, dto.getDeliveryLogicWarehouseCode());
        ((Bill)easBillReqDto.getPurInWarehsBills().get(0)).setTransactionType(EASTransactionTypeEnum.TYPE_002.code);
        ((Bill)easBillReqDto.getPurInWarehsBills().get(0)).setBizType(EASBizTypeEnum.IMPORT_002_PURCHASE_RETURN.code);
        ((Bill)easBillReqDto.getPurInWarehsBills().get(0)).setSourceBillType(EASSourceBillTypeEnum.PURCHASE_RETURN.code);
        ((Bill)easBillReqDto.getPurInWarehsBills().get(0)).setIsPriceInTax(Boolean.valueOf(true));
        this.executeToEas(OpenapiDefineEnum.EAS003, easBillReqDto);
    }

    private void easOutsourceIn(CsDeliveryReceiveResultRespDto dto) {
        logger.info("EAS\u59d4\u5916\u5165\u5e93\uff1a{}", (Object)JSON.toJSONString((Object)dto));
        EASBillReqDto easBillReqDto = this.outsourcePurchaseOrderDataBuild(dto, dto.getReceiveLogicWarehouseCode());
        ((Bill)easBillReqDto.getPurInWarehsBills().get(0)).setTransactionType(EASTransactionTypeEnum.TYPE_001.code);
        ((Bill)easBillReqDto.getPurInWarehsBills().get(0)).setBizType(EASBizTypeEnum.IMPORT_002_OUTSOURCE.code);
        ((Bill)easBillReqDto.getPurInWarehsBills().get(0)).setSourceBillType(EASSourceBillTypeEnum.OUTSOURCE.code);
        ((Bill)easBillReqDto.getPurInWarehsBills().get(0)).setIsPriceInTax(Boolean.valueOf(true));
        this.executeToEas(OpenapiDefineEnum.EAS004, easBillReqDto);
    }

    private void easProductionIn(CsDeliveryReceiveResultRespDto dto) {
        logger.info("EAS\u751f\u4ea7\u6210\u54c1\u5165\u5e93\uff1a{}", (Object)JSON.toJSONString((Object)dto));
        EASBillReqDto easBillReqDto = this.produceDataBuild(dto, dto.getReceiveLogicWarehouseCode());
        this.executeToEas(OpenapiDefineEnum.EAS006, easBillReqDto);
    }

    private void easOtherOut(CsDeliveryReceiveResultRespDto dto) {
        logger.info("EAS\u5176\u4ed6\u51fa\u5e93\uff1a{}", (Object)JSON.toJSONString((Object)dto));
        EASBillReqDto easBillReqDto = this.otherDataBuild(dto, dto.getDeliveryLogicWarehouseCode());
        if (ObjectUtil.isNotEmpty((Object)easBillReqDto)) {
            this.executeToEas(OpenapiDefineEnum.EAS010, easBillReqDto);
        }
    }

    private void easOtherIn(CsDeliveryReceiveResultRespDto dto) {
        logger.info("EAS\u5176\u4ed6\u5165\u5e93\uff1a{}", (Object)JSON.toJSONString((Object)dto));
        EASBillReqDto easBillReqDto = this.otherDataBuild(dto, dto.getReceiveLogicWarehouseCode());
        if (ObjectUtil.isNotEmpty((Object)easBillReqDto)) {
            this.executeToEas(OpenapiDefineEnum.EAS009, easBillReqDto);
        }
    }

    private void easInternalTrade(CsDeliveryReceiveResultRespDto dto) {
        logger.info("EAS\u5185\u90e8\u4ea4\u6613\uff1a{}", (Object)JSON.toJSONString((Object)dto));
        switch (CsPcpBusinessTypeEnum.getByCode((String)dto.getBusinessType())) {
            case INTERNAL_DEAL: 
            case ROUTE_INTERNAL_DEAL: {
                if (dto.getOrderType().equals("receive")) {
                    logger.info("\u6536\u8d27\uff0c\u63a8\u9001eas\u91c7\u8d2d\u5165");
                    Object obj = this.easPurchaseIn(dto, false);
                    if (!ObjectUtil.isNotEmpty((Object)obj)) break;
                    EASOrderBaseResult result = (EASOrderBaseResult)JSON.parseObject((String)JSON.toJSONString((Object)obj), EASOrderBaseResult.class);
                    CsTransferOrderRespDto transfer = (CsTransferOrderRespDto)RestResponseHelper.extractData((RestResponse)this.csTransferOrderApi.queryByTransferOrderNo(dto.getRelevanceNo()));
                    if (!StringUtils.isNotBlank((CharSequence)result.getOrderNum()) || !ObjectUtil.isNotEmpty((Object)transfer)) break;
                    HashMap<String, String> map = new HashMap<String, String>();
                    map.put("EAS_PURCHASE_ORDER_ID", result.getOrderNum());
                    CsTransferOrderReqDto params = new CsTransferOrderReqDto();
                    params.setId(transfer.getId());
                    params.setPreOrderNo(transfer.getPreOrderNo());
                    params.setExtension(JSON.toJSONString(map));
                    this.csTransferOrderApi.modifyCsTransferOrderExtension(params);
                    break;
                }
                logger.info("\u53d1\u8d27\uff0c\u4e3a\u9500\u552e\u51fa\uff0c\u8d22\u52a1\u4e2d\u53f0\u4e3b\u52a8\u62c9\u5355");
                break;
            }
            case INTERNAL_DEAL_RETURN: 
            case SALE_RETURN_INTERNAL_DEAL: {
                if (dto.getOrderType().equals("delivery")) {
                    logger.info("\u53d1\u8d27\uff0c\u63a8\u9001eas\u91c7\u8d2d\u9000");
                    this.easPurchaseReturn(dto);
                    break;
                }
                logger.info("\u6536\u8d27\uff0c\u4e3a\u9500\u552e\u7ea2\u5355\uff0c\u8d22\u52a1\u4e2d\u53f0\u4e3b\u52a8\u62c9\u5355");
                break;
            }
            default: {
                logger.info("\u8bf7\u6c42\u4e1a\u52a1\u5f02\u5e38");
            }
        }
    }

    private void easProductionRedAudit(CsDeliveryReceiveResultRespDto dto) {
        logger.info("\u751f\u4ea7\u7ea2\u5355\u5ba1\u6838\uff1a{}", (Object)JSON.toJSONString((Object)dto));
        EASOrderAuditReqDto orderAuditReqDto = new EASOrderAuditReqDto();
        orderAuditReqDto.setFnumber(dto.getExternalOrderNo());
        orderAuditReqDto.setFid(this.getExtensionValue(dto.getExtension(), EASExtendKeyEnum.SOURCE_ID.code));
        orderAuditReqDto.setBillType(EASBillTypeEnum.IMPORT_AUDIT_001_TYPE_105.code);
        orderAuditReqDto.setRemark(dto.getRemark());
        this.executeToEas(OpenapiDefineEnum.EAS016, orderAuditReqDto);
    }

    private void psiCreateOrder(CsDeliveryReceiveResultRespDto dto, BizSaleOrderRespDto saleOrder, boolean ifOffset) {
        List detailRespDtoList;
        List maps;
        CustomerOrgPartnerRespDto customerOrgChildDto;
        boolean lockFlag = this.cacheService.setIfAbsent("PUSH_ERP_LOCK_KEY_" + dto.getDocumentNo(), (Object)true, 60);
        if (!lockFlag) {
            logger.info("\u8fdb\u9500\u5b58\u5df2\u7ecf\u63a8\u9001\u8fc7\u4e00\u6b21");
            return;
        }
        logger.info("\u8fdb\u9500\u5b58\u521b\u5efa\u8ba2\u5355\uff1a{}\uff0c{}", (Object)JSON.toJSONString((Object)dto), (Object)saleOrder.getOrderType());
        logger.info("\u8fdb\u9500\u5b58\u521b\u5efa\u8ba2\u5355\uff0c\u9500\u552e\u5355\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)saleOrder));
        if (!this.saleOrderToPsiTypes.contains(saleOrder.getOrderType())) {
            logger.info("\u8be5\u5355\u636e\u7c7b\u578b\u65e0\u987b\u63a8\u9001\u8fdb\u9500\u5b58");
            return;
        }
        OrderPushInterceptRecordReqDto reqDto = new OrderPushInterceptRecordReqDto();
        reqDto.setType("psi");
        reqDto.setOrder(saleOrder.getSaleOrderNo());
        if (!ifOffset && this.apiControl(DictEnum.STOCK_SELL_STORAGE_API_CONTROL, DictEnum.STOCK_SELL_STORAGE_API_CONTROL_DATE, reqDto, saleOrder.getSaleOrderNo())) {
            return;
        }
        this.combinationSaleOrder(dto);
        logger.info("\u5173\u8054\u9500\u552e\u5355\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)dto.getSaleOrder()));
        this.gainDetailMoreIfo(dto, dto.getDeliveryLogicWarehouseCode());
        String thirdPartyId = saleOrder.getOrderType().equals(SaleOrderTypeEnum.COMPENSATION_ORDER.getType()) ? this.getExtensionValue(dto.getSaleOrder().getExtension(), "thirdPartyActualId") : this.getExtensionValue(dto.getSaleOrder().getExtension(), "thirdPartyId");
        if (StringUtils.isBlank((CharSequence)thirdPartyId)) {
            throw new BizException("-1", "\u5ba2\u6237\u4e0d\u5b58\u5728");
        }
        CustomerOrgPartnerRespDto customerOrgDto = (CustomerOrgPartnerRespDto)RestResponseHelper.extractData((RestResponse)this.customerOrgPartnerQueryApi.queryByPartnerId(thirdPartyId));
        if (ObjectUtil.isEmpty((Object)customerOrgDto) || StringUtils.isBlank((CharSequence)customerOrgDto.getOrgId())) {
            logger.info("\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u79df\u6237ID");
            return;
        }
        String subTenantId = "";
        String disDelearId = this.getExtensionValue(dto.getSaleOrder().getExtension(), "disDelearId");
        if (StringUtils.isNotBlank((CharSequence)disDelearId) && ObjectUtil.isNotEmpty((Object)(customerOrgChildDto = (CustomerOrgPartnerRespDto)RestResponseHelper.extractData((RestResponse)this.customerOrgPartnerQueryApi.queryByPartnerId(disDelearId))))) {
            subTenantId = customerOrgChildDto.getOrgId();
        }
        SaleOrderAddrRespDto orderAddr = dto.getSaleOrder().getOrderAddrRespDto();
        PSIOrderDto psiOrderDto = new PSIOrderDto();
        psiOrderDto.setOrderType(dto.getSaleOrder().getOrderType());
        psiOrderDto.setOtherNumber(dto.getSaleOrder().getSaleOrderNo());
        psiOrderDto.setYxyNumber(dto.getSaleOrder().getPlatformOrderNo());
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        psiOrderDto.setOpertime(ObjectUtil.isNotEmpty((Object)dto.getCreateTime()) ? simpleDateFormat.format(dto.getCreateTime()) : "");
        psiOrderDto.setTenantId(customerOrgDto.getOrgId());
        psiOrderDto.setSubTenantId(subTenantId);
        psiOrderDto.setOrganId(this.getExtensionValue(dto.getSaleOrder().getExtension(), "thirdOrgID"));
        psiOrderDto.setApplyerId(thirdPartyId);
        psiOrderDto.setLessGoodsNumber(dto.getSaleOrder().getPlatformOrderNo());
        psiOrderDto.setCarryNo(dto.getShippingCode());
        psiOrderDto.setRecvContact(orderAddr.getReceiveName());
        psiOrderDto.setRecvTel(orderAddr.getReceivePhone());
        psiOrderDto.setRecvAddr(orderAddr.getReceiveAddress());
        psiOrderDto.setRemark(dto.getSaleOrder().getSellerRemark());
        psiOrderDto.setEasSaleOrderNo(saleOrder.getEasOrderNo());
        if (StringUtils.isNotBlank((CharSequence)dto.getShippingJson()) && CollectionUtil.isNotEmpty((Collection)(maps = JSON.parseArray((String)dto.getShippingJson(), CsWmsShippingInfoReqDto.class)))) {
            psiOrderDto.setCarryNo(((CsWmsShippingInfoReqDto)maps.get(0)).getConsignNo());
        }
        if (CollectionUtil.isEmpty((Collection)(detailRespDtoList = (List)RestResponseHelper.extractData((RestResponse)this.deliveryResultOrderQueryApi.queryOrderDetailApportion((List)Lists.newArrayList((Object[])new String[]{dto.getDocumentNo()})))))) {
            RestResponseHelper.extractData((RestResponse)this.deliveryResultOrderQueryApi.orderDetailApportionBase((List)Lists.newArrayList((Object[])new String[]{dto.getRelevanceNo()}), ApportionOrderEnum.SALE.getCode()));
            detailRespDtoList = (List)RestResponseHelper.extractData((RestResponse)this.deliveryResultOrderQueryApi.queryOrderDetailApportion((List)Lists.newArrayList((Object[])new String[]{dto.getDocumentNo()})));
        }
        if (CollectionUtil.isEmpty((Collection)detailRespDtoList)) {
            logger.error("\u65e0\u5206\u644a\u4fe1\u606f");
            return;
        }
        List collect = detailRespDtoList.stream().map(item -> {
            PSIOrderItemDto itemDto = new PSIOrderItemDto();
            itemDto.setId(ObjectUtil.isNotEmpty((Object)item.getDetailItemId()) ? item.getDetailItemId().toString() : null);
            itemDto.setMaterialNo(item.getLongCode());
            itemDto.setHelpCode(item.getCargoCode());
            itemDto.setLot(item.getBatch());
            itemDto.setOperNumber(item.getQuantity().toString());
            itemDto.setMfg(ObjectUtil.isNotEmpty((Object)item.getProduceTime()) ? simpleDateFormat.format(item.getProduceTime()) : null);
            itemDto.setExp(ObjectUtil.isNotEmpty((Object)item.getExpireTime()) ? simpleDateFormat.format(item.getExpireTime()) : null);
            itemDto.setTaxRate(ObjectUtil.isNotEmpty((Object)item.getTaxRate()) ? item.getTaxRate().toString() : null);
            itemDto.setTaxPrice(ObjectUtil.isNotEmpty((Object)item.getSalePrice()) ? item.getSalePrice().toString() : null);
            itemDto.setTaxLastMoney(ObjectUtil.isNotEmpty((Object)item.getPayableAmount()) ? item.getPayableAmount().toString() : null);
            itemDto.setActualTaxPrice(ObjectUtil.isNotEmpty((Object)item.getTransactionPrice()) ? item.getTransactionPrice().toString() : null);
            itemDto.setActualTotalPrice(ObjectUtil.isNotEmpty((Object)item.getActuallyAmount()) ? item.getActuallyAmount().toString() : null);
            itemDto.setDiscountAmount(ObjectUtil.isNotEmpty((Object)item.getDiscountAmount()) ? item.getDiscountAmount().toString() : null);
            return itemDto;
        }).collect(Collectors.toList());
        psiOrderDto.setItemList(collect);
        this.externalPsiApi.createOrder(psiOrderDto);
    }

    private boolean apiControl(DictEnum dictEnum, DictEnum dictEnumDate, OrderPushInterceptRecordReqDto reqDto, String saleOrderNo) {
        String date;
        String value = Optional.ofNullable(this.pcpDictApi.queryByGroupCodeAndCode("COMMON_CONFIG", dictEnum.getCode()).getData()).map(DictDto::getValue).orElse("0");
        if (value.equals("1") && ObjectUtil.isNotEmpty((Object)(date = ((DictDto)this.pcpDictApi.queryByGroupCodeAndCode("COMMON_CONFIG", dictEnumDate.getCode()).getData()).getValue()))) {
            Date parse = DateUtil.parse((String)date, (String)DatePattern.DATETIME_PATTERN.getPattern());
            BizSaleOrderRespDto saleOrderDto = (BizSaleOrderRespDto)RestResponseHelper.extractData((RestResponse)this.saleOrderQueryApi.queryByOrderNo(saleOrderNo));
            AssertUtil.isFalse(ObjectUtil.isEmpty((Object)saleOrderDto), "\u627e\u4e0d\u5230\u9500\u552e\u5355");
            List orderTagRecordList = (List)RestResponseHelper.extractData((RestResponse)this.orderTagRecordQueryApi.queryByOrderIds((List)Lists.newArrayList((Object[])new Long[]{saleOrderDto.getId()})));
            List<Object> tagCodes = new ArrayList();
            if (CollectionUtil.isNotEmpty((Collection)orderTagRecordList)) {
                tagCodes = orderTagRecordList.stream().map(OrderTagBaseRespDto::getTagCode).collect(Collectors.toList());
            }
            if (new Date().compareTo(parse) >= 0 && tagCodes.contains("GS001")) {
                logger.info("\u6682\u4e0d\u5141\u8bb8\u63a8\u9001");
                try {
                    this.orderPushInterceptRecordApi.add(reqDto);
                }
                catch (Exception e) {
                    logger.error("\u4fdd\u5b58\u62e6\u622a\u8bb0\u5f55\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
                }
                return true;
            }
        }
        return false;
    }

    private void cspCreatePurchase(CsDeliveryReceiveResultRespDto dto) {
        logger.info("\u9500\u5b58\u91c7\u8ba2\u5355\u521b\u5efa\uff1a{}", (Object)JSON.toJSONString((Object)dto));
        dto = this.combinationSaleOrder(dto);
        dto = this.gainDetailMoreIfo(dto, dto.getDeliveryLogicWarehouseCode());
        CustomerExtDetailRespDto customer = (CustomerExtDetailRespDto)RestResponseHelper.extractData((RestResponse)this.customerExtQueryApi.queryById(dto.getSaleOrder().getCustomerId()));
        if (ObjectUtil.isEmpty((Object)customer) || StringUtils.isBlank((CharSequence)customer.getThirdPartyId())) {
            throw new BizException("-1", "\u627e\u4e0d\u5230\u5ba2\u6237\u4fe1\u606f");
        }
        BizSaleOrderRespDto saleOrder = dto.getSaleOrder();
        SaleOrderAddrRespDto orderAddr = saleOrder.getOrderAddrRespDto();
        CSPPurchaseInOrderCreateReqDto cspPurchaseInOrderCreateReqDto = new CSPPurchaseInOrderCreateReqDto();
        cspPurchaseInOrderCreateReqDto.setOtherNumber(dto.getDocumentNo());
        cspPurchaseInOrderCreateReqDto.setNo(dto.getExternalOrderNo());
        cspPurchaseInOrderCreateReqDto.setCarryNo(dto.getShippingCode());
        cspPurchaseInOrderCreateReqDto.setSaleOrderNo(saleOrder.getEasOrderNo());
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        cspPurchaseInOrderCreateReqDto.setOperTime(ObjectUtil.isNotEmpty((Object)dto.getCreateTime()) ? simpleDateFormat.format(dto.getCreateTime()) : null);
        cspPurchaseInOrderCreateReqDto.setTenantId(customer.getThirdPartyId());
        cspPurchaseInOrderCreateReqDto.setOrganId(saleOrder.getCustomerCode());
        cspPurchaseInOrderCreateReqDto.setRecvContact(orderAddr.getReceiveName());
        cspPurchaseInOrderCreateReqDto.setRecvTel(orderAddr.getReceivePhone());
        cspPurchaseInOrderCreateReqDto.setRecvAddr(orderAddr.getReceiveAddress());
        cspPurchaseInOrderCreateReqDto.setRemark(saleOrder.getRemark());
        ArrayList itemDtoListIn = new ArrayList();
        dto.getDeliveryReceiveResultDetailRespDtoList().forEach(item -> {
            CSPItemDto cspItemDto = new CSPItemDto();
            cspItemDto.setId(item.getId().toString());
            cspItemDto.setOriginId(item.getSaleOrderItem().getId().toString());
            cspItemDto.setMaterialNo(item.getLongCode());
            cspItemDto.setLot(item.getBatch());
            cspItemDto.setMfg(ObjectUtil.isNotEmpty((Object)item.getProduceTime()) ? simpleDateFormat.format(item.getProduceTime()) : null);
            cspItemDto.setExp(ObjectUtil.isNotEmpty((Object)item.getExpireTime()) ? simpleDateFormat.format(item.getExpireTime()) : null);
            cspItemDto.setOperNumber(ObjectUtil.isEmpty((Object)item.getQuantity()) ? BigDecimal.ZERO.toString() : item.getQuantity().toString());
            cspItemDto.setTaxPrice(ObjectUtil.isEmpty((Object)item.getSaleOrderItem().getSalePrice()) ? BigDecimal.ZERO.toString() : item.getSaleOrderItem().getSalePrice().toString());
            cspItemDto.setTaxLastMoney(ObjectUtil.isEmpty((Object)item.getSaleOrderItem().getLineAmount()) ? BigDecimal.ZERO.toString() : item.getSaleOrderItem().getLineAmount().toString());
            cspItemDto.setTaxRate(ObjectUtil.isEmpty((Object)item.getSaleOrderItem().getTaxRate()) ? BigDecimal.ZERO.toString() : item.getSaleOrderItem().getTaxRate().toString());
            cspItemDto.setActualTaxPrice(ObjectUtil.isEmpty((Object)item.getSaleOrderItem().getPrice()) ? BigDecimal.ZERO.toString() : item.getSaleOrderItem().getPrice().toString());
            cspItemDto.setActualTotalPrice(ObjectUtil.isEmpty((Object)item.getSaleOrderItem().getPayAmount()) ? BigDecimal.ZERO.toString() : item.getSaleOrderItem().getPayAmount().toString());
            cspItemDto.setDiscountAmount(ObjectUtil.isEmpty((Object)item.getSaleOrderItem().getDiscountAmount()) ? BigDecimal.ZERO.toString() : item.getSaleOrderItem().getDiscountAmount().toString());
            itemDtoListIn.add(cspItemDto);
        });
        cspPurchaseInOrderCreateReqDto.setItemList(itemDtoListIn);
        CSPPurchaseOrderCreateReqDto cspPurchaseOrderCreateReqDto = new CSPPurchaseOrderCreateReqDto();
        cspPurchaseOrderCreateReqDto.setOtherNumber(dto.getDocumentNo());
        cspPurchaseOrderCreateReqDto.setNo(dto.getExternalOrderNo());
        cspPurchaseOrderCreateReqDto.setSaleOrderNo(saleOrder.getEasOrderNo());
        cspPurchaseOrderCreateReqDto.setOperTime(ObjectUtil.isNotEmpty((Object)dto.getCreateTime()) ? simpleDateFormat.format(dto.getCreateTime()) : null);
        cspPurchaseOrderCreateReqDto.setTenantId(customer.getThirdPartyId());
        cspPurchaseOrderCreateReqDto.setOrganId(dto.getSaleOrder().getCustomerCode());
        cspPurchaseOrderCreateReqDto.setRecvContact(orderAddr.getReceiveName());
        cspPurchaseOrderCreateReqDto.setRecvTel(orderAddr.getReceivePhone());
        cspPurchaseOrderCreateReqDto.setRecvAddr(orderAddr.getReceiveAddress());
        cspPurchaseOrderCreateReqDto.setRemark(saleOrder.getRemark());
        ArrayList itemDtoList = new ArrayList(itemDtoListIn);
        itemDtoList.forEach(item -> {
            item.setId(item.getOriginId());
            item.setOriginId(null);
        });
        cspPurchaseOrderCreateReqDto.setItemList(itemDtoList);
        CSPPurchaseCreateReqDto cspPurchaseCreateReqDto = new CSPPurchaseCreateReqDto();
        cspPurchaseCreateReqDto.setPurOrderCreateReqDto(cspPurchaseOrderCreateReqDto);
        cspPurchaseCreateReqDto.setPurInOrderCreateReqDtoList((List)Lists.newArrayList((Object[])new CSPPurchaseInOrderCreateReqDto[]{cspPurchaseInOrderCreateReqDto}));
        this.externalCspApi.purchaseCreate(cspPurchaseCreateReqDto);
    }

    private void cspUpdateOrderStatus(BizSaleOrderRespDto saleOrderRespDto, CspOrderStatusEnum statusEnum, boolean ifOffset) {
        logger.info("CSP\u66f4\u65b0\u8ba2\u5355\u72b6\u6001\uff1a{}\uff0c{}", (Object)statusEnum.getDesc(), (Object)JSON.toJSONString((Object)saleOrderRespDto));
        OrderPushInterceptRecordReqDto reqDto = new OrderPushInterceptRecordReqDto();
        reqDto.setType("csp_" + statusEnum.getType());
        reqDto.setOrder(saleOrderRespDto.getPlatformOrderNo());
        if (!ifOffset && this.apiControl(DictEnum.CSP_ORDER_STATUS_API_CONTROL, DictEnum.CSP_ORDER_STATUS_API_CONTROL_DATE, reqDto, saleOrderRespDto.getSaleOrderNo())) {
            return;
        }
        if (Objects.isNull(saleOrderRespDto.getPlatformOrderId()) || !saleOrderRespDto.getChannelCode().equals("CSP") || saleOrderRespDto.getOrderType().equals(SaleOrderTypeEnum.COMPENSATION_NOT_ORDER.getType())) {
            logger.info("\u975eCSP\u6216\u7d22\u8d54\u4e0d\u8865\u53d1\u5355\u636e\u4e0d\u6267\u884c");
            return;
        }
        if (CspOrderStatusEnum.DELIVERED.getType().equals(statusEnum.getType())) {
            com.dtyunxi.tcbj.api.dto.request.SaleOrderReqDto params = new com.dtyunxi.tcbj.api.dto.request.SaleOrderReqDto();
            params.setId(saleOrderRespDto.getId());
            params.setOrderNo(saleOrderRespDto.getSaleOrderNo());
            params.setReceiveDeliveryType("delivery");
            if (((Boolean)RestResponseHelper.extractData((RestResponse)this.saleOrderReportQueryApi.verifySaleOrderEntireReceiveDelivery(params))).booleanValue()) {
                if (CsPcpBusinessTypeEnum.getByCode((String)saleOrderRespDto.getOrderType()).getCode().equals(CsPcpBusinessTypeEnum.SPECIAL_CHANNEL_ORDER.getCode())) {
                    List listDto = (List)RestResponseHelper.extractData((RestResponse)this.iOutResultOrderQueryApi.queryDeliveryInformation(saleOrderRespDto.getPlatformOrderNo()));
                    CSPUpdateSpecialChannelOrderReqDto specialChannelOrderReqDto = new CSPUpdateSpecialChannelOrderReqDto();
                    specialChannelOrderReqDto.setOrderNo(saleOrderRespDto.getPlatformOrderNo());
                    specialChannelOrderReqDto.setStatus(CspOrderStatusEnum.DELIVERED.getType());
                    specialChannelOrderReqDto.setOrderType(saleOrderRespDto.getOrderType());
                    ArrayList<ShippingDto> shippingDtoList = new ArrayList<ShippingDto>();
                    if (CollectionUtils.isNotEmpty((Collection)listDto)) {
                        for (DeliveryInformationRespDto dto : listDto) {
                            ShippingDto shippingDto = new ShippingDto();
                            shippingDto.setShippingCode(dto.getWmsConsignmentNo());
                            shippingDto.setShippingCompany(dto.getCarrierName());
                            shippingDtoList.add(shippingDto);
                        }
                    }
                    specialChannelOrderReqDto.setShippingDtoList(shippingDtoList);
                    logger.info("\u7279\u6e20\u8ba2\u5355\u63a8\u9001csp\u66f4\u65b0\u8ba2\u5355\u72b6\u6001\uff1a{}", (Object)JSON.toJSONString((Object)specialChannelOrderReqDto));
                    this.externalCspApi.updateCspSpecialChannelOrderStatus(specialChannelOrderReqDto);
                    return;
                }
                CSPUpdateCspOrderReqDto cspUpdateCspOrderReqDto = new CSPUpdateCspOrderReqDto();
                cspUpdateCspOrderReqDto.setOrderNo(saleOrderRespDto.getPlatformOrderNo());
                cspUpdateCspOrderReqDto.setStatus(CspOrderStatusEnum.DELIVERED.getType());
                cspUpdateCspOrderReqDto.setOrderType(saleOrderRespDto.getOrderType());
                this.externalCspApi.updateCspOrderStatus(cspUpdateCspOrderReqDto);
                return;
            }
            logger.info("\u672a\u5168\u90e8\u53d1\u8d27\uff0c\u4e0d\u63a8\u9001csp");
        } else if (CspOrderStatusEnum.RECEIVED.getType().equals(statusEnum.getType())) {
            if (((Boolean)RestResponseHelper.extractData((RestResponse)this.saleOrderQueryApi.verifySaleOrderEntireSign(saleOrderRespDto.getId(), saleOrderRespDto.getSaleOrderNo()))).booleanValue()) {
                logger.info("\u5df2\u5168\u90e8\u7b7e\u6536\uff0c\u63a8\u9001csp");
                if (CsPcpBusinessTypeEnum.getByCode((String)saleOrderRespDto.getOrderType()).getCode().equals(CsPcpBusinessTypeEnum.SPECIAL_CHANNEL_ORDER.getCode())) {
                    List listDto = (List)RestResponseHelper.extractData((RestResponse)this.iOutResultOrderQueryApi.queryDeliveryInformation(saleOrderRespDto.getPlatformOrderNo()));
                    CSPUpdateSpecialChannelOrderReqDto specialChannelOrderReqDto = new CSPUpdateSpecialChannelOrderReqDto();
                    specialChannelOrderReqDto.setOrderNo(saleOrderRespDto.getPlatformOrderNo());
                    specialChannelOrderReqDto.setStatus(CspOrderStatusEnum.RECEIVED.getType());
                    specialChannelOrderReqDto.setOrderType(saleOrderRespDto.getOrderType());
                    ArrayList<ShippingDto> shippingDtoList = new ArrayList<ShippingDto>();
                    if (CollectionUtils.isNotEmpty((Collection)listDto)) {
                        for (DeliveryInformationRespDto dto : listDto) {
                            ShippingDto shippingDto = new ShippingDto();
                            shippingDto.setShippingCode(dto.getWmsConsignmentNo());
                            shippingDto.setShippingCompany(dto.getCarrierName());
                            shippingDtoList.add(shippingDto);
                        }
                    }
                    specialChannelOrderReqDto.setShippingDtoList(shippingDtoList);
                    logger.info("\u7279\u6e20\u8ba2\u5355\u63a8\u9001csp\u66f4\u65b0\u8ba2\u5355\u72b6\u6001\uff1a{}", (Object)JSON.toJSONString((Object)specialChannelOrderReqDto));
                    this.externalCspApi.updateCspSpecialChannelOrderStatus(specialChannelOrderReqDto);
                    return;
                }
                CSPUpdateCspOrderReqDto cspUpdateCspOrderReqDto = new CSPUpdateCspOrderReqDto();
                cspUpdateCspOrderReqDto.setOrderNo(saleOrderRespDto.getPlatformOrderNo());
                cspUpdateCspOrderReqDto.setStatus(CspOrderStatusEnum.RECEIVED.getType());
                cspUpdateCspOrderReqDto.setOrderType(saleOrderRespDto.getOrderType());
                this.externalCspApi.updateCspOrderStatus(cspUpdateCspOrderReqDto);
                return;
            }
            logger.info("\u672a\u5168\u90e8\u7b7e\u6536\uff0c\u4e0d\u63a8\u9001csp");
        } else {
            logger.info("\u672a\u5904\u7406\u7684\u72b6\u6001\u5b9a\u4e49");
        }
    }

    private void yyjUpdateOrderStatus(BizSaleOrderRespDto saleOrderRespDto, NutritionOrderStatus status) {
        logger.info("\u8425\u517b\u5bb6\u66f4\u65b0\u8ba2\u5355\u72b6\u6001\uff1a{}", (Object)JSON.toJSONString((Object)saleOrderRespDto));
        if (NutritionOrderStatus.SENDED.getCode().equals(status.getCode())) {
            if (StringUtils.isNotBlank((CharSequence)saleOrderRespDto.getPlatformParentOrderNo()) && ((Boolean)RestResponseHelper.extractData((RestResponse)this.saleOrderReportQueryApi.verifySaleOrderEntireReceiveDeliveryPlatform(saleOrderRespDto.getPlatformParentOrderNo()))).booleanValue()) {
                ReceiveCheckoutInfoReqDto receiveCheckoutInfoReqDto = new ReceiveCheckoutInfoReqDto();
                receiveCheckoutInfoReqDto.setOrderNo(saleOrderRespDto.getPlatformParentOrderNo());
                receiveCheckoutInfoReqDto.setOrderState(NutritionOrderStatus.SENDED.getCode());
                this.externalNutritionApi.receiveCheckoutInfo(receiveCheckoutInfoReqDto);
            } else {
                logger.info("\u8be5\u7236\u5355\u672a\u5168\u90e8\u53d1\u8d27");
            }
        } else if (NutritionOrderStatus.FINISH.getCode().equals(status.getCode())) {
            if (StringUtils.isNotBlank((CharSequence)saleOrderRespDto.getPlatformParentOrderNo()) && ((Boolean)RestResponseHelper.extractData((RestResponse)this.saleOrderReportQueryApi.verifySaleOrderEntireSignPlatform(saleOrderRespDto.getPlatformParentOrderNo()))).booleanValue()) {
                ReceiveCheckoutInfoReqDto receiveCheckoutInfoReqDto = new ReceiveCheckoutInfoReqDto();
                receiveCheckoutInfoReqDto.setOrderNo(saleOrderRespDto.getPlatformParentOrderNo());
                receiveCheckoutInfoReqDto.setOrderState(NutritionOrderStatus.FINISH.getCode());
                this.externalNutritionApi.receiveCheckoutInfo(receiveCheckoutInfoReqDto);
            } else {
                logger.info("\u8be5\u7236\u5355\u672a\u5168\u90e8\u7b7e\u6536");
            }
        } else {
            logger.info("\u672a\u5904\u7406\u7684\u8425\u517b\u5bb6\u72b6\u6001");
        }
    }

    private void yyjExpress(String orderNo, CsDeliveryReceiveResultRespDto dto) {
        logger.info("\u8425\u517b\u5bb6\u540c\u6b65\u7269\u6d41\u4fe1\u606f\uff1a{}\uff0c{}", (Object)orderNo, (Object)JSON.toJSONString((Object)dto));
        try {
            if (StringUtils.isNotBlank((CharSequence)dto.getShippingCompanyCode()) && StringUtils.isNotBlank((CharSequence)dto.getShippingCode())) {
                ReceiveExpressInfoReqDto reqDto = new ReceiveExpressInfoReqDto();
                reqDto.setReqFrom("TCBJ");
                reqDto.setSubOrderNo(orderNo);
                reqDto.setDeliveryCompany(dto.getShippingCompanyCode());
                reqDto.setDeliveryOrderNo(dto.getShippingCode());
                RestResponseHelper.extractData((RestResponse)this.externalNutritionApi.receiveExpressInfo(reqDto));
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    private void easInventoryAllotSpecial(CsDeliveryReceiveResultRespDto dto) {
        logger.info("EAS\u521b\u5efa\u8c03\u62e8\u5355\uff0c\u5e76\u751f\u6210\u51fa\u5165\u5e93\uff1a{}", (Object)JSON.toJSONString((Object)dto));
        dto = this.gainDetailMoreIfo(dto, dto.getReceiveLogicWarehouseCode());
        this.dispatchEasInventoryAllot.create(dto.getRelevanceNo(), EASGeneralSubBillFlagEnum.CODE_110110, dto, true);
    }

    private Object executeToEas(OpenapiDefineEnum openapiDefineEnum, Object data) {
        logger.info("\u53d1\u9001openAPI\u8bf7\u6c42EAS\u670d\u52a1\uff1a{}=={}", (Object)openapiDefineEnum.getApiCode(), (Object)JSON.toJSONString((Object)data));
        for (ExternalDispatchEasService centerService : this.externalDispatchServices) {
            if (!openapiDefineEnum.getApiCode().equals(centerService.getApiCode())) continue;
            return centerService.execute(data);
        }
        return null;
    }

    private void easOtherOutOfCustomerRefunding(CsDeliveryReceiveResultRespDto resultRespDto, BizSaleOrderRespDto saleOrder) {
        logger.info("\u6d88\u8d39\u8005\u9000\u6362\u8d27\u63a8\u9001EAS\u5176\u4ed6\u51fa\uff1a{}\uff0c{}", (Object)JSON.toJSONString((Object)resultRespDto), (Object)JSON.toJSONString((Object)saleOrder));
        if (saleOrder.getIfButtThirdParty() == 1) {
            CsBusinessTypeRespDto businessTypeRespDto;
            Bill bill = new Bill();
            bill.setTransactionType("TC014");
            bill.setCostCenterOrgUnit("0110010300");
            if (ObjectUtil.isNotEmpty((Object)saleOrder.getBusinessTypeId()) && ObjectUtil.isNotEmpty((Object)(businessTypeRespDto = (CsBusinessTypeRespDto)RestResponseHelper.extractData((RestResponse)this.csBusinessTypeQueryApi.queryById(saleOrder.getBusinessTypeId()))))) {
                bill.setTransactionType(businessTypeRespDto.getCode());
            }
            if (StringUtils.isNotBlank((CharSequence)saleOrder.getCostCenterCode())) {
                bill.setCostCenterOrgUnit(saleOrder.getCostCenterCode());
            }
            bill.setDescription(saleOrder.getPlatformOrderNo() + "-" + saleOrder.getCustomerName() + " \u2018\u8d39\u7528\uff1a\u73b0\u91d1-\u9000\u6362\u8d27\u2019");
            EASBillReqDto easBillReqDto = this.otherDataBuild(resultRespDto, saleOrder, bill);
            this.executeToEas(OpenapiDefineEnum.EAS010, easBillReqDto);
        } else {
            logger.info("\u4e0d\u5141\u8bb8\u63a8\u9001");
        }
    }

    private void easOtherOutOfOtherOutStock(CsDeliveryReceiveResultRespDto resultRespDto, BizSaleOrderRespDto saleOrder) {
        logger.info("\u9500\u552e\u5176\u4ed6\u51fa\u63a8\u9001EAS\u5176\u4ed6\u51fa\uff1a{}\uff0c{}", (Object)JSON.toJSONString((Object)resultRespDto), (Object)JSON.toJSONString((Object)saleOrder));
        if (saleOrder.getIfButtThirdParty() == 1) {
            CsBusinessTypeRespDto businessTypeRespDto;
            Bill bill = new Bill();
            bill.setTransactionType("TC011");
            if (ObjectUtil.isNotEmpty((Object)saleOrder.getBusinessTypeId()) && ObjectUtil.isNotEmpty((Object)(businessTypeRespDto = (CsBusinessTypeRespDto)RestResponseHelper.extractData((RestResponse)this.csBusinessTypeQueryApi.queryById(saleOrder.getBusinessTypeId()))))) {
                bill.setTransactionType(businessTypeRespDto.getCode());
            }
            if (StringUtils.isNotBlank((CharSequence)saleOrder.getEasCode())) {
                CostCenterReqDto reqDto = new CostCenterReqDto();
                reqDto.setEasCode(saleOrder.getEasCode());
                PageInfo respDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.costCenterQueryApi.queryByPageByPost(reqDto));
                if (CollectionUtil.isNotEmpty((Collection)respDtoPageInfo.getList())) {
                    bill.setCostCenterOrgUnit(((CostCenterRespDto)respDtoPageInfo.getList().get(0)).getCostCenterCode());
                }
            }
            if (StringUtils.isNotBlank((CharSequence)saleOrder.getCostCenterCode())) {
                bill.setCostCenterOrgUnit(saleOrder.getCostCenterCode());
            }
            bill.setDescription(saleOrder.getRemark());
            EASBillReqDto easBillReqDto = this.otherDataBuild(resultRespDto, saleOrder, bill);
            this.executeToEas(OpenapiDefineEnum.EAS010, easBillReqDto);
        } else {
            logger.info("\u4e0d\u5141\u8bb8\u63a8\u9001");
        }
    }

    private void easOtherOutOfQualityRefunding(CsDeliveryReceiveResultRespDto resultRespDto, BizSaleOrderRespDto saleOrder) {
        logger.info("\u8d28\u91cf\u9000\u6362\u8d27\u63a8\u9001EAS\u5176\u4ed6\u51fa\uff1a{}\uff0c{}", (Object)JSON.toJSONString((Object)resultRespDto), (Object)JSON.toJSONString((Object)saleOrder));
        if (saleOrder.getIfButtThirdParty() == 1) {
            CsBusinessTypeRespDto businessTypeRespDto;
            Bill bill = new Bill();
            bill.setTransactionType("TC014");
            if (ObjectUtil.isNotEmpty((Object)saleOrder.getBusinessTypeId()) && ObjectUtil.isNotEmpty((Object)(businessTypeRespDto = (CsBusinessTypeRespDto)RestResponseHelper.extractData((RestResponse)this.csBusinessTypeQueryApi.queryById(saleOrder.getBusinessTypeId()))))) {
                bill.setTransactionType(businessTypeRespDto.getCode());
            }
            bill.setCostCenterOrgUnit(saleOrder.getCostCenterCode());
            bill.setDescription(saleOrder.getSaleOrderNo() + (StringUtils.isNotBlank((CharSequence)saleOrder.getRemark()) ? "-" + saleOrder.getRemark() : ""));
            EASBillReqDto easBillReqDto = this.otherDataBuild(resultRespDto, saleOrder, bill);
            easBillReqDto.setAutoAudit(Boolean.valueOf(true));
            this.executeToEas(OpenapiDefineEnum.EAS010, easBillReqDto);
        } else {
            logger.info("\u4e0d\u5141\u8bb8\u63a8\u9001");
        }
    }

    private void easOtherOutOfReplenishOrder(CsDeliveryReceiveResultRespDto resultRespDto, BizSaleOrderRespDto saleOrder) {
        logger.info("\u5c11\u8d27\u8865\u53d1\u63a8\u9001EAS\u5176\u4ed6\u51fa\uff1a{}\uff0c{}", (Object)JSON.toJSONString((Object)resultRespDto), (Object)JSON.toJSONString((Object)saleOrder));
        if (saleOrder.getIfButtThirdParty() == 1) {
            CsBusinessTypeRespDto businessTypeRespDto;
            Bill bill = new Bill();
            bill.setTransactionType("TC014");
            if (ObjectUtil.isNotEmpty((Object)saleOrder.getBusinessTypeId()) && ObjectUtil.isNotEmpty((Object)(businessTypeRespDto = (CsBusinessTypeRespDto)RestResponseHelper.extractData((RestResponse)this.csBusinessTypeQueryApi.queryById(saleOrder.getBusinessTypeId()))))) {
                bill.setTransactionType(businessTypeRespDto.getCode());
            }
            bill.setCostCenterOrgUnit(saleOrder.getCostCenterCode());
            bill.setDescription(saleOrder.getSaleOrderNo() + (StringUtils.isNotBlank((CharSequence)saleOrder.getRemark()) ? "-" + saleOrder.getRemark() : ""));
            EASBillReqDto easBillReqDto = this.otherDataBuild(resultRespDto, saleOrder, bill);
            easBillReqDto.setAutoAudit(Boolean.valueOf(true));
            this.executeToEas(OpenapiDefineEnum.EAS010, easBillReqDto);
        } else {
            logger.info("\u4e0d\u5141\u8bb8\u63a8\u9001");
        }
    }

    private InventoryReqDto allotDataBuild(CsDeliveryReceiveResultRespDto resultRespDto, String warehouseCode) {
        logger.info("\u8c03\u62e8\u5355/\u51fa/\u5165\u8bf7\u6c42\u53c2\u6570\u6784\u5efa\uff1a{}", (Object)JSON.toJSONString((Object)resultRespDto));
        resultRespDto = this.gainDetailMoreIfo(resultRespDto, warehouseCode);
        InventoryReqDto inventoryReqDto = new InventoryReqDto();
        inventoryReqDto.setBillType(EASBillTypeEnum.IMPORT_008_TYPE_106.code);
        inventoryReqDto.setAutoSubmit(Boolean.valueOf(true));
        inventoryReqDto.setAutoAudit(Boolean.valueOf(true));
        MoveIssueBill moveIssueBill = new MoveIssueBill();
        moveIssueBill.setSeq(resultRespDto.getDocumentNo());
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        moveIssueBill.setBizDate(simpleDateFormat.format(resultRespDto.getCreateTime()));
        moveIssueBill.setSyncMiddleBillName(null);
        moveIssueBill.setSourceBillId(this.getExtensionValue(resultRespDto.getExtension(), EASExtendKeyEnum.SOURCE_ID.code));
        moveIssueBill.setSourceBillNumber(this.getExtensionValue(resultRespDto.getExtension(), EASExtendKeyEnum.SOURCE_NUM.code));
        moveIssueBill.setBizType(null);
        moveIssueBill.setTransactionType(null);
        ArrayList entries = new ArrayList();
        CsTransferOrderRespDto transferOrderRespDto = (CsTransferOrderRespDto)RestResponseHelper.extractData((RestResponse)this.csTransferOrderApi.queryByTransferOrderNo(resultRespDto.getRelevanceNo()));
        if (null != transferOrderRespDto) {
            moveIssueBill.setDescription(transferOrderRespDto.getRemark());
        }
        if (ObjectUtil.isNotEmpty((Object)transferOrderRespDto) && StringUtils.isNotBlank((CharSequence)transferOrderRespDto.getSourceSystem()) && transferOrderRespDto.getSourceSystem().equals("EAS") && resultRespDto.getOrderType().equals("delivery")) {
            logger.info("\u6839\u636e\u6570\u91cf\u5206\u644a\u63a8\u9001EAS");
            List list = (List)RestResponseHelper.extractData((RestResponse)this.deliveryResultOrderQueryApi.easTransferOrderApportion(resultRespDto.getRelevanceNo(), resultRespDto.getDocumentNo()));
            list.forEach(detail -> {
                MoveIssueBillEntry entry = new MoveIssueBillEntry();
                entry.setPrice(null);
                entry.setQty(ObjectUtil.isEmpty((Object)detail.getQuantity()) ? "0" : detail.getQuantity().toString());
                entry.setBaseQty(entry.getQty());
                entry.setLot(detail.getBatch());
                entry.setMaterial(detail.getLongCode());
                entry.setIsPresent(null);
                entry.setActualCost(null);
                entry.setUnitActualCost(null);
                entry.setStandardCost(null);
                entry.setUnitStandardCost(null);
                entry.setWarehouse(warehouseCode);
                entry.setSourceBillEntryId(this.getExtensionValue(detail.getExtension(), EASExtendKeyEnum.ENTRY_ID.code));
                entry.setSourceBillEntrySeq(this.getExtensionValue(detail.getExtension(), EASExtendKeyEnum.ENTRY_SEQ.code));
                entry.setMfg(detail.getProduceTime() != null ? new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(detail.getProduceTime()) : null);
                entry.setExp(detail.getExpireTime() != null ? new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(detail.getExpireTime()) : null);
                entries.add(entry);
            });
        } else {
            logger.info("\u6839\u636e\u7ed3\u679c\u5355\u63a8\u9001EAS");
            CsDeliveryReceiveResultRespDto finalResultRespDto = resultRespDto;
            resultRespDto.getDeliveryReceiveResultDetailRespDtoList().forEach(detail -> {
                MoveIssueBillEntry entry = new MoveIssueBillEntry();
                entry.setPrice(null);
                entry.setQty(ObjectUtil.isEmpty((Object)detail.getQuantity()) ? "0" : detail.getQuantity().toString());
                entry.setBaseQty(entry.getQty());
                entry.setLot(detail.getBatch());
                entry.setMaterial(detail.getLongCode());
                entry.setIsPresent(null);
                entry.setActualCost(null);
                entry.setUnitActualCost(null);
                entry.setStandardCost(null);
                entry.setUnitStandardCost(null);
                entry.setWarehouse(warehouseCode);
                entry.setSourceBillEntryId(this.getExtensionValue(detail.getExtension(), EASExtendKeyEnum.ENTRY_ID.code));
                entry.setSourceBillEntrySeq(this.getExtensionValue(detail.getExtension(), EASExtendKeyEnum.ENTRY_SEQ.code));
                entry.setMfg(detail.getProduceTime() != null ? new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(detail.getProduceTime()) : null);
                entry.setExp(detail.getExpireTime() != null ? new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(detail.getExpireTime()) : null);
                entries.add(entry);
            });
        }
        moveIssueBill.setEntrys(entries);
        if (resultRespDto.getOrderType().equals("delivery")) {
            inventoryReqDto.setMoveIssueBills((List)Lists.newArrayList((Object[])new MoveIssueBill[]{moveIssueBill}));
        } else {
            inventoryReqDto.setMoveInWarehsBills((List)Lists.newArrayList((Object[])new MoveIssueBill[]{moveIssueBill}));
        }
        return inventoryReqDto;
    }

    private EASBillReqDto outsourcePurchaseOrderDataBuild(CsDeliveryReceiveResultRespDto resultRespDto, String warehouseCode) {
        logger.info("\u59d4\u5916/\u91c7\u8d2d\u51fa\u5165\u5e93\u53c2\u6570\u6784\u5efa\uff1a{}=={}", (Object)warehouseCode, (Object)JSON.toJSONString((Object)resultRespDto));
        resultRespDto = this.gainDetailMoreIfo(resultRespDto, warehouseCode);
        EASBillReqDto reqDto = new EASBillReqDto();
        reqDto.setAutoAudit(Boolean.valueOf(true));
        reqDto.setAutoSubmit(Boolean.valueOf(true));
        reqDto.setAutoCreateSubBill(Boolean.valueOf(false));
        Bill bill = new Bill();
        bill.setBillType(EASBillTypeEnum.IMPORT_002_TYPE_103.code);
        bill.setSourceNumber(resultRespDto.getExternalOrderNo());
        bill.setTransactionType(null);
        bill.setStorageOrgUnit(this.getExtensionValue(resultRespDto.getExtension(), EASExtendKeyEnum.F_COMPANY_ORG.code));
        bill.setSourceBillType(null);
        bill.setBizType(null);
        bill.setSourceBillId(this.getExtensionValue(resultRespDto.getExtension(), EASExtendKeyEnum.SOURCE_ID.code));
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        bill.setBizDate(simpleDateFormat.format(resultRespDto.getCreateTime()));
        bill.setSeq(resultRespDto.getDocumentNo());
        bill.setWmsBillNo(resultRespDto.getWmsOrderNo());
        ArrayList entries = new ArrayList();
        if (resultRespDto.getRelevanceTableName().equals(CsRelevanceTableNameEnum.CS_TRANSFER_ORDER.getCode())) {
            logger.info("\u6839\u636e\u6570\u91cf\u5206\u644a\u63a8\u9001EAS");
            List list = (List)RestResponseHelper.extractData((RestResponse)this.deliveryResultOrderQueryApi.easTransferOrderApportion(resultRespDto.getRelevanceNo(), resultRespDto.getDocumentNo()));
            list.forEach(detail -> {
                BillEntry billEntry = new BillEntry();
                billEntry.setMfg(detail.getProduceTime() != null ? simpleDateFormat.format(detail.getProduceTime()) : null);
                billEntry.setExp(detail.getExpireTime() != null ? simpleDateFormat.format(detail.getExpireTime()) : null);
                billEntry.setLot(detail.getBatch());
                billEntry.setQty(Long.valueOf(ObjectUtil.isEmpty((Object)detail.getQuantity()) ? 0L : detail.getQuantity().longValue()));
                billEntry.setBaseQty(billEntry.getQty());
                billEntry.setWarehouse(warehouseCode);
                billEntry.setSourceBillEntryId(this.getExtensionValue(detail.getExtension(), EASExtendKeyEnum.ENTRY_ID.code));
                billEntry.setMaterial(detail.getLongCode());
                billEntry.setProject(this.getExtensionValue(detail.getExtension(), EASExtendKeyEnum.INTERNAL_DEAL_DETAIL_PROJECT_NO.code));
                billEntry.setTrackNumber(this.getExtensionValue(detail.getExtension(), EASExtendKeyEnum.INTERNAL_DEAL_DETAIL_TRACK_PLAN.code));
                entries.add(billEntry);
            });
        } else {
            logger.info("\u91c7\u8d2d\u5165\u5e93\uff0c\u6839\u636e\u7ed3\u679c\u5355\u63a8\u9001EAS");
            CsDeliveryReceiveResultRespDto finalRespDto = resultRespDto;
            resultRespDto.getDeliveryReceiveResultDetailRespDtoList().forEach(detail -> {
                BillEntry billEntry = new BillEntry();
                billEntry.setMfg(detail.getProduceTime() != null ? simpleDateFormat.format(detail.getProduceTime()) : null);
                billEntry.setExp(detail.getExpireTime() != null ? simpleDateFormat.format(detail.getExpireTime()) : null);
                billEntry.setLot(detail.getBatch());
                billEntry.setQty(Long.valueOf(ObjectUtil.isEmpty((Object)detail.getQuantity()) ? 0L : detail.getQuantity().longValue()));
                billEntry.setBaseQty(billEntry.getQty());
                billEntry.setWarehouse(warehouseCode);
                billEntry.setSourceBillEntryId(this.getExtensionValue(detail.getExtension(), EASExtendKeyEnum.ENTRY_ID.code));
                billEntry.setMaterial(detail.getLongCode());
                if (finalRespDto.getBusinessType().equals(BusinessTypeEnum.PURCHASE.getCode())) {
                    billEntry.setCoreBillType(EASSourceBillTypeEnum.PURCHASE.code);
                }
                if (finalRespDto.getBusinessType().equals(BusinessTypeEnum.OUTSOURCE.getCode())) {
                    billEntry.setCoreBillType(EASSourceBillTypeEnum.OUTSOURCE.code);
                }
                billEntry.setPurOrderEntry(this.getExtensionValue(detail.getExtension(), EASExtendKeyEnum.ENTRY_ID.code));
                billEntry.setPurOrderEntrySeq(this.getExtensionValue(detail.getExtension(), EASExtendKeyEnum.ENTRY_SEQ.code));
                billEntry.setPurOrder(bill.getSourceBillId());
                billEntry.setPurOrderNumber(bill.getSourceNumber());
                entries.add(billEntry);
            });
        }
        bill.setEntrys(entries);
        reqDto.setPurInWarehsBills((List)Lists.newArrayList((Object[])new Bill[]{bill}));
        return reqDto;
    }

    private EASBillReqDto produceDataBuild(CsDeliveryReceiveResultRespDto resultRespDto, String warehouseCode) {
        logger.info("\u751f\u4ea7\u6210\u54c1\u53c2\u6570\u6784\u5efa\uff1a{}=={}", (Object)warehouseCode, (Object)JSON.toJSONString((Object)resultRespDto));
        resultRespDto = this.gainDetailMoreIfo(resultRespDto, warehouseCode);
        EASBillReqDto reqDto = new EASBillReqDto();
        reqDto.setAutoAudit(Boolean.valueOf(true));
        reqDto.setAutoSubmit(Boolean.valueOf(true));
        reqDto.setAutoCreateSubBill(Boolean.valueOf(false));
        Bill bill = new Bill();
        bill.setBillType(EASBillTypeEnum.IMPORT_007_TYPE_105.code);
        bill.setSourceNumber(resultRespDto.getExternalOrderNo());
        bill.setTransactionType(EASTransactionTypeEnum.TYPE_024.code);
        bill.setStorageOrgUnit(null);
        bill.setSourceBillType(null);
        bill.setBizType(EASBizTypeEnum.IMPORT_007_PRODUCT.code);
        bill.setBizDate(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(resultRespDto.getCreateTime()));
        bill.setSeq(resultRespDto.getDocumentNo());
        bill.setStorageOrgUnit(this.getExtensionValue(resultRespDto.getExtension(), EASExtendKeyEnum.F_COMPANY_ORG.code));
        bill.setWmsBillNo(resultRespDto.getWmsOrderNo());
        ArrayList entries = new ArrayList();
        CsDeliveryReceiveResultRespDto finalRespDto = resultRespDto;
        resultRespDto.getDeliveryReceiveResultDetailRespDtoList().forEach(detail -> {
            BillEntry billEntry = new BillEntry();
            billEntry.setMfg(detail.getProduceTime() != null ? new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(detail.getProduceTime()) : null);
            billEntry.setExp(detail.getExpireTime() != null ? new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(detail.getExpireTime()) : null);
            billEntry.setLot(detail.getBatch());
            billEntry.setQty(Long.valueOf(ObjectUtil.isEmpty((Object)detail.getQuantity()) ? 0L : detail.getQuantity().longValue()));
            billEntry.setBaseQty(billEntry.getQty());
            billEntry.setWarehouse(warehouseCode);
            billEntry.setSourceBillEntryId(this.getExtensionValue(detail.getExtension(), EASExtendKeyEnum.ENTRY_ID.code));
            billEntry.setMaterial(detail.getLongCode());
            entries.add(billEntry);
        });
        bill.setEntrys(entries);
        reqDto.setManufactureRecBills((List)Lists.newArrayList((Object[])new Bill[]{bill}));
        return reqDto;
    }

    private EASBillReqDto otherDataBuild(CsDeliveryReceiveResultRespDto resultRespDto, String warehouseCode) {
        logger.info("\u5176\u4ed6\u51fa/\u5165\u5e93\u53c2\u6570\u6784\u5efa\uff1a{}=={}", (Object)warehouseCode, (Object)JSON.toJSONString((Object)resultRespDto));
        this.gainDetailMoreIfo(resultRespDto, warehouseCode);
        CsOtherStorageOrderRespDto otherStorageOrder = (CsOtherStorageOrderRespDto)RestResponseHelper.extractData((RestResponse)this.csOtherStorageOrderQueryApi.queryByOtherStorageNo(resultRespDto.getRelevanceNo()));
        logger.info("\u5355\u636e\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)otherStorageOrder));
        if (ObjectUtil.isEmpty((Object)otherStorageOrder)) {
            throw new BizException("-1", "\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u5355\u636e");
        }
        if (otherStorageOrder.getIsSendEas().equals(0)) {
            logger.info("\u4e0d\u9700\u8981\u63a8\u9001EAS");
            return null;
        }
        EASBillReqDto reqDto = new EASBillReqDto();
        reqDto.setAutoAudit(Boolean.valueOf(true));
        reqDto.setAutoCreateSubBill(Boolean.valueOf(false));
        Bill bill = new Bill();
        bill.setSeq(resultRespDto.getDocumentNo());
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        bill.setBizDate(simpleDateFormat.format(resultRespDto.getCreateTime()));
        bill.setStorageOrgUnit(this.getOrgCodeByWarehouseCode(warehouseCode));
        bill.setDescription(otherStorageOrder.getMessage());
        bill.setCostCenterOrgUnit(otherStorageOrder.getCostCenterCode());
        bill.setAddress(otherStorageOrder.getAddress());
        bill.setTell(otherStorageOrder.getPhone());
        bill.setLinkMan(otherStorageOrder.getConsignee());
        bill.setAprovince(otherStorageOrder.getProvinceName());
        bill.setAcity(otherStorageOrder.getCityName());
        bill.setAcounty(otherStorageOrder.getAreaName());
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("pcpNumber", otherStorageOrder.getStorageOrderNo());
        map.put("budgetItem", otherStorageOrder.getBudgetItemId());
        map.put("budgetItemNum", otherStorageOrder.getBudgetItemCode());
        bill.setExtendsJsonMap(JSON.toJSONString(map));
        if (ObjectUtil.isNotEmpty((Object)otherStorageOrder.getBusinessType())) {
            logger.info("\u83b7\u53d6\u4e8b\u52a1\u7c7b\u578b\uff1a{}", (Object)otherStorageOrder.getBusinessType());
            CsBusinessTypeRespDto businessTypeRespDto = (CsBusinessTypeRespDto)RestResponseHelper.extractData((RestResponse)this.csBusinessTypeQueryApi.queryById(otherStorageOrder.getBusinessType()));
            if (ObjectUtil.isNotEmpty((Object)businessTypeRespDto)) {
                bill.setTransactionType(businessTypeRespDto.getCode());
            }
        }
        ArrayList entries = new ArrayList();
        resultRespDto.getDeliveryReceiveResultDetailRespDtoList().forEach(detail -> {
            BillEntry billEntry = new BillEntry();
            billEntry.setMfg(detail.getProduceTime() != null ? simpleDateFormat.format(detail.getProduceTime()) : null);
            billEntry.setExp(detail.getExpireTime() != null ? simpleDateFormat.format(detail.getExpireTime()) : null);
            billEntry.setLot(detail.getBatch());
            billEntry.setQty(Long.valueOf(ObjectUtil.isEmpty((Object)detail.getQuantity()) ? 0L : detail.getQuantity().longValue()));
            billEntry.setBaseQty(billEntry.getQty());
            billEntry.setWarehouse(warehouseCode);
            billEntry.setMaterial(detail.getLongCode());
            billEntry.setSourceBillEntryId(this.getExtensionValue(detail.getExtension(), EASExtendKeyEnum.ENTRY_ID.code));
            entries.add(billEntry);
        });
        bill.setEntrys(entries);
        if (CsPcpBusinessTypeEnum.OTHER_IN.getCode().equals(resultRespDto.getBusinessType())) {
            reqDto.setOtherInWarehsBills((List)Lists.newArrayList((Object[])new Bill[]{bill}));
        } else {
            reqDto.setOtherIssueBills((List)Lists.newArrayList((Object[])new Bill[]{bill}));
        }
        return reqDto;
    }

    private EASBillReqDto otherDataBuild(CsDeliveryReceiveResultRespDto resultRespDto, BizSaleOrderRespDto saleOrder, Bill bill) {
        logger.info("\u5176\u4ed6\u51fa/\u5165\u5e93\u53c2\u6570\u6784\u5efa\uff1a{}\uff0c{}\uff0c{}", new Object[]{JSON.toJSONString((Object)resultRespDto), JSON.toJSONString((Object)saleOrder), JSON.toJSONString((Object)bill)});
        this.gainDetailMoreIfo(resultRespDto, resultRespDto.getDeliveryLogicWarehouseCode());
        EASBillReqDto reqDto = new EASBillReqDto();
        reqDto.setAutoSubmit(Boolean.valueOf(true));
        reqDto.setAutoAudit(Boolean.valueOf(true));
        reqDto.setAutoCreateSubBill(Boolean.valueOf(false));
        bill.setSeq(resultRespDto.getDocumentNo());
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        bill.setBizDate(simpleDateFormat.format(resultRespDto.getCreateTime()));
        bill.setStorageOrgUnit(this.getOrgCodeByWarehouseCode(resultRespDto.getDeliveryLogicWarehouseCode()));
        if (ObjectUtil.isNotEmpty((Object)saleOrder.getOrderAddrRespDto())) {
            bill.setAddress(saleOrder.getOrderAddrRespDto().getReceiveAddress());
            bill.setTell(saleOrder.getOrderAddrRespDto().getReceivePhone());
            bill.setLinkMan(saleOrder.getOrderAddrRespDto().getReceiveName());
            bill.setAprovince(saleOrder.getOrderAddrRespDto().getProvince());
            bill.setAcity(saleOrder.getOrderAddrRespDto().getCity());
            bill.setAcounty(saleOrder.getOrderAddrRespDto().getCounty());
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("pcpNumber", saleOrder.getSaleOrderNo());
        map.put("yxyNumber", saleOrder.getPlatformOrderNo());
        map.put("customerOrderNumber", saleOrder.getPlatformOrderNo());
        map.put("budgetItem", saleOrder.getBudgetItemId());
        map.put("budgetItemNum", saleOrder.getBudgetItemCode());
        bill.setExtendsJsonMap(JSON.toJSONString(map));
        if (StringUtils.isNotBlank((CharSequence)saleOrder.getPlatformOrderNo())) {
            bill.setCustomerOrderNumber(saleOrder.getPlatformOrderNo());
        }
        ArrayList entries = new ArrayList();
        resultRespDto.getDeliveryReceiveResultDetailRespDtoList().forEach(detail -> {
            BillEntry billEntry = new BillEntry();
            billEntry.setMfg(detail.getProduceTime() != null ? simpleDateFormat.format(detail.getProduceTime()) : null);
            billEntry.setExp(detail.getExpireTime() != null ? simpleDateFormat.format(detail.getExpireTime()) : null);
            billEntry.setLot(detail.getBatch());
            billEntry.setQty(Long.valueOf(ObjectUtil.isEmpty((Object)detail.getQuantity()) ? 0L : detail.getQuantity().longValue()));
            billEntry.setBaseQty(billEntry.getQty());
            billEntry.setWarehouse(resultRespDto.getDeliveryLogicWarehouseCode());
            billEntry.setMaterial(detail.getLongCode());
            billEntry.setSourceBillEntryId(this.getExtensionValue(detail.getExtension(), EASExtendKeyEnum.ENTRY_ID.code));
            billEntry.setCustomer(saleOrder.getEasCode());
            entries.add(billEntry);
        });
        bill.setEntrys(entries);
        reqDto.setOtherIssueBills((List)Lists.newArrayList((Object[])new Bill[]{bill}));
        return reqDto;
    }

    private CsDeliveryReceiveResultRespDto gainDetailMoreIfo(CsDeliveryReceiveResultRespDto dto, String warehouseCode) {
        logger.info("\u83b7\u53d6\u8d27\u7269\u5bf9\u5e94\u5e93\u5b58\u751f\u4ea7/\u8fc7\u671f\u65e5\u671f\uff1a{}=={}", (Object)warehouseCode, (Object)JSON.toJSONString((Object)dto));
        if (ObjectUtil.isEmpty((Object)dto) || CollectionUtil.isEmpty((Collection)dto.getDeliveryReceiveResultDetailRespDtoList()) || StringUtils.isBlank((CharSequence)warehouseCode)) {
            return dto;
        }
        dto.getDeliveryReceiveResultDetailRespDtoList().forEach(detail -> {
            CsLogicInventoryQueryDto params = new CsLogicInventoryQueryDto();
            params.setLongCode(detail.getLongCode());
            params.setWarehouseCode(warehouseCode);
            params.setBatch(detail.getBatch());
            List select = (List)RestResponseHelper.extractData((RestResponse)this.csLogicInventoryQueryApi.queryInfoList(params));
            if (CollectionUtil.isNotEmpty((Collection)select)) {
                logger.info("\u586b\u5145\u7269\u6599\u660e\u7ec6\uff0c\u586b\u5145\u660e\u7ec6\uff1a{}", (Object)JSON.toJSONString((Object)select));
                detail.setExpireTime(((CsLogicInventoryRespDto)select.get(0)).getExpireTime());
                detail.setProduceTime(((CsLogicInventoryRespDto)select.get(0)).getProduceTime());
            }
        });
        return dto;
    }

    private String getExtensionValue(String extension, String key) {
        Map map;
        Object obj;
        logger.info("\u83b7\u53d6\u6269\u5c55\u5b57\u6bb5\u6307\u5b9a\u5185\u5bb9\uff1a{}=={}", (Object)key, (Object)JSON.toJSONString((Object)extension));
        if (StringUtils.isNotBlank((CharSequence)extension) && ObjectUtil.isNotEmpty(obj = (map = (Map)JSON.parseObject((String)extension, Map.class)).get(key))) {
            return obj.toString();
        }
        return "";
    }

    private String getOrgCodeByWarehouseCode(String warehouseCode) {
        logger.info("\u83b7\u53d6\u5e93\u5b58\u7ec4\u7ec7\uff1a{}", (Object)warehouseCode);
        if (StringUtils.isBlank((CharSequence)warehouseCode)) {
            return null;
        }
        DgLogicWarehousePageReqDto params = new DgLogicWarehousePageReqDto();
        params.setWarehouseCode(warehouseCode);
        List logicWarehouseRespDtoList = (List)RestResponseHelper.extractData((RestResponse)this.dgLogicWarehouseApi.queryList(params));
        if (CollectionUtil.isNotEmpty((Collection)logicWarehouseRespDtoList)) {
            return ((DgLogicWarehouseDto)logicWarehouseRespDtoList.get(0)).getCargoEscheatageId();
        }
        return null;
    }

    private String getOrgCode(String customerCode) {
        logger.info("\u5ba2\u6237\u7f16\u53f7\u4e3a\uff1a{}", (Object)customerCode);
        CustomerRespDto customerRespDto = (CustomerRespDto)RestResponseHelper.extractData((RestResponse)this.customerQueryApi.queryCustomerByCode(customerCode));
        if (ObjectUtil.isNotEmpty((Object)customerRespDto)) {
            return customerRespDto.getThirdPartyId();
        }
        return null;
    }

    private CsDeliveryReceiveResultRespDto combinationSaleOrder(CsDeliveryReceiveResultRespDto respDto) {
        logger.info("\u7ec4\u5408\u9500\u552e\u5355\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)respDto));
        BizSaleOrderRespDto saleOrder = (BizSaleOrderRespDto)RestResponseHelper.extractData((RestResponse)this.saleOrderQueryApi.queryByOrderNo(respDto.getRelevanceNo()));
        if (ObjectUtil.isEmpty((Object)saleOrder)) {
            throw new BizException("-1", "\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u9500\u552e\u5355");
        }
        respDto.setSaleOrder(saleOrder);
        Map<Long, SaleOrderItemExtRespDto> saleItemMaps = saleOrder.getItemList().stream().collect(Collectors.toMap(SaleOrderItemRespDto::getId, entity -> entity, (v1, v2) -> v2));
        respDto.getDeliveryReceiveResultDetailRespDtoList().forEach(item -> {
            if (ObjectUtil.isNotEmpty((Object)item.getTradeOrderItemId())) {
                item.setSaleOrderItem((SaleOrderItemExtRespDto)saleItemMaps.get(item.getTradeOrderItemId()));
            }
        });
        return respDto;
    }

    private void sapInventoryMove(CsDeliveryReceiveResultRespDto dto) {
        logger.info("sapInventoryMove, {}", (Object)JSON.toJSONString((Object)dto));
        boolean isDeliveryType = dto.getOrderType().equals("delivery");
        InventoryMoveReqDto sapReqDto = new InventoryMoveReqDto();
        SapGoodsMovementEnum goodsMovement = SapGoodsMovementEnum.enumOfKey((String)dto.getBusinessType());
        sapReqDto.setGoodsMovementCode(goodsMovement.getGoodsMovementCode());
        sapReqDto.setPostingDate(dto.getCreateTime());
        ArrayList<InventoryMoveItemDto> toMaterialDocumentItems = new ArrayList<InventoryMoveItemDto>();
        AtomicInteger i = new AtomicInteger();
        for (CsDeliveryReceiveResultDetailRespDto item : dto.getDeliveryReceiveResultDetailRespDtoList()) {
            String line = String.valueOf(i.getAndIncrement());
            InventoryMoveItemDto itemDto = new InventoryMoveItemDto();
            itemDto.setZz1ZwmsnoMsegMmi(dto.getDocumentNo());
            itemDto.setGoodsMovementType(goodsMovement.getGoodsMovementType());
            itemDto.setGoodsMovementRefDocType(goodsMovement.getGoodsMovementRefDocType());
            itemDto.setMaterial(item.getLongCode());
            itemDto.setQuantityInEntryUnit(String.valueOf(item.getQuantity()));
            itemDto.setBatch(item.getBatch());
            itemDto.setManufactureDate(item.getProduceTime());
            itemDto.setShelfLifeExpirationDate(item.getExpireTime());
            itemDto.setStorageLocation(isDeliveryType ? dto.getDeliveryLogicWarehouseCode() : dto.getReceiveLogicWarehouseCode());
            itemDto.setMaterialDocumentLine(line);
            switch (CsPcpBusinessTypeEnum.getByCode((String)dto.getBusinessType())) {
                case PURCHASE: 
                case PURCHASE_REFUND: 
                case OUTSOURCE: {
                    itemDto.setPurchaseOrder(dto.getExternalOrderNo());
                    itemDto.setPurchaseOrderItem(this.getExtensionValue(item.getExtension(), EASExtendKeyEnum.ENTRY_SEQ.code));
                    itemDto.setSupplier("");
                    itemDto.setPlant(this.getExtensionValue(dto.getExtension(), EASExtendKeyEnum.F_COMPANY_ORG.code));
                    break;
                }
                case PRODUCTION: 
                case PRODUCT_REPAIR: {
                    itemDto.setManufacturingOrder(dto.getExternalOrderNo());
                    itemDto.setManufacturingOrderItem(line);
                    itemDto.setPlant(this.getExtensionValue(dto.getExtension(), EASExtendKeyEnum.F_COMPANY_ORG.code));
                    break;
                }
                case OTHER_OUT: 
                case OTHER_IN: {
                    CsOtherStorageOrderRespDto otherStorageOrder = (CsOtherStorageOrderRespDto)RestResponseHelper.extractData((RestResponse)this.csOtherStorageOrderQueryApi.queryByOtherStorageNo(dto.getRelevanceNo()));
                    if (ObjectUtil.isNotEmpty((Object)otherStorageOrder.getBusinessType())) {
                        logger.info("\u83b7\u53d6\u4e8b\u52a1\u7c7b\u578b\uff1a{}", (Object)otherStorageOrder.getBusinessType());
                        CsBusinessTypeRespDto businessTypeRespDto = (CsBusinessTypeRespDto)RestResponseHelper.extractData((RestResponse)this.csBusinessTypeQueryApi.queryById(otherStorageOrder.getBusinessType()));
                        if (ObjectUtil.isNotEmpty((Object)businessTypeRespDto)) {
                            itemDto.setGoodsMovementReasonCode(businessTypeRespDto.getCode());
                            if (businessTypeRespDto.getBusinessTypeName().contains("\u62a5\u5e9f\u51fa\u5e93")) {
                                itemDto.setGoodsMovementType("551");
                            }
                            if (businessTypeRespDto.getBusinessTypeName().contains("\u62a5\u5e9f\u5165\u5e93")) {
                                itemDto.setGoodsMovementType("552");
                            }
                        }
                    }
                    itemDto.setCustomer(otherStorageOrder.getCustomerCode());
                    itemDto.setCostCenter(otherStorageOrder.getCostCenterCode());
                    itemDto.setBudgetItemNum(otherStorageOrder.getBudgetItemCode());
                    itemDto.setReservation(this.getExtensionValue(dto.getExtension(), EASExtendKeyEnum.SOURCE_NUM.code));
                    itemDto.setReservationItem(this.getExtensionValue(item.getExtension(), EASExtendKeyEnum.ENTRY_SEQ.code));
                    itemDto.setZz1ZmmshengfenMmi(otherStorageOrder.getProvinceName());
                    itemDto.setZz1ZmmshiquMmi(otherStorageOrder.getCityName());
                    itemDto.setZz1ZmmdiQuMmi(otherStorageOrder.getAreaName());
                    itemDto.setZz1ZmmstreetMmi(otherStorageOrder.getAddress());
                    itemDto.setZz1ZmmconamMmi(otherStorageOrder.getConsignee());
                    itemDto.setZz1ZmmcotelMmi(otherStorageOrder.getPhone());
                    itemDto.setZz1ZmmjjbsMmi("");
                    break;
                }
                case PRODUCTION_MATERIALS: 
                case PRODUCTION_MATERIALS_RETURN: {
                    itemDto.setStorageLocation(dto.getDeliveryLogicWarehouseCode());
                    itemDto.setIssuingOrReceivingStorageLoc(dto.getReceiveLogicWarehouseCode());
                    itemDto.setPlant(this.getExtensionValue(dto.getExtension(), EASExtendKeyEnum.F_COMPANY_ORG.code));
                    break;
                }
                case INTERNAL_ALLOT: 
                case ROUTE_INTERNAL_ALLOT: 
                case INTERNAL_EXPORT_DEAL: {
                    itemDto.setStorageLocation(dto.getDeliveryLogicWarehouseCode());
                    itemDto.setIssuingOrReceivingStorageLoc(dto.getReceiveLogicWarehouseCode());
                    itemDto.setZz1ZfhdhMmi(dto.getExternalOrderNo());
                    itemDto.setZz1ZfhdhitemMmi(this.getExtensionValue(item.getExtension(), EASExtendKeyEnum.ENTRY_SEQ.code));
                    break;
                }
            }
            if (ObjectUtil.isEmpty((Object)itemDto.getPlant())) {
                itemDto.setPlant(this.getOrgCodeByWarehouseCode(itemDto.getStorageLocation()));
            }
            if (ObjectUtil.isNotEmpty((Object)itemDto.getIssuingOrReceivingStorageLoc()) && ObjectUtil.isEmpty((Object)itemDto.getIssuingOrReceivingPlant())) {
                itemDto.setIssuingOrReceivingPlant(this.getOrgCodeByWarehouseCode(itemDto.getIssuingOrReceivingStorageLoc()));
            }
            toMaterialDocumentItems.add(itemDto);
        }
        sapReqDto.setToMaterialDocumentItem(toMaterialDocumentItems);
        logger.info("SAP\u5e93\u5b58\u8f6c\u79fb\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString((Object)sapReqDto));
        String result = (String)RestResponseHelper.extractData((RestResponse)this.iExternalOutSapApi.inventoryMove(sapReqDto));
        logger.info(result);
    }

    private void sapInventorySto(CsDeliveryReceiveResultRespDto dto) {
        boolean isInternalDealType;
        logger.info("sapInventorySto, {}", (Object)JSON.toJSONString((Object)dto));
        InventoryStoReqDto sapReqDto = new InventoryStoReqDto();
        sapReqDto.setZsourcesystemdocument(dto.getDocumentNo());
        sapReqDto.setPurchaseorderdate(DateUtils.formatYMD(dto.getCreateTime()));
        sapReqDto.setZstoragelocation(dto.getReceiveLogicWarehouseCode());
        sapReqDto.setZmoveoutstoragelocation(dto.getDeliveryLogicWarehouseCode());
        sapReqDto.setZcompanycode(this.getOrgCodeByWarehouseCode(dto.getReceiveLogicWarehouseCode()));
        sapReqDto.setZmoveoutcompanycode(this.getOrgCodeByWarehouseCode(dto.getDeliveryLogicWarehouseCode()));
        sapReqDto.setZplant(this.getOrgCodeByWarehouseCode(dto.getReceiveLogicWarehouseCode()));
        sapReqDto.setZmoveoutplant(this.getOrgCodeByWarehouseCode(dto.getDeliveryLogicWarehouseCode()));
        sapReqDto.setZprocessingBatchType("UB");
        sapReqDto.setDocumentcurrency("CNY");
        sapReqDto.setPurchaseorderreason("01");
        sapReqDto.setZAutomaticReceiptFlag("Y");
        CsPcpBusinessTypeEnum businessType = CsPcpBusinessTypeEnum.getByCode((String)dto.getBusinessType());
        boolean bl = isInternalDealType = businessType == CsPcpBusinessTypeEnum.INTERNAL_DEAL || businessType == CsPcpBusinessTypeEnum.INTERNAL_DEAL_RETURN || businessType == CsPcpBusinessTypeEnum.SALE_RETURN_INTERNAL_DEAL || businessType == CsPcpBusinessTypeEnum.ROUTE_INTERNAL_DEAL;
        if (isInternalDealType) {
            sapReqDto.setZaoNumber(dto.getExternalOrderNo());
        }
        ArrayList<InventoryStoItemDto> sapItem = new ArrayList<InventoryStoItemDto>();
        for (CsDeliveryReceiveResultDetailRespDto item : dto.getDeliveryReceiveResultDetailRespDtoList()) {
            InventoryStoItemDto itemDto = new InventoryStoItemDto();
            itemDto.setMaterial(item.getLongCode());
            itemDto.setPurchaseorderquantity(Integer.valueOf(item.getQuantity().intValue()));
            itemDto.setBatch(item.getBatch());
            itemDto.setPlant(sapReqDto.getZplant());
            itemDto.setStoragelocation(sapReqDto.getZstoragelocation());
            if (isInternalDealType) {
                itemDto.setZaoItemNo(this.getExtensionValue(item.getExtension(), EASExtendKeyEnum.ENTRY_SEQ.code));
            }
            itemDto.setAccountassignmentcategory("U");
            itemDto.setItemcategory("N");
            sapItem.add(itemDto);
        }
        sapReqDto.setItem(sapItem);
        logger.info("SAP\u8de8\u5de5\u5382\u95f4\u8c03\u62d4\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString((Object)sapReqDto));
        String result = (String)RestResponseHelper.extractData((RestResponse)this.iExternalOutSapApi.inventorySto(sapReqDto));
        logger.info(result);
    }
}

