/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cis.pms.biz.service.impl;

import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cis.pms.biz.dto.request.InspectionOptLogQueryReqDto;
import com.dtyunxi.cis.pms.biz.dto.request.InspectionOptLogReqDto;
import com.dtyunxi.cis.pms.biz.dto.response.InspectionOptLogRespDto;
import com.dtyunxi.cis.pms.biz.service.IInspectionOptLogService;
import com.dtyunxi.cis.pms.dao.das.InspectionOptLogDas;
import com.dtyunxi.cis.pms.dao.eo.InspectionOptLogEo;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.vo.BaseVo;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class InspectionOptLogServiceImpl
implements IInspectionOptLogService {
    @Resource
    private InspectionOptLogDas inspectionOptLogDas;

    @Override
    @Transactional(rollbackFor={Exception.class}, propagation=Propagation.NOT_SUPPORTED)
    public Long addInspectionOptLog(InspectionOptLogReqDto addReqDto) {
        InspectionOptLogEo inspectionOptLogEo = new InspectionOptLogEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)inspectionOptLogEo);
        this.inspectionOptLogDas.insert((BaseEo)inspectionOptLogEo);
        return inspectionOptLogEo.getId();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void addInspectionOptLogBatch(List<InspectionOptLogReqDto> addList) {
        if (CollectionUtils.isEmpty(addList)) {
            return;
        }
        ArrayList addEoList = Lists.newArrayList();
        DtoHelper.dtoList2EoList(addList, (Collection)addEoList, InspectionOptLogEo.class);
        this.inspectionOptLogDas.insertBatch((List)addEoList);
    }

    @Override
    public InspectionOptLogRespDto queryById(Long id) {
        InspectionOptLogEo inspectionOptLogEo = (InspectionOptLogEo)this.inspectionOptLogDas.selectByPrimaryKey(id);
        InspectionOptLogRespDto inspectionOptLogRespDto = new InspectionOptLogRespDto();
        DtoHelper.eo2Dto((BaseEo)inspectionOptLogEo, (BaseVo)inspectionOptLogRespDto);
        return inspectionOptLogRespDto;
    }

    @Override
    public PageInfo<InspectionOptLogRespDto> queryByPage(InspectionOptLogQueryReqDto queryReqDto) {
        ExtQueryChainWrapper wrapper = this.inspectionOptLogDas.filter();
        if (queryReqDto != null && StringUtils.isNotBlank((CharSequence)queryReqDto.getSkuCode())) {
            wrapper.like((Object)"sku_code", (Object)("%" + queryReqDto.getSkuCode() + "%"));
        }
        if (queryReqDto != null && StringUtils.isNotBlank((CharSequence)queryReqDto.getItemName())) {
            wrapper.like((Object)"item_name", (Object)("%" + queryReqDto.getItemName() + "%"));
        }
        if (queryReqDto != null && StringUtils.isNotBlank((CharSequence)queryReqDto.getBatchNo())) {
            wrapper.like((Object)"batch_no", (Object)("%" + queryReqDto.getBatchNo() + "%"));
        }
        if (queryReqDto != null && StringUtils.isNotBlank((CharSequence)queryReqDto.getTransferOrderNo())) {
            wrapper.like((Object)"transfer_order_no", (Object)("%" + queryReqDto.getTransferOrderNo() + "%"));
        }
        if (queryReqDto != null && StringUtils.isNotBlank((CharSequence)queryReqDto.getInspectionStatus())) {
            wrapper.eq((Object)"inspection_status", (Object)queryReqDto.getInspectionStatus());
        }
        if (queryReqDto != null && StringUtils.isNotBlank((CharSequence)queryReqDto.getOptPerson())) {
            wrapper.like((Object)"opt_person", (Object)("%" + queryReqDto.getOptPerson() + "%"));
        }
        if (queryReqDto != null && StringUtils.isNotBlank((CharSequence)queryReqDto.getOptTimeStart())) {
            wrapper.ge((Object)"opt_time", (Object)queryReqDto.getOptTimeStart());
        }
        if (queryReqDto != null && StringUtils.isNotBlank((CharSequence)queryReqDto.getOptTimeEnd())) {
            wrapper.le((Object)"opt_time", (Object)queryReqDto.getOptTimeEnd());
        }
        if (queryReqDto != null && StringUtils.isNotBlank((CharSequence)queryReqDto.getFailMsg())) {
            wrapper.like((Object)"fail_msg", (Object)("%" + queryReqDto.getFailMsg() + "%"));
        }
        wrapper.orderByDesc((Object)"id");
        PageInfo eoPageInfo = wrapper.page(queryReqDto.getPageNum(), queryReqDto.getPageSize());
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, InspectionOptLogRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }
}

