/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cis.pms.biz.service.impl;

import com.dtyunxi.cis.pms.biz.model.GetShopListPageParams;
import com.dtyunxi.cis.pms.biz.model.ShopVO;
import com.dtyunxi.cis.pms.biz.model.SubmitShopBody;
import com.dtyunxi.cis.pms.biz.service.BasedataCenterShopService;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.cube.utils.enums.DatePattern;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.util.DateUtil;
import com.dtyunxi.yundt.cube.center.data.api.enums.PcpShopStatusEnum;
import com.dtyunxi.yundt.cube.center.data.api.shop.IPcpShopApi;
import com.dtyunxi.yundt.cube.center.data.api.shop.dto.request.PcpShopReqDto;
import com.dtyunxi.yundt.cube.center.data.api.shop.dto.response.PcpShopChannelRespDto;
import com.dtyunxi.yundt.cube.center.data.api.shop.dto.response.PcpShopRespDto;
import com.dtyunxi.yundt.cube.center.data.api.shop.query.IPcpShopChannelQueryApi;
import com.dtyunxi.yundt.cube.center.data.api.shop.query.IPcpShopQueryApi;
import com.dtyunxi.yundt.cube.center.user.api.dto.OrganizationDto;
import com.dtyunxi.yundt.cube.center.user.api.query.IOrganizationQueryApi;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.ApiParam;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.validation.Valid;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;

@Service
public class BasedataCenterShopServiceServiceImpl
implements BasedataCenterShopService {
    @Resource
    private IPcpShopApi shopApi;
    @Resource
    private IPcpShopQueryApi shopQueryApi;
    @Resource
    private IOrganizationQueryApi organizationQueryApi;
    @Resource
    private IPcpShopChannelQueryApi shopChannelQueryApi;

    @Override
    public RestResponse<Object> addShop(@ApiParam(value="") @Valid @RequestBody(required=false) SubmitShopBody submitShopBody) {
        PcpShopReqDto addReqDto = this.bodyToReq(submitShopBody);
        return new RestResponse((Object)this.shopApi.addShop(addReqDto));
    }

    @Override
    public RestResponse<ShopVO> getShopDetail(@ApiParam(value="", required=true) @PathVariable(value="id") String id) {
        PcpShopRespDto shopRespDto = (PcpShopRespDto)RestResponseHelper.extractData((RestResponse)this.shopQueryApi.queryDetailById(Long.valueOf(id)));
        ShopVO shopVO = this.respToVO(shopRespDto);
        return new RestResponse((Object)shopVO);
    }

    @Override
    public RestResponse<PageInfo<ShopVO>> getShopListPage(@ApiParam(value="") @Valid @RequestBody(required=false) GetShopListPageParams getShopListPageParams) {
        PcpShopReqDto reqDto = new PcpShopReqDto();
        CubeBeanUtils.copyProperties((Object)reqDto, (Object)getShopListPageParams, (String[])new String[0]);
        reqDto.setStatus(getShopListPageParams.getShopStatus());
        PageInfo shopRespDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.shopQueryApi.queryDetailByPage(reqDto));
        if (CollectionUtils.isNotEmpty((Collection)shopRespDtoPageInfo.getList())) {
            PageInfo pageInfo = new PageInfo();
            CubeBeanUtils.copyProperties((Object)pageInfo, (Object)shopRespDtoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
            List shopVOS = shopRespDtoPageInfo.getList().stream().map(shopRespDto -> {
                ShopVO shopVO = this.respToVO((PcpShopRespDto)shopRespDto);
                return shopVO;
            }).collect(Collectors.toList());
            pageInfo.setList(shopVOS);
            return new RestResponse((Object)pageInfo);
        }
        return new RestResponse();
    }

    @Override
    public RestResponse<Object> updateShop(String id, @Valid SubmitShopBody submitShopBody) {
        PcpShopReqDto updateReqDto = this.bodyToReq(submitShopBody);
        return new RestResponse(RestResponseHelper.extractData((RestResponse)this.shopApi.modifyShop(updateReqDto)));
    }

    private PcpShopReqDto bodyToReq(SubmitShopBody submitShopBody) {
        PcpShopReqDto reqDto = new PcpShopReqDto();
        CubeBeanUtils.copyProperties((Object)reqDto, (Object)submitShopBody, (String[])new String[0]);
        if (Objects.nonNull(submitShopBody.getId())) {
            reqDto.setId(Long.valueOf(submitShopBody.getId()));
        }
        reqDto.setShopUrl(submitShopBody.getShopWebSite());
        if (StringUtils.isNotEmpty((CharSequence)submitShopBody.getShopStatus())) {
            PcpShopStatusEnum statusEnum = PcpShopStatusEnum.getByKey((String)submitShopBody.getShopStatus());
            if (statusEnum == null) {
                throw new BizException("\u5e97\u94fa\u72b6\u6001\u4e0d\u5b58\u5728");
            }
            reqDto.setStatus(submitShopBody.getShopStatus());
        }
        reqDto.setBusinessPractice(submitShopBody.getShopBusinessPractice());
        reqDto.setPrincipalName(submitShopBody.getShopPrincipalName());
        if (Objects.nonNull(submitShopBody.getShopChannelId())) {
            PcpShopChannelRespDto shopChannelRespDto = (PcpShopChannelRespDto)RestResponseHelper.extractData((RestResponse)this.shopChannelQueryApi.queryById(Long.valueOf(submitShopBody.getShopChannelId())));
            if (!Objects.nonNull(shopChannelRespDto)) {
                throw new BizException("\u5e97\u94fa\u6e20\u9053\u4e0d\u5b58\u5728");
            }
        } else {
            throw new BizException("\u53c2\u6570\u5e97\u94fa\u6e20\u9053ID\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        }
        reqDto.setChannelId(submitShopBody.getShopChannelId());
        if (Objects.nonNull(submitShopBody.getSaleOrganizationId())) {
            Long orgId = (long)submitShopBody.getSaleOrganizationId();
            OrganizationDto organizationDto = (OrganizationDto)RestResponseHelper.extractData((RestResponse)this.organizationQueryApi.queryById(orgId, ""));
            reqDto.setOrganizationCode(organizationDto.getCode());
            reqDto.setOrganizationId(orgId);
            reqDto.setOrganizationName(organizationDto.getName());
        }
        return reqDto;
    }

    private ShopVO respToVO(PcpShopRespDto shopRespDto) {
        ShopVO shopVO = new ShopVO();
        CubeBeanUtils.copyProperties((Object)shopVO, (Object)shopRespDto, (String[])new String[0]);
        shopVO.setId(shopRespDto.getId());
        shopVO.setShopId(shopRespDto.getId().toString());
        shopVO.setShopChannelId(shopRespDto.getChannelId());
        shopVO.setShopChannelCode(shopRespDto.getChannelCode());
        shopVO.setShopChannelName(shopRespDto.getChannelName());
        shopVO.setSaleOrganizationCode(shopRespDto.getOrganizationCode());
        shopVO.setSaleOrganizationId(shopRespDto.getOrganizationId());
        shopVO.setSaleOrganizationCompanyName(shopRespDto.getOrganizationName());
        shopVO.setShopStatus(shopRespDto.getStatus());
        shopVO.setShopBusinessPractice(shopRespDto.getBusinessPractice());
        shopVO.setShopPrincipalName(shopRespDto.getPrincipalName());
        shopVO.setShopTel(shopRespDto.getShopTel());
        shopVO.setShopWebSite(shopRespDto.getShopUrl());
        shopVO.setCreateTime(DateUtil.format((Date)shopRespDto.getCreateTime(), (String)DatePattern.DATETIME_PATTERN.getPattern()));
        shopVO.setUpdateTime(DateUtil.format((Date)shopRespDto.getUpdateTime(), (String)DatePattern.DATETIME_PATTERN.getPattern()));
        return shopVO;
    }
}

