/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cis.pms.biz.service.impl;

import cn.afterturn.easypoi.excel.entity.result.ExcelImportResult;
import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.cis.pms.biz.model.ExportFeeAttributionConfigDto;
import com.dtyunxi.cis.pms.biz.model.GetLogicalWarehouseListPageParams;
import com.dtyunxi.cis.pms.biz.model.ImportBaseModeDto;
import com.dtyunxi.cis.pms.biz.model.ImportFeeAttributionConfigDto;
import com.dtyunxi.cis.pms.biz.model.ImportFileOperationCommonReqDto;
import com.dtyunxi.cis.pms.biz.model.ImportFileOperationCommonRespDto;
import com.dtyunxi.cis.pms.biz.model.LogicalWarehouseVO;
import com.dtyunxi.cis.pms.biz.service.FinanceCenterFeeAttributionConfigService;
import com.dtyunxi.cis.pms.biz.service.InventoryCenterBaseWarehouseLogicalWarehouseService;
import com.dtyunxi.cis.pms.biz.service.operation.impl.HandlerFileOperationCommonServiceImpl;
import com.dtyunxi.cis.pms.biz.utils.ExcelUtils;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.finance.api.dto.request.FeeAttributionConfigDetailQueryReqDto;
import com.dtyunxi.finance.api.dto.request.FeeAttributionConfigListQueryReqDto;
import com.dtyunxi.finance.api.dto.request.SubmitFeeAttributionConfigAddReqDto;
import com.dtyunxi.finance.api.dto.request.SubmitFeeAttributionConfigEditReqDto;
import com.dtyunxi.finance.api.dto.response.FeeAttributionConfigRespDto;
import com.dtyunxi.finance.api.exception.FinanceException;
import com.dtyunxi.finance.api.exception.FinanceExceptionEnum;
import com.dtyunxi.finance.api.query.FeeAttributionConfigApi;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.warehouse.ICsLogicWarehouseExposedApi;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.warehouse.CsLogicWarehouseParamQueryDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.OrgAdvQueryReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.OrgAdvRespDto;
import com.dtyunxi.yundt.cube.center.user.api.query.IOrganizationQueryExtApi;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import io.swagger.annotations.ApiParam;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Resource;
import javax.validation.Valid;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.RequestBody;

@Service(value="abstractFileOperationCommonService_fee_attribution_config")
public class FinanceCenterFeeAttributionConfigServiceImpl
extends HandlerFileOperationCommonServiceImpl
implements FinanceCenterFeeAttributionConfigService {
    private static final Logger log = LoggerFactory.getLogger(FinanceCenterFeeAttributionConfigServiceImpl.class);
    @Resource
    IOrganizationQueryExtApi organizationQueryExtApi;
    @Resource
    FeeAttributionConfigApi feeAttributionConfigApi;
    @Resource
    ICsLogicWarehouseExposedApi logicWarehouseQueryApi;
    @Resource
    InventoryCenterBaseWarehouseLogicalWarehouseService inventoryCenterBaseWarehouseLogicalWarehouseService;
    @Resource
    private IContext context;

    @Override
    public RestResponse<Object> addFeeAttributionConfig(@Valid SubmitFeeAttributionConfigAddReqDto submitFeeAttributionConfigAddReqDto) {
        LogicalWarehouseVO outWareHouse = this.validateWareHouse(submitFeeAttributionConfigAddReqDto.getOutWarehouseCode());
        LogicalWarehouseVO inWarehouse = this.validateWareHouse(submitFeeAttributionConfigAddReqDto.getInWarehouseCode());
        this.validateOrg(submitFeeAttributionConfigAddReqDto.getCostBelongOrgCode());
        return this.feeAttributionConfigApi.addFeeAttributionConfig(submitFeeAttributionConfigAddReqDto);
    }

    @Override
    public RestResponse<Object> editFeeAttributionConfig(@Valid SubmitFeeAttributionConfigEditReqDto submitFeeAttributionConfigAddReqDto) {
        LogicalWarehouseVO outWareHouse = this.validateWareHouse(submitFeeAttributionConfigAddReqDto.getOutWarehouseCode());
        LogicalWarehouseVO inWarehouse = this.validateWareHouse(submitFeeAttributionConfigAddReqDto.getInWarehouseCode());
        this.validateOrg(submitFeeAttributionConfigAddReqDto.getCostBelongOrgCode());
        return this.feeAttributionConfigApi.editFeeAttributionConfig(submitFeeAttributionConfigAddReqDto);
    }

    @Override
    public RestResponse<FeeAttributionConfigRespDto> detailFeeAttributionConfig(@ApiParam(value="") @Valid @RequestBody(required=false) FeeAttributionConfigDetailQueryReqDto feeAttributionConfigDetailQueryReqDto) {
        return this.feeAttributionConfigApi.detailFeeAttributionConfig(feeAttributionConfigDetailQueryReqDto);
    }

    @Override
    public RestResponse<PageInfo<FeeAttributionConfigRespDto>> getFeeAttributionConfigListPage(@Valid FeeAttributionConfigListQueryReqDto feeAttributionConfigListQueryReqDto) {
        return this.feeAttributionConfigApi.getFeeAttributionConfigListPage(feeAttributionConfigListQueryReqDto);
    }

    @Override
    public RestResponse<FeeAttributionConfigRespDto> deleteFeeAttributionConfig(Long id) {
        return this.feeAttributionConfigApi.deleteFeeAttributionConfig(id);
    }

    @Override
    public RestResponse<Object> addBatchFeeAttributionConfig(List<SubmitFeeAttributionConfigAddReqDto> list) {
        for (SubmitFeeAttributionConfigAddReqDto submitFeeAttributionConfigAddReqDto : list) {
            this.validateWareHouse(submitFeeAttributionConfigAddReqDto.getOutWarehouseCode());
            this.validateWareHouse(submitFeeAttributionConfigAddReqDto.getInWarehouseCode());
            this.validateOrg(submitFeeAttributionConfigAddReqDto.getCostBelongOrgCode());
        }
        return this.feeAttributionConfigApi.addBatchFeeAttributionConfig(list);
    }

    private LogicalWarehouseVO validateWareHouse(String warehouseCode) {
        CsLogicWarehouseParamQueryDto csLogicWarehouseQueryDto = new CsLogicWarehouseParamQueryDto();
        ArrayList<String> list = new ArrayList<String>();
        list.add(warehouseCode);
        csLogicWarehouseQueryDto.setWarehouseCodeList(list);
        csLogicWarehouseQueryDto.setWarehouseStatus("enable");
        GetLogicalWarehouseListPageParams param = new GetLogicalWarehouseListPageParams();
        param.setWarehouseCode(warehouseCode);
        param.setPageNum(1);
        param.setPageSize(1);
        RestResponse<PageInfo<LogicalWarehouseVO>> restResponse = this.inventoryCenterBaseWarehouseLogicalWarehouseService.getLogicalWarehouseListPage(param);
        if (Objects.isNull(restResponse) || Objects.isNull(restResponse.getData()) || CollectionUtils.isEmpty((Collection)((PageInfo)restResponse.getData()).getList()) || ((PageInfo)restResponse.getData()).getList().size() != 1) {
            log.info("-----------validateWareHouse:{}", (Object)restResponse.toString());
            FinanceException.throwException((FinanceExceptionEnum)FinanceExceptionEnum.OUT_WAREHOUSE_RECORD_NOT_EXIST);
        }
        return (LogicalWarehouseVO)((PageInfo)restResponse.getData()).getList().get(0);
    }

    private OrgAdvRespDto validateOrg(String code) {
        OrgAdvQueryReqDto orgAdvQueryReqDto = new OrgAdvQueryReqDto();
        orgAdvQueryReqDto.setCode(code);
        RestResponse restResponse = this.organizationQueryExtApi.queryPage(orgAdvQueryReqDto, Integer.valueOf(1), Integer.valueOf(1));
        if (Objects.isNull(restResponse) || Objects.isNull(restResponse.getData()) || CollectionUtils.isEmpty((Collection)((PageInfo)restResponse.getData()).getList())) {
            log.info("-----------validateOrg:{}", (Object)restResponse.toString());
            FinanceException.throwException((FinanceExceptionEnum)FinanceExceptionEnum.FEE_ATTR_CONFIG_WAREHOUSE_RECORD_NOT_EXIST);
        }
        return (OrgAdvRespDto)((PageInfo)restResponse.getData()).getList().get(0);
    }

    @Override
    public Object verifyImportFileOperationCommon(ExcelImportResult<ImportBaseModeDto> result, ImportFileOperationCommonReqDto commonReqDto, ImportFileOperationCommonRespDto respDto) {
        ArrayList list = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)list, (Collection)result.getList(), ImportFeeAttributionConfigDto.class);
        ArrayList msgList = Lists.newArrayList();
        ArrayList saveList = new ArrayList();
        HashSet checkUnique = Sets.newHashSet();
        list.forEach(importDto -> {
            FinanceException financeException;
            ExportFeeAttributionConfigDto msgDto = new ExportFeeAttributionConfigDto();
            SubmitFeeAttributionConfigAddReqDto saveDto = new SubmitFeeAttributionConfigAddReqDto();
            try {
                if (checkUnique.contains(importDto.getUniqueKey())) {
                    msgDto.setMsg("\u6570\u636e\u91cd\u590d");
                } else {
                    checkUnique.add(importDto.getUniqueKey());
                }
                String outWarehouseCode = importDto.getOutWarehouseCode();
                LogicalWarehouseVO outWareHouse = this.validateWareHouse(outWarehouseCode);
                String outWarehouseName = outWareHouse.getWarehouseName();
                saveDto.setOutWarehouseCode(outWarehouseCode);
                saveDto.setOutWarehouseName(outWarehouseName);
                saveDto.setOutOrgId(Long.valueOf(Long.parseLong(outWareHouse.getCargoRightId())));
                saveDto.setOutOrgName(outWareHouse.getCargoRightName());
                msgDto.setOutWarehouseCode(outWarehouseCode);
            }
            catch (Exception e) {
                if (e instanceof FinanceException) {
                    financeException = (FinanceException)e;
                    msgDto.setMsg(financeException.getErrorMsg());
                }
                msgDto.setMsg("\u6821\u9a8c\u8c03\u51fa\u4ed3\u5931\u8d25");
            }
            try {
                String inWarehouseCode = importDto.getInWarehouseCode();
                LogicalWarehouseVO inWareHouse = this.validateWareHouse(inWarehouseCode);
                String inWarehouseName = inWareHouse.getWarehouseName();
                saveDto.setInWarehouseCode(inWarehouseCode);
                saveDto.setInWarehouseName(inWarehouseName);
                saveDto.setInOrgId(Long.valueOf(Long.parseLong(inWareHouse.getCargoRightId())));
                saveDto.setInOrgName(inWareHouse.getCargoRightName());
                msgDto.setInWarehouseCode(inWarehouseCode);
            }
            catch (Exception e) {
                if (e instanceof FinanceException) {
                    financeException = (FinanceException)e;
                    msgDto.setMsg(financeException.getErrorMsg());
                }
                msgDto.setMsg("\u6821\u9a8c\u8c03\u5165\u4ed3\u5931\u8d25");
            }
            try {
                String costBelongOrgCode = importDto.getCostBelongOrgCode();
                OrgAdvRespDto org = this.validateOrg(costBelongOrgCode);
                Long organizationId = org.getId();
                String organizationName = org.getName();
                String organizationCode = org.getCode();
                saveDto.setCostBelongOrgId(organizationId);
                saveDto.setCostBelongOrgCode(organizationCode);
                saveDto.setCostBelongOrgName(organizationName);
                msgDto.setCostBelongOrgCode(organizationCode);
            }
            catch (Exception e) {
                if (e instanceof FinanceException) {
                    financeException = (FinanceException)e;
                    msgDto.setMsg(financeException.getErrorMsg());
                }
                msgDto.setMsg("\u6821\u9a8c\u8d39\u7528\u5f52\u5c5e\u5931\u8d25");
            }
            saveDto.setCreatePerson(commonReqDto.getOperator());
            log.info("\u8d39\u7528\u5f52\u5c5e\u5bfc\u5165---------------------userName:{}", (Object)commonReqDto.getOperator());
            saveDto.setRemark(importDto.getRemark());
            msgDto.setRemark(importDto.getRemark());
            log.info("---------------------msgDto:{}", (Object)JSON.toJSONString((Object)((Object)msgDto)));
            log.info("---------------------saveDto:{}", (Object)JSON.toJSONString((Object)saveDto));
            if (StringUtils.isNotBlank((CharSequence)msgDto.getMsg())) {
                msgList.add(msgDto);
            } else {
                saveList.add(saveDto);
            }
        });
        HashMap map = Maps.newHashMap();
        map.put("saveList", saveList);
        map.put("msgList", msgList);
        log.info("---------------------saveList:{}", (Object)JSON.toJSONString(saveList));
        log.info("---------------------msgList:{}", (Object)JSON.toJSONString((Object)msgList));
        return map;
    }

    @Override
    public String executeImportFileOperationCommon(ExcelImportResult<ImportBaseModeDto> result, ImportFileOperationCommonReqDto commonReqDto, ImportFileOperationCommonRespDto respDto, Object obj) {
        List msgList;
        List saveList;
        Map map = (Map)obj;
        Object saveObj = map.get("saveList");
        Object msgObj = map.get("msgList");
        if (saveObj != null && CollectionUtil.isNotEmpty((Collection)(saveList = (List)saveObj))) {
            this.feeAttributionConfigApi.addBatchFeeAttributionConfig(saveList);
        }
        String errorMsgUrl = null;
        if (msgObj != null && CollectionUtil.isNotEmpty((Collection)(msgList = (List)msgObj))) {
            String excelName = String.format("%s%s", "\u8d39\u7528\u5f52\u5c5e\u8bbe\u7f6e\u5bfc\u5165\u9519\u8bef\u4fe1\u606f", commonReqDto.getTaskCode());
            errorMsgUrl = ExcelUtils.getExportUrl(msgList, ExportFeeAttributionConfigDto.class, null, excelName);
        }
        return errorMsgUrl;
    }
}

